/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.streamImpl;

import com.bea.xml.XmlCursor;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

public class ExtraInfo {
    private int attsCount;
    private XMLName[] attname;
    private String[] attval;
    private String[] atttype;
    private XmlCursor.XmlBookmark[] attann;
    private int nsCount;
    private String[] nsPrefix;
    private String[] nsUri;
    private XmlCursor.XmlBookmark[] nsAnn;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xml$streamImpl$ExtraInfo;

    ExtraInfo() {
    }

    public int getAttsCount() {
        return this.attsCount;
    }

    public int getNsCount() {
        return this.nsCount;
    }

    public XMLName getAttname(int i) {
        return this.attname[i];
    }

    public String getAttval(int i) {
        return this.attval[i];
    }

    public String getAtttype(int i) {
        return this.atttype[i];
    }

    public String getNsPrefix(int i) {
        return this.nsPrefix[i];
    }

    public String getNsUri(int i) {
        return this.nsUri[i];
    }

    public XmlCursor.XmlBookmark getAttJavelinAnnotation(int i) {
        return this.attann[i];
    }

    public XmlCursor.XmlBookmark getNsJavelinAnnotation(int i) {
        return this.nsAnn[i];
    }

    void init(int atts, int nss) {
        this.attsCount = 0;
        if (this.attname == null || atts > this.attname.length) {
            this.attname = new XMLName[atts];
            this.attval = new String[atts];
            this.atttype = new String[atts];
            this.attann = new XmlCursor.XmlBookmark[atts];
        }
        this.nsCount = 0;
        if (this.nsPrefix == null || nss > this.nsPrefix.length) {
            this.nsPrefix = new String[nss];
            this.nsUri = new String[nss];
            this.nsAnn = new XmlCursor.XmlBookmark[nss];
        }
    }

    void addAttribute(XMLName xmlName, String val, String type, XmlCursor.XmlBookmark ann) {
        if (!($assertionsDisabled || this.attname != null && this.attsCount < this.attname.length)) {
            throw new AssertionError((Object)"Add to many attributes.");
        }
        this.attname[this.attsCount] = xmlName;
        this.attval[this.attsCount] = val;
        this.atttype[this.attsCount] = type;
        this.attann[this.attsCount] = ann;
        ++this.attsCount;
    }

    void addNamespace(String prefix, String uri, XmlCursor.XmlBookmark ann) {
        if (!($assertionsDisabled || this.nsPrefix != null && this.nsCount < this.nsPrefix.length)) {
            throw new AssertionError((Object)"Add to many namespaces.");
        }
        this.nsPrefix[this.nsCount] = prefix;
        this.nsUri[this.nsCount] = uri;
        this.nsAnn[this.nsCount] = ann;
        ++this.nsCount;
    }

    String getNamespaceUri(String prefix) {
        int i = 0;
        while (i < this.attsCount) {
            if (this.nsPrefix[i] == prefix) {
                return this.nsUri[i];
            }
            ++i;
        }
        return null;
    }

    AttributeIterator getAttributes() {
        return new AttributeIteratorImpl(this, 1);
    }

    Attribute getAttributeByName(XMLName name) {
        int i = 0;
        while (i < this.attsCount) {
            if (this.attname[i].equals(name)) {
                return ElementFactory.createAttribute((XMLName)this.attname[i], (String)this.attval[i], (String)this.atttype[i]);
            }
            ++i;
        }
        return null;
    }

    AttributeIterator getAttributesAndNamespaces() {
        return new AttributeIteratorImpl(this, 3);
    }

    AttributeIterator getNamespaces() {
        return new AttributeIteratorImpl(this, 2);
    }

    public String toString() {
        String res = "";
        int i = 0;
        while (i < this.nsCount) {
            res = res + "  xmlns" + (this.nsPrefix[i] == null ? "" : ":" + this.nsPrefix[i]) + "=\"" + this.nsUri[i] + "\"";
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attsCount) {
            res = res + "  " + this.attname[i2] + "=\"" + this.attval[i2] + "\"";
            ++i2;
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xml$streamImpl$ExtraInfo == null ? (class$com$bea$xml$streamImpl$ExtraInfo = ExtraInfo.class$("com.bea.xml.streamImpl.ExtraInfo")) : class$com$bea$xml$streamImpl$ExtraInfo).desiredAssertionStatus();
    }

    static class AttributeIteratorImpl
    implements AttributeIterator {
        static final int ATTS = 1;
        static final int NSS = 2;
        static final int ATTSANDNSS = 3;
        private int _current;
        private int _type;
        private ExtraInfo _attsAndNs;
        static final /* synthetic */ boolean $assertionsDisabled;

        AttributeIteratorImpl(ExtraInfo attsAndNs, int type) {
            this._attsAndNs = attsAndNs;
            this._type = type;
            this._current = 0;
        }

        public boolean hasNext() {
            switch (this._type) {
                case 1: {
                    return this._current < this._attsAndNs.attsCount;
                }
                case 2: {
                    return this._current < this._attsAndNs.nsCount;
                }
                case 3: {
                    return this._current < this._attsAndNs.attsCount + this._attsAndNs.nsCount;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unsupported type.");
            }
            return false;
        }

        public Attribute next() {
            Attribute att = this.peek();
            ++this._current;
            return att;
        }

        public void skip() {
            this.next();
        }

        public Attribute peek() {
            switch (this._type) {
                case 1: {
                    return ElementFactory.createAttribute((XMLName)this._attsAndNs.attname[this._current], (String)this._attsAndNs.attval[this._current], (String)this._attsAndNs.atttype[this._current]);
                }
                case 2: {
                    return ElementFactory.createNamespaceAttribute((String)this._attsAndNs.nsPrefix[this._current], (String)this._attsAndNs.nsUri[this._current]);
                }
                case 3: {
                    if (this._current < this._attsAndNs.nsCount) {
                        return ElementFactory.createNamespaceAttribute((String)this._attsAndNs.nsPrefix[this._current], (String)this._attsAndNs.nsUri[this._current]);
                    }
                    return ElementFactory.createAttribute((XMLName)this._attsAndNs.attname[this._current], (String)this._attsAndNs.attval[this._current], (String)this._attsAndNs.atttype[this._current]);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unsupported type.");
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$com$bea$xml$streamImpl$ExtraInfo == null ? (class$com$bea$xml$streamImpl$ExtraInfo = ExtraInfo.class$("com.bea.xml.streamImpl.ExtraInfo")) : class$com$bea$xml$streamImpl$ExtraInfo).desiredAssertionStatus();
        }
    }
}

