/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.soap;

import com.bea.xbean.common.PrefixResolver;
import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.XmlWhitespace;
import com.bea.xbean.values.XmlValueOutOfRangeException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public final class SOAPArrayType {
    private QName _type;
    private int[] _ranks;
    private int[] _dimensions;
    private static int[] EMPTY_INT_ARRAY = new int[0];

    public boolean isSameRankAs(SOAPArrayType otherType) {
        if (this._ranks.length != otherType._ranks.length) {
            return false;
        }
        int i = 0;
        while (i < this._ranks.length) {
            if (this._ranks[i] != otherType._ranks[i]) {
                return false;
            }
            ++i;
        }
        return this._dimensions.length == otherType._dimensions.length;
    }

    public static int[] parseSoap11Index(String inbraces) {
        if (!(inbraces = XmlWhitespace.collapse(inbraces, 3)).startsWith("[") || !inbraces.endsWith("]")) {
            throw new IllegalArgumentException("Misformed SOAP 1.1 index: must be contained in braces []");
        }
        return SOAPArrayType.internalParseCommaIntString(inbraces.substring(1, inbraces.length() - 1));
    }

    private static int[] internalParseCommaIntString(String csl) {
        ArrayList<String> dimStrings = new ArrayList<String>();
        int i = 0;
        while (true) {
            int j;
            if ((j = csl.indexOf(44, i)) < 0) break;
            dimStrings.add(csl.substring(i, j));
            i = j + 1;
        }
        dimStrings.add(csl.substring(i));
        int[] result = new int[dimStrings.size()];
        i = 0;
        Iterator it = dimStrings.iterator();
        while (it.hasNext()) {
            String dimString = XmlWhitespace.collapse((String)it.next(), 3);
            if (dimString.equals("*") || dimString.equals("")) {
                result[i] = -1;
            } else {
                try {
                    result[i] = Integer.parseInt(dimString);
                }
                catch (Exception e) {
                    throw new XmlValueOutOfRangeException("Malformed integer in SOAP array index");
                }
            }
            ++i;
        }
        return result;
    }

    public SOAPArrayType(String s, PrefixResolver m) {
        String uri;
        int firstbrace = s.indexOf(91);
        if (firstbrace < 0) {
            throw new XmlValueOutOfRangeException();
        }
        String firstpart = XmlWhitespace.collapse(s.substring(0, firstbrace), 3);
        int firstcolon = firstpart.indexOf(58);
        String prefix = "";
        if (firstcolon >= 0) {
            prefix = firstpart.substring(0, firstcolon);
        }
        if ((uri = m.getNamespaceForPrefix(prefix)) == null) {
            throw new XmlValueOutOfRangeException();
        }
        this._type = QNameHelper.forLNS(firstpart.substring(firstcolon + 1), uri);
        this.initDimensions(s, firstbrace);
    }

    public SOAPArrayType(QName name, String dimensions) {
        int firstbrace = dimensions.indexOf(91);
        if (firstbrace < 0) {
            this._type = name;
            this._ranks = EMPTY_INT_ARRAY;
            dimensions = XmlWhitespace.collapse(dimensions, 3);
            String[] dimStrings = dimensions.split(" ");
            int i = 0;
            while (i < dimStrings.length) {
                String dimString = dimStrings[i];
                if (dimString.equals("*")) {
                    this._dimensions[i] = -1;
                } else {
                    try {
                        this._dimensions[i] = Integer.parseInt(dimStrings[i]);
                    }
                    catch (Exception e) {
                        throw new XmlValueOutOfRangeException();
                    }
                }
                ++i;
            }
        } else {
            this._type = name;
            this.initDimensions(dimensions, firstbrace);
        }
    }

    public SOAPArrayType(SOAPArrayType nested, int[] dimensions) {
        this._type = nested._type;
        this._ranks = new int[nested._ranks.length + 1];
        System.arraycopy(this._ranks, 0, nested._ranks, 0, nested._ranks.length);
        this._ranks[this._ranks.length - 1] = nested._dimensions.length;
        this._dimensions = new int[dimensions.length];
        System.arraycopy(dimensions, 0, this._dimensions, 0, dimensions.length);
    }

    private void initDimensions(String s, int firstbrace) {
        ArrayList<String> braces = new ArrayList<String>();
        int lastbrace = -1;
        int i = firstbrace;
        while (i >= 0) {
            lastbrace = s.indexOf(93, i);
            if (lastbrace < 0) {
                throw new XmlValueOutOfRangeException();
            }
            braces.add(s.substring(i + 1, lastbrace));
            i = s.indexOf(91, lastbrace);
        }
        String trailer = s.substring(lastbrace + 1);
        if (!XmlWhitespace.isAllSpace(trailer)) {
            throw new XmlValueOutOfRangeException();
        }
        this._ranks = new int[braces.size() - 1];
        int i2 = 0;
        while (i2 < this._ranks.length) {
            String commas = (String)braces.get(i2);
            int commacount = 0;
            int j = 0;
            while (j < commas.length()) {
                char ch = commas.charAt(j);
                if (ch == ',') {
                    ++commacount;
                } else if (!XmlWhitespace.isSpace(ch)) {
                    throw new XmlValueOutOfRangeException();
                }
                ++j;
            }
            this._ranks[i2] = commacount + 1;
            ++i2;
        }
        this._dimensions = SOAPArrayType.internalParseCommaIntString((String)braces.get(braces.size() - 1));
    }

    public QName getQName() {
        return this._type;
    }

    public int[] getRanks() {
        int[] result = new int[this._ranks.length];
        System.arraycopy(this._ranks, 0, result, 0, result.length);
        return result;
    }

    public int[] getDimensions() {
        int[] result = new int[this._dimensions.length];
        System.arraycopy(this._dimensions, 0, result, 0, result.length);
        return result;
    }

    public boolean containsNestedArrays() {
        return this._ranks.length > 0;
    }

    public String soap11DimensionString() {
        return this.soap11DimensionString(this._dimensions);
    }

    public String soap11DimensionString(int[] actualDimensions) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._ranks.length) {
            sb.append('[');
            int j = 1;
            while (j < this._ranks[i]) {
                sb.append(',');
                ++j;
            }
            sb.append(']');
            ++i;
        }
        sb.append('[');
        int i2 = 0;
        while (i2 < actualDimensions.length) {
            if (i2 > 0) {
                sb.append(',');
            }
            if (actualDimensions[i2] >= 0) {
                sb.append(actualDimensions[i2]);
            }
            ++i2;
        }
        sb.append(']');
        return sb.toString();
    }

    private SOAPArrayType() {
    }

    public static SOAPArrayType newSoap12Array(QName itemType, String arraySize) {
        int[] ranks = EMPTY_INT_ARRAY;
        arraySize = XmlWhitespace.collapse(arraySize, 3);
        String[] dimStrings = arraySize.split(" ");
        int[] dimensions = new int[dimStrings.length];
        int i = 0;
        while (i < dimStrings.length) {
            String dimString = dimStrings[i];
            if (i == 0 && dimString.equals("*")) {
                dimensions[i] = -1;
            } else {
                try {
                    dimensions[i] = Integer.parseInt(dimStrings[i]);
                }
                catch (Exception e) {
                    throw new XmlValueOutOfRangeException();
                }
            }
            ++i;
        }
        SOAPArrayType sot = new SOAPArrayType();
        sot._ranks = ranks;
        sot._type = itemType;
        sot._dimensions = dimensions;
        return sot;
    }

    public String soap12DimensionString(int[] actualDimensions) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < actualDimensions.length) {
            if (i > 0) {
                sb.append(' ');
            }
            if (actualDimensions[i] >= 0) {
                sb.append(actualDimensions[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public SOAPArrayType nestedArrayType() {
        if (!this.containsNestedArrays()) {
            throw new IllegalStateException();
        }
        SOAPArrayType result = new SOAPArrayType();
        result._type = this._type;
        result._ranks = new int[this._ranks.length - 1];
        System.arraycopy(this._ranks, 0, result._ranks, 0, result._ranks.length);
        result._dimensions = new int[this._ranks[this._ranks.length - 1]];
        int i = 0;
        while (i < result._dimensions.length) {
            result._dimensions[i] = -1;
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this._type.hashCode() + this._dimensions.length + this._ranks.length + (this._dimensions.length == 0 ? 0 : this._dimensions[0]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        SOAPArrayType sat = (SOAPArrayType)obj;
        if (!this._type.equals(sat._type)) {
            return false;
        }
        if (this._ranks.length != sat._ranks.length) {
            return false;
        }
        if (this._dimensions.length != sat._dimensions.length) {
            return false;
        }
        int i = 0;
        while (i < this._ranks.length) {
            if (this._ranks[i] != sat._ranks[i]) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._dimensions.length) {
            if (this._dimensions[i2] != sat._dimensions[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

