/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml;

import com.bea.xml.XmlCursor;
import com.bea.xml.XmlLineNumber;
import com.bea.xml.XmlObject;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public class XmlError
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _message;
    private String _source;
    private int _severity = 0;
    private int _line = -1;
    private int _column = -1;
    private int _offset = -1;
    private transient XmlCursor _cursor;
    public static final int SEVERITY_ERROR = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_INFO = 2;
    static /* synthetic */ Class class$com$bea$xml$XmlLineNumber;
    static /* synthetic */ Class class$com$bea$xml$XmlCursor;
    static /* synthetic */ Class class$com$bea$xml$XmlObject;

    public XmlError(XmlError src) {
        this._message = src.getMessage();
        this._severity = src.getSeverity();
        this._source = src.getSourceName();
        this._line = src.getLine();
        this._column = src.getColumn();
        this._offset = src.getOffset();
        this._cursor = src.getCursorLocation();
    }

    private XmlError(String message, int severity, String source, int line, int column, int offset, XmlCursor cursor) {
        this._message = message;
        this._severity = severity;
        this._source = source;
        this._line = line;
        this._column = column;
        this._offset = offset;
        this._cursor = cursor;
    }

    public static XmlError forMessage(String message) {
        return XmlError.forMessage(message, 0);
    }

    public static XmlError forMessage(String message, int severity) {
        return XmlError.forSource(message, severity, null);
    }

    public static XmlError forSource(String message, String sourceName) {
        return XmlError.forLocation(message, 0, sourceName, -1, -1, -1);
    }

    public static XmlError forSource(String message, int severity, String sourceName) {
        return XmlError.forLocation(message, severity, sourceName, -1, -1, -1);
    }

    public static XmlError forLocation(String message, String sourceName, int line, int column, int offset) {
        return new XmlError(message, 0, sourceName, line, column, offset, null);
    }

    public static XmlError forLocation(String message, int severity, String sourceName, int line, int column, int offset) {
        return new XmlError(message, severity, sourceName, line, column, offset, null);
    }

    public static XmlError forLocationAndCursor(String message, int severity, String sourceName, int line, int column, int offset, XmlCursor cursor) {
        return new XmlError(message, severity, sourceName, line, column, offset, cursor);
    }

    public static XmlError forObject(String message, XmlObject xobj) {
        return XmlError.forObject(message, 0, xobj);
    }

    public static XmlError forObject(String message, int severity, XmlObject xobj) {
        if (xobj == null) {
            return XmlError.forMessage(message, severity);
        }
        XmlCursor cur = xobj.newCursor();
        XmlError result = XmlError.forCursor(message, severity, cur);
        if (cur != null) {
            cur.dispose();
        }
        return result;
    }

    public static XmlError forCursor(String message, XmlCursor cursor) {
        return XmlError.forCursor(message, 0, cursor);
    }

    public static XmlError forCursor(String message, int severity, XmlCursor cursor) {
        if (cursor == null) {
            return XmlError.forMessage(message, severity);
        }
        int line = -1;
        int column = -1;
        int offset = -1;
        String source = null;
        source = cursor.documentProperties().getSourceName();
        XmlCursor c = cursor.newCursor();
        XmlLineNumber ln = (XmlLineNumber)c.getBookmark(class$com$bea$xml$XmlLineNumber == null ? (class$com$bea$xml$XmlLineNumber = XmlError.class$("com.bea.xml.XmlLineNumber")) : class$com$bea$xml$XmlLineNumber);
        if (ln == null) {
            ln = (XmlLineNumber)c.toPrevBookmark(class$com$bea$xml$XmlLineNumber == null ? (class$com$bea$xml$XmlLineNumber = XmlError.class$("com.bea.xml.XmlLineNumber")) : class$com$bea$xml$XmlLineNumber);
        }
        if (ln != null) {
            line = ln.getLine();
            column = ln.getColumn();
            offset = ln.getOffset();
        }
        c.dispose();
        return new XmlError(message, severity, source, line, column, offset, cursor);
    }

    protected static String formattedFileName(String rawString, URI base) {
        if (rawString == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(rawString);
            if (!uri.isAbsolute()) {
                uri = null;
            }
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (uri == null) {
            uri = new File(rawString).toURI();
        }
        if (base != null) {
            uri = base.relativize(uri);
        }
        if (uri.isAbsolute() ? uri.getScheme().compareToIgnoreCase("file") == 0 : base != null && base.isAbsolute() && base.getScheme().compareToIgnoreCase("file") == 0) {
            try {
                return new File(uri).toString();
            }
            catch (Exception e) {
            }
        }
        return uri.toString();
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getMessage() {
        return this._message;
    }

    public String getSourceName() {
        return this._source;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public int getOffset() {
        return this._offset;
    }

    public Object getLocation(Object type) {
        if (type == (class$com$bea$xml$XmlCursor == null ? (class$com$bea$xml$XmlCursor = XmlError.class$("com.bea.xml.XmlCursor")) : class$com$bea$xml$XmlCursor)) {
            return this._cursor;
        }
        if (type == (class$com$bea$xml$XmlObject == null ? (class$com$bea$xml$XmlObject = XmlError.class$("com.bea.xml.XmlObject")) : class$com$bea$xml$XmlObject) && this._cursor != null) {
            return this._cursor.getObject();
        }
        return null;
    }

    public XmlCursor getCursorLocation() {
        return (XmlCursor)this.getLocation(class$com$bea$xml$XmlCursor == null ? (class$com$bea$xml$XmlCursor = XmlError.class$("com.bea.xml.XmlCursor")) : class$com$bea$xml$XmlCursor);
    }

    public XmlObject getObjectLocation() {
        return (XmlObject)this.getLocation(class$com$bea$xml$XmlObject == null ? (class$com$bea$xml$XmlObject = XmlError.class$("com.bea.xml.XmlObject")) : class$com$bea$xml$XmlObject);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(URI base) {
        StringBuffer sb = new StringBuffer();
        String source = XmlError.formattedFileName(this.getSourceName(), base);
        if (source != null) {
            sb.append(source);
            int line = this.getLine();
            if (line < 0) {
                line = 0;
            }
            sb.append(':');
            sb.append(line);
            sb.append(':');
            if (this.getColumn() > 0) {
                sb.append(this.getColumn());
                sb.append(':');
            }
            sb.append(" ");
        }
        switch (this.getSeverity()) {
            case 0: {
                sb.append("error: ");
                break;
            }
            case 1: {
                sb.append("warning: ");
                break;
            }
        }
        String msg = this.getMessage();
        sb.append(msg == null ? "<Unspecified message>" : msg);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

