/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.values;

import com.bea.xbean.common.PrefixResolver;
import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.ValidationContext;
import com.bea.xbean.common.XMLChar;
import com.bea.xbean.values.NamespaceContext;
import com.bea.xbean.values.NamespaceManager;
import com.bea.xbean.values.XmlObjectBase;
import com.bea.xbean.values.XmlValueOutOfRangeException;
import com.bea.xml.SchemaType;
import com.bea.xml.SimpleValue;
import com.bea.xml.XmlAnySimpleType;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlSimpleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XmlListImpl
extends XmlObjectBase
implements XmlAnySimpleType {
    private SchemaType _schemaType;
    private XmlSimpleList _value;
    private XmlSimpleList _jvalue;
    private static final String[] EMPTY_STRINGARRAY = new String[0];

    public XmlListImpl(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    private static String nullAsEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static String compute_list_text(List xList) {
        if (xList.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(XmlListImpl.nullAsEmpty(((SimpleValue)xList.get(0)).stringValue()));
        int i = 1;
        while (i < xList.size()) {
            sb.append(' ');
            sb.append(XmlListImpl.nullAsEmpty(((SimpleValue)xList.get(i)).stringValue()));
            ++i;
        }
        return sb.toString();
    }

    protected String compute_text(NamespaceManager nsm) {
        return XmlListImpl.compute_list_text(this._value);
    }

    protected boolean is_defaultable_ws(String v) {
        try {
            XmlSimpleList savedValue = this._value;
            this.set_text(v);
            this._value = savedValue;
            return false;
        }
        catch (XmlValueOutOfRangeException e) {
            return true;
        }
    }

    protected void set_text(String s) {
        if (this._validateOnSet() && !this._schemaType.matchPatternFacet(s)) {
            throw new XmlValueOutOfRangeException();
        }
        SchemaType itemType = this._schemaType.getListItemType();
        XmlSimpleList newval = XmlListImpl.lex(s, itemType, XmlObjectBase._voorVc, this.has_store() ? this.get_store() : null);
        if (this._validateOnSet()) {
            XmlListImpl.validateValue(newval, this._schemaType, XmlObjectBase._voorVc);
        }
        this._value = newval;
    }

    public static String[] split_list(String s) {
        if (s.length() == 0) {
            return EMPTY_STRINGARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (true) {
            if (i < s.length() && XMLChar.isSpace(s.charAt(i))) {
                ++i;
                continue;
            }
            if (i >= s.length()) {
                return result.toArray(EMPTY_STRINGARRAY);
            }
            start = i;
            while (i < s.length() && !XMLChar.isSpace(s.charAt(i))) {
                ++i;
            }
            result.add(s.substring(start, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlSimpleList lex(String s, SchemaType itemType, ValidationContext ctx, PrefixResolver resolver) {
        String[] parts = XmlListImpl.split_list(s);
        XmlAnySimpleType[] newArray = new XmlAnySimpleType[parts.length];
        boolean pushed = false;
        if (resolver != null) {
            NamespaceContext.push(new NamespaceContext(resolver));
            pushed = true;
        }
        int i = 0;
        try {
            i = 0;
            while (i < parts.length) {
                try {
                    newArray[i] = itemType.newValue(parts[i]);
                }
                catch (XmlValueOutOfRangeException e) {
                    ctx.invalid("List item '" + parts[i] + "' is not a valid value of " + QNameHelper.readable(itemType));
                }
                ++i;
            }
            Object var10_9 = null;
            if (!pushed) return new XmlSimpleList(Arrays.asList(newArray));
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!pushed) throw throwable;
            NamespaceContext.pop();
            throw throwable;
        }
        NamespaceContext.pop();
        return new XmlSimpleList(Arrays.asList(newArray));
    }

    protected void set_nil() {
        this._value = null;
    }

    public List xlistValue() {
        this.check_dated();
        return this._value;
    }

    public List listValue() {
        this.check_dated();
        if (this._value == null) {
            return null;
        }
        if (this._jvalue != null) {
            return this._jvalue;
        }
        ArrayList<Object> javaResult = new ArrayList<Object>();
        int i = 0;
        while (i < this._value.size()) {
            javaResult.add(XmlObjectBase.java_value((XmlObject)this._value.get(i)));
            ++i;
        }
        this._jvalue = new XmlSimpleList(javaResult);
        return this._jvalue;
    }

    private static boolean permits_inner_space(XmlObject obj) {
        switch (((SimpleValue)obj).instanceType().getPrimitiveType().getBuiltinTypeCode()) {
            case 1: 
            case 2: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean contains_white_space(String s) {
        return s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || s.indexOf(10) >= 0 || s.indexOf(13) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set_list(List list) {
        XmlSimpleList xList;
        block8: {
            SchemaType itemType = this._schemaType.getListItemType();
            boolean pushed = false;
            if (this.has_store()) {
                NamespaceContext.push(new NamespaceContext(this.get_store()));
                pushed = true;
            }
            try {
                XmlAnySimpleType[] newval = new XmlAnySimpleType[list.size()];
                int i = 0;
                while (true) {
                    String stringrep;
                    if (i >= list.size()) {
                        xList = new XmlSimpleList(Arrays.asList(newval));
                        Object var10_9 = null;
                        if (!pushed) break block8;
                        break;
                    }
                    Object entry = list.get(i);
                    if (entry instanceof XmlObject && XmlListImpl.permits_inner_space((XmlObject)list.get(i)) && XmlListImpl.contains_white_space(stringrep = list.get(i).toString())) {
                        throw new XmlValueOutOfRangeException();
                    }
                    newval[i] = itemType.newValue(entry);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (pushed) {
                    NamespaceContext.pop();
                }
                throw throwable;
            }
            NamespaceContext.pop();
        }
        if (this._validateOnSet()) {
            XmlListImpl.validateValue(xList, this._schemaType, XmlObjectBase._voorVc);
        }
        this._value = xList;
    }

    public static void validateValue(XmlSimpleList items, SchemaType sType, ValidationContext context) {
        int i;
        XmlAnySimpleType o;
        block6: {
            XmlAnySimpleType[] enumvals = sType.getEnumerationValues();
            if (enumvals != null) {
                int i2 = 0;
                while (i2 < enumvals.length) {
                    if (!XmlListImpl.equal_xmlLists(items, ((XmlObjectBase)((Object)enumvals[i2])).xlistValue())) {
                        ++i2;
                        continue;
                    }
                    break block6;
                }
                context.invalid("List (" + items + ") is not a valid enumerated value for " + QNameHelper.readable(sType));
            }
        }
        if ((o = sType.getFacet(0)) != null && (i = ((SimpleValue)((Object)o)).intValue()) != items.size()) {
            context.invalid("List (" + items + ") does not have " + i + " items per length facet for " + QNameHelper.readable(sType));
        }
        if ((o = sType.getFacet(1)) != null && (i = ((SimpleValue)((Object)o)).intValue()) > items.size()) {
            context.invalid("List (" + items + ") has only " + items.size() + " items, fewer than min length facet (" + i + ") for " + QNameHelper.readable(sType));
        }
        if ((o = sType.getFacet(2)) != null && (i = ((SimpleValue)((Object)o)).intValue()) < items.size()) {
            context.invalid("List (" + items + ") has " + items.size() + " items, more than max length facet (" + i + ") for " + QNameHelper.readable(sType));
        }
    }

    protected boolean equal_to(XmlObject obj) {
        return XmlListImpl.equal_xmlLists(this._value, ((XmlObjectBase)obj).xlistValue());
    }

    private static boolean equal_xmlLists(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        int i = 0;
        while (i < a.size()) {
            if (!a.get(i).equals(b.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected int value_hash_code() {
        if (this._value == null) {
            return 0;
        }
        int hash = this._value.size();
        int incr = this._value.size() / 9;
        if (incr < 1) {
            incr = 1;
        }
        int i = 0;
        while (i < this._value.size()) {
            hash *= 19;
            hash += this._value.get(i).hashCode();
            i += incr;
        }
        if (i < this._value.size()) {
            hash *= 19;
            hash += this._value.get(i).hashCode();
        }
        return hash;
    }
}

