/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.values;

import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.ValidationContext;
import com.bea.xbean.values.JavaUriHolder;
import com.bea.xbean.values.XmlAnyUriImpl;
import com.bea.xbean.values.XmlValueOutOfRangeException;
import com.bea.xml.SchemaType;
import com.bea.xml.SimpleValue;
import com.bea.xml.XmlAnySimpleType;

public class JavaUriHolderEx
extends JavaUriHolder {
    private SchemaType _schemaType;

    public SchemaType schemaType() {
        return this._schemaType;
    }

    public JavaUriHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    protected int get_wscanon_rule() {
        return this.schemaType().getWhiteSpaceRule();
    }

    protected void set_text(String s) {
        if (this._validateOnSet()) {
            if (!JavaUriHolderEx.check(s, this._schemaType)) {
                throw new XmlValueOutOfRangeException();
            }
            if (!this._schemaType.matchPatternFacet(s)) {
                throw new XmlValueOutOfRangeException();
            }
        }
        super.set_text(s);
    }

    public static void validateLexical(String v, SchemaType sType, ValidationContext context) {
        XmlAnySimpleType x;
        XmlAnyUriImpl.validateLexical(v, context);
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            int i = 0;
            while (i < vals.length) {
                String e = ((SimpleValue)((Object)vals[i])).stringValue();
                if (e.equals(v)) break;
                ++i;
            }
            if (i >= vals.length) {
                context.invalid("anyURI '" + v + "' is not a valid enumerated value for " + QNameHelper.readable(sType));
            }
        }
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v)) {
            context.invalid("anyURI value '" + v + "' does not match pattern for " + QNameHelper.readable(sType));
        }
        if ((x = sType.getFacet(0)) != null && ((SimpleValue)((Object)x)).bigIntegerValue().intValue() != v.length()) {
            context.invalid("anyURI value '" + v + "' does not match length facet (" + ((SimpleValue)((Object)x)).bigIntegerValue() + ") for " + QNameHelper.readable(sType));
        }
        if ((x = sType.getFacet(1)) != null && ((SimpleValue)((Object)x)).bigIntegerValue().intValue() > v.length()) {
            context.invalid("anyURI value '" + v + "' does not match min length facet (" + ((SimpleValue)((Object)x)).bigIntegerValue() + ") for " + QNameHelper.readable(sType));
        }
        if ((x = sType.getFacet(2)) != null && ((SimpleValue)((Object)x)).bigIntegerValue().intValue() < v.length()) {
            context.invalid("anyURI value '" + v + "' does not match max length facet (" + ((SimpleValue)((Object)x)).bigIntegerValue() + ") for " + QNameHelper.readable(sType));
        }
    }

    private static boolean check(String v, SchemaType sType) {
        int m;
        int m2;
        int m3;
        int length = v == null ? 0 : v.length();
        XmlAnySimpleType len = sType.getFacet(0);
        if (len != null && length == (m3 = ((SimpleValue)((Object)len)).bigIntegerValue().intValue())) {
            return false;
        }
        XmlAnySimpleType min = sType.getFacet(1);
        if (min != null && length < (m2 = ((SimpleValue)((Object)min)).bigIntegerValue().intValue())) {
            return false;
        }
        XmlAnySimpleType max = sType.getFacet(2);
        return max == null || length <= (m = ((SimpleValue)((Object)max)).bigIntegerValue().intValue());
    }
}

