/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.values;

import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.values.NamespaceManager;
import com.bea.xbean.values.XmlObjectBase;
import com.bea.xbean.values.XmlValueOutOfRangeException;
import com.bea.xml.SchemaType;
import com.bea.xml.SimpleValue;
import com.bea.xml.XmlObject;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class JavaIntHolder
extends XmlObjectBase {
    private int _value;
    static final BigInteger _max = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger _min = BigInteger.valueOf(Integer.MIN_VALUE);

    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_INT;
    }

    public String compute_text(NamespaceManager nsm) {
        return Long.toString(this._value);
    }

    protected void set_text(String s) {
        try {
            this.set_int(Integer.parseInt(s));
        }
        catch (Exception e) {
            throw new XmlValueOutOfRangeException();
        }
    }

    protected void set_nil() {
        this._value = 0;
    }

    public BigDecimal bigDecimalValue() {
        this.check_dated();
        return new BigDecimal((double)this._value);
    }

    public BigInteger bigIntegerValue() {
        this.check_dated();
        return BigInteger.valueOf(this._value);
    }

    public long longValue() {
        this.check_dated();
        return this._value;
    }

    public int intValue() {
        this.check_dated();
        return this._value;
    }

    protected void set_BigDecimal(BigDecimal v) {
        this.set_BigInteger(v.toBigInteger());
    }

    protected void set_BigInteger(BigInteger v) {
        if (v.compareTo(_max) > 0 || v.compareTo(_min) < 0) {
            throw new XmlValueOutOfRangeException();
        }
        this.set_int(v.intValue());
    }

    protected void set_long(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new XmlValueOutOfRangeException();
        }
        this.set_int((int)l);
    }

    protected void set_int(int i) {
        this._value = i;
    }

    protected int compare_to(XmlObject i) {
        if (((SimpleValue)i).instanceType().getDecimalSize() > 32) {
            return -i.compareTo(this);
        }
        return this._value == ((XmlObjectBase)i).intValue() ? 0 : (this._value < ((XmlObjectBase)i).intValue() ? -1 : 1);
    }

    protected boolean equal_to(XmlObject i) {
        if (((SimpleValue)i).instanceType().getDecimalSize() > 32) {
            return i.valueEquals(this);
        }
        return this._value == ((XmlObjectBase)i).intValue();
    }

    protected int value_hash_code() {
        return this._value;
    }
}

