/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.values;

import com.bea.xbean.common.ValidationContext;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.values.NamespaceManager;
import com.bea.xbean.values.XmlObjectBase;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlObject;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JavaDecimalHolder
extends XmlObjectBase {
    private BigDecimal _value;
    private static BigInteger _maxlong;
    private static BigInteger _minlong;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$values$JavaDecimalHolder;

    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_DECIMAL;
    }

    protected String compute_text(NamespaceManager nsm) {
        return this._value.toString();
    }

    protected void set_text(String s) {
        if (this._validateOnSet()) {
            JavaDecimalHolder.validateLexical(s, XmlObjectBase._voorVc);
        }
        try {
            this.set_BigDecimal(new BigDecimal(s));
        }
        catch (NumberFormatException e) {
            XmlObjectBase._voorVc.invalid("Invalid Decimal");
        }
    }

    protected void set_nil() {
        this._value = null;
    }

    public static void validateLexical(String v, ValidationContext context) {
        char ch;
        int i = 0;
        int l = v.length();
        if (i < l && ((ch = v.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        boolean sawDot = false;
        boolean sawDigit = false;
        while (i < l) {
            char ch2 = v.charAt(i);
            if (ch2 == '.') {
                if (sawDot) {
                    context.invalid("Illegal decimal, saw '.' more than once");
                    return;
                }
                sawDot = true;
            } else if (ch2 >= '0' && ch2 <= '9') {
                sawDigit = true;
            } else {
                context.invalid("Illegal decimal, unexpected char: " + ch2);
                return;
            }
            ++i;
        }
        if (!sawDigit) {
            context.invalid("Illegal decimal, expected at least one digit");
            return;
        }
    }

    public BigDecimal bigDecimalValue() {
        this.check_dated();
        return this._value;
    }

    protected void set_BigDecimal(BigDecimal v) {
        this._value = v;
    }

    protected int compare_to(XmlObject decimal) {
        return this._value.compareTo(((XmlObjectBase)decimal).bigDecimalValue());
    }

    protected boolean equal_to(XmlObject decimal) {
        return this._value.compareTo(((XmlObjectBase)decimal).bigDecimalValue()) == 0;
    }

    protected int value_hash_code() {
        if (this._value.scale() > 0 && this._value.setScale(0, 1).compareTo(this._value) != 0) {
            return this.decimalHashCode();
        }
        BigInteger intval = this._value.toBigInteger();
        if (intval.compareTo(_maxlong) > 0 || intval.compareTo(_minlong) < 0) {
            return intval.hashCode();
        }
        long longval = intval.longValue();
        return (int)((longval >> 32) * 19L + longval);
    }

    protected int decimalHashCode() {
        if (!$assertionsDisabled && this._value.scale() <= 0) {
            throw new AssertionError();
        }
        String strValue = this._value.toString();
        int i = strValue.length() - 1;
        while (i >= 0) {
            if (strValue.charAt(i) != '0') break;
            --i;
        }
        if (!$assertionsDisabled && strValue.indexOf(46) >= i) {
            throw new AssertionError();
        }
        return strValue.substring(0, i + 1).hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$values$JavaDecimalHolder == null ? (class$com$bea$xbean$values$JavaDecimalHolder = JavaDecimalHolder.class$("com.bea.xbean.values.JavaDecimalHolder")) : class$com$bea$xbean$values$JavaDecimalHolder).desiredAssertionStatus();
        _maxlong = BigInteger.valueOf(Long.MAX_VALUE);
        _minlong = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

