/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.validator;

import com.bea.xbean.common.Chars;
import com.bea.xbean.common.GenericXmlInputStream;
import com.bea.xbean.common.ValidatorListener;
import com.bea.xbean.common.XMLNameHelper;
import com.bea.xbean.common.XmlWhitespace;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.validator.Validator;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XMLStreamValidationException;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlError;
import com.bea.xml.XmlOptions;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public final class ValidatingXMLInputStream
extends GenericXmlInputStream
implements ValidatorListener.Event {
    private XMLStreamValidationException _exception;
    private XMLInputStream _source;
    private Validator _validator;
    private StringBuffer _text = new StringBuffer();
    private boolean _finished;
    private String _xsiType;
    private String _xsiNil;
    private String _xsiLoc;
    private String _xsiNoLoc;
    private XMLName _name;
    private StartElement _startElement;
    static /* synthetic */ Class class$com$bea$xbean$validator$ValidatingXMLInputStream;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ValidatingXMLInputStream(XMLInputStream xis, SchemaTypeLoader typeLoader, SchemaType sType, XmlOptions options) throws XMLStreamException {
        this._source = xis;
        options = XmlOptions.maskNull(options);
        SchemaType type = (SchemaType)options.get("DOCUMENT_TYPE");
        if (type == null) {
            type = sType;
        }
        if (type == null) {
            SchemaType docType;
            type = BuiltinSchemaTypeSystem.ST_ANY_TYPE;
            if ((xis = xis.getSubStream()).skip(2) && (docType = typeLoader.findDocumentType(XMLNameHelper.getQName(xis.next().getName()))) != null) {
                type = docType;
            }
            xis.close();
        }
        this._validator = new Validator(type, null, typeLoader, options, new ExceptionXmlErrorListener());
        this.nextEvent(1);
    }

    protected XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent e = this._source.next();
        if (e == null) {
            if (!this._finished) {
                this.flushText();
                this.nextEvent(2);
                this._finished = true;
            }
        } else {
            switch (e.getType()) {
                case 16: 
                case 64: {
                    CharacterData cd = (CharacterData)e;
                    if (!cd.hasContent()) break;
                    this._text.append(cd.getContent());
                    break;
                }
                case 2: {
                    String local;
                    XMLName attrName;
                    Attribute attr;
                    StartElement se = (StartElement)e;
                    this.flushText();
                    this._startElement = se;
                    AttributeIterator attrs = se.getAttributes();
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        attrName = attr.getName();
                        if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attrName.getNamespaceUri())) continue;
                        local = attrName.getLocalName();
                        if (local.equals("type")) {
                            this._xsiType = attr.getValue();
                            continue;
                        }
                        if (local.equals("nil")) {
                            this._xsiNil = attr.getValue();
                            continue;
                        }
                        if (local.equals("schemaLocation")) {
                            this._xsiLoc = attr.getValue();
                            continue;
                        }
                        if (!local.equals("noNamespaceSchemaLocation")) continue;
                        this._xsiNoLoc = attr.getValue();
                    }
                    this._name = e.getName();
                    this.nextEvent(1);
                    attrs = se.getAttributes();
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        attrName = attr.getName();
                        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attrName.getNamespaceUri()) && ((local = attrName.getLocalName()).equals("type") || local.equals("nil") || local.equals("schemaLocation") || local.equals("noNamespaceSchemaLocation"))) continue;
                        this._text.append(attr.getValue());
                        this._name = attr.getName();
                        this.nextEvent(4);
                    }
                    this.clearText();
                    this._startElement = null;
                    break;
                }
                case 4: {
                    this.flushText();
                    this.nextEvent(2);
                }
            }
        }
        return e;
    }

    private void clearText() {
        this._text.delete(0, this._text.length());
    }

    private void flushText() throws XMLStreamException {
        if (this._text.length() > 0) {
            this.nextEvent(3);
            this.clearText();
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this._startElement == null) {
            return null;
        }
        Map map = this._startElement.getNamespaceMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(prefix);
    }

    public XmlCursor getLocationAsCursor() {
        return null;
    }

    public boolean getXsiType(Chars chars) {
        if (this._xsiType == null) {
            return false;
        }
        chars.string = this._xsiType;
        chars.buffer = null;
        return true;
    }

    public boolean getXsiNil(Chars chars) {
        if (this._xsiNil == null) {
            return false;
        }
        chars.string = this._xsiNil;
        chars.buffer = null;
        return true;
    }

    public boolean getXsiLoc(Chars chars) {
        if (this._xsiLoc == null) {
            return false;
        }
        chars.string = this._xsiLoc;
        chars.buffer = null;
        return true;
    }

    public boolean getXsiNoLoc(Chars chars) {
        if (this._xsiNoLoc == null) {
            return false;
        }
        chars.string = this._xsiNoLoc;
        chars.buffer = null;
        return true;
    }

    public QName getName() {
        return XMLNameHelper.getQName(this._name);
    }

    public void getText(Chars chars) {
        chars.string = this._text.toString();
        chars.buffer = null;
    }

    public void getText(Chars chars, int wsr) {
        chars.string = XmlWhitespace.collapse(this._text.toString(), wsr);
        chars.buffer = null;
    }

    public boolean textIsWhitespace() {
        int i = 0;
        while (i < this._text.length()) {
            switch (this._text.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void nextEvent(int kind) throws XMLStreamException {
        if (!$assertionsDisabled && this._exception != null) {
            throw new AssertionError();
        }
        this._validator.nextEvent(kind, this);
        if (this._exception != null) {
            throw this._exception;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$validator$ValidatingXMLInputStream == null ? (class$com$bea$xbean$validator$ValidatingXMLInputStream = ValidatingXMLInputStream.class$("com.bea.xbean.validator.ValidatingXMLInputStream")) : class$com$bea$xbean$validator$ValidatingXMLInputStream).desiredAssertionStatus();
    }

    private final class ExceptionXmlErrorListener
    extends AbstractCollection {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ExceptionXmlErrorListener() {
        }

        public boolean add(Object o) {
            if (!$assertionsDisabled && ValidatingXMLInputStream.this._exception != null) {
                throw new AssertionError();
            }
            ValidatingXMLInputStream.this._exception = new XMLStreamValidationException((XmlError)o);
            return false;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public int size() {
            return 0;
        }

        static {
            $assertionsDisabled = !(class$com$bea$xbean$validator$ValidatingXMLInputStream == null ? (class$com$bea$xbean$validator$ValidatingXMLInputStream = ValidatingXMLInputStream.class$("com.bea.xbean.validator.ValidatingXMLInputStream")) : class$com$bea$xbean$validator$ValidatingXMLInputStream).desiredAssertionStatus();
        }
    }
}

