/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.util;

import java.io.UnsupportedEncodingException;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static final boolean fDebug = false;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[64];

    protected static boolean isWhiteSpace(byte octect) {
        return octect == 32 || octect == 13 || octect == 10 || octect == 9;
    }

    protected static boolean isPad(byte octect) {
        return octect == 61;
    }

    protected static boolean isData(byte octect) {
        return base64Alphabet[octect] != -1;
    }

    protected static boolean isBase64(byte octect) {
        return Base64.isWhiteSpace(octect) || Base64.isPad(octect) || Base64.isData(octect);
    }

    public static byte[] encode(byte[] binaryData) {
        byte val2;
        byte val1;
        if (binaryData == null) {
            return null;
        }
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        byte[] encodedData = null;
        encodedData = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i = 0;
        i = 0;
        while (i < numberTriplets) {
            dataIndex = i * 3;
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            b3 = binaryData[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            encodedIndex = i * 4;
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
            ++i;
        }
        dataIndex = i * 3;
        encodedIndex = i * 4;
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k << 4];
            encodedData[encodedIndex + 2] = 61;
            encodedData[encodedIndex + 3] = 61;
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2];
            encodedData[encodedIndex + 3] = 61;
        }
        return encodedData;
    }

    public static byte[] decode(byte[] base64Data) {
        if (base64Data == null) {
            return null;
        }
        if ((base64Data = Base64.removeWhiteSpace(base64Data)).length % 4 != 0) {
            return null;
        }
        int numberQuadruple = base64Data.length / 4;
        if (numberQuadruple == 0) {
            return new byte[0];
        }
        byte[] decodedData = null;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        byte d1 = 0;
        byte d2 = 0;
        byte d3 = 0;
        byte d4 = 0;
        int i = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        decodedData = new byte[numberQuadruple * 3];
        while (i < numberQuadruple - 1) {
            if (!(Base64.isData(d1 = base64Data[dataIndex++]) && Base64.isData(d2 = base64Data[dataIndex++]) && Base64.isData(d3 = base64Data[dataIndex++]) && Base64.isData(d4 = base64Data[dataIndex++]))) {
                return null;
            }
            b1 = base64Alphabet[d1];
            b2 = base64Alphabet[d2];
            b3 = base64Alphabet[d3];
            b4 = base64Alphabet[d4];
            decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
            decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
            ++i;
        }
        if (!Base64.isData(d1 = base64Data[dataIndex++]) || !Base64.isData(d2 = base64Data[dataIndex++])) {
            return null;
        }
        b1 = base64Alphabet[d1];
        b2 = base64Alphabet[d2];
        d3 = base64Data[dataIndex++];
        d4 = base64Data[dataIndex++];
        if (!Base64.isData(d3) || !Base64.isData(d4)) {
            if (Base64.isPad(d3) && Base64.isPad(d4)) {
                if ((b2 & 0xF) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 1];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                return tmp;
            }
            if (!Base64.isPad(d3) && Base64.isPad(d4)) {
                b3 = base64Alphabet[d3];
                if ((b3 & 3) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 2];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                tmp[encodedIndex] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                return tmp;
            }
            return null;
        }
        b3 = base64Alphabet[d3];
        b4 = base64Alphabet[d4];
        decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
        decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
        decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
        return decodedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decode(String base64Data) {
        if (base64Data == null) {
            return null;
        }
        byte[] decoded = null;
        try {
            try {
                decoded = Base64.decode(base64Data.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Object var4_3 = null;
                return decoded == null ? null : new String(decoded);
            }
            Object var4_2 = null;
            return decoded == null ? null : new String(decoded);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return decoded == null ? null : new String(decoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(String binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] encoded = null;
        try {
            try {
                encoded = Base64.encode(binaryData.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Object var4_3 = null;
                return encoded == null ? null : new String(encoded);
            }
            Object var4_2 = null;
            return encoded == null ? null : new String(encoded);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return encoded == null ? null : new String(encoded);
        }
    }

    protected static byte[] removeWhiteSpace(byte[] data) {
        if (data == null) {
            return null;
        }
        int newSize = 0;
        int len = data.length;
        int i = 0;
        while (i < len) {
            if (!Base64.isWhiteSpace(data[i])) {
                ++newSize;
            }
            ++i;
        }
        if (newSize == len) {
            return data;
        }
        byte[] newArray = new byte[newSize];
        int j = 0;
        int i2 = 0;
        while (i2 < len) {
            if (!Base64.isWhiteSpace(data[i2])) {
                newArray[j++] = data[i2];
            }
            ++i2;
        }
        return newArray;
    }

    static {
        int i = 0;
        while (i < 255) {
            Base64.base64Alphabet[i] = -1;
            ++i;
        }
        int i2 = 90;
        while (i2 >= 65) {
            Base64.base64Alphabet[i2] = (byte)(i2 - 65);
            --i2;
        }
        int i3 = 122;
        while (i3 >= 97) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 97 + 26);
            --i3;
        }
        int i4 = 57;
        while (i4 >= 48) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 48 + 52);
            --i4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int i5 = 0;
        while (i5 <= 25) {
            Base64.lookUpBase64Alphabet[i5] = (byte)(65 + i5);
            ++i5;
        }
        int i6 = 26;
        int j = 0;
        while (i6 <= 51) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(97 + j);
            ++i6;
            ++j;
        }
        int i7 = 52;
        int j2 = 0;
        while (i7 <= 61) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(48 + j2);
            ++i7;
            ++j2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

