/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.x2003.x05.xmlbean.ltgfmt.TestsDocument;
import com.bea.xbean.tool.CommandLine;
import com.bea.xbean.tool.XMLBeanXSTCHarness;
import com.bea.xml.XmlCalendar;
import com.bea.xml.XmlError;
import com.bea.xml.XmlException;
import com.bea.xml.XmlOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;

public class XSTCTester {
    private static final Pattern leadingSpace = Pattern.compile("^\\s+", 8);

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        CommandLine cl = new CommandLine(args, Collections.EMPTY_SET);
        boolean showpass = cl.getOpt("showpass") != null;
        File[] allFiles = cl.getFiles();
        ArrayList<File> ltgFiles = new ArrayList<File>();
        XMLBeanXSTCHarness harness = new XMLBeanXSTCHarness();
        int i = 0;
        while (i < allFiles.length) {
            if (allFiles[i].getName().indexOf("LTG") >= 0) {
                ltgFiles.add(allFiles[i]);
            }
            ++i;
        }
        File resultsFile = new File("out.html");
        PrintWriter writer = new PrintWriter(new FileWriter(resultsFile));
        writer.println("<html>");
        writer.println("<style>td {border-bottom: 1px solid black} xmp {white-space: normal; word-wrap: break-word; word-break: break-all} </style>");
        writer.println("<body>");
        writer.println("<h1>XML Schema Test Collection Results</h1>");
        writer.println("<p>Run on " + new XmlCalendar(new Date()) + "</p>");
        writer.println("<table style='border: 1px solid black' cellpadding=0 cellspacing=0>");
        writer.println("<tr><td width=75%>Description</td><td width=12.5%>sch v</td><td width=12.5%>ins v</td></tr>");
        int failures = 0;
        int cases = 0;
        Iterator i2 = ltgFiles.iterator();
        while (i2.hasNext()) {
            Iterator j;
            ArrayList<TestCaseResult> results;
            ArrayList ltgErrors;
            File ltgFile;
            block14: {
                ltgFile = (File)i2.next();
                System.out.println("Processing test cases in " + ltgFile);
                ltgErrors = new ArrayList();
                TestCase[] testCases = XSTCTester.parseLTGFile(ltgFile, ltgErrors);
                results = new ArrayList<TestCaseResult>();
                if (testCases == null) break block14;
                int j2 = 0;
                while (j2 < testCases.length) {
                    block17: {
                        TestCaseResult result;
                        block16: {
                            block15: {
                                result = new TestCaseResult();
                                result.testCase = testCases[j2];
                                harness.runTestCase(result);
                                ++cases;
                                if (result.succeeded()) break block15;
                                ++failures;
                                break block16;
                            }
                            if (!showpass) break block17;
                        }
                        results.add(result);
                    }
                    ++j2;
                }
            }
            writer.println("<tr><td colspan=3 bgcolor=skyblue>" + ltgFile + "</td></tr>");
            if (!ltgErrors.isEmpty()) {
                writer.println("<tr><td>Errors within the LTG file:");
                writer.println("<xmp>");
                j = ltgErrors.iterator();
                while (j.hasNext()) {
                    writer.println(j.next());
                }
                writer.println("</xmp>");
                writer.println("</td></tr>");
            } else if (results.size() == 0) {
                writer.println("<tr><td colspan=3 bgcolor=green>Nothing to report</td></tr>");
            }
            if (results == null) continue;
            j = results.iterator();
            while (j.hasNext()) {
                XSTCTester.summarizeResultAsHTMLTableRows((TestCaseResult)j.next(), writer);
            }
        }
        writer.println("<tr><td colspan=3>Summary: " + failures + " failures out of " + cases + " cases run.</td></tr>");
        writer.println("</table>");
        writer.close();
        long finish = System.currentTimeMillis();
        System.out.println("Time run tests: " + (double)(finish - start) / 1000.0 + " seconds");
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            Runtime.getRuntime().exec("cmd /c start iexplore \"" + resultsFile.getAbsolutePath() + "\"");
        } else {
            System.out.println("Results output to " + resultsFile);
        }
    }

    public static String makeHTMLLink(File file, boolean value) {
        if (file == null) {
            return "&nbsp;";
        }
        URI uri = file.getAbsoluteFile().toURI();
        return "<a href=\"" + uri + "\" target=_blank>" + Boolean.toString(value) + "</a>";
    }

    public static String makeHTMLDescription(TestCase testCase) {
        StringBuffer sb = new StringBuffer();
        sb.append("<a class=noline target=xstc href='about:<frameset rows=*,*>");
        if (testCase.getSchemaFile() == null) {
            sb.append("<frame src=\"about:No schema\">");
        } else {
            sb.append("<frame src=\"" + testCase.getSchemaFile().getAbsolutePath() + "\">");
        }
        if (testCase.getInstanceFile() == null) {
            sb.append("<frame src=\"about:No instance\">");
        } else {
            sb.append("<frame src=\"" + testCase.getInstanceFile().getAbsolutePath() + "\">");
        }
        sb.append("</frameset>'><xmp>");
        sb.append(leadingSpace.matcher(testCase.getDescription()).replaceAll("") + "(" + testCase.getId() + ")");
        sb.append("</xmp></a>");
        return sb.toString();
    }

    public static void summarizeResultAsHTMLTableRows(TestCaseResult result, PrintWriter out) {
        TestCase testCase = result.getTestCase();
        boolean sRight = testCase.getSchemaFile() == null || testCase.isSvExpected() == result.isSvActual();
        boolean iRight = testCase.getInstanceFile() == null || testCase.isIvExpected() == result.isIvActual();
        out.println(result.isCrash() ? "<tr bgcolor=black color=white>" : "<tr>");
        out.println("<td valign=top>" + XSTCTester.makeHTMLDescription(testCase) + "</td>");
        String sLinks = testCase.getResourceFile() == null ? XSTCTester.makeHTMLLink(testCase.getSchemaFile(), result.isSvActual()) : XSTCTester.makeHTMLLink(testCase.getSchemaFile(), result.isSvActual()) + "<br>" + XSTCTester.makeHTMLLink(testCase.getResourceFile(), result.isSvActual());
        out.println((sRight ? "<td valign=top>" : (result.isSvActual() ? "<td bgcolor=orange valign=top>" : "<td bgcolor=red valign=top>")) + sLinks + "</td>");
        out.println((iRight ? "<td valign=top>" : (result.isIvActual() ? "<td bgcolor=orange valign=top>" : "<td bgcolor=red valign=top>")) + XSTCTester.makeHTMLLink(testCase.getInstanceFile(), result.isIvActual()) + "</td>");
        out.println("</tr>");
        if (!result.getIvMessages().isEmpty() || !result.getSvMessages().isEmpty()) {
            if (!result.succeeded()) {
                out.println("<tr><td colspan=3 bgcolor=yellow><xmp>");
            } else {
                out.println("<tr><td colspan=3><xmp>");
            }
            Iterator j = result.getSvMessages().iterator();
            while (j.hasNext()) {
                out.println(j.next());
            }
            Iterator j2 = result.getIvMessages().iterator();
            while (j2.hasNext()) {
                out.println(j2.next());
            }
            out.println("</xmp></tr></td>");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static TestCase[] parseLTGFile(File ltgFile, Collection outerErrors) {
        block17: {
            errors = new ArrayList<E>();
            try {
                ltgOptions = new XmlOptions();
                ltgOptions.setLoadSubstituteNamespaces(Collections.singletonMap("", "http://www.bea.com/2003/05/xmlbean/ltgfmt"));
                ltgOptions.setErrorListener(errors);
                ltgOptions.setLoadLineNumbers();
                doc = TestsDocument.Factory.parse(ltgFile, ltgOptions);
                if (!doc.validate(ltgOptions)) {
                    throw new Exception("Document " + ltgFile + " not valid.");
                }
                testCases = doc.getTests().getTestArray();
                result = new ArrayList<TestCase>();
                i = 0;
                while (i < testCases.length) {
                    newCase = new TestCase();
                    TestCase.access$102(newCase, ltgFile);
                    TestCase.access$202(newCase, testCases[i].getId());
                    TestCase.access$302(newCase, testCases[i].getOrigin());
                    TestCase.access$402(newCase, testCases[i].getDescription());
                    filedescs = testCases[i].getFiles().getFileArray();
                    testCases[i].getOrigin();
                    j = 0;
                    while (j < filedescs.length) {
                        dir = filedescs[j].getFolder();
                        filename = filedescs[j].getFileName();
                        theFile = new File(ltgFile.getParentFile(), dir + "/" + filename);
                        if (!(theFile.exists() && theFile.isFile() && theFile.canRead())) {
                            outerErrors.add(XmlError.forObject("Can't read file " + theFile, filedescs[j]).toString());
                        } else {
                            switch (filedescs[j].getRole().intValue()) {
                                case 2: {
                                    if (TestCase.access$500(newCase) != null) {
                                        outerErrors.add(XmlError.forObject("More than one instance file speicifed - ignoring all but last", filedescs[j]).toString());
                                    }
                                    TestCase.access$502(newCase, theFile);
                                    TestCase.access$602(newCase, filedescs[j].getValidity());
                                    break;
                                }
                                case 1: {
                                    if (TestCase.access$700(newCase) != null) {
                                        outerErrors.add(XmlError.forObject("More than one schema file speicifed - ignoring all but last", filedescs[j]).toString());
                                    }
                                    TestCase.access$702(newCase, theFile);
                                    TestCase.access$802(newCase, filedescs[j].getValidity());
                                    break;
                                }
                                case 3: {
                                    if (TestCase.access$900(newCase) != null) {
                                        outerErrors.add(XmlError.forObject("More than one resource file speicifed - ignoring all but last", filedescs[j]).toString());
                                    }
                                    TestCase.access$902(newCase, theFile);
                                    TestCase.access$1002(newCase, filedescs[j].getValidity());
                                    break;
                                }
                                default: {
                                    throw new XmlException(XmlError.forObject("Unexpected file role", filedescs[j]));
                                }
                            }
                        }
                        ++j;
                    }
                    result.add(newCase);
                    ++i;
                }
                return result.toArray(new TestCase[result.size()]);
            }
            catch (Exception e) {
                if (errors.isEmpty()) {
                    outerErrors.add(e.getMessage());
                    break block17;
                }
                i = errors.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                outerErrors.add(i.next().toString());
                continue;
            }
        }
        return null;
    }

    public static interface Harness {
        public void runTestCase(TestCaseResult var1);
    }

    public static class TestCaseResult {
        private TestCase testCase;
        private boolean svActual;
        private Collection svMessages = new ArrayList();
        private boolean ivActual;
        private Collection ivMessages = new ArrayList();
        private boolean crash;

        public TestCase getTestCase() {
            return this.testCase;
        }

        public boolean isSvActual() {
            return this.svActual;
        }

        public void setSvActual(boolean svActual) {
            this.svActual = svActual;
        }

        public boolean isIvActual() {
            return this.ivActual;
        }

        public void setIvActual(boolean ivActual) {
            this.ivActual = ivActual;
        }

        public Collection getSvMessages() {
            return Collections.unmodifiableCollection(this.svMessages);
        }

        public void addSvMessages(Collection svMessages) {
            this.svMessages.addAll(svMessages);
        }

        public Collection getIvMessages() {
            return Collections.unmodifiableCollection(this.ivMessages);
        }

        public void addIvMessages(Collection ivMessages) {
            this.ivMessages.addAll(ivMessages);
        }

        public void setCrash(boolean crash) {
            this.crash = crash;
        }

        public boolean isCrash() {
            return this.crash;
        }

        public boolean succeeded() {
            return !this.crash && this.isIvActual() == this.testCase.isIvExpected() && this.isSvActual() == this.testCase.isSvExpected();
        }
    }

    public static class TestCase {
        private File ltgFile;
        private String id;
        private String origin;
        private String description;
        private File schemaFile;
        private File instanceFile;
        private File resourceFile;
        private boolean svExpected;
        private boolean ivExpected;
        private boolean rvExpected;

        public File getLtgFile() {
            return this.ltgFile;
        }

        public String getId() {
            return this.id;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getDescription() {
            return this.description;
        }

        public File getSchemaFile() {
            return this.schemaFile;
        }

        public File getInstanceFile() {
            return this.instanceFile;
        }

        public File getResourceFile() {
            return this.resourceFile;
        }

        public boolean isSvExpected() {
            return this.svExpected;
        }

        public boolean isIvExpected() {
            return this.ivExpected;
        }

        public boolean isRvExpected() {
            return this.rvExpected;
        }

        static /* synthetic */ File access$102(TestCase x0, File x1) {
            x0.ltgFile = x1;
            return x0.ltgFile;
        }

        static /* synthetic */ String access$202(TestCase x0, String x1) {
            x0.id = x1;
            return x0.id;
        }

        static /* synthetic */ String access$302(TestCase x0, String x1) {
            x0.origin = x1;
            return x0.origin;
        }

        static /* synthetic */ String access$402(TestCase x0, String x1) {
            x0.description = x1;
            return x0.description;
        }

        static /* synthetic */ File access$500(TestCase x0) {
            return x0.instanceFile;
        }

        static /* synthetic */ File access$502(TestCase x0, File x1) {
            x0.instanceFile = x1;
            return x0.instanceFile;
        }

        static /* synthetic */ boolean access$602(TestCase x0, boolean x1) {
            x0.ivExpected = x1;
            return x0.ivExpected;
        }

        static /* synthetic */ File access$700(TestCase x0) {
            return x0.schemaFile;
        }

        static /* synthetic */ File access$702(TestCase x0, File x1) {
            x0.schemaFile = x1;
            return x0.schemaFile;
        }

        static /* synthetic */ boolean access$802(TestCase x0, boolean x1) {
            x0.svExpected = x1;
            return x0.svExpected;
        }

        static /* synthetic */ File access$900(TestCase x0) {
            return x0.resourceFile;
        }

        static /* synthetic */ File access$902(TestCase x0, File x1) {
            x0.resourceFile = x1;
            return x0.resourceFile;
        }

        static /* synthetic */ boolean access$1002(TestCase x0, boolean x1) {
            x0.rvExpected = x1;
            return x0.rvExpected;
        }
    }
}

