/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.xbean.tool.SchemaCompiler;
import com.bea.xml.XmlError;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class XMLBean
extends MatchingTask {
    private ArrayList schemas = new ArrayList();
    private Path classpath;
    private File destfile;
    private File schema;
    private File srcgendir;
    private File classgendir;
    private boolean verbose = true;
    private boolean download;
    private boolean srconly;
    private boolean failonerror = true;
    private String typesystemname;
    private HashMap _extRouter = new HashMap(5);
    private static final String XSD = ".xsd";
    private static final String WSDL = ".wsdl";
    private static final String JAVA = ".java";
    private static final String XSDCONFIG = ".xsdconfig";

    public void execute() throws BuildException {
        if (this.schemas.size() == 0 && this.schema == null && this.fileset.getDir(this.project) == null) {
            String msg = "The 'schema' or 'dir' attribute or a nested fileset is required.";
            if (this.failonerror) {
                throw new BuildException(msg);
            }
            this.log(msg, 0);
            return;
        }
        this._extRouter.put(XSD, new HashSet());
        this._extRouter.put(WSDL, new HashSet());
        this._extRouter.put(JAVA, new HashSet());
        this._extRouter.put(XSDCONFIG, new HashSet());
        File theBasedir = this.schema;
        if (this.schema != null) {
            if (this.schema.isDirectory()) {
                DirectoryScanner scanner = this.getDirectoryScanner(this.schema);
                String[] paths = scanner.getIncludedFiles();
                this.processPaths(paths, scanner.getBasedir());
            } else {
                theBasedir = this.schema.getParentFile();
                this.processPaths(new String[]{this.schema.getName()}, theBasedir);
            }
        }
        if (this.fileset.getDir(this.project) != null) {
            this.schemas.add(this.fileset);
        }
        Iterator si = this.schemas.iterator();
        while (si.hasNext()) {
            FileSet fs = (FileSet)si.next();
            DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
            File basedir = scanner.getBasedir();
            String[] paths = scanner.getIncludedFiles();
            this.processPaths(paths, basedir);
        }
        Set xsdList = (Set)this._extRouter.get(XSD);
        Set wsdlList = (Set)this._extRouter.get(WSDL);
        if (xsdList.size() + wsdlList.size() == 0) {
            this.log("Could not find any xsd or wsdl files to process.", 1);
            return;
        }
        Set javaList = (Set)this._extRouter.get(JAVA);
        Set xsdconfigList = (Set)this._extRouter.get(XSDCONFIG);
        if (this.srcgendir == null && this.srconly) {
            this.srcgendir = this.classgendir;
        }
        if (this.destfile == null && this.classgendir == null && !this.srconly) {
            this.destfile = new File("xmltypes.jar");
        }
        File[] cp = null;
        if (this.classpath != null) {
            String[] paths = this.classpath.list();
            cp = new File[paths.length];
            int i = 0;
            while (i < paths.length) {
                cp[i] = new File(paths[i]);
                ++i;
            }
        }
        File[] xsdArray = xsdList.toArray(new File[xsdList.size()]);
        File[] wsdlArray = wsdlList.toArray(new File[wsdlList.size()]);
        File[] javaArray = javaList.toArray(new File[javaList.size()]);
        File[] xsdconfigArray = xsdconfigList.toArray(new File[xsdconfigList.size()]);
        ErrorLogger err = new ErrorLogger(this.verbose);
        boolean success = false;
        try {
            SchemaCompiler.Parameters params = new SchemaCompiler.Parameters();
            params.setBaseDir(theBasedir);
            params.setXsdFiles(xsdArray);
            params.setWsdlFiles(wsdlArray);
            params.setJavaFiles(javaArray);
            params.setConfigFiles(xsdconfigArray);
            params.setClasspath(cp);
            params.setOutputJar(this.destfile);
            params.setName(this.typesystemname);
            params.setSrcDir(this.srcgendir);
            params.setClassesDir(this.classgendir);
            params.setNojavac(this.srconly);
            params.setCline(this.verbose);
            params.setDownload(this.download);
            params.setErrorListener(err);
            success = SchemaCompiler.compile(params);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                throw new BuildException(e);
            }
            this.log("Exception while building schemas:", 0);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.log(sw.toString(), 2);
        }
        if (!success && this.failonerror) {
            throw new BuildException();
        }
    }

    private void processPaths(String[] paths, File baseDir) {
        int i = 0;
        while (i < paths.length) {
            String path;
            String possExt;
            Set set;
            int dot = paths[i].lastIndexOf(46);
            if (dot > -1 && (set = (Set)this._extRouter.get(possExt = (path = paths[i]).substring(dot).toLowerCase())) != null) {
                set.add(new File(baseDir, path));
            }
            ++i;
        }
    }

    public void addFileset(FileSet fileset) {
        this.schemas.add(fileset);
    }

    public File getSchema() {
        return this.schema;
    }

    public void setSchema(File schema) {
        this.schema = schema;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath != null) {
            this.classpath.append(classpath);
        } else {
            this.classpath = classpath;
        }
    }

    public void setClasspathRef(Reference classpathref) {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        this.classpath.createPath().setRefid(classpathref);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public File getSrcgendir() {
        return this.srcgendir;
    }

    public void setSrcgendir(File srcgendir) {
        this.srcgendir = srcgendir;
    }

    public File getClassgendir() {
        return this.classgendir;
    }

    public void setClassgendir(File classgendir) {
        this.classgendir = classgendir;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSrconly() {
        return this.srconly;
    }

    public void setSrconly(boolean srconly) {
        this.srconly = srconly;
    }

    public String getTypesystemname() {
        return this.typesystemname;
    }

    public void setTypesystemname(String typesystemname) {
        this.typesystemname = typesystemname;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    private static URI uriFromFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile().toURI();
        }
        catch (IOException e) {
            return f.getAbsoluteFile().toURI();
        }
    }

    public class ErrorLogger
    extends AbstractCollection {
        private boolean _noisy;
        private URI _baseURI;

        public ErrorLogger(boolean noisy) {
            this._noisy = noisy;
            this._baseURI = XMLBean.uriFromFile(XMLBean.this.project.getBaseDir());
        }

        public boolean add(Object o) {
            if (o instanceof XmlError) {
                XmlError err = (XmlError)o;
                if (err.getSeverity() == 0) {
                    XMLBean.this.log(err.toString(this._baseURI), 0);
                } else if (err.getSeverity() == 1) {
                    XMLBean.this.log(err.toString(this._baseURI), 1);
                } else if (this._noisy) {
                    XMLBean.this.log(err.toString(this._baseURI), 2);
                }
            }
            return false;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public int size() {
            return 0;
        }
    }
}

