/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.xbean.common.IOUtil;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlObject;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3.x2001.xmlSchema.ImportDocument;
import org.w3.x2001.xmlSchema.IncludeDocument;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TDefinitions;
import org.xmlsoap.schemas.wsdl.TImport;
import org.xmlsoap.schemas.wsdl.TTypes;

public class SchemaCopy {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: schemacopy sourceurl [targetfile]");
            return;
        }
        URI source = null;
        URI target = null;
        try {
            source = new URI(args[0]);
            source.toURL();
        }
        catch (Exception e) {
            System.err.println("Badly formed URL " + source);
            return;
        }
        if (args.length < 2) {
            try {
                URI dir = new File(".").getCanonicalFile().toURI();
                String lastPart = source.getPath();
                lastPart = lastPart.substring(lastPart.lastIndexOf(47) + 1);
                target = dir.resolve(lastPart);
            }
            catch (Exception e) {
                System.err.println("Cannot canonicalize current directory");
                return;
            }
        }
        try {
            target = new URI(args[1]);
            if (!target.isAbsolute()) {
                target = null;
            } else if (!target.getScheme().equals("file")) {
                target = null;
            }
        }
        catch (Exception e) {
            target = null;
        }
        if (target == null) {
            try {
                target = new File(target).getCanonicalFile().toURI();
            }
            catch (Exception e) {
                System.err.println("Cannot canonicalize current directory");
                return;
            }
        }
        Map thingsToCopy = SchemaCopy.findAllRelative(source, target);
        SchemaCopy.copyAll(thingsToCopy, true);
    }

    private static void copyAll(Map uriMap, boolean stdout) {
        Iterator i = uriMap.keySet().iterator();
        while (i.hasNext()) {
            URI source = (URI)i.next();
            URI target = (URI)uriMap.get(source);
            try {
                IOUtil.copyCompletely(source, target);
            }
            catch (Exception e) {
                if (!stdout) continue;
                System.out.println("Could not copy " + source + " -> " + target);
                continue;
            }
            if (!stdout) continue;
            System.out.println("Copied " + source + " -> " + target);
        }
    }

    public static Map findAllRelative(URI source, URI target) {
        LinkedHashMap<URI, URI> result = new LinkedHashMap<URI, URI>();
        result.put(source, target);
        LinkedList<URI> process = new LinkedList<URI>();
        process.add(source);
        while (!process.isEmpty()) {
            URI nextSource = (URI)process.removeFirst();
            URI nextTarget = (URI)result.get(nextSource);
            Map nextResults = SchemaCopy.findRelativeInOne(nextSource, nextTarget);
            Iterator i = nextResults.keySet().iterator();
            while (i.hasNext()) {
                URI newSource = (URI)i.next();
                if (result.containsKey(newSource)) continue;
                result.put(newSource, (URI)nextResults.get(newSource));
                process.add(newSource);
            }
        }
        return result;
    }

    private static Map findRelativeInOne(URI source, URI target) {
        try {
            URL sourceURL = source.toURL();
            XmlObject xobj = XmlObject.Factory.parse(sourceURL);
            XmlCursor xcur = xobj.newCursor();
            xcur.toFirstChild();
            QName name = xcur.getName();
            LinkedHashMap result = new LinkedHashMap();
            if (xobj instanceof SchemaDocument) {
                SchemaCopy.putMappingsFromSchema(result, source, target, ((SchemaDocument)xobj).getSchema());
            } else if (xobj instanceof DefinitionsDocument) {
                SchemaCopy.putMappingsFromWsdl(result, source, target, ((DefinitionsDocument)xobj).getDefinitions());
            }
            return result;
        }
        catch (Exception e) {
            return Collections.EMPTY_MAP;
        }
    }

    private static void putNewMapping(Map result, URI origSource, URI origTarget, String literalURI) {
        try {
            if (literalURI == null) {
                return;
            }
            URI newRelative = new URI(literalURI);
            if (newRelative.isAbsolute()) {
                return;
            }
            URI newSource = origSource.resolve(newRelative);
            URI newTarget = origTarget.resolve(newRelative);
            result.put(newSource, newTarget);
        }
        catch (URISyntaxException e) {}
    }

    private static void putMappingsFromSchema(Map result, URI source, URI target, SchemaDocument.Schema schema) {
        ImportDocument.Import[] imports = schema.getImportArray();
        int i = 0;
        while (i < imports.length) {
            SchemaCopy.putNewMapping(result, source, target, imports[i].getSchemaLocation());
            ++i;
        }
        IncludeDocument.Include[] includes = schema.getIncludeArray();
        int i2 = 0;
        while (i2 < includes.length) {
            SchemaCopy.putNewMapping(result, source, target, includes[i2].getSchemaLocation());
            ++i2;
        }
    }

    private static void putMappingsFromWsdl(Map result, URI source, URI target, TDefinitions wdoc) {
        TTypes[] types = wdoc.getTypesArray();
        int i = 0;
        while (i < types.length) {
            SchemaDocument.Schema[] schemas = (SchemaDocument.Schema[])types[i].selectPath("declare namespace xs='http://www.w3.org/2001/XMLSchema' xs:schema");
            int j = 0;
            while (j < schemas.length) {
                SchemaCopy.putMappingsFromSchema(result, source, target, schemas[j]);
                ++j;
            }
            ++i;
        }
        TImport[] imports = wdoc.getImportArray();
        int i2 = 0;
        while (i2 < imports.length) {
            SchemaCopy.putNewMapping(result, source, target, imports[i2].getLocation());
            ++i2;
        }
    }
}

