/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.x2002.x09.xbean.config.ConfigDocument;
import com.bea.xbean.common.XmlErrorPrinter;
import com.bea.xbean.common.XmlErrorWatcher;
import com.bea.xbean.schema.PathResourceLoader;
import com.bea.xbean.schema.ResourceLoader;
import com.bea.xbean.schema.SchemaTypeLoaderImpl;
import com.bea.xbean.schema.SchemaTypeSystemCompiler;
import com.bea.xbean.schema.StscState;
import com.bea.xbean.tool.CodeGenUtil;
import com.bea.xbean.tool.CommandLine;
import com.bea.xbean.tool.SchemaCodeGenerator;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TTypes;

public class SchemaCompiler {
    static /* synthetic */ Class class$org$w3$x2001$xmlSchema$SchemaDocument;

    public static void main(String[] args) {
        URI baseURI;
        XmlErrorPrinter err;
        File baseDir;
        boolean result;
        if (args.length == 0) {
            System.out.println("Compiles a schema into XML Bean classes and metadata.");
            System.out.println("Usage: scomp [opts] [dirs]* [schema.xsd]* [service.wsdl]* [config.xsdconfig]*");
            System.out.println("Options include:");
            System.out.println("    -cp [a;b;c] - classpath");
            System.out.println("    -d [dir] - target binary directory for .class and .xsb files");
            System.out.println("    -src [dir] - target directory for generated .java files");
            System.out.println("    -srconly - do not compile .java files or jar the output.");
            System.out.println("    -out [result.jar] - the name of the output jar");
            System.out.println("    -dl - permit network downloads for imports and includes (default is off)");
            System.out.println("    -noupa - do not enforce the unique particle attribution rule");
            System.out.println("    -nopvr - do not enforce the particle valid (restriction) rule");
            System.out.println("    -quiet - print fewer informational messages");
            System.out.println("    -license prints license information");
            System.exit(0);
            return;
        }
        HashSet<String> opts = new HashSet<String>();
        opts.add("out");
        opts.add("name");
        opts.add("src");
        opts.add("d");
        opts.add("cp");
        CommandLine cl = new CommandLine(args, opts);
        if (cl.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        args = cl.args();
        boolean verbose = cl.getOpt("quiet") == null;
        String outputfilename = cl.getOpt("out");
        String name = cl.getOpt("name");
        boolean download = cl.getOpt("dl") != null;
        boolean noUpa = cl.getOpt("noupa") != null;
        boolean noPvr = cl.getOpt("nopvr") != null;
        boolean nojavac = cl.getOpt("srconly") != null;
        String classesdir = cl.getOpt("d");
        File classes = null;
        if (classesdir != null) {
            classes = new File(classesdir);
        }
        String srcdir = cl.getOpt("src");
        File src = null;
        if (srcdir != null) {
            src = new File(srcdir);
        }
        if (nojavac && srcdir == null && classes != null) {
            src = classes;
        }
        File jarfile = null;
        if (outputfilename == null && classes == null && !nojavac) {
            outputfilename = "xmltypes.jar";
        }
        if (outputfilename != null) {
            jarfile = new File(outputfilename);
        }
        File[] classpath = null;
        String cpString = cl.getOpt("cp");
        if (cpString != null) {
            String[] cpparts = cpString.split(File.pathSeparator);
            ArrayList<File> cpList = new ArrayList<File>();
            int i = 0;
            while (i < cpparts.length) {
                cpList.add(new File(cpparts[i]));
                ++i;
            }
            classpath = cpList.toArray(new File[cpList.size()]);
        } else {
            classpath = CodeGenUtil.systemClasspath();
        }
        File[] xsdFiles = cl.filesEndingWith(".xsd");
        File[] wsdlFiles = cl.filesEndingWith(".wsdl");
        File[] javaFiles = cl.filesEndingWith(".java");
        File[] configFiles = cl.filesEndingWith(".xsdconfig");
        if (xsdFiles.length + wsdlFiles.length == 0) {
            System.err.println("Could not find any xsd or wsdl files to process.");
            System.exit(1);
        }
        if (!(result = SchemaCompiler.compileImpl(baseDir, xsdFiles, wsdlFiles, javaFiles, configFiles, classpath, jarfile, name, src, classes, nojavac, verbose, download, noUpa, noPvr, err = new XmlErrorPrinter(verbose, baseURI = (baseDir = cl.getBaseDir()) == null ? null : baseDir.toURI())))) {
            System.exit(1);
        }
        System.exit(0);
    }

    public static boolean compile(Parameters params) {
        return SchemaCompiler.compileImpl(params.getBaseDir(), params.getXsdFiles(), params.getWsdlFiles(), params.getJavaFiles(), params.getConfigFiles(), params.getClasspath(), params.getOutputJar(), params.getName(), params.getSrcDir(), params.getClassesDir(), params.isNojavac(), params.isCline(), params.isDownload(), params.isNoUpa(), params.isNoPvr(), params.getErrorListener());
    }

    public static SchemaTypeSystem loadTypeSystem(String name, File[] xsdFiles, File[] wsdlFiles, File[] configFiles, ResourceLoader cpResourceLoader, boolean download, boolean noUpa, boolean noPvr, File baseDir, Map sourcesToCopyMap, Collection outerErrorListener) {
        XmlOptions options;
        int i;
        XmlErrorWatcher errorListener = new XmlErrorWatcher(outerErrorListener);
        SchemaTypeLoader loader = XmlBeans.typeLoaderForClassLoader((class$org$w3$x2001$xmlSchema$SchemaDocument == null ? (class$org$w3$x2001$xmlSchema$SchemaDocument = SchemaCompiler.class$("org.w3.x2001.xmlSchema.SchemaDocument")) : class$org$w3$x2001$xmlSchema$SchemaDocument).getClassLoader());
        ArrayList<SchemaDocument.Schema> scontentlist = new ArrayList<SchemaDocument.Schema>();
        if (xsdFiles != null) {
            i = 0;
            while (i < xsdFiles.length) {
                try {
                    options = new XmlOptions();
                    options.put("LOAD_LINE_NUMBERS");
                    options.put("LOAD_MESSAGE_DIGEST");
                    XmlObject schemadoc = loader.parse(xsdFiles[i], null, options);
                    if (!(schemadoc instanceof SchemaDocument)) {
                        StscState.addError((Collection)errorListener, "Document " + xsdFiles[i] + " is not a schema file", 1, schemadoc);
                    } else {
                        StscState.addInfo(errorListener, "Loading schema file " + xsdFiles[i]);
                        XmlOptions opts = new XmlOptions().setErrorListener(errorListener);
                        if (schemadoc.validate(opts)) {
                            scontentlist.add(((SchemaDocument)schemadoc).getSchema());
                        }
                    }
                }
                catch (XmlException e) {
                    errorListener.add(e.getError());
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, "Cannot load file " + xsdFiles[i] + ": " + e, 1, xsdFiles[i]);
                }
                ++i;
            }
        }
        if (wsdlFiles != null) {
            i = 0;
            while (i < wsdlFiles.length) {
                try {
                    options = new XmlOptions();
                    options.put("LOAD_LINE_NUMBERS");
                    XmlObject wsdldoc = loader.parse(wsdlFiles[i], null, options);
                    if (!(wsdldoc instanceof DefinitionsDocument)) {
                        StscState.addError((Collection)errorListener, "Document " + wsdlFiles[i] + " is not a wsdl file", 1, wsdldoc);
                    } else {
                        StscState.addInfo(errorListener, "Loading wsdl file " + wsdlFiles[i]);
                        TTypes[] types = ((DefinitionsDocument)wsdldoc).getDefinitions().getTypesArray();
                        int count = 0;
                        int j = 0;
                        while (j < types.length) {
                            SchemaDocument.Schema[] schemas = (SchemaDocument.Schema[])types[j].selectPath("declare namespace xs=\"http://www.w3.org/2001/XMLSchema\" xs:schema");
                            int k = 0;
                            while (k < schemas.length) {
                                if (schemas[k].validate(new XmlOptions().setErrorListener(errorListener))) {
                                    scontentlist.add(schemas[k]);
                                }
                                ++k;
                            }
                            count += schemas.length;
                            ++j;
                        }
                        StscState.addInfo(errorListener, "Processing " + count + " schema(s) in " + wsdlFiles[i].toString());
                    }
                }
                catch (XmlException e) {
                    errorListener.add(e.getError());
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, "Cannot load file " + wsdlFiles[i] + ": " + e, 1, wsdlFiles[i]);
                }
                ++i;
            }
        }
        SchemaDocument.Schema[] sdocs = scontentlist.toArray(new SchemaDocument.Schema[scontentlist.size()]);
        ArrayList<ConfigDocument.Config> cdoclist = new ArrayList<ConfigDocument.Config>();
        if (configFiles != null) {
            int i2 = 0;
            while (i2 < configFiles.length) {
                try {
                    XmlOptions options2 = new XmlOptions();
                    options2.put("LOAD_LINE_NUMBERS");
                    XmlObject configdoc = XmlObject.Factory.parse(new FileInputStream(configFiles[i2]), options2);
                    if (!(configdoc instanceof ConfigDocument)) {
                        StscState.addError((Collection)errorListener, "Document " + configFiles[i2] + " is not an xsd config file", 1, configdoc);
                    } else {
                        StscState.addInfo(errorListener, "Loading config file " + configFiles[i2]);
                        if (configdoc.validate(new XmlOptions().setErrorListener(errorListener))) {
                            cdoclist.add(((ConfigDocument)configdoc).getConfig());
                        }
                    }
                }
                catch (XmlException e) {
                    errorListener.add(e.getError());
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, "Cannot load xsd config file " + configFiles[i2] + ": " + e, 2, configFiles[i2]);
                }
                ++i2;
            }
        }
        ConfigDocument.Config[] cdocs = cdoclist.toArray(new ConfigDocument.Config[cdoclist.size()]);
        SchemaTypeLoader linkTo = SchemaTypeLoaderImpl.build(null, cpResourceLoader, null);
        URI baseURI = null;
        if (baseDir != null) {
            baseURI = baseDir.toURI();
        }
        XmlOptions opts = new XmlOptions();
        if (download) {
            opts.setCompileDownloadUrls();
        }
        if (noUpa) {
            opts.setCompileNoUpaRule();
        }
        if (noPvr) {
            opts.setCompileNoPvrRule();
        }
        opts.setCompileNoValidation();
        SchemaTypeSystemCompiler.Parameters params = new SchemaTypeSystemCompiler.Parameters();
        params.setName(name);
        params.setSchemas(sdocs);
        params.setConfigs(cdocs);
        params.setLinkTo(linkTo);
        params.setOptions(opts);
        params.setErrorListener(errorListener);
        params.setJavaize(true);
        params.setBaseURI(baseURI);
        params.setSourcesToCopyMap(sourcesToCopyMap);
        return SchemaTypeSystemCompiler.compile(params);
    }

    private static boolean compileImpl(File baseDir, File[] xsdFiles, File[] wsdlFiles, File[] javaFiles, File[] configFiles, File[] classpath, File outputJar, String name, File srcDir, File classesDir, boolean nojavac, boolean cline, boolean download, boolean noUpa, boolean noPvr, Collection outerErrorListener) {
        long start = System.currentTimeMillis();
        if (baseDir == null) {
            baseDir = new File(System.getProperty("user.dir"));
        }
        PathResourceLoader cpResourceLoader = null;
        HashMap sourcesToCopyMap = new HashMap();
        if (classpath != null) {
            cpResourceLoader = new PathResourceLoader(classpath);
        }
        boolean result = true;
        XmlErrorWatcher errorListener = new XmlErrorWatcher(outerErrorListener);
        SchemaTypeSystem system = SchemaCompiler.loadTypeSystem(name, xsdFiles, wsdlFiles, configFiles, cpResourceLoader, download, noUpa, noPvr, baseDir, sourcesToCopyMap, errorListener);
        if (errorListener.hasError()) {
            result = false;
        }
        long finish = System.currentTimeMillis();
        if (cline) {
            System.out.println("Time to build schema type system: " + (double)(finish - start) / 1000.0 + " seconds");
        }
        if (result && system != null) {
            if (!SchemaCodeGenerator.compileTypeSystem(system, srcDir, javaFiles, sourcesToCopyMap, classpath, classesDir, outputJar, nojavac)) {
                result = false;
            } else {
                finish = System.currentTimeMillis();
                if (cline) {
                    System.out.println("Time to generate code: " + (double)(finish - start) / 1000.0 + " seconds");
                }
                if (cline && outputJar != null) {
                    System.out.println("Compiled types to " + outputJar);
                }
            }
        }
        if (!result && cline) {
            System.out.println("BUILD FAILED");
        }
        if (cpResourceLoader != null) {
            cpResourceLoader.close();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Parameters {
        private File baseDir;
        private File[] xsdFiles;
        private File[] wsdlFiles;
        private File[] javaFiles;
        private File[] configFiles;
        private File[] classpath;
        private File outputJar;
        private String name;
        private File srcDir;
        private File classesDir;
        private boolean nojavac;
        private boolean cline;
        private boolean download;
        private Collection errorListener;
        private boolean noUpa;
        private boolean noPvr;

        public File getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(File baseDir) {
            this.baseDir = baseDir;
        }

        public File[] getXsdFiles() {
            return this.xsdFiles;
        }

        public void setXsdFiles(File[] xsdFiles) {
            this.xsdFiles = xsdFiles;
        }

        public File[] getWsdlFiles() {
            return this.wsdlFiles;
        }

        public void setWsdlFiles(File[] wsdlFiles) {
            this.wsdlFiles = wsdlFiles;
        }

        public File[] getJavaFiles() {
            return this.javaFiles;
        }

        public void setJavaFiles(File[] javaFiles) {
            this.javaFiles = javaFiles;
        }

        public File[] getConfigFiles() {
            return this.configFiles;
        }

        public void setConfigFiles(File[] configFiles) {
            this.configFiles = configFiles;
        }

        public File[] getClasspath() {
            return this.classpath;
        }

        public void setClasspath(File[] classpath) {
            this.classpath = classpath;
        }

        public File getOutputJar() {
            return this.outputJar;
        }

        public void setOutputJar(File outputJar) {
            this.outputJar = outputJar;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public File getSrcDir() {
            return this.srcDir;
        }

        public void setSrcDir(File srcDir) {
            this.srcDir = srcDir;
        }

        public File getClassesDir() {
            return this.classesDir;
        }

        public void setClassesDir(File classesDir) {
            this.classesDir = classesDir;
        }

        public boolean isNojavac() {
            return this.nojavac;
        }

        public void setNojavac(boolean nojavac) {
            this.nojavac = nojavac;
        }

        public boolean isCline() {
            return this.cline;
        }

        public void setCline(boolean cline) {
            this.cline = cline;
        }

        public boolean isDownload() {
            return this.download;
        }

        public void setDownload(boolean download) {
            this.download = download;
        }

        public boolean isNoUpa() {
            return this.noUpa;
        }

        public void setNoUpa(boolean noUpa) {
            this.noUpa = noUpa;
        }

        public boolean isNoPvr() {
            return this.noPvr;
        }

        public void setNoPvr(boolean noPvr) {
            this.noPvr = noPvr;
        }

        public Collection getErrorListener() {
            return this.errorListener;
        }

        public void setErrorListener(Collection errorListener) {
            this.errorListener = errorListener;
        }
    }
}

