/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.xbean.common.IOUtil;
import com.bea.xbean.schema.SchemaTypeCodePrinter;
import com.bea.xbean.tool.CodeGenUtil;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SchemaCodeGenerator {
    private static Set deleteFileQueue;
    private static int triesRemaining;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$tool$SchemaCodeGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean compileTypeSystem(SchemaTypeSystem saver, File sourcedir, File[] javasrc, Map sourcesToCopyMap, File[] classpath, File classesdir, File outputJar, boolean nojavac) {
        File rootdir = null;
        File tempdir = null;
        boolean failure = false;
        if (sourcedir == null || classesdir == null) {
            try {
                tempdir = SchemaCodeGenerator.createTempDir();
            }
            catch (IOException e) {
                System.err.println("Error creating temp dir " + e);
                return false;
            }
            rootdir = tempdir;
        }
        if (sourcedir == null) {
            sourcedir = SchemaCodeGenerator.createDir(rootdir, "src");
        }
        if (classesdir == null) {
            classesdir = SchemaCodeGenerator.createDir(rootdir, "classes");
        }
        saver.saveToDirectory(classesdir);
        if (sourcesToCopyMap != null && sourcesToCopyMap.size() > 0) {
            File schemasdir = SchemaCodeGenerator.createDir(classesdir, "schema/src");
            Iterator iter = sourcesToCopyMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    URL url = new URL(key);
                    String schemalocation = (String)sourcesToCopyMap.get(key);
                    File targetFile = new File(schemasdir, schemalocation);
                    File parentDir = new File(targetFile.getParent());
                    SchemaCodeGenerator.createDir(parentDir, null);
                    InputStream in = url.openStream();
                    FileOutputStream out = new FileOutputStream(new File(schemasdir, schemalocation));
                    IOUtil.copyCompletely(in, out);
                }
                catch (IOException e) {
                    System.err.println("IO Error " + e);
                }
            }
        }
        ArrayList<File> sourcefiles = new ArrayList<File>();
        try {
            String filename = SchemaTypeCodePrinter.indexClassForSystem(saver).replace('.', File.separatorChar) + ".java";
            File sourcefile = new File(sourcedir, filename);
            sourcefile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(sourcefile);
            SchemaTypeCodePrinter.printLoader(writer, saver);
            ((Writer)writer).close();
            sourcefiles.add(sourcefile);
        }
        catch (IOException e) {
            System.err.println("IO Error " + e);
            failure = true;
        }
        ArrayList<SchemaType> types = new ArrayList<SchemaType>();
        types.addAll(Arrays.asList(saver.globalTypes()));
        types.addAll(Arrays.asList(saver.documentTypes()));
        types.addAll(Arrays.asList(saver.attributeTypes()));
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Writer writer;
            String filename;
            SchemaType type;
            block39: {
                type = (SchemaType)i.next();
                if (type.isBuiltinType() || type.getFullJavaName() == null) continue;
                String fjn = type.getFullJavaName();
                if (fjn.indexOf(36) > 0) {
                    fjn = fjn.substring(0, fjn.lastIndexOf(46)) + "." + fjn.substring(fjn.indexOf(36) + 1);
                }
                filename = fjn.replace('.', File.separatorChar) + ".java";
                writer = null;
                File sourcefile = new File(sourcedir, filename);
                sourcefile.getParentFile().mkdirs();
                writer = new FileWriter(sourcefile);
                SchemaTypeCodePrinter.printType(writer, type);
                writer.close();
                sourcefiles.add(sourcefile);
                Object var21_25 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block39;
                }
                catch (IOException e2) {}
                break block39;
                {
                    catch (IOException e) {
                        System.err.println("IO Error " + e);
                        failure = true;
                        var21_25 = null;
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            break block39;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    var21_25 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            filename = type.getFullJavaImplName().replace('.', File.separatorChar) + ".java";
            File implFile = new File(sourcedir, filename);
            implFile.getParentFile().mkdirs();
            writer = new FileWriter(implFile);
            SchemaTypeCodePrinter.printTypeImpl(writer, type);
            writer.close();
            sourcefiles.add(implFile);
            Object var24_27 = null;
            try {
                if (writer == null) continue;
                writer.close();
            }
            catch (IOException e3) {}
            continue;
            {
                catch (IOException e) {
                    System.err.println("IO Error " + e);
                    failure = true;
                    var24_27 = null;
                    try {
                        if (writer == null) continue;
                        writer.close();
                    }
                    catch (IOException e3) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var24_27 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (failure) {
            return false;
        }
        if (!nojavac) {
            if (javasrc != null) {
                sourcefiles.addAll(Arrays.asList(javasrc));
            }
            if (!CodeGenUtil.externalCompile(sourcefiles, classesdir, classpath, false)) {
                return false;
            }
            if (outputJar != null && !CodeGenUtil.externalJar(classesdir, outputJar)) {
                return false;
            }
        }
        if (tempdir != null) {
            SchemaCodeGenerator.tryHardToDelete(tempdir);
        }
        return true;
    }

    private static File createDir(File rootdir, String subdir) {
        boolean created;
        File newdir = subdir == null ? rootdir : new File(rootdir, subdir);
        boolean bl = created = newdir.exists() && newdir.isDirectory() || newdir.mkdirs();
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)("Could not create " + newdir.getAbsolutePath()));
        }
        return newdir;
    }

    private static File createTempDir() throws IOException {
        File tmpFile = File.createTempFile("xbean", null);
        String path = tmpFile.getAbsolutePath();
        if (!path.endsWith(".tmp")) {
            throw new IOException("Error: createTempFile did not create a file ending with .tmp");
        }
        path = path.substring(0, path.length() - 4);
        File tmpSrcDir = null;
        int count = 0;
        while (count < 100) {
            String name = path + ".d" + (count == 0 ? "" : Integer.toString(count++));
            tmpSrcDir = new File(name);
            if (!tmpSrcDir.exists()) {
                boolean created = tmpSrcDir.mkdirs();
                if (!$assertionsDisabled && !created) {
                    throw new AssertionError((Object)("Could not create " + tmpSrcDir.getAbsolutePath()));
                }
                break;
            }
            ++count;
        }
        tmpFile.deleteOnExit();
        return tmpSrcDir;
    }

    private static void tryHardToDelete(File dir) {
        SchemaCodeGenerator.tryToDelete(dir);
        if (dir.exists()) {
            SchemaCodeGenerator.tryToDeleteLater(dir);
        }
    }

    private static void tryToDelete(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                String[] list = dir.list();
                int i = 0;
                while (i < list.length) {
                    SchemaCodeGenerator.tryToDelete(new File(dir, list[i]));
                    ++i;
                }
            }
            if (!dir.delete()) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryNowThatItsLater() {
        ArrayList files;
        Set set = deleteFileQueue;
        synchronized (set) {
            files = new ArrayList(deleteFileQueue);
            deleteFileQueue.clear();
        }
        ArrayList<File> retry = new ArrayList<File>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            SchemaCodeGenerator.tryToDelete(file);
            if (!file.exists()) continue;
            retry.add(file);
        }
        Set set2 = deleteFileQueue;
        synchronized (set2) {
            if (triesRemaining > 0) {
                --triesRemaining;
            }
            if (triesRemaining <= 0 || retry.size() == 0) {
                triesRemaining = 0;
            } else {
                deleteFileQueue.addAll(retry);
            }
            return triesRemaining <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void giveUp() {
        Set set = deleteFileQueue;
        synchronized (set) {
            deleteFileQueue.clear();
            triesRemaining = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryToDeleteLater(File dir) {
        Set set = deleteFileQueue;
        synchronized (set) {
            deleteFileQueue.add(dir);
            if (triesRemaining == 0) {
                new Thread(){

                    public void run() {
                        try {
                            while (true) {
                                if (SchemaCodeGenerator.tryNowThatItsLater()) {
                                    return;
                                }
                                Thread.sleep(3000L);
                            }
                        }
                        catch (InterruptedException e) {
                            SchemaCodeGenerator.giveUp();
                            return;
                        }
                    }
                };
            }
            if (triesRemaining < 10) {
                triesRemaining = 10;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$tool$SchemaCodeGenerator == null ? (class$com$bea$xbean$tool$SchemaCodeGenerator = SchemaCodeGenerator.class$("com.bea.xbean.tool.SchemaCodeGenerator")) : class$com$bea$xbean$tool$SchemaCodeGenerator).desiredAssertionStatus();
        deleteFileQueue = new HashSet();
        triesRemaining = 0;
    }
}

