/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import com.bea.xbean.tool.CommandLine;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class PrettyPrinter {
    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args, Collections.singleton("indent"));
        if (cl.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        if (cl.args().length == 0) {
            System.out.println("Pretty prints XML files.");
            System.out.println("Usage: xpretty [switches] file.xml");
            System.out.println("Switches:");
            System.out.println("    -indent #   use the given indent");
            System.out.println("    -license prints license information");
            return;
        }
        String indentStr = cl.getOpt("indent");
        int indent = indentStr == null ? 2 : Integer.parseInt(indentStr);
        File[] files = cl.getFiles();
        int i = 0;
        while (i < files.length) {
            block7: {
                XmlObject doc;
                try {
                    doc = XmlObject.Factory.parse(files[i], new XmlOptions().setLoadLineNumbers());
                }
                catch (Exception e) {
                    System.err.println(files[i] + " not loadable: " + e.getMessage());
                    break block7;
                }
                try {
                    doc.save(System.out, new XmlOptions().setSavePrettyPrint().setSavePrettyPrintIndent(indent));
                }
                catch (IOException e) {
                    System.err.println("Unable to pretty print " + files[i] + ": " + e.getMessage());
                }
            }
            ++i;
        }
    }
}

