/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CodeGenUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$tool$CodeGenUtil;

    static void addAllJavaFiles(List srcFiles, List args) {
        Iterator i = srcFiles.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            if (!f.isDirectory()) {
                args.add(CodeGenUtil.quoteAndEscapeFilename(f.getAbsolutePath()));
                continue;
            }
            List<File> inside = Arrays.asList(f.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".java") || file.isDirectory();
                }
            }));
            CodeGenUtil.addAllJavaFiles(inside, args);
        }
    }

    private static String quoteAndEscapeFilename(String filename) {
        if (filename.indexOf(" ") < 0) {
            return filename;
        }
        return "\"" + filename.replaceAll("\\\\", "\\\\\\\\") + "\"";
    }

    private static String quoteNoEscapeFilename(String filename) {
        if (filename.indexOf(" ") < 0 || File.separatorChar == '/') {
            return filename;
        }
        return "\"" + filename + "\"";
    }

    public static boolean externalCompile(List srcFiles, File outdir, File[] cp, boolean debug) {
        ArrayList<String> args = new ArrayList<String>();
        String home = System.getProperty("java.home");
        String sep = File.separator;
        File javac = new File(home + sep + ".." + sep + "bin" + sep + "javac");
        if (!javac.exists()) {
            javac = new File(javac.getParent(), "javac.exe");
        }
        if (!$assertionsDisabled && !javac.exists()) {
            throw new AssertionError((Object)("javac not found " + javac));
        }
        args.add(javac.getAbsolutePath());
        if (outdir == null) {
            outdir = new File(".");
        } else {
            args.add("-d");
            args.add(CodeGenUtil.quoteAndEscapeFilename(outdir.getAbsolutePath()));
        }
        if (cp == null) {
            cp = CodeGenUtil.systemClasspath();
        }
        if (cp.length > 0) {
            StringBuffer classPath = new StringBuffer();
            classPath.append(outdir.getAbsolutePath());
            int i = 0;
            while (i < cp.length) {
                classPath.append(File.pathSeparator);
                classPath.append(cp[i].getAbsolutePath());
                ++i;
            }
            args.add("-classpath");
            args.add(CodeGenUtil.quoteAndEscapeFilename(classPath.toString()));
        }
        args.add("-source");
        args.add("1.4");
        args.add(debug ? "-g" : "-g:none");
        CodeGenUtil.addAllJavaFiles(srcFiles, args);
        File clFile = null;
        try {
            clFile = File.createTempFile("javac", "");
            FileWriter fw = new FileWriter(clFile);
            Iterator i = args.iterator();
            i.next();
            while (i.hasNext()) {
                String arg = (String)i.next();
                fw.write(arg);
                fw.write(10);
            }
            fw.close();
            ArrayList newargs = new ArrayList();
            newargs.add(args.get(0));
            newargs.add("-J-Xmx256M");
            newargs.add("@" + clFile.getAbsolutePath());
            args = newargs;
        }
        catch (Exception e) {
            System.err.println("Could not create command-line file for javac");
        }
        try {
            String[] strArgs = args.toArray(new String[args.size()]);
            if (System.getProperty("compile.command-line.print") != null) {
                System.out.print("exec:");
                int i = 0;
                while (i < strArgs.length) {
                    System.out.print(" " + strArgs[i]);
                    ++i;
                }
                System.out.println();
            }
            Process proc = Runtime.getRuntime().exec(strArgs);
            StringBuffer errorBuffer = new StringBuffer();
            StringBuffer outputBuffer = new StringBuffer();
            ThreadedReader out = new ThreadedReader(proc.getInputStream(), outputBuffer);
            ThreadedReader err = new ThreadedReader(proc.getErrorStream(), errorBuffer);
            proc.waitFor();
            if (proc.exitValue() != 0) {
                Object[] errArgs = new Object[]{outputBuffer.toString(), errorBuffer.toString()};
                System.out.println(outputBuffer.toString());
                System.out.flush();
                System.err.println(errorBuffer.toString());
                System.err.flush();
                return false;
            }
        }
        catch (Throwable e) {
            System.err.println(e.toString());
            System.err.println(e.getCause());
            e.printStackTrace(System.err);
            return false;
        }
        if (clFile != null) {
            clFile.delete();
        }
        return true;
    }

    public static File[] systemClasspath() {
        ArrayList<File> cp = new ArrayList<File>();
        String[] systemcp = System.getProperty("java.class.path").split(File.pathSeparator);
        int i = 0;
        while (i < systemcp.length) {
            cp.add(new File(systemcp[i]));
            ++i;
        }
        return cp.toArray(new File[cp.size()]);
    }

    public static boolean externalJar(File srcdir, File outfile) {
        ArrayList<String> args = new ArrayList<String>();
        String home = System.getProperty("java.home");
        String sep = File.separator;
        File jar = new File(home + sep + ".." + sep + "bin" + sep + "jar");
        if (!jar.exists()) {
            jar = new File(jar.getParent(), "jar.exe");
        }
        if (!$assertionsDisabled && !jar.exists()) {
            throw new AssertionError((Object)("jar not found " + jar));
        }
        args.add(jar.getAbsolutePath());
        args.add("cf");
        args.add(CodeGenUtil.quoteNoEscapeFilename(outfile.getAbsolutePath()));
        args.add("-C");
        args.add(CodeGenUtil.quoteNoEscapeFilename(srcdir.getAbsolutePath()));
        args.add(".");
        try {
            String[] strArgs = args.toArray(new String[args.size()]);
            if (System.getProperty("compile.command-line.print") != null) {
                System.out.print("exec:");
                int i = 0;
                while (i < strArgs.length) {
                    System.out.print(" " + strArgs[i]);
                    ++i;
                }
                System.out.println();
            }
            Process proc = Runtime.getRuntime().exec(strArgs);
            StringBuffer errorBuffer = new StringBuffer();
            StringBuffer outputBuffer = new StringBuffer();
            ThreadedReader out = new ThreadedReader(proc.getInputStream(), outputBuffer);
            ThreadedReader err = new ThreadedReader(proc.getErrorStream(), errorBuffer);
            proc.waitFor();
            if (proc.exitValue() != 0) {
                Object[] errArgs = new Object[]{outputBuffer.toString(), errorBuffer.toString()};
                System.out.println(outputBuffer.toString());
                System.out.flush();
                System.err.println(errorBuffer.toString());
                System.err.flush();
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$tool$CodeGenUtil == null ? (class$com$bea$xbean$tool$CodeGenUtil = CodeGenUtil.class$("com.bea.xbean.tool.CodeGenUtil")) : class$com$bea$xbean$tool$CodeGenUtil).desiredAssertionStatus();
    }

    private static class ThreadedReader {
        public ThreadedReader(InputStream stream, StringBuffer output) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Thread readerThread = new Thread(new Runnable(this, reader, output){
                private final /* synthetic */ BufferedReader val$reader;
                private final /* synthetic */ StringBuffer val$output;
                private final /* synthetic */ ThreadedReader this$0;
                {
                    this.this$0 = this$0;
                    this.val$reader = val$reader;
                    this.val$output = val$output;
                }

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    try {
                        String s;
                        while ((s = this.val$reader.readLine()) != null) {
                            void var1_1;
                            this.val$output.append((String)var1_1 + "\n");
                        }
                    }
                    catch (Exception e) {}
                }
            });
            readerThread.start();
        }
    }
}

