/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.store;

import com.bea.xbean.common.XPath;
import com.bea.xbean.store.Cursor;
import com.bea.xbean.store.Root;
import com.bea.xbean.store.Splay;
import com.bea.xbean.store.Type;
import com.bea.xbean.store.XqrlDelegate;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.util.HashMap;

public abstract class Path {
    public static String _useXqrlForXpath;
    public static String _useXbeanForXpath;
    private static HashMap _xqrlPathCache;
    private static HashMap _xbeanPathCache;
    private static HashMap _xqrlQueryCache;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$store$Path;

    static Cursor.Selections newSelections() {
        return new Cursor.Selections();
    }

    static Cursor.PathEngine select(Root r, Splay s, int p, String pathExpr, XmlOptions options) {
        Path path = Path.getPath(pathExpr, options);
        return path == null ? null : path.execute(r, s, p, options);
    }

    public static Path getPath(String pathExpr) {
        return Path.getPath(pathExpr, false, null);
    }

    public static Path getPath(String pathExpr, XmlOptions options) {
        return Path.getPath(pathExpr, false, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getPath(String pathExpr, boolean xqrl, XmlOptions options) {
        Path path = null;
        HashMap hashMap = _xbeanPathCache;
        synchronized (hashMap) {
            if (!xqrl) {
                path = (Path)_xbeanPathCache.get(pathExpr);
            }
            if (path == null) {
                path = (Path)_xqrlPathCache.get(pathExpr);
            }
            if (path == null) {
                String pathStr = Path.getCompiledPath(pathExpr, xqrl, options);
                path = pathStr == null ? null : Path.getPath(pathExpr, xqrl, options);
            }
        }
        return path;
    }

    public static String getCompiledPath(String pathExpr, XmlOptions options) {
        return Path.getCompiledPath(pathExpr, false, options);
    }

    private static String getCurrentNoddeVar(XmlOptions options) {
        String currentNodeVar = "this";
        if ((options = XmlOptions.maskNull(options)).hasOption("XQUERY_CURRENT_NODE_VAR") && (currentNodeVar = (String)options.get("XQUERY_CURRENT_NODE_VAR")).startsWith("$")) {
            throw new IllegalArgumentException("Omit the '$' prefix for the current node variable");
        }
        return currentNodeVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompiledPath(String pathExpr, boolean xqrl, XmlOptions options) {
        options = XmlOptions.maskNull(options);
        Path path = null;
        String currentNodeVar = Path.getCurrentNoddeVar(options);
        HashMap hashMap = _xbeanPathCache;
        synchronized (hashMap) {
            if ($assertionsDisabled || !(xqrl |= options.hasOption(_useXqrlForXpath))) {
                // empty if block
            }
            if ((!xqrl || options.hasOption(_useXbeanForXpath)) && (path = (Path)_xbeanPathCache.get(pathExpr)) == null && (path = XbeanPathImpl.create(pathExpr, currentNodeVar)) != null) {
                _xbeanPathCache.put(path.getPathExpr(), path);
            }
            if (path == null) {
                if (!$assertionsDisabled && options.hasOption(_useXbeanForXpath)) {
                    throw new AssertionError();
                }
                path = (Path)_xqrlPathCache.get(pathExpr);
                if (path == null && (path = XqrlPathImpl.create(pathExpr, currentNodeVar)) != null) {
                    _xqrlPathCache.put(path.getPathExpr(), path);
                }
            }
        }
        return path == null ? null : path.getPathExpr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Query getQuery(String queryExpr, XmlOptions options) {
        Query query = null;
        HashMap hashMap = _xqrlQueryCache;
        synchronized (hashMap) {
            query = (Query)_xqrlQueryCache.get(queryExpr);
            if (query == null) {
                String queryStr = Path.getCompiledQuery(queryExpr, options);
                query = queryStr == null ? null : Path.getQuery(queryExpr, options);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompiledQuery(String queryExpr, XmlOptions options) {
        Query query = null;
        String currentNodeVar = Path.getCurrentNoddeVar(options);
        HashMap hashMap = _xqrlQueryCache;
        synchronized (hashMap) {
            query = (Query)_xqrlQueryCache.get(queryExpr);
            if (query == null && (query = XqrlDelegate.compileQuery(queryExpr, currentNodeVar)) != null) {
                _xqrlQueryCache.put(query.getQueryExpr(), query);
            }
        }
        return query == null ? null : query.getQueryExpr();
    }

    public static XmlCursor query(Cursor c, String queryExpr, XmlOptions options) {
        Query query = Path.getQuery(queryExpr, options);
        return query == null ? null : query.executeQuery(c, options);
    }

    public static XmlObject[] query(Type type, String queryExpr, XmlOptions options) {
        Query query = Path.getQuery(queryExpr, options);
        return query == null ? null : query.executeQuery(type, options);
    }

    protected abstract Cursor.PathEngine execute(Root var1, Splay var2, int var3, XmlOptions var4);

    protected abstract String getPathExpr();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$store$Path == null ? (class$com$bea$xbean$store$Path = Path.class$("com.bea.xbean.store.Path")) : class$com$bea$xbean$store$Path).desiredAssertionStatus();
        _useXqrlForXpath = "use xqrl for xpath";
        _useXbeanForXpath = "use xbean for xpath";
        _xqrlPathCache = new HashMap();
        _xbeanPathCache = new HashMap();
        _xqrlQueryCache = new HashMap();
    }

    private static final class XbeanPathImpl
    extends Path {
        private String _pathExpr;
        private XPath _xpath;
        private String _currentNodeVar;
        static final /* synthetic */ boolean $assertionsDisabled;

        private XbeanPathImpl(XPath xpath, String pathExpr, String currentNodeVar) {
            this._pathExpr = pathExpr;
            this._xpath = xpath;
            this._currentNodeVar = currentNodeVar;
        }

        static Path create(String pathExpr, String currentNodeVar) {
            if (!$assertionsDisabled && currentNodeVar.startsWith("$")) {
                throw new AssertionError();
            }
            try {
                return new XbeanPathImpl(XPath.compileXPath(pathExpr, currentNodeVar), pathExpr, currentNodeVar);
            }
            catch (XPath.XPathCompileException e) {
                return null;
            }
        }

        protected String getPathExpr() {
            return this._pathExpr;
        }

        protected Cursor.PathEngine execute(Root r, Splay s, int p, XmlOptions options) {
            if (p != 0 || !s.isContainer() || this._xpath.sawDeepDot()) {
                try {
                    return Path.getPath(this._pathExpr, true, null).execute(r, s, p, options);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Can't compile path", e);
                }
            }
            return new XBeanPathEngine(this._xpath, r, s);
        }

        static {
            $assertionsDisabled = !(class$com$bea$xbean$store$Path == null ? (class$com$bea$xbean$store$Path = Path.class$("com.bea.xbean.store.Path")) : class$com$bea$xbean$store$Path).desiredAssertionStatus();
        }

        private static class XBeanPathEngine
        extends XPath.ExecutionContext
        implements Cursor.PathEngine {
            private Root _root;
            private long _version;
            private Splay _top;
            private Splay _curr;
            static final /* synthetic */ boolean $assertionsDisabled;

            XBeanPathEngine(XPath xpath, Root r, Splay s) {
                if (!$assertionsDisabled && !s.isContainer()) {
                    throw new AssertionError();
                }
                this._root = r;
                this._curr = this._top = s;
                this._version = r.getVersion();
                this.init(xpath);
            }

            public boolean next(Cursor.Selections selections) {
                int initialSize = selections.currentSize();
                do {
                    if (this._root.getVersion() != this._version) {
                        throw new IllegalStateException("Document changed");
                    }
                    if (this._curr == null) {
                        return false;
                    }
                    this.advance(selections);
                } while (initialSize >= selections.currentSize());
                return true;
            }

            private Splay doAttrs(int ret, Splay s, Cursor.Selections selections) {
                if ((ret & 4) == 0) {
                    return null;
                }
                s = this._curr.nextSplay();
                while (s.isAttr()) {
                    if (s.isNormalAttr() && this.attr(s.getName())) {
                        selections.add(this._root, s);
                    }
                    s = s.nextSplay();
                }
                return s;
            }

            private void advance(Cursor.Selections selections) {
                if (this._curr == this._top) {
                    int ret = this.start();
                    if ((ret & 1) != 0) {
                        selections.add(this._root, this._curr);
                    }
                    Splay s = this.doAttrs(ret, this._curr, selections);
                    this._curr = (ret & 2) == 0 || this._curr.isLeaf() ? null : (s == null ? this._curr.nextNonAttrSplay() : s);
                    return;
                }
                while (true) {
                    if (this._curr.isFinish()) {
                        if (this._curr.getContainer() == this._top) {
                            this._curr = null;
                        } else {
                            this.end();
                            this._curr = this._curr.nextSplay();
                        }
                        return;
                    }
                    if (this._curr.isBegin()) {
                        int ret = this.element(this._curr.getName());
                        if ((ret & 1) != 0) {
                            selections.add(this._root, this._curr);
                        }
                        Splay s = this.doAttrs(ret, this._curr, selections);
                        if (this._curr.isLeaf()) {
                            this.end();
                            this._curr = s == null ? this._curr.nextNonAttrSplay() : s;
                        } else {
                            this._curr = (ret & 2) == 0 ? ((Splay.Container)this._curr).getFinish() : (s == null ? this._curr.nextNonAttrSplay() : s);
                        }
                        return;
                    }
                    this._curr = this._curr.nextSplay();
                }
            }

            static {
                $assertionsDisabled = !(class$com$bea$xbean$store$Path == null ? (class$com$bea$xbean$store$Path = Path.class$("com.bea.xbean.store.Path")) : class$com$bea$xbean$store$Path).desiredAssertionStatus();
            }
        }
    }

    private static class XqrlPathImpl
    extends Path {
        private String _pathExpr;
        private Query _compiledPath;

        private XqrlPathImpl(String pathExpr, Query compiledPath) {
            this._pathExpr = pathExpr;
            this._compiledPath = compiledPath;
        }

        static Path create(String pathExpr, String currentNodeVar) {
            return new XqrlPathImpl(pathExpr, XqrlDelegate.compilePath(pathExpr, currentNodeVar));
        }

        protected Cursor.PathEngine execute(Root r, Splay s, int p, XmlOptions options) {
            return this._compiledPath.executePath(r, s, p, options);
        }

        protected String getPathExpr() {
            return this._pathExpr;
        }
    }

    public static interface Query {
        public Cursor.PathEngine executePath(Root var1, Splay var2, int var3, XmlOptions var4);

        public XmlCursor executeQuery(Cursor var1, XmlOptions var2);

        public XmlObject[] executeQuery(Type var1, XmlOptions var2);

        public String getQueryExpr();
    }
}

