/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.schema;

import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.XMLChar;
import com.bea.xbean.common.XPath;
import com.bea.xbean.regex.RegularExpression;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.schema.SchemaAttributeGroupImpl;
import com.bea.xbean.schema.SchemaGlobalAttributeImpl;
import com.bea.xbean.schema.SchemaGlobalElementImpl;
import com.bea.xbean.schema.SchemaIdentityConstraintImpl;
import com.bea.xbean.schema.SchemaLocalAttributeImpl;
import com.bea.xbean.schema.SchemaLocalElementImpl;
import com.bea.xbean.schema.SchemaModelGroupImpl;
import com.bea.xbean.schema.SchemaTypeImpl;
import com.bea.xbean.schema.StscImporter;
import com.bea.xbean.schema.StscState;
import com.bea.xbean.values.NamespaceContext;
import com.bea.xbean.values.XmlIntegerImpl;
import com.bea.xbean.values.XmlValueOutOfRangeException;
import com.bea.xml.QNameSet;
import com.bea.xml.SchemaAttributeModel;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaIdentityConstraint;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlAnySimpleType;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlInteger;
import com.bea.xml.XmlObject;
import com.bea.xml.soap.SOAPArrayType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3.x2001.xmlSchema.Annotated;
import org.w3.x2001.xmlSchema.Attribute;
import org.w3.x2001.xmlSchema.AttributeGroup;
import org.w3.x2001.xmlSchema.Element;
import org.w3.x2001.xmlSchema.FieldDocument;
import org.w3.x2001.xmlSchema.FormChoice;
import org.w3.x2001.xmlSchema.Keybase;
import org.w3.x2001.xmlSchema.KeyrefDocument;
import org.w3.x2001.xmlSchema.LocalElement;
import org.w3.x2001.xmlSchema.LocalSimpleType;
import org.w3.x2001.xmlSchema.NamedAttributeGroup;
import org.w3.x2001.xmlSchema.NamedGroup;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.w3.x2001.xmlSchema.TopLevelAttribute;
import org.w3.x2001.xmlSchema.TopLevelComplexType;
import org.w3.x2001.xmlSchema.TopLevelElement;
import org.w3.x2001.xmlSchema.TopLevelSimpleType;

public class StscTranslator {
    private static final QName WSDL_ARRAYTYPE_NAME;
    public static final RegularExpression XPATH_REGEXP;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$schema$StscTranslator;

    public static void addAllDefinitions(StscImporter.SchemaToProcess[] schemasAndChameleons) {
        int i = 0;
        while (i < schemasAndChameleons.length) {
            StscTranslator.addAllDefinitions(schemasAndChameleons[i].getSchema(), schemasAndChameleons[i].getChameleonNamespace());
            ++i;
        }
    }

    public static void addAllDefinitions(SchemaDocument.Schema schema, String givenTargetNamespace) {
        StscState state = StscState.get();
        if (schema.sizeOfRedefineArray() > 0) {
            state.warning("Schema <redefine> is not yet supported for this release.", 51, schema.getRedefineArray(0));
        }
        if (schema.sizeOfNotationArray() > 0) {
            state.warning("Schema <notation> is not yet supported for this release.", 51, schema.getNotationArray(0));
        }
        if (schema.getTargetNamespace() != null && givenTargetNamespace != null && !schema.getTargetNamespace().equals(givenTargetNamespace)) {
            givenTargetNamespace = null;
        }
        String targetNamespace = schema.getTargetNamespace();
        boolean chameleon = false;
        if (givenTargetNamespace != null && targetNamespace == null) {
            targetNamespace = givenTargetNamespace;
            chameleon = true;
        }
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        state.addNamespace(targetNamespace);
        TopLevelComplexType[] complexTypes = schema.getComplexTypeArray();
        int i = 0;
        while (i < complexTypes.length) {
            state.addGlobalType(StscTranslator.translateGlobalComplexType(complexTypes[i], targetNamespace, chameleon));
            ++i;
        }
        TopLevelSimpleType[] simpleTypes = schema.getSimpleTypeArray();
        int i2 = 0;
        while (i2 < simpleTypes.length) {
            state.addGlobalType(StscTranslator.translateGlobalSimpleType(simpleTypes[i2], targetNamespace, chameleon));
            ++i2;
        }
        TopLevelElement[] elements = schema.getElementArray();
        int i3 = 0;
        while (i3 < elements.length) {
            TopLevelElement element = elements[i3];
            state.addDocumentType(StscTranslator.translateDocumentType(element, targetNamespace, chameleon), QNameHelper.forLNS(element.getName(), targetNamespace));
            ++i3;
        }
        TopLevelAttribute[] attributes = schema.getAttributeArray();
        int i4 = 0;
        while (i4 < attributes.length) {
            TopLevelAttribute attribute = attributes[i4];
            state.addAttributeType(StscTranslator.translateAttributeType(attribute, targetNamespace, chameleon), QNameHelper.forLNS(attribute.getName(), targetNamespace));
            ++i4;
        }
        NamedGroup[] modelgroups = schema.getGroupArray();
        int i5 = 0;
        while (i5 < modelgroups.length) {
            state.addModelGroup(StscTranslator.translateModelGroup(modelgroups[i5], targetNamespace, chameleon));
            ++i5;
        }
        NamedAttributeGroup[] attrgroups = schema.getAttributeGroupArray();
        int i6 = 0;
        while (i6 < attrgroups.length) {
            state.addAttributeGroup(StscTranslator.translateAttributeGroup(attrgroups[i6], targetNamespace, chameleon));
            ++i6;
        }
    }

    private static String findFilename(XmlObject xobj) {
        return StscState.get().sourceNameForUri(xobj.documentProperties().getSourceName());
    }

    private static SchemaTypeImpl translateDocumentType(TopLevelElement xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().sts());
        sType.setDocumentType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateAttributeType(TopLevelAttribute xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().sts());
        sType.setAttributeType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalComplexType(TopLevelComplexType xsdType, String targetNamespace, boolean chameleon) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("Global type missing a name", 5, xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("Invalid type name \"" + localname + "\"", 53, xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("Skipping definition of built-in type " + QNameHelper.pretty(name), 44, xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.sts());
        sType.setParseContext(xsdType, targetNamespace, chameleon);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(QNameHelper.forLNS(localname, targetNamespace));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalSimpleType(TopLevelSimpleType xsdType, String targetNamespace, boolean chameleon) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("Global type missing a name", 5, xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("Invalid type name \"" + localname + "\"", 53, xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("Skipping definition of built-in type " + QNameHelper.pretty(name), 44, xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.sts());
        sType.setSimpleType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(name);
        return sType;
    }

    static FormChoice findElementFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetElementFormDefault();
    }

    public static boolean uriMatch(String s1, String s2) {
        if (s1 == null) {
            return s2 == null || s2.equals("");
        }
        if (s2 == null) {
            return s1.equals("");
        }
        return s1.equals(s2);
    }

    public static void copyGlobalElementToLocalElement(SchemaGlobalElement referenced, SchemaLocalElementImpl target) {
        target.setNameAndTypeRef(referenced.getName(), referenced.getType().getRef());
        target.setNillable(referenced.isNillable());
        target.setDefault(referenced.getDefaultText(), referenced.isFixed());
        target.setIdentityConstraints(((SchemaLocalElementImpl)((Object)referenced)).getIdentityConstraintRefs());
        target.setBlock(referenced.blockExtension(), referenced.blockRestriction(), referenced.blockSubstitution());
    }

    public static void copyGlobalAttributeToLocalAttribute(SchemaGlobalAttributeImpl referenced, SchemaLocalAttributeImpl target) {
        target.init(referenced.getName(), referenced.getTypeRef(), referenced.getUse(), referenced.getDefaultText(), referenced.isFixed(), referenced.getWSDLArrayType());
    }

    public static SchemaLocalElementImpl translateElement(Element xsdElt, String targetNamespace, boolean chameleon, List anonymousTypes, SchemaType outerType) {
        QName qname;
        SchemaLocalElementImpl impl;
        StscState state = StscState.get();
        String name = xsdElt.getName();
        QName ref = xsdElt.getRef();
        if (xsdElt.isSetSubstitutionGroup()) {
            state.warning("Element substitution groups not supported in this release", 51, xsdElt.xgetSubstitutionGroup());
        }
        if (ref != null && name != null) {
            state.error("Element " + name + " specifies both a ref and a name", 30, xsdElt.xgetRef());
            name = null;
        }
        if (ref == null && name == null) {
            state.error("Element has no name", 8, xsdElt);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("Invalid element name \"" + name + "\"", 53, xsdElt.xgetName());
        }
        if (ref != null) {
            if (xsdElt.getType() != null || xsdElt.getSimpleType() != null || xsdElt.getComplexType() != null) {
                state.error("Element reference cannot also specify a type", 53, xsdElt.xgetName());
            }
            if (xsdElt.getForm() != null) {
                state.error("Element reference cannot also specify form", 53, xsdElt.xgetName());
            }
            if (!$assertionsDisabled && !(xsdElt instanceof LocalElement)) {
                throw new AssertionError();
            }
            SchemaGlobalElementImpl referenced = state.findGlobalElement(ref, chameleon ? targetNamespace : null);
            if (referenced == null) {
                state.notFoundError(ref, 29, xsdElt.xgetRef());
                return null;
            }
            SchemaLocalElementImpl target = new SchemaLocalElementImpl();
            target.setParticleType(4);
            StscTranslator.copyGlobalElementToLocalElement(referenced, target);
            return target;
        }
        SchemaTypeImpl sType = null;
        if (xsdElt instanceof LocalElement) {
            impl = new SchemaLocalElementImpl();
            FormChoice form = xsdElt.xgetForm();
            if (form == null) {
                form = StscTranslator.findElementFormDefault(xsdElt);
            }
            qname = form == null || form.stringValue().equals("unqualified") ? QNameHelper.forLN(name) : QNameHelper.forLNS(name, targetNamespace);
        } else {
            impl = new SchemaGlobalElementImpl(state.sts());
            qname = QNameHelper.forLNS(name, targetNamespace);
            impl.setTransitionRules(QNameSet.singleton(qname), false);
            impl.setTransitionNotes(QNameSet.EMPTY, true);
            boolean finalExt = false;
            boolean finalRest = false;
            Object ds = xsdElt.getFinal();
            if (ds != null) {
                if (ds instanceof String && ds.equals("#all")) {
                    finalRest = true;
                    finalExt = true;
                } else if (ds instanceof List) {
                    if (((List)ds).contains("extension")) {
                        finalExt = true;
                    }
                    if (((List)ds).contains("restriction")) {
                        finalRest = true;
                    }
                }
            }
            ((SchemaGlobalElementImpl)impl).setAbstractFinal(xsdElt.getAbstract(), finalExt, finalRest);
            ((SchemaGlobalElementImpl)impl).setFilename(StscTranslator.findFilename(xsdElt));
            ((SchemaGlobalElementImpl)impl).setParseContext(xsdElt, targetNamespace, chameleon);
        }
        if (xsdElt.getType() != null && (sType = state.findGlobalType(xsdElt.getType(), chameleon ? targetNamespace : null)) == null) {
            state.notFoundError(xsdElt.getType(), 6, xsdElt.xgetType());
        }
        boolean simpleTypedef = false;
        Annotated typedef = xsdElt.getComplexType();
        if (typedef == null) {
            typedef = xsdElt.getSimpleType();
            simpleTypedef = true;
        }
        if (sType != null && typedef != null) {
            state.error("Illegal to define a nested type when a type attribute is specified", 7, typedef);
            typedef = null;
        }
        if (typedef != null) {
            SchemaTypeImpl sTypeImpl;
            sType = sTypeImpl = new SchemaTypeImpl(state.sts());
            sTypeImpl.setContainerField(impl);
            sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
            anonymousTypes.add(sType);
            sTypeImpl.setSimpleType(simpleTypedef);
            sTypeImpl.setParseContext(typedef, targetNamespace, chameleon);
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_TYPE;
        }
        SOAPArrayType wat = null;
        XmlCursor c = xsdElt.newCursor();
        String arrayType = c.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c.dispose();
        if (arrayType != null) {
            wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdElt));
        }
        impl.setWsdlArrayType(wat);
        boolean isFixed = xsdElt.isSetFixed();
        if (xsdElt.isSetDefault() && isFixed) {
            state.error("Should not set both default and fixed on the same element", 9, xsdElt.xgetFixed());
            isFixed = false;
        }
        impl.setParticleType(4);
        impl.setNameAndTypeRef(qname, sType.getRef());
        impl.setNillable(xsdElt.getNillable());
        impl.setDefault(isFixed ? xsdElt.getFixed() : xsdElt.getDefault(), isFixed);
        Object block = xsdElt.getBlock();
        boolean blockExt = false;
        boolean blockRest = false;
        boolean blockSubst = false;
        if (block != null) {
            if (block instanceof String && block.equals("#all")) {
                blockSubst = true;
                blockRest = true;
                blockExt = true;
            } else if (block instanceof List) {
                if (((List)block).contains("extension")) {
                    blockExt = true;
                }
                if (((List)block).contains("restriction")) {
                    blockRest = true;
                }
                if (((List)block).contains("substitution")) {
                    blockSubst = true;
                }
            }
        }
        impl.setBlock(blockExt, blockRest, blockSubst);
        boolean constraintFailed = false;
        int length = xsdElt.sizeOfKeyArray() + xsdElt.sizeOfKeyrefArray() + xsdElt.sizeOfUniqueArray();
        SchemaIdentityConstraintImpl[] constraints = new SchemaIdentityConstraintImpl[length];
        int cur = 0;
        Keybase[] keys = xsdElt.getKeyArray();
        int i = 0;
        while (i < keys.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(keys[i], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(1);
            } else {
                constraintFailed = true;
            }
            ++i;
            ++cur;
        }
        Keybase[] uc = xsdElt.getUniqueArray();
        int i2 = 0;
        while (i2 < uc.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(uc[i2], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(3);
            } else {
                constraintFailed = true;
            }
            ++i2;
            ++cur;
        }
        KeyrefDocument.Keyref[] krs = xsdElt.getKeyrefArray();
        int i3 = 0;
        while (i3 < krs.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(krs[i3], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(2);
            } else {
                constraintFailed = true;
            }
            ++i3;
            ++cur;
        }
        if (!constraintFailed) {
            SchemaIdentityConstraint.Ref[] refs = new SchemaIdentityConstraint.Ref[length];
            int i4 = 0;
            while (i4 < refs.length) {
                refs[i4] = constraints[i4].getRef();
                ++i4;
            }
            impl.setIdentityConstraints(refs);
        }
        return impl;
    }

    private static String removeWhitespace(String xpath) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < xpath.length()) {
            char ch = xpath.charAt(i);
            if (!XMLChar.isSpace(ch)) {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkXPathSyntax(String xpath) {
        if (xpath == null) {
            return false;
        }
        xpath = StscTranslator.removeWhitespace(xpath);
        RegularExpression regularExpression = XPATH_REGEXP;
        synchronized (regularExpression) {
            return XPATH_REGEXP.matches(xpath);
        }
    }

    private static SchemaIdentityConstraintImpl translateIdentityConstraint(Keybase parseIC, String targetNamespace, boolean chameleon) {
        String selector;
        StscState state = StscState.get();
        String string = selector = parseIC.getSelector() == null ? null : parseIC.getSelector().getXpath();
        if (!StscTranslator.checkXPathSyntax(selector)) {
            StscState.get().error("Invalid xpath in selector.", 58, parseIC.getSelector().xgetXpath());
            return null;
        }
        FieldDocument.Field[] fieldElts = parseIC.getFieldArray();
        int j = 0;
        while (j < fieldElts.length) {
            if (!StscTranslator.checkXPathSyntax(fieldElts[j].getXpath())) {
                StscState.get().error("Invalid xpath in field.", 58, fieldElts[j].xgetXpath());
                return null;
            }
            ++j;
        }
        SchemaIdentityConstraintImpl ic = new SchemaIdentityConstraintImpl(state.sts());
        ic.setName(QNameHelper.forLNS(parseIC.getName(), targetNamespace));
        ic.setSelector(parseIC.getSelector().getXpath());
        ic.setParseContext(parseIC, targetNamespace, chameleon);
        XmlCursor c = parseIC.newCursor();
        HashMap nsMap = new HashMap();
        c.getAllNamespaces(nsMap);
        nsMap.remove("");
        ic.setNSMap(nsMap);
        c.dispose();
        String[] fields = new String[fieldElts.length];
        int j2 = 0;
        while (j2 < fields.length) {
            fields[j2] = fieldElts[j2].getXpath();
            ++j2;
        }
        ic.setFields(fields);
        try {
            ic.buildPaths();
        }
        catch (XPath.XPathCompileException e) {
            StscState.get().error("Invalid xpath in identity constraint: " + e.getMessage(), 58, parseIC);
            return null;
        }
        state.addIdConstraint(ic);
        return ic;
    }

    public static SchemaModelGroupImpl translateModelGroup(NamedGroup namedGroup, String targetNamespace, boolean chameleon) {
        String name = namedGroup.getName();
        if (name == null) {
            StscState.get().error("Model groups must be named", 10, namedGroup);
            return null;
        }
        SchemaModelGroupImpl result = new SchemaModelGroupImpl(StscState.get().sts());
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, namedGroup);
        return result;
    }

    public static SchemaAttributeGroupImpl translateAttributeGroup(AttributeGroup attrGroup, String targetNamespace, boolean chameleon) {
        String name = attrGroup.getName();
        if (name == null) {
            StscState.get().error("Attribute groups must be named", 12, attrGroup);
            return null;
        }
        SchemaAttributeGroupImpl result = new SchemaAttributeGroupImpl(StscState.get().sts());
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, attrGroup);
        return result;
    }

    static FormChoice findAttributeFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetAttributeFormDefault();
    }

    static SchemaLocalAttributeImpl translateAttribute(Attribute xsdAttr, String targetNamespace, boolean chameleon, List anonymousTypes, SchemaType outerType, SchemaAttributeModel baseModel, boolean local) {
        QName qname;
        SchemaLocalAttributeImpl sAttr;
        StscState state = StscState.get();
        String name = xsdAttr.getName();
        QName ref = xsdAttr.getRef();
        if (ref != null && name != null) {
            if (name.equals(ref.getLocalPart()) && StscTranslator.uriMatch(targetNamespace, ref.getNamespaceURI())) {
                state.warning("Attribute " + name + " specifies both a ref and a name", 30, xsdAttr.xgetRef());
            } else {
                state.error("Attribute " + name + " specifies both a ref and a name", 30, xsdAttr.xgetRef());
            }
            name = null;
        }
        if (ref == null && name == null) {
            state.error("Attribute has no name", 8, xsdAttr);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("Invalid attribute name \"" + name + "\"", 53, xsdAttr.xgetName());
        }
        boolean isFixed = false;
        String deftext = null;
        SchemaType sType = null;
        int use = 2;
        if (local) {
            sAttr = new SchemaLocalAttributeImpl();
        } else {
            sAttr = new SchemaGlobalAttributeImpl(state.sts());
            ((SchemaGlobalAttributeImpl)sAttr).setParseContext(xsdAttr, targetNamespace, chameleon);
        }
        if (ref != null) {
            SchemaGlobalAttributeImpl referenced;
            if (xsdAttr.getType() != null || xsdAttr.getSimpleType() != null) {
                state.error("Attribute reference cannot also specify type", 53, xsdAttr);
            }
            if (xsdAttr.getForm() != null) {
                state.error("Attribute reference cannot also specify form", 53, xsdAttr);
            }
            if ((referenced = state.findGlobalAttribute(ref, chameleon ? targetNamespace : null)) == null) {
                state.notFoundError(ref, 36, xsdAttr.xgetRef());
                return null;
            }
            qname = ref;
            use = referenced.getUse();
            sType = referenced.getType();
            deftext = referenced.getDefaultText();
            if (deftext != null) {
                isFixed = referenced.isFixed();
            }
        } else {
            if (local) {
                FormChoice form = xsdAttr.xgetForm();
                if (form == null) {
                    form = StscTranslator.findAttributeFormDefault(xsdAttr);
                }
                qname = form == null || form.stringValue().equals("unqualified") ? QNameHelper.forLN(name) : QNameHelper.forLNS(name, targetNamespace);
            } else {
                qname = QNameHelper.forLNS(name, targetNamespace);
            }
            if (xsdAttr.getType() != null && (sType = state.findGlobalType(xsdAttr.getType(), chameleon ? targetNamespace : null)) == null) {
                state.notFoundError(xsdAttr.getType(), 6, xsdAttr.xgetType());
            }
            if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                state.error("Illegal namespace for attribute declaration.", 53, xsdAttr.xgetName());
            }
            if (qname.getNamespaceURI().length() == 0 && qname.getLocalPart().equals("xmlns")) {
                state.error("Illegal name for attribute declaration.", 53, xsdAttr.xgetName());
            }
            Object baseAttr = null;
            LocalSimpleType typedef = xsdAttr.getSimpleType();
            if (sType != null && typedef != null) {
                state.error("Illegal to define a nested type when a type attribute is specified", 7, typedef);
                typedef = null;
            }
            if (typedef != null) {
                SchemaTypeImpl sTypeImpl = new SchemaTypeImpl(state.sts());
                sType = sTypeImpl;
                sTypeImpl.setContainerField(sAttr);
                sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
                anonymousTypes.add(sType);
                sTypeImpl.setSimpleType(true);
                sTypeImpl.setParseContext(typedef, targetNamespace, chameleon);
            }
            if (sType == null && baseModel != null && baseModel.getAttribute(qname) != null) {
                sType = baseModel.getAttribute(qname).getType();
            }
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (!sType.isSimpleType()) {
            state.error("Attributes must have a simple type (not complex).", 46, xsdAttr);
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (xsdAttr.isSetDefault() || xsdAttr.isSetFixed()) {
            isFixed = xsdAttr.isSetFixed();
            if (xsdAttr.isSetDefault() && isFixed) {
                state.error("Should not set both default and fixed on the same attribute", 9, xsdAttr.xgetFixed());
                isFixed = false;
            }
            String string = deftext = isFixed ? xsdAttr.getFixed() : xsdAttr.getDefault();
        }
        if (xsdAttr.isSetUse()) {
            use = StscTranslator.translateUseCode(xsdAttr.xgetUse());
        }
        if (!local) {
            ((SchemaGlobalAttributeImpl)sAttr).setFilename(StscTranslator.findFilename(xsdAttr));
        }
        SOAPArrayType wat = null;
        XmlCursor c = xsdAttr.newCursor();
        String arrayType = c.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c.dispose();
        if (arrayType != null) {
            wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdAttr));
        }
        sAttr.init(qname, sType.getRef(), use, deftext, isFixed, wat);
        return sAttr;
    }

    static int translateUseCode(Attribute.Use attruse) {
        if (attruse == null) {
            return 2;
        }
        String val = attruse.stringValue();
        if (val.equals("optional")) {
            return 2;
        }
        if (val.equals("required")) {
            return 3;
        }
        if (val.equals("prohibited")) {
            return 1;
        }
        return 2;
    }

    static XmlInteger buildNnInteger(XmlAnySimpleType value) {
        BigInteger bigInt;
        if (value == null) {
            return null;
        }
        String text = value.stringValue();
        try {
            bigInt = new BigInteger(text);
        }
        catch (NumberFormatException e) {
            StscState.get().error("Must be nonnegative integer", 21, value);
            return null;
        }
        if (bigInt.signum() < 0) {
            StscState.get().error("Must be nonnegative integer", 21, value);
            return null;
        }
        try {
            XmlIntegerImpl i = new XmlIntegerImpl();
            i.set(bigInt);
            i.setImmutable();
            return i;
        }
        catch (XmlValueOutOfRangeException e) {
            StscState.get().error("Internal error processing number", 21, value);
            return null;
        }
    }

    private static boolean isReservedTypeName(QName name) {
        return BuiltinSchemaTypeSystem.get().findType(name) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$schema$StscTranslator == null ? (class$com$bea$xbean$schema$StscTranslator = StscTranslator.class$("com.bea.xbean.schema.StscTranslator")) : class$com$bea$xbean$schema$StscTranslator).desiredAssertionStatus();
        WSDL_ARRAYTYPE_NAME = QNameHelper.forLNS("arrayType", "http://schemas.xmlsoap.org/wsdl/");
        XPATH_REGEXP = new RegularExpression("(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))(\\|(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*)))))*", "X");
    }
}

