/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.schema;

import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.schema.SchemaAttributeGroupImpl;
import com.bea.xbean.schema.SchemaAttributeModelImpl;
import com.bea.xbean.schema.SchemaLocalAttributeImpl;
import com.bea.xbean.schema.SchemaModelGroupImpl;
import com.bea.xbean.schema.SchemaParticleImpl;
import com.bea.xbean.schema.SchemaPropertyImpl;
import com.bea.xbean.schema.SchemaTypeImpl;
import com.bea.xbean.schema.StscResolver;
import com.bea.xbean.schema.StscSimpleTypeResolver;
import com.bea.xbean.schema.StscState;
import com.bea.xbean.schema.StscTranslator;
import com.bea.xml.QNameSet;
import com.bea.xml.QNameSetBuilder;
import com.bea.xml.QNameSetSpecification;
import com.bea.xml.SchemaAttributeModel;
import com.bea.xml.SchemaField;
import com.bea.xml.SchemaLocalAttribute;
import com.bea.xml.SchemaLocalElement;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlInteger;
import com.bea.xml.XmlNonNegativeInteger;
import com.bea.xml.XmlObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3.x2001.xmlSchema.AllNNI;
import org.w3.x2001.xmlSchema.AnyDocument;
import org.w3.x2001.xmlSchema.Attribute;
import org.w3.x2001.xmlSchema.AttributeGroupRef;
import org.w3.x2001.xmlSchema.ComplexContentDocument;
import org.w3.x2001.xmlSchema.ComplexRestrictionType;
import org.w3.x2001.xmlSchema.ComplexType;
import org.w3.x2001.xmlSchema.ExtensionType;
import org.w3.x2001.xmlSchema.Group;
import org.w3.x2001.xmlSchema.LocalElement;
import org.w3.x2001.xmlSchema.NamespaceList;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.w3.x2001.xmlSchema.SimpleContentDocument;
import org.w3.x2001.xmlSchema.SimpleExtensionType;
import org.w3.x2001.xmlSchema.SimpleRestrictionType;
import org.w3.x2001.xmlSchema.Wildcard;

public class StscComplexTypeResolver {
    private static final int MODEL_GROUP_CODE = 100;
    private static CodeForNameEntry[] particleCodes;
    private static Map particleCodeMap;
    private static final int ATTRIBUTE_CODE = 100;
    private static final int ATTRIBUTE_GROUP_CODE = 101;
    private static final int ANY_ATTRIBUTE_CODE = 102;
    private static CodeForNameEntry[] attributeCodes;
    private static Map attributeCodeMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$schema$StscComplexTypeResolver;

    public static Group getContentModel(ComplexType parseCt) {
        if (parseCt.getAll() != null) {
            return parseCt.getAll();
        }
        if (parseCt.getSequence() != null) {
            return parseCt.getSequence();
        }
        if (parseCt.getChoice() != null) {
            return parseCt.getChoice();
        }
        if (parseCt.getGroup() != null) {
            return parseCt.getGroup();
        }
        return null;
    }

    public static Group getContentModel(ComplexRestrictionType parseRest) {
        if (parseRest.getAll() != null) {
            return parseRest.getAll();
        }
        if (parseRest.getSequence() != null) {
            return parseRest.getSequence();
        }
        if (parseRest.getChoice() != null) {
            return parseRest.getChoice();
        }
        if (parseRest.getGroup() != null) {
            return parseRest.getGroup();
        }
        return null;
    }

    public static Group getContentModel(ExtensionType parseExt) {
        if (parseExt.getAll() != null) {
            return parseExt.getAll();
        }
        if (parseExt.getSequence() != null) {
            return parseExt.getSequence();
        }
        if (parseExt.getChoice() != null) {
            return parseExt.getChoice();
        }
        if (parseExt.getGroup() != null) {
            return parseExt.getGroup();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SchemaDocument.Schema getSchema(XmlObject o) {
        XmlCursor c = o.newCursor();
        try {
            block3: {
                do {
                    if (!c.toParent()) break block3;
                } while (!(o = c.getObject()).schemaType().equals(SchemaDocument.Schema.type));
                SchemaDocument.Schema schema = (SchemaDocument.Schema)o;
                Object var4_3 = null;
                c.dispose();
                return schema;
            }
            Object var4_4 = null;
            c.dispose();
            return null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            c.dispose();
            throw throwable;
        }
    }

    public static void resolveComplexType(SchemaTypeImpl sImpl) {
        ComplexType parseCt = (ComplexType)sImpl.getParseObject();
        StscState state = StscState.get();
        SchemaDocument.Schema schema = StscComplexTypeResolver.getSchema(parseCt);
        boolean abs = parseCt.isSetAbstract() ? parseCt.getAbstract() : false;
        boolean finalExt = false;
        boolean finalRest = false;
        Object ds = null;
        if (parseCt.isSetFinal()) {
            ds = parseCt.getFinal();
        } else if (schema != null && schema.isSetFinalDefault()) {
            ds = schema.getFinalDefault();
        }
        if (ds != null) {
            if (ds instanceof String && ds.equals("#all")) {
                finalRest = true;
                finalExt = true;
            } else if (ds instanceof List) {
                if (((List)ds).contains("extension")) {
                    finalExt = true;
                }
                if (((List)ds).contains("restriction")) {
                    finalRest = true;
                }
            }
        }
        sImpl.setAbstractFinal(abs, finalExt, finalRest);
        boolean blockExt = false;
        boolean blockRest = false;
        Object block = null;
        if (parseCt.isSetBlock()) {
            block = parseCt.getBlock();
        } else if (schema != null && schema.isSetBlockDefault()) {
            block = schema.getBlockDefault();
        }
        if (block != null) {
            if (block instanceof String && block.equals("#all")) {
                blockRest = true;
                blockExt = true;
            } else if (block instanceof List) {
                if (((List)block).contains("extension")) {
                    blockExt = true;
                }
                if (((List)block).contains("restriction")) {
                    blockRest = true;
                }
            }
        }
        sImpl.setBlock(blockExt, blockRest);
        ComplexContentDocument.ComplexContent parseCc = parseCt.getComplexContent();
        SimpleContentDocument.SimpleContent parseSc = parseCt.getSimpleContent();
        Group parseGroup = StscComplexTypeResolver.getContentModel(parseCt);
        int count = (parseCc != null ? 1 : 0) + (parseSc != null ? 1 : 0) + (parseGroup != null ? 1 : 0);
        if (count > 1) {
            state.error("A complex type must define either a content model, or a simpleContent or complexContent derivation: more than one found.", 26, parseCt);
            parseGroup = null;
            if (parseCc != null && parseSc != null) {
                parseSc = null;
            }
        }
        if (parseCc != null) {
            boolean mixed;
            if (parseCc.getExtension() != null && parseCc.getRestriction() != null) {
                state.error("Restriction conflicts with extension", 26, parseCc.getRestriction());
            }
            boolean bl = mixed = parseCc.isSetMixed() ? parseCc.getMixed() : parseCt.getMixed();
            if (parseCc.getExtension() != null) {
                StscComplexTypeResolver.resolveCcExtension(sImpl, parseCc.getExtension(), mixed);
            } else if (parseCc.getRestriction() != null) {
                StscComplexTypeResolver.resolveCcRestriction(sImpl, parseCc.getRestriction(), mixed);
            } else {
                state.error("Missing restriction or extension", 27, parseCc);
                StscComplexTypeResolver.resolveErrorType(sImpl);
            }
            return;
        }
        if (parseSc != null) {
            if (parseSc.getExtension() != null && parseSc.getRestriction() != null) {
                state.error("Restriction conflicts with extension", 26, parseSc.getRestriction());
            }
            if (parseSc.getExtension() != null) {
                StscComplexTypeResolver.resolveScExtension(sImpl, parseSc.getExtension());
            } else if (parseSc.getRestriction() != null) {
                StscComplexTypeResolver.resolveScRestriction(sImpl, parseSc.getRestriction());
            } else {
                state.error("Missing restriction or extension", 27, parseSc);
                StscComplexTypeResolver.resolveErrorType(sImpl);
            }
            return;
        }
        StscComplexTypeResolver.resolveBasicComplexType(sImpl);
    }

    static void resolveErrorType(SchemaTypeImpl sImpl) {
        throw new RuntimeException("This type of error recovery not yet implemented.");
    }

    private static SchemaType.Ref[] makeRefArray(Collection typeList) {
        SchemaType.Ref[] result = new SchemaType.Ref[typeList.size()];
        int j = 0;
        Iterator i = typeList.iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaType)i.next()).getRef();
            ++j;
        }
        return result;
    }

    static void resolveBasicComplexType(SchemaTypeImpl sImpl) {
        ArrayList anonymousTypes = new ArrayList();
        ComplexType parseTree = (ComplexType)sImpl.getParseObject();
        String targetNamespace = sImpl.getTargetNamespace();
        boolean chameleon = sImpl.getChameleonNamespace() != null;
        Group parseGroup = StscComplexTypeResolver.getContentModel(parseTree);
        int particleCode = StscComplexTypeResolver.translateParticleCode(parseGroup);
        LinkedHashMap elementModel = new LinkedHashMap();
        SchemaParticle contentModel = StscComplexTypeResolver.translateContentModel(sImpl, parseGroup, targetNamespace, chameleon, particleCode, anonymousTypes, elementModel, false);
        boolean isAll = contentModel != null && contentModel.getParticleType() == 1;
        SchemaAttributeModelImpl attrModel = new SchemaAttributeModelImpl();
        StscComplexTypeResolver.translateAttributeModel(parseTree, targetNamespace, chameleon, anonymousTypes, sImpl, null, attrModel, null, true);
        WildcardResult wcElt = StscComplexTypeResolver.summarizeEltWildcards(contentModel);
        WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
        if (contentModel != null) {
            StscComplexTypeResolver.buildStateMachine(contentModel);
            if (!StscState.get().noUpa() && !((SchemaParticleImpl)contentModel).isDeterministic()) {
                StscState.get().error("Content model violates the unique particle attribution rule", 57, parseGroup);
            }
        }
        Map elementPropertyModel = StscComplexTypeResolver.buildContentPropertyModelByQName(contentModel, sImpl);
        Map attributePropertyModel = StscComplexTypeResolver.buildAttributePropertyModelByQName(attrModel, sImpl);
        int complexVariety = parseTree.getMixed() ? 4 : (contentModel == null ? 1 : 3);
        sImpl.setBaseTypeRef(BuiltinSchemaTypeSystem.ST_ANY_TYPE.getRef());
        sImpl.setBaseDepth(BuiltinSchemaTypeSystem.ST_ANY_TYPE.getBaseDepth() + 1);
        sImpl.setDerivationType(2);
        sImpl.setComplexTypeVariety(complexVariety);
        sImpl.setContentModel(contentModel, attrModel, elementPropertyModel, attributePropertyModel, isAll);
        sImpl.setAnonymousTypeRefs(StscComplexTypeResolver.makeRefArray(anonymousTypes));
        sImpl.setWildcardSummary(wcElt.typedWildcards, wcElt.hasWildcards, wcAttr.typedWildcards, wcAttr.hasWildcards);
    }

    static void resolveCcRestriction(SchemaTypeImpl sImpl, ComplexRestrictionType parseTree, boolean mixed) {
        LinkedHashMap elementModel;
        int particleCode;
        SchemaTypeImpl baseType;
        boolean chameleon;
        StscState state = StscState.get();
        String targetNamespace = sImpl.getTargetNamespace();
        boolean bl = chameleon = sImpl.getChameleonNamespace() != null;
        if (parseTree.getBase() == null) {
            state.error("A complexContent must define a base type", 28, parseTree);
            baseType = null;
        } else {
            baseType = state.findGlobalType(parseTree.getBase(), sImpl.getChameleonNamespace());
            if (baseType == null) {
                state.notFoundError(parseTree.getBase(), 6, parseTree.xgetBase());
            }
        }
        if (baseType == null) {
            baseType = BuiltinSchemaTypeSystem.ST_ANY_TYPE;
        }
        if (baseType != null && baseType.finalRestriction()) {
            state.error("Cannot restrict a final type", 54, parseTree.xgetBase());
        }
        if (baseType != null && !StscResolver.resolveType(baseType)) {
            baseType = null;
        }
        ArrayList anonymousTypes = new ArrayList();
        Group parseEg = StscComplexTypeResolver.getContentModel(parseTree);
        SchemaParticle contentModel = StscComplexTypeResolver.translateContentModel(sImpl, parseEg, targetNamespace, chameleon, particleCode = StscComplexTypeResolver.translateParticleCode(parseEg), anonymousTypes, elementModel = new LinkedHashMap(), false);
        boolean isAll = contentModel != null && contentModel.getParticleType() == 1;
        SchemaAttributeModelImpl attrModel = baseType == null ? new SchemaAttributeModelImpl() : new SchemaAttributeModelImpl(baseType.getAttributeModel());
        StscComplexTypeResolver.translateAttributeModel(parseTree, targetNamespace, chameleon, anonymousTypes, sImpl, null, attrModel, baseType, false);
        WildcardResult wcElt = StscComplexTypeResolver.summarizeEltWildcards(contentModel);
        WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
        if (contentModel != null) {
            StscComplexTypeResolver.buildStateMachine(contentModel);
            if (!StscState.get().noUpa() && !((SchemaParticleImpl)contentModel).isDeterministic()) {
                StscState.get().error("Content model violates the unique particle attribution rule", 57, parseEg);
            }
        }
        Map elementPropertyModel = StscComplexTypeResolver.buildContentPropertyModelByQName(contentModel, sImpl);
        Map attributePropertyModel = StscComplexTypeResolver.buildAttributePropertyModelByQName(attrModel, sImpl);
        int complexVariety = contentModel == null ? 1 : (mixed ? 4 : 3);
        sImpl.setBaseTypeRef(baseType.getRef());
        sImpl.setBaseDepth(baseType.getBaseDepth() + 1);
        sImpl.setDerivationType(1);
        sImpl.setComplexTypeVariety(complexVariety);
        sImpl.setContentModel(contentModel, attrModel, elementPropertyModel, attributePropertyModel, isAll);
        sImpl.setAnonymousTypeRefs(StscComplexTypeResolver.makeRefArray(anonymousTypes));
        sImpl.setWildcardSummary(wcElt.typedWildcards, wcElt.hasWildcards, wcAttr.typedWildcards, wcAttr.hasWildcards);
    }

    static Map extractElementModel(SchemaType sType) {
        HashMap<QName, SchemaType> elementModel = new HashMap<QName, SchemaType>();
        if (sType != null) {
            SchemaProperty[] sProps = sType.getProperties();
            int i = 0;
            while (i < sProps.length) {
                if (!sProps[i].isAttribute()) {
                    elementModel.put(sProps[i].getName(), sProps[i].getType());
                }
                ++i;
            }
        }
        return elementModel;
    }

    static void resolveCcExtension(SchemaTypeImpl sImpl, ExtensionType parseTree, boolean mixed) {
        int complexVariety;
        SchemaParticle contentModel;
        SchemaType baseType;
        boolean chameleon;
        StscState state = StscState.get();
        String targetNamespace = sImpl.getTargetNamespace();
        boolean bl = chameleon = sImpl.getChameleonNamespace() != null;
        if (parseTree.getBase() == null) {
            state.error("A complexContent must define a base type", 28, parseTree);
            baseType = null;
        } else {
            baseType = state.findGlobalType(parseTree.getBase(), sImpl.getChameleonNamespace());
            if (baseType == null) {
                state.notFoundError(parseTree.getBase(), 6, parseTree.xgetBase());
            }
        }
        if (baseType != null && !StscResolver.resolveType((SchemaTypeImpl)baseType)) {
            baseType = null;
        }
        if (baseType != null && (baseType.isSimpleType() || baseType.getContentType() == 2)) {
            state.error("The specified base type is not a complex type with complex content.", 41, parseTree.xgetBase());
            baseType = null;
        }
        if (baseType != null && baseType.finalExtension()) {
            state.error("Cannot extend a final type", 54, parseTree.xgetBase());
        }
        SchemaParticle baseContentModel = baseType == null ? null : baseType.getContentModel();
        ArrayList anonymousTypes = new ArrayList();
        Map baseElementModel = StscComplexTypeResolver.extractElementModel(baseType);
        Group parseEg = StscComplexTypeResolver.getContentModel(parseTree);
        SchemaParticle extensionModel = StscComplexTypeResolver.translateContentModel(sImpl, parseEg, targetNamespace, chameleon, StscComplexTypeResolver.translateParticleCode(parseEg), anonymousTypes, baseElementModel, false);
        if (extensionModel == null && !mixed) {
            boolean bl2 = mixed = baseType.getContentType() == 4;
        }
        if (baseType != null && baseType.getContentType() != 1 && baseType.getContentType() == 4 != mixed) {
            state.error("Cannot extend an element-only type with a mixed type or vice-versa", 50, parseTree.xgetBase());
        }
        if (baseType != null && baseType.hasAllContent() && extensionModel != null) {
            state.error("Cannot extend a type with 'all' content model", 42, parseTree.xgetBase());
            extensionModel = null;
        }
        boolean isAll = (contentModel = StscComplexTypeResolver.extendContentModel(baseContentModel, extensionModel, parseTree)) != null && contentModel.getParticleType() == 1;
        SchemaAttributeModelImpl attrModel = baseType == null ? new SchemaAttributeModelImpl() : new SchemaAttributeModelImpl(baseType.getAttributeModel());
        StscComplexTypeResolver.translateAttributeModel(parseTree, targetNamespace, chameleon, anonymousTypes, sImpl, null, attrModel, baseType, true);
        WildcardResult wcElt = StscComplexTypeResolver.summarizeEltWildcards(contentModel);
        WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
        if (contentModel != null) {
            StscComplexTypeResolver.buildStateMachine(contentModel);
            if (!StscState.get().noUpa() && !((SchemaParticleImpl)contentModel).isDeterministic()) {
                StscState.get().error("Content model violates the unique particle attribution rule", 57, parseEg);
            }
        }
        Map elementPropertyModel = StscComplexTypeResolver.buildContentPropertyModelByQName(contentModel, sImpl);
        Map attributePropertyModel = StscComplexTypeResolver.buildAttributePropertyModelByQName(attrModel, sImpl);
        int n = mixed ? 4 : (complexVariety = contentModel == null ? 1 : 3);
        if (baseType == null) {
            baseType = XmlObject.type;
        }
        sImpl.setBaseTypeRef(baseType.getRef());
        sImpl.setBaseDepth(((SchemaTypeImpl)baseType).getBaseDepth() + 1);
        sImpl.setDerivationType(2);
        sImpl.setComplexTypeVariety(complexVariety);
        sImpl.setContentModel(contentModel, attrModel, elementPropertyModel, attributePropertyModel, isAll);
        sImpl.setAnonymousTypeRefs(StscComplexTypeResolver.makeRefArray(anonymousTypes));
        sImpl.setWildcardSummary(wcElt.typedWildcards, wcElt.hasWildcards, wcAttr.typedWildcards, wcAttr.hasWildcards);
    }

    static void resolveScRestriction(SchemaTypeImpl sImpl, SimpleRestrictionType parseTree) {
        SchemaTypeImpl baseType;
        boolean chameleon;
        StscState state = StscState.get();
        String targetNamespace = sImpl.getTargetNamespace();
        boolean bl = chameleon = sImpl.getChameleonNamespace() != null;
        if (parseTree.getSimpleType() != null) {
            state.warning("Nested simple types inside simple content restrictions are unsupported - ignoring", 45, parseTree);
        }
        if (parseTree.getBase() == null) {
            state.error("A simpleContent restriction must define a base type", 28, parseTree);
            baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        } else {
            baseType = state.findGlobalType(parseTree.getBase(), sImpl.getChameleonNamespace());
            if (baseType == null) {
                state.notFoundError(parseTree.getBase(), 6, parseTree.xgetBase());
                baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
            }
        }
        StscResolver.resolveType(baseType);
        if (baseType.isSimpleType()) {
            state.error("Simple type '" + baseType.getName() + "' cannot be used as the base type of a simple content restriction. (Use extension instead.)", 43, parseTree);
            baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        } else if (baseType.getContentType() != 2) {
            state.error("The specified base type " + ((Object)baseType).toString() + " does not have simple content.", 43, parseTree);
            baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (baseType != null && baseType.finalRestriction()) {
            state.error("Cannot restrict a final type", 54, parseTree.xgetBase());
        }
        ArrayList anonymousTypes = new ArrayList();
        SchemaAttributeModelImpl attrModel = baseType == null ? new SchemaAttributeModelImpl() : new SchemaAttributeModelImpl(baseType.getAttributeModel());
        StscComplexTypeResolver.translateAttributeModel(parseTree, targetNamespace, chameleon, anonymousTypes, sImpl, null, attrModel, baseType, false);
        WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
        Map attributePropertyModel = StscComplexTypeResolver.buildAttributePropertyModelByQName(attrModel, sImpl);
        sImpl.setBaseTypeRef(baseType.getRef());
        sImpl.setBaseDepth(baseType.getBaseDepth() + 1);
        sImpl.setDerivationType(1);
        sImpl.setAnonymousTypeRefs(StscComplexTypeResolver.makeRefArray(anonymousTypes));
        sImpl.setWildcardSummary(QNameSet.EMPTY, false, wcAttr.typedWildcards, wcAttr.hasWildcards);
        sImpl.setComplexTypeVariety(2);
        sImpl.setContentModel(null, attrModel, null, attributePropertyModel, false);
        sImpl.setSimpleTypeVariety(baseType.getSimpleVariety());
        sImpl.setPrimitiveTypeRef(baseType.getPrimitiveType() == null ? null : baseType.getPrimitiveType().getRef());
        switch (sImpl.getSimpleVariety()) {
            case 3: {
                sImpl.setListItemTypeRef(baseType.getListItemType().getRef());
                break;
            }
            case 2: {
                sImpl.setUnionMemberTypeRefs(StscComplexTypeResolver.makeRefArray(Arrays.asList(baseType.getUnionMemberTypes())));
            }
        }
        StscSimpleTypeResolver.resolveFacets(sImpl, parseTree, baseType);
        StscSimpleTypeResolver.resolveFundamentalFacets(sImpl);
    }

    static void resolveScExtension(SchemaTypeImpl sImpl, SimpleExtensionType parseTree) {
        SchemaTypeImpl baseType;
        boolean chameleon;
        StscState state = StscState.get();
        String targetNamespace = sImpl.getTargetNamespace();
        boolean bl = chameleon = sImpl.getChameleonNamespace() != null;
        if (parseTree.getBase() == null) {
            state.error("A simpleContent extension must define a base type", 28, parseTree);
            baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        } else {
            baseType = state.findGlobalType(parseTree.getBase(), sImpl.getChameleonNamespace());
            if (baseType == null) {
                state.notFoundError(parseTree.getBase(), 6, parseTree.xgetBase());
                baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
            }
        }
        StscResolver.resolveType(baseType);
        if (!baseType.isSimpleType() && baseType.getContentType() != 2) {
            state.error("The specified base type " + ((Object)baseType).toString() + " does not have simple content.", 43, parseTree);
            baseType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (baseType != null && baseType.finalExtension()) {
            state.error("Cannot extend a final type", 54, parseTree.xgetBase());
        }
        ArrayList anonymousTypes = new ArrayList();
        SchemaAttributeModelImpl attrModel = new SchemaAttributeModelImpl(baseType.getAttributeModel());
        StscComplexTypeResolver.translateAttributeModel(parseTree, targetNamespace, chameleon, anonymousTypes, sImpl, null, attrModel, baseType, true);
        WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
        Map attributePropertyModel = StscComplexTypeResolver.buildAttributePropertyModelByQName(attrModel, sImpl);
        sImpl.setBaseTypeRef(baseType.getRef());
        sImpl.setBaseDepth(baseType.getBaseDepth() + 1);
        sImpl.setDerivationType(2);
        sImpl.setAnonymousTypeRefs(StscComplexTypeResolver.makeRefArray(anonymousTypes));
        sImpl.setWildcardSummary(QNameSet.EMPTY, false, wcAttr.typedWildcards, wcAttr.hasWildcards);
        sImpl.setComplexTypeVariety(2);
        sImpl.setContentModel(null, attrModel, null, attributePropertyModel, false);
        sImpl.setSimpleTypeVariety(baseType.getSimpleVariety());
        sImpl.setPrimitiveTypeRef(baseType.getPrimitiveType() == null ? null : baseType.getPrimitiveType().getRef());
        switch (sImpl.getSimpleVariety()) {
            case 3: {
                sImpl.setListItemTypeRef(baseType.getListItemType().getRef());
                break;
            }
            case 2: {
                sImpl.setUnionMemberTypeRefs(StscComplexTypeResolver.makeRefArray(Arrays.asList(baseType.getUnionMemberTypes())));
            }
        }
        StscSimpleTypeResolver.resolveFacets(sImpl, null, baseType);
        StscSimpleTypeResolver.resolveFundamentalFacets(sImpl);
    }

    static WildcardResult summarizeAttrWildcards(SchemaAttributeModel attrModel) {
        if (attrModel.getWildcardProcess() == 0) {
            return new WildcardResult(QNameSet.EMPTY, false);
        }
        if (attrModel.getWildcardProcess() == 3) {
            return new WildcardResult(QNameSet.EMPTY, true);
        }
        return new WildcardResult(attrModel.getWildcardSet(), true);
    }

    static WildcardResult summarizeEltWildcards(SchemaParticle contentModel) {
        if (contentModel == null) {
            return new WildcardResult(QNameSet.EMPTY, false);
        }
        switch (contentModel.getParticleType()) {
            case 1: 
            case 2: 
            case 3: {
                QNameSetBuilder set = new QNameSetBuilder();
                boolean hasWildcards = false;
                int i = 0;
                while (i < contentModel.countOfParticleChild()) {
                    WildcardResult inner = StscComplexTypeResolver.summarizeEltWildcards(contentModel.getParticleChild(i));
                    set.addAll(inner.typedWildcards);
                    hasWildcards |= inner.hasWildcards;
                    ++i;
                }
                return new WildcardResult(set.toQNameSet(), hasWildcards);
            }
            case 5: {
                return new WildcardResult(contentModel.getWildcardProcess() == 3 ? QNameSet.EMPTY : contentModel.getWildcardSet(), true);
            }
        }
        return new WildcardResult(QNameSet.EMPTY, false);
    }

    static void translateAttributeModel(XmlObject parseTree, String targetNamespace, boolean chameleon, List anonymousTypes, SchemaType outerType, Set seenAttributes, SchemaAttributeModelImpl result, SchemaType baseType, boolean extension) {
        StscState state = StscState.get();
        if (seenAttributes == null) {
            seenAttributes = new HashSet<QName>();
        }
        boolean seenWildcard = false;
        SchemaAttributeModel baseModel = null;
        if (baseType != null) {
            baseModel = baseType.getAttributeModel();
        }
        XmlCursor cur = parseTree.newCursor();
        boolean more = cur.toFirstChild();
        while (more) {
            switch (StscComplexTypeResolver.translateAttributeCode(cur.getName())) {
                case 100: {
                    Attribute xsdattr = (Attribute)cur.getObject();
                    SchemaLocalAttributeImpl sAttr = StscTranslator.translateAttribute(xsdattr, targetNamespace, chameleon, anonymousTypes, outerType, baseModel, true);
                    if (sAttr == null) break;
                    if (seenAttributes.contains(sAttr.getName())) {
                        state.error("Attribute with the same name already defined ", 37, xsdattr.xgetName());
                        break;
                    }
                    seenAttributes.add(sAttr.getName());
                    if (baseModel != null) {
                        SchemaLocalAttribute baseAttr = baseModel.getAttribute(sAttr.getName());
                        if (baseAttr == null) {
                            if (!extension && !baseModel.getWildcardSet().contains(sAttr.getName())) {
                                state.error("A restriction cannot introduce a new attribute that would not be allowed in the base type.", 37, xsdattr);
                            }
                        } else if (extension) {
                            if (sAttr.getUse() == 1) {
                                state.error("An extension cannot prohibit an attribute from the base type; use restriction instead.", 37, xsdattr.xgetUse());
                            }
                        } else if (sAttr.getUse() != 3) {
                            if (baseAttr.getUse() == 3) {
                                state.error("A restriction cannot modify an attribute that is required in the base type to be prohibited or optional.", 37, xsdattr.xgetUse());
                            }
                            if (sAttr.getUse() == 1) {
                                result.removeProhibitedAttribute(sAttr.getName());
                            }
                        }
                    }
                    if (sAttr.getUse() != 1) {
                        result.addAttribute(sAttr);
                    }
                    if (sAttr.getDefaultText() == null || sAttr.isFixed() || sAttr.getUse() == 2) break;
                    state.error("An attribute declaration must be optional in order to specify a default", 60, xsdattr);
                    break;
                }
                case 102: {
                    Wildcard xsdwc = (Wildcard)cur.getObject();
                    if (seenWildcard) {
                        state.error("Only one attribute wildcard allowed", 38, xsdwc);
                        break;
                    }
                    seenWildcard = true;
                    NamespaceList nsList = xsdwc.xgetNamespace();
                    String nsText = nsList == null ? "##any" : nsList.stringValue();
                    QNameSet wcset = QNameSet.forWildcardNamespaceString(nsText, targetNamespace);
                    if (baseModel != null && !extension) {
                        if (baseModel.getWildcardSet() == null) {
                            state.error("A restriction cannot add anyAttribute when the base type does not have anyAttribute", 38, xsdwc);
                            break;
                        }
                        if (!baseModel.getWildcardSet().containsAll(wcset)) {
                            state.error("The anyAttribute namespace='" + nsText + "' is not a subset of the base type anyAttribute", 38, xsdwc);
                            break;
                        }
                    }
                    int wcprocess = StscComplexTypeResolver.translateWildcardProcess(xsdwc.xgetProcessContents());
                    if (result.getWildcardProcess() == 0) {
                        result.setWildcardSet(wcset);
                        result.setWildcardProcess(wcprocess);
                        break;
                    }
                    if (extension) {
                        result.setWildcardSet(wcset.union(result.getWildcardSet()));
                        result.setWildcardProcess(wcprocess);
                        break;
                    }
                    result.setWildcardSet(wcset.intersect(result.getWildcardSet()));
                    break;
                }
                case 101: {
                    AttributeGroupRef xsdag = (AttributeGroupRef)cur.getObject();
                    QName ref = xsdag.getRef();
                    if (ref == null) {
                        state.error("Group reference must have a ref attribute", 39, xsdag);
                        break;
                    }
                    SchemaAttributeGroupImpl group = state.findAttributeGroup(ref, chameleon ? targetNamespace : null);
                    if (group == null) {
                        state.notFoundError(ref, 40, xsdag.xgetRef());
                        break;
                    }
                    if (state.isProcessing(group)) {
                        state.error("Attribute group " + QNameHelper.pretty(group.getName()) + " references itself", 13, group.getParseObject());
                        break;
                    }
                    String subTargetNamespace = targetNamespace;
                    if (group.getTargetNamespace() != null) {
                        subTargetNamespace = group.getTargetNamespace();
                        chameleon = group.getChameleonNamespace() != null;
                    }
                    state.startProcessing(group);
                    StscComplexTypeResolver.translateAttributeModel(group.getParseObject(), subTargetNamespace, chameleon, anonymousTypes, outerType, seenAttributes, result, baseType, extension);
                    state.finishProcessing(group);
                    break;
                }
            }
            more = cur.toNextSibling();
        }
    }

    static SchemaParticle extendContentModel(SchemaParticle baseContentModel, SchemaParticle extendedContentModel, XmlObject parseTree) {
        if (extendedContentModel == null) {
            return baseContentModel;
        }
        if (baseContentModel == null) {
            return extendedContentModel;
        }
        SchemaParticleImpl sPart = new SchemaParticleImpl();
        sPart.setParticleType(3);
        ArrayList accumulate = new ArrayList();
        StscComplexTypeResolver.addMinusPointlessParticles(accumulate, baseContentModel, 3);
        StscComplexTypeResolver.addMinusPointlessParticles(accumulate, extendedContentModel, 3);
        sPart.setMinOccurs(BigInteger.ONE);
        sPart.setMaxOccurs(BigInteger.ONE);
        sPart.setParticleChildren(accumulate.toArray(new SchemaParticle[accumulate.size()]));
        return StscComplexTypeResolver.filterPointlessParticlesAndVerifyAllParticles(sPart, parseTree);
    }

    static BigInteger extractMinOccurs(XmlNonNegativeInteger nni) {
        if (nni == null) {
            return BigInteger.ONE;
        }
        BigInteger result = nni.bigIntegerValue();
        if (result == null) {
            return BigInteger.ONE;
        }
        return result;
    }

    static BigInteger extractMaxOccurs(AllNNI allNNI) {
        if (allNNI == null) {
            return BigInteger.ONE;
        }
        if (allNNI.instanceType().getPrimitiveType().getBuiltinTypeCode() == 11) {
            return ((XmlInteger)((Object)allNNI)).bigIntegerValue();
        }
        return null;
    }

    static SchemaParticle translateContentModel(SchemaType outerType, XmlObject parseTree, String targetNamespace, boolean chameleon, int particleCode, List anonymousTypes, Map elementModel, boolean allowElt) {
        BigInteger maxOccurs;
        BigInteger minOccurs;
        SchemaParticleImpl sPart;
        if (parseTree == null || particleCode == 0) {
            return null;
        }
        StscState state = StscState.get();
        if (!$assertionsDisabled && particleCode == 0) {
            throw new AssertionError();
        }
        boolean hasChildren = false;
        SchemaModelGroupImpl group = null;
        if (particleCode == 4) {
            LocalElement parseElt;
            if (!allowElt) {
                state.error("Must be a sequence, choice or all here", 32, parseTree);
            }
            if ((sPart = StscTranslator.translateElement(parseElt = (LocalElement)parseTree, targetNamespace, chameleon, anonymousTypes, outerType)) == null) {
                return null;
            }
            minOccurs = StscComplexTypeResolver.extractMinOccurs(parseElt.xgetMinOccurs());
            maxOccurs = StscComplexTypeResolver.extractMaxOccurs(parseElt.xgetMaxOccurs());
            SchemaType oldType = (SchemaType)elementModel.get(sPart.getName());
            if (oldType == null) {
                elementModel.put(sPart.getName(), sPart.getType());
            } else if (!sPart.getType().equals(oldType)) {
                state.error("Type of " + QNameHelper.pretty(sPart.getName()) + " is inconsistent with another element with the same name in this content model", 50, parseTree);
                return null;
            }
        } else if (particleCode == 5) {
            if (!allowElt) {
                state.error("Must be a sequence, choice or all here", 32, parseTree);
            }
            AnyDocument.Any parseAny = (AnyDocument.Any)parseTree;
            sPart = new SchemaParticleImpl();
            sPart.setParticleType(5);
            NamespaceList nslist = parseAny.xgetNamespace();
            QNameSet wcset = nslist == null ? QNameSet.ALL : QNameSet.forWildcardNamespaceString(nslist.stringValue(), targetNamespace);
            sPart.setWildcardSet(wcset);
            sPart.setWildcardProcess(StscComplexTypeResolver.translateWildcardProcess(parseAny.xgetProcessContents()));
            minOccurs = StscComplexTypeResolver.extractMinOccurs(parseAny.xgetMinOccurs());
            maxOccurs = StscComplexTypeResolver.extractMaxOccurs(parseAny.xgetMaxOccurs());
        } else {
            Group parseGroup = (Group)parseTree;
            sPart = new SchemaParticleImpl();
            minOccurs = StscComplexTypeResolver.extractMinOccurs(parseGroup.xgetMinOccurs());
            maxOccurs = StscComplexTypeResolver.extractMaxOccurs(parseGroup.xgetMaxOccurs());
            if (particleCode == 100) {
                String newTargetNamespace;
                QName ref = parseGroup.getRef();
                if (ref == null) {
                    state.error("Group reference must have a ref attribute", 33, parseTree);
                    return null;
                }
                group = state.findModelGroup(ref, chameleon ? targetNamespace : null);
                if (group == null) {
                    state.notFoundError(ref, 34, ((Group)parseTree).xgetRef());
                    return null;
                }
                if (state.isProcessing(group)) {
                    state.error("Model group " + QNameHelper.pretty(group.getName()) + " references itself", 13, group.getParseObject());
                    return null;
                }
                XmlCursor cur = group.getParseObject().newCursor();
                boolean more = cur.toFirstChild();
                while (more) {
                    particleCode = StscComplexTypeResolver.translateParticleCode(cur.getName());
                    if (particleCode != 0) {
                        parseGroup = (Group)cur.getObject();
                        parseTree = parseGroup;
                        break;
                    }
                    more = cur.toNextSibling();
                }
                if (particleCode == 0) {
                    state.error("Model group " + QNameHelper.pretty(group.getName()) + " is empty", 32, group.getParseObject());
                    return null;
                }
                if (particleCode != 1 && particleCode != 3 && particleCode != 2) {
                    state.error("Model group " + QNameHelper.pretty(group.getName()) + " is not a sequence, all, or choice", 32, group.getParseObject());
                }
                if ((newTargetNamespace = group.getTargetNamespace()) != null) {
                    targetNamespace = newTargetNamespace;
                }
            }
            switch (particleCode) {
                case 1: 
                case 2: 
                case 3: {
                    sPart.setParticleType(particleCode);
                    hasChildren = true;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    throw new IllegalStateException();
                }
            }
        }
        if (maxOccurs != null && minOccurs.compareTo(maxOccurs) > 0) {
            state.error("maxOccurs must not be less than minOccurs", 35, parseTree);
            maxOccurs = minOccurs;
        }
        if (maxOccurs != null && maxOccurs.compareTo(BigInteger.ONE) < 0) {
            return null;
        }
        sPart.setMinOccurs(minOccurs);
        sPart.setMaxOccurs(maxOccurs);
        if (group != null) {
            state.startProcessing(group);
        }
        if (hasChildren) {
            XmlCursor cur = parseTree.newCursor();
            ArrayList accumulate = new ArrayList();
            boolean more = cur.toFirstChild();
            while (more) {
                int code = StscComplexTypeResolver.translateParticleCode(cur.getName());
                if (code != 0) {
                    StscComplexTypeResolver.addMinusPointlessParticles(accumulate, StscComplexTypeResolver.translateContentModel(outerType, cur.getObject(), targetNamespace, chameleon, code, anonymousTypes, elementModel, true), sPart.getParticleType());
                }
                more = cur.toNextSibling();
            }
            sPart.setParticleChildren(accumulate.toArray(new SchemaParticle[accumulate.size()]));
            cur.dispose();
        }
        SchemaParticle result = StscComplexTypeResolver.filterPointlessParticlesAndVerifyAllParticles(sPart, parseTree);
        if (group != null) {
            state.finishProcessing(group);
        }
        return result;
    }

    static int translateWildcardProcess(Wildcard.ProcessContents process) {
        if (process == null) {
            return 1;
        }
        String processValue = process.stringValue();
        if ("lax".equals(processValue)) {
            return 2;
        }
        if ("skip".equals(processValue)) {
            return 3;
        }
        return 1;
    }

    static SchemaParticle filterPointlessParticlesAndVerifyAllParticles(SchemaParticle part, XmlObject parseTree) {
        boolean isAll;
        if (part.getMaxOccurs() != null && part.getMaxOccurs().signum() == 0) {
            return null;
        }
        switch (part.getParticleType()) {
            case 1: 
            case 3: {
                if (part.getParticleChildren().length == 0) {
                    return null;
                }
                if (!part.isSingleton() || part.countOfParticleChild() != 1) break;
                return part.getParticleChild(0);
            }
            case 2: {
                if (part.getParticleChildren().length == 0 && part.getMinOccurs().compareTo(BigInteger.ZERO) == 0) {
                    return null;
                }
                if (!part.isSingleton() || part.countOfParticleChild() != 1) break;
                return part.getParticleChild(0);
            }
            case 4: 
            case 5: {
                return part;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new IllegalStateException();
            }
        }
        boolean bl = isAll = part.getParticleType() == 1;
        if (isAll && (part.getMaxOccurs() == null || part.getMaxOccurs().compareTo(BigInteger.ONE) > 0)) {
            StscState.get().error("An all group must have maxOccurs <= 1", 31, parseTree);
        }
        int i = 0;
        while (i < part.countOfParticleChild()) {
            SchemaParticle child = part.getParticleChild(i);
            if (child.getParticleType() == 1) {
                StscState.get().error("An all group is only allowed at the top level of the content model", 42, parseTree);
            } else if (isAll && (child.getParticleType() != 4 || child.getMaxOccurs() == null || child.getMaxOccurs().compareTo(BigInteger.ONE) > 0)) {
                StscState.get().error("An all group can contain only element particles with maxOccurs <= 1", 31, parseTree);
            }
            ++i;
        }
        return part;
    }

    static void addMinusPointlessParticles(List list, SchemaParticle part, int parentParticleType) {
        if (part == null) {
            return;
        }
        switch (part.getParticleType()) {
            case 3: {
                if (parentParticleType != 3 || !part.isSingleton()) break;
                list.addAll(Arrays.asList(part.getParticleChildren()));
                return;
            }
            case 2: {
                if (parentParticleType != 2 || !part.isSingleton()) break;
                list.addAll(Arrays.asList(part.getParticleChildren()));
                return;
            }
        }
        list.add(part);
    }

    static Map buildAttributePropertyModelByQName(SchemaAttributeModel attrModel, SchemaType owner) {
        LinkedHashMap<QName, SchemaProperty> result = new LinkedHashMap<QName, SchemaProperty>();
        SchemaLocalAttribute[] attruses = attrModel.getAttributes();
        int i = 0;
        while (i < attruses.length) {
            result.put(attruses[i].getName(), StscComplexTypeResolver.buildUseProperty(attruses[i], owner));
            ++i;
        }
        return result;
    }

    static Map buildContentPropertyModelByQName(SchemaParticle part, SchemaType owner) {
        if (part == null) {
            return Collections.EMPTY_MAP;
        }
        boolean asSequence = false;
        LinkedHashMap<QName, SchemaProperty> model = null;
        switch (part.getParticleType()) {
            case 1: 
            case 3: {
                asSequence = true;
                break;
            }
            case 2: {
                asSequence = false;
                break;
            }
            case 4: {
                model = StscComplexTypeResolver.buildElementPropertyModel((SchemaLocalElement)((Object)part), owner);
                break;
            }
            case 5: {
                model = Collections.EMPTY_MAP;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new IllegalStateException();
            }
        }
        if (model == null) {
            SchemaProperty oProp;
            model = new LinkedHashMap<QName, SchemaProperty>();
            SchemaParticle[] children = part.getParticleChildren();
            int i = 0;
            while (i < children.length) {
                Map childModel = StscComplexTypeResolver.buildContentPropertyModelByQName(children[i], owner);
                Iterator j = childModel.values().iterator();
                while (j.hasNext()) {
                    SchemaProperty iProp = (SchemaProperty)j.next();
                    oProp = (SchemaPropertyImpl)model.get(iProp.getName());
                    if (oProp == null) {
                        if (!asSequence) {
                            ((SchemaPropertyImpl)iProp).setMinOccurs(BigInteger.ZERO);
                        }
                        model.put(iProp.getName(), iProp);
                        continue;
                    }
                    if (!$assertionsDisabled && !((SchemaPropertyImpl)oProp).getType().equals(iProp.getType())) {
                        throw new AssertionError();
                    }
                    StscComplexTypeResolver.mergeProperties((SchemaPropertyImpl)oProp, iProp, asSequence);
                }
                ++i;
            }
            BigInteger min = part.getMinOccurs();
            BigInteger max = part.getMaxOccurs();
            Iterator j = model.values().iterator();
            while (j.hasNext()) {
                oProp = (SchemaProperty)j.next();
                BigInteger minOccurs = oProp.getMinOccurs();
                BigInteger maxOccurs = oProp.getMaxOccurs();
                minOccurs = minOccurs.multiply(min);
                if (max != null && max.equals(BigInteger.ZERO)) {
                    maxOccurs = BigInteger.ZERO;
                } else if (maxOccurs != null && !maxOccurs.equals(BigInteger.ZERO)) {
                    maxOccurs = max == null ? null : maxOccurs.multiply(max);
                }
                ((SchemaPropertyImpl)oProp).setMinOccurs(minOccurs);
                ((SchemaPropertyImpl)oProp).setMaxOccurs(maxOccurs);
            }
        }
        return model;
    }

    static Map buildElementPropertyModel(SchemaLocalElement epart, SchemaType owner) {
        HashMap<QName, SchemaProperty> result = new HashMap<QName, SchemaProperty>(1);
        SchemaProperty sProp = StscComplexTypeResolver.buildUseProperty(epart, owner);
        result.put(sProp.getName(), sProp);
        return result;
    }

    static SchemaProperty buildUseProperty(SchemaField use, SchemaType owner) {
        SchemaPropertyImpl sPropImpl = new SchemaPropertyImpl();
        sPropImpl.setName(use.getName());
        sPropImpl.setContainerTypeRef(owner.getRef());
        sPropImpl.setTypeRef(use.getType().getRef());
        sPropImpl.setAttribute(use.isAttribute());
        sPropImpl.setDefault(use.isDefault() ? 2 : 0);
        sPropImpl.setFixed(use.isFixed() ? 2 : 0);
        sPropImpl.setNillable(use.isNillable() ? 2 : 0);
        sPropImpl.setDefaultText(use.getDefaultText());
        sPropImpl.setMinOccurs(use.getMinOccurs());
        sPropImpl.setMaxOccurs(use.getMaxOccurs());
        return sPropImpl;
    }

    static void mergeProperties(SchemaPropertyImpl into, SchemaProperty from, boolean asSequence) {
        BigInteger minOccurs = into.getMinOccurs();
        BigInteger maxOccurs = into.getMaxOccurs();
        if (asSequence) {
            minOccurs = minOccurs.add(from.getMinOccurs());
            if (maxOccurs != null) {
                maxOccurs = from.getMaxOccurs() == null ? null : maxOccurs.add(from.getMaxOccurs());
            }
        } else {
            minOccurs = minOccurs.min(from.getMinOccurs());
            if (maxOccurs != null) {
                maxOccurs = from.getMaxOccurs() == null ? null : maxOccurs.max(from.getMaxOccurs());
            }
        }
        into.setMinOccurs(minOccurs);
        into.setMaxOccurs(maxOccurs);
        if (from.hasNillable() != into.hasNillable()) {
            into.setNillable(1);
        }
        if (from.hasDefault() != into.hasDefault()) {
            into.setDefault(1);
        }
        if (from.hasFixed() != into.hasFixed()) {
            into.setFixed(1);
        }
        if (!(into.getDefaultText() == null || from.getDefaultText() != null && into.getDefaultText().equals(from.getDefaultText()))) {
            into.setDefaultText(null);
        }
    }

    static SchemaParticle[] ensureStateMachine(SchemaParticle[] children) {
        int i = 0;
        while (i < children.length) {
            StscComplexTypeResolver.buildStateMachine(children[i]);
            ++i;
        }
        return children;
    }

    static void buildStateMachine(SchemaParticle contentModel) {
        boolean varloop;
        if (contentModel == null) {
            return;
        }
        SchemaParticleImpl partImpl = (SchemaParticleImpl)contentModel;
        if (partImpl.hasTransitionNotes()) {
            return;
        }
        QNameSetBuilder start = new QNameSetBuilder();
        QNameSetBuilder excludenext = new QNameSetBuilder();
        boolean deterministic = true;
        SchemaParticle[] children = null;
        boolean canskip = partImpl.getMinOccurs().signum() == 0;
        block0 : switch (partImpl.getParticleType()) {
            case 4: {
                start.add(partImpl.getName());
                break;
            }
            case 5: {
                start.addAll(partImpl.getWildcardSet());
                break;
            }
            case 3: {
                children = StscComplexTypeResolver.ensureStateMachine(partImpl.getParticleChildren());
                canskip = true;
                int i = 0;
                while (canskip && i < children.length) {
                    if (!children[i].isSkippable()) {
                        canskip = false;
                    }
                    ++i;
                }
                int i2 = 0;
                while (deterministic && i2 < children.length) {
                    if (!((SchemaParticleImpl)children[i2]).isDeterministic()) {
                        deterministic = false;
                    }
                    ++i2;
                }
                int i3 = 1;
                while (i3 < children.length) {
                    excludenext.addAll(((SchemaParticleImpl)children[i3 - 1]).getExcludeNextSet());
                    if (deterministic && !excludenext.isDisjoint(children[i3].acceptedStartNames())) {
                        deterministic = false;
                    }
                    if (children[i3].isSkippable()) {
                        excludenext.addAll(children[i3].acceptedStartNames());
                    } else {
                        excludenext.clear();
                    }
                    ++i3;
                }
                int i4 = 0;
                while (i4 < children.length) {
                    start.addAll(children[i4].acceptedStartNames());
                    if (!children[i4].isSkippable()) break block0;
                    ++i4;
                }
                break;
            }
            case 2: {
                children = StscComplexTypeResolver.ensureStateMachine(partImpl.getParticleChildren());
                canskip = false;
                int i = 0;
                while (!canskip && i < children.length) {
                    if (children[i].isSkippable()) {
                        canskip = true;
                    }
                    ++i;
                }
                int i5 = 0;
                while (deterministic && i5 < children.length) {
                    if (!((SchemaParticleImpl)children[i5]).isDeterministic()) {
                        deterministic = false;
                    }
                    ++i5;
                }
                int i6 = 0;
                while (i6 < children.length) {
                    if (deterministic && !start.isDisjoint(children[i6].acceptedStartNames())) {
                        deterministic = false;
                    }
                    start.addAll(children[i6].acceptedStartNames());
                    excludenext.addAll(((SchemaParticleImpl)children[i6]).getExcludeNextSet());
                    ++i6;
                }
                break;
            }
            case 1: {
                children = StscComplexTypeResolver.ensureStateMachine(partImpl.getParticleChildren());
                canskip = true;
                int i = 0;
                while (!canskip && i < children.length) {
                    if (!children[i].isSkippable()) {
                        canskip = false;
                    }
                    ++i;
                }
                int i7 = 0;
                while (deterministic && i7 < children.length) {
                    if (!((SchemaParticleImpl)children[i7]).isDeterministic()) {
                        deterministic = false;
                    }
                    ++i7;
                }
                int i8 = 0;
                while (i8 < children.length) {
                    if (deterministic && !start.isDisjoint(children[i8].acceptedStartNames())) {
                        deterministic = false;
                    }
                    start.addAll(children[i8].acceptedStartNames());
                    excludenext.addAll(((SchemaParticleImpl)children[i8]).getExcludeNextSet());
                    ++i8;
                }
                if (!canskip) break;
                excludenext.addAll(start);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized schema particle");
            }
        }
        BigInteger minOccurs = partImpl.getMinOccurs();
        BigInteger maxOccurs = partImpl.getMaxOccurs();
        boolean canloop = maxOccurs == null || maxOccurs.compareTo(BigInteger.ONE) > 0;
        boolean bl = varloop = maxOccurs == null || minOccurs.compareTo(maxOccurs) < 0;
        if (canloop && deterministic && !excludenext.isDisjoint(start)) {
            QNameSet suspectSet = excludenext.intersect(start);
            HashMap startMap = new HashMap();
            StscComplexTypeResolver.particlesMatchingStart(partImpl, suspectSet, startMap, new QNameSetBuilder());
            HashMap afterMap = new HashMap();
            StscComplexTypeResolver.particlesMatchingAfter(partImpl, suspectSet, afterMap, new QNameSetBuilder(), true);
            deterministic = StscComplexTypeResolver.afterMapSubsumedByStartMap(startMap, afterMap);
        }
        if (varloop) {
            excludenext.addAll(start);
        }
        canskip = canskip || minOccurs.signum() == 0;
        partImpl.setTransitionRules(start.toQNameSet(), canskip);
        partImpl.setTransitionNotes(excludenext.toQNameSet(), deterministic);
    }

    private static boolean afterMapSubsumedByStartMap(Map startMap, Map afterMap) {
        if (afterMap.size() > startMap.size()) {
            return false;
        }
        if (afterMap.isEmpty()) {
            return true;
        }
        Iterator i = startMap.keySet().iterator();
        while (i.hasNext()) {
            QNameSet afterSet;
            QNameSet startSet;
            SchemaParticle part = (SchemaParticle)i.next();
            if (part.getParticleType() == 5 && afterMap.containsKey(part) && !(startSet = (QNameSet)startMap.get(part)).containsAll(afterSet = (QNameSet)afterMap.get(part))) {
                return false;
            }
            afterMap.remove(part);
            if (!afterMap.isEmpty()) continue;
            return true;
        }
        return afterMap.isEmpty();
    }

    private static void particlesMatchingStart(SchemaParticle part, QNameSetSpecification suspectSet, Map result, QNameSetBuilder eliminate) {
        switch (part.getParticleType()) {
            case 4: {
                if (!suspectSet.contains(part.getName())) {
                    return;
                }
                result.put(part, null);
                eliminate.add(part.getName());
                return;
            }
            case 5: {
                if (suspectSet.isDisjoint(part.getWildcardSet())) {
                    return;
                }
                result.put(part, part.getWildcardSet().intersect(suspectSet));
                eliminate.addAll(part.getWildcardSet());
                return;
            }
            case 1: 
            case 2: {
                SchemaParticle[] children = part.getParticleChildren();
                int i = 0;
                while (i < children.length) {
                    StscComplexTypeResolver.particlesMatchingStart(children[i], suspectSet, result, eliminate);
                    ++i;
                }
                return;
            }
            case 3: {
                SchemaParticle[] children = part.getParticleChildren();
                if (children.length == 0) {
                    return;
                }
                if (!children[0].isSkippable()) {
                    StscComplexTypeResolver.particlesMatchingStart(children[0], suspectSet, result, eliminate);
                    return;
                }
                QNameSetBuilder remainingSuspects = new QNameSetBuilder(suspectSet);
                QNameSetBuilder suspectsToEliminate = new QNameSetBuilder();
                int i = 0;
                while (i < children.length) {
                    StscComplexTypeResolver.particlesMatchingStart(children[i], remainingSuspects, result, suspectsToEliminate);
                    eliminate.addAll(suspectsToEliminate);
                    if (!children[i].isSkippable()) {
                        return;
                    }
                    remainingSuspects.removeAll(suspectsToEliminate);
                    if (remainingSuspects.isEmpty()) {
                        return;
                    }
                    suspectsToEliminate.clear();
                    ++i;
                }
                return;
            }
        }
    }

    private static void particlesMatchingAfter(SchemaParticle part, QNameSetSpecification suspectSet, Map result, QNameSetBuilder eliminate, boolean top) {
        block0 : switch (part.getParticleType()) {
            case 1: 
            case 2: {
                SchemaParticle[] children = part.getParticleChildren();
                int i = 0;
                while (i < children.length) {
                    StscComplexTypeResolver.particlesMatchingAfter(children[i], suspectSet, result, eliminate, false);
                    ++i;
                }
                break;
            }
            case 3: {
                SchemaParticle[] children = part.getParticleChildren();
                if (children.length == 0) break;
                if (!children[children.length - 1].isSkippable()) {
                    StscComplexTypeResolver.particlesMatchingAfter(children[0], suspectSet, result, eliminate, false);
                    break;
                }
                QNameSetBuilder remainingSuspects = new QNameSetBuilder(suspectSet);
                QNameSetBuilder suspectsToEliminate = new QNameSetBuilder();
                int i = children.length - 1;
                while (i >= 0) {
                    StscComplexTypeResolver.particlesMatchingAfter(children[i], remainingSuspects, result, suspectsToEliminate, false);
                    eliminate.addAll(suspectsToEliminate);
                    if (!children[i].isSkippable()) break block0;
                    remainingSuspects.removeAll(suspectsToEliminate);
                    if (remainingSuspects.isEmpty()) break block0;
                    suspectsToEliminate.clear();
                    --i;
                }
                break;
            }
        }
        if (!top) {
            boolean varloop;
            BigInteger minOccurs = part.getMinOccurs();
            BigInteger maxOccurs = part.getMaxOccurs();
            boolean bl = varloop = maxOccurs == null || minOccurs.compareTo(maxOccurs) < 0;
            if (varloop) {
                StscComplexTypeResolver.particlesMatchingStart(part, suspectSet, result, eliminate);
            }
        }
    }

    private static Map buildParticleCodeMap() {
        HashMap<QName, Integer> result = new HashMap<QName, Integer>();
        int i = 0;
        while (i < particleCodes.length) {
            result.put(StscComplexTypeResolver.particleCodes[i].name, new Integer(StscComplexTypeResolver.particleCodes[i].code));
            ++i;
        }
        return result;
    }

    private static int translateParticleCode(Group parseEg) {
        if (parseEg == null) {
            return 0;
        }
        return StscComplexTypeResolver.translateParticleCode(parseEg.newCursor().getName());
    }

    private static int translateParticleCode(QName name) {
        Integer result = (Integer)particleCodeMap.get(name);
        if (result == null) {
            return 0;
        }
        return result;
    }

    private static Map buildAttributeCodeMap() {
        HashMap<QName, Integer> result = new HashMap<QName, Integer>();
        int i = 0;
        while (i < attributeCodes.length) {
            result.put(StscComplexTypeResolver.attributeCodes[i].name, new Integer(StscComplexTypeResolver.attributeCodes[i].code));
            ++i;
        }
        return result;
    }

    static int translateAttributeCode(QName currentName) {
        Integer result = (Integer)attributeCodeMap.get(currentName);
        if (result == null) {
            return 0;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$schema$StscComplexTypeResolver == null ? (class$com$bea$xbean$schema$StscComplexTypeResolver = StscComplexTypeResolver.class$("com.bea.xbean.schema.StscComplexTypeResolver")) : class$com$bea$xbean$schema$StscComplexTypeResolver).desiredAssertionStatus();
        particleCodes = new CodeForNameEntry[]{new CodeForNameEntry(QNameHelper.forLNS("all", "http://www.w3.org/2001/XMLSchema"), 1), new CodeForNameEntry(QNameHelper.forLNS("sequence", "http://www.w3.org/2001/XMLSchema"), 3), new CodeForNameEntry(QNameHelper.forLNS("choice", "http://www.w3.org/2001/XMLSchema"), 2), new CodeForNameEntry(QNameHelper.forLNS("element", "http://www.w3.org/2001/XMLSchema"), 4), new CodeForNameEntry(QNameHelper.forLNS("any", "http://www.w3.org/2001/XMLSchema"), 5), new CodeForNameEntry(QNameHelper.forLNS("group", "http://www.w3.org/2001/XMLSchema"), 100)};
        particleCodeMap = StscComplexTypeResolver.buildParticleCodeMap();
        attributeCodes = new CodeForNameEntry[]{new CodeForNameEntry(QNameHelper.forLNS("attribute", "http://www.w3.org/2001/XMLSchema"), 100), new CodeForNameEntry(QNameHelper.forLNS("attributeGroup", "http://www.w3.org/2001/XMLSchema"), 101), new CodeForNameEntry(QNameHelper.forLNS("anyAttribute", "http://www.w3.org/2001/XMLSchema"), 102)};
        attributeCodeMap = StscComplexTypeResolver.buildAttributeCodeMap();
    }

    private static class CodeForNameEntry {
        public QName name;
        public int code;

        CodeForNameEntry(QName name, int code) {
            this.name = name;
            this.code = code;
        }
    }

    static class WildcardResult {
        QNameSet typedWildcards;
        boolean hasWildcards;

        WildcardResult(QNameSet typedWildcards, boolean hasWildcards) {
            this.typedWildcards = typedWildcards;
            this.hasWildcards = hasWildcards;
        }
    }
}

