/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.schema;

import com.bea.x2002.x09.xbean.config.ConfigDocument;
import com.bea.xbean.common.NameUtil;
import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.XBeanDebug;
import com.bea.xbean.common.XmlErrorWatcher;
import com.bea.xbean.regex.RegularExpression;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.schema.ClassLoaderResourceLoader;
import com.bea.xbean.schema.ResourceLoader;
import com.bea.xbean.schema.SchemaAttributeGroupImpl;
import com.bea.xbean.schema.SchemaAttributeModelImpl;
import com.bea.xbean.schema.SchemaGlobalAttributeImpl;
import com.bea.xbean.schema.SchemaGlobalElementImpl;
import com.bea.xbean.schema.SchemaIdentityConstraintImpl;
import com.bea.xbean.schema.SchemaLocalAttributeImpl;
import com.bea.xbean.schema.SchemaLocalElementImpl;
import com.bea.xbean.schema.SchemaModelGroupImpl;
import com.bea.xbean.schema.SchemaParticleImpl;
import com.bea.xbean.schema.SchemaPropertyImpl;
import com.bea.xbean.schema.SchemaStringEnumEntryImpl;
import com.bea.xbean.schema.SchemaTypeImpl;
import com.bea.xbean.schema.SchemaTypeLoaderBase;
import com.bea.xbean.schema.SchemaTypeLoaderImpl;
import com.bea.xbean.schema.SchemaTypeSystemCompiler;
import com.bea.xbean.schema.StscComplexTypeResolver;
import com.bea.xbean.schema.StscState;
import com.bea.xbean.schema.XmlValueRef;
import com.bea.xbean.util.HexBin;
import com.bea.xbean.values.XmlObjectBase;
import com.bea.xml.QNameSet;
import com.bea.xml.SchemaAttributeGroup;
import com.bea.xml.SchemaAttributeModel;
import com.bea.xml.SchemaComponent;
import com.bea.xml.SchemaGlobalAttribute;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaIdentityConstraint;
import com.bea.xml.SchemaLocalAttribute;
import com.bea.xml.SchemaLocalElement;
import com.bea.xml.SchemaModelGroup;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaStringEnumEntry;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeLoaderException;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.SimpleValue;
import com.bea.xml.XmlAnySimpleType;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import com.bea.xml.soap.SOAPArrayType;
import com.bea.xml.soap.SchemaWSDLArrayType;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.w3.x2001.xmlSchema.AttributeGroupDocument;
import org.w3.x2001.xmlSchema.GroupDocument;
import org.w3.x2001.xmlSchema.SchemaDocument;

public class SchemaTypeSystemImpl
extends SchemaTypeLoaderBase
implements SchemaTypeSystem {
    public static final int DATA_BABE = -629491010;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 14;
    public static final int FILETYPE_SCHEMAINDEX = 1;
    public static final int FILETYPE_SCHEMATYPE = 2;
    public static final int FILETYPE_SCHEMAELEMENT = 3;
    public static final int FILETYPE_SCHEMAATTRIBUTE = 4;
    public static final int FILETYPE_SCHEMAPOINTER = 5;
    public static final int FILETYPE_SCHEMAMODELGROUP = 6;
    public static final int FILETYPE_SCHEMAATTRIBUTEGROUP = 7;
    public static final int FILETYPE_SCHEMAIDENTITYCONSTRAINT = 8;
    public static final int FLAG_PART_SKIPPABLE = 1;
    public static final int FLAG_PART_FIXED = 4;
    public static final int FLAG_PART_NILLABLE = 8;
    public static final int FLAG_PART_BLOCKEXT = 16;
    public static final int FLAG_PART_BLOCKREST = 32;
    public static final int FLAG_PART_BLOCKSUBST = 64;
    public static final int FLAG_PART_ABSTRACT = 128;
    public static final int FLAG_PART_FINALEXT = 256;
    public static final int FLAG_PART_FINALREST = 512;
    public static final int FLAG_PROP_ISATTR = 1;
    public static final int FLAG_PROP_JAVASINGLETON = 2;
    public static final int FLAG_PROP_JAVAOPTIONAL = 4;
    public static final int FLAG_PROP_JAVAARRAY = 8;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_GLOBAL = 1;
    public static final int FIELD_LOCALATTR = 2;
    public static final int FIELD_LOCALELT = 3;
    static final int FLAG_SIMPLE_TYPE = 1;
    static final int FLAG_DOCUMENT_TYPE = 2;
    static final int FLAG_ORDERED = 4;
    static final int FLAG_BOUNDED = 8;
    static final int FLAG_FINITE = 16;
    static final int FLAG_NUMERIC = 32;
    static final int FLAG_STRINGENUM = 64;
    static final int FLAG_UNION_OF_LISTS = 128;
    static final int FLAG_HAS_PATTERN = 256;
    static final int FLAG_ORDER_SENSITIVE = 512;
    static final int FLAG_TOTAL_ORDER = 1024;
    static final int FLAG_COMPILED = 2048;
    static final int FLAG_BLOCK_EXT = 4096;
    static final int FLAG_BLOCK_REST = 8192;
    static final int FLAG_FINAL_EXT = 16384;
    static final int FLAG_FINAL_REST = 32768;
    static final int FLAG_FINAL_UNION = 65536;
    static final int FLAG_FINAL_LIST = 131072;
    static final int FLAG_ABSTRACT = 262144;
    static final int FLAG_ATTRIBUTE_TYPE = 524288;
    private static final SchemaDocument.Schema[] EMPTY_SCHEMA_ARRAY;
    private static final ConfigDocument.Config[] EMPTY_CONFIG_ARRAY;
    private static Random _random;
    private static byte[] _mask;
    private String _name;
    private String _basePackage;
    private ClassLoader _classloader;
    private ResourceLoader _resourceLoader;
    SchemaTypeLoader _linker;
    private HandlePool _localHandles;
    private File _baseSaveDir;
    private Map _globalElements;
    private Map _globalAttributes;
    private Map _modelGroups;
    private Map _attributeGroups;
    private Map _globalTypes;
    private Map _documentTypes;
    private Map _attributeTypes;
    private Map _identityConstraints = Collections.EMPTY_MAP;
    private Map _typeRefsByClassname = new HashMap();
    private Set _namespaces;
    private static final SchemaType[] EMPTY_ST_ARRAY;
    private static final SchemaGlobalElement[] EMPTY_GE_ARRAY;
    private static final SchemaGlobalAttribute[] EMPTY_GA_ARRAY;
    private static final SchemaModelGroup[] EMPTY_MG_ARRAY;
    private static final SchemaAttributeGroup[] EMPTY_AG_ARRAY;
    private static final SchemaIdentityConstraint[] EMPTY_IC_ARRAY;
    static final byte[] SINGLE_ZERO_BYTE;
    private final Map _resolvedHandles = new HashMap();
    private boolean _allNonGroupHandlesResolved = false;
    static /* synthetic */ Class class$com$bea$xbean$schema$SchemaTypeSystemImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String nameToPathString(String nameForSystem) {
        if (!(nameForSystem = nameForSystem.replace('.', '/')).endsWith("/") && nameForSystem.length() > 0) {
            nameForSystem = nameForSystem + "/";
        }
        return nameForSystem;
    }

    public SchemaTypeSystemImpl(Class indexclass) {
        String fullname = indexclass.getName();
        this._name = fullname.substring(0, fullname.lastIndexOf(46));
        XBeanDebug.trace(1, "Loading type system " + this._name, 1);
        this._basePackage = SchemaTypeSystemImpl.nameToPathString(this._name);
        this._classloader = indexclass.getClassLoader();
        this._linker = SchemaTypeLoaderImpl.build(null, null, this._classloader);
        this._resourceLoader = new ClassLoaderResourceLoader(this._classloader);
        this.initFromHeader();
        XBeanDebug.trace(1, "Finished loading type system " + this._name, -1);
    }

    public static SchemaTypeSystemImpl forSchemaXml(XmlObject[] input, SchemaTypeLoader linkTo, XmlOptions options) throws XmlException {
        options = XmlOptions.maskNull(options);
        ArrayList<XmlObject> schemas = new ArrayList<XmlObject>();
        ArrayList<XmlObject> configs = new ArrayList<XmlObject>();
        int i = 0;
        while (i < input.length) {
            if (input[i] instanceof SchemaDocument.Schema) {
                schemas.add(input[i]);
            } else if (input[i] instanceof SchemaDocument && ((SchemaDocument)input[i]).getSchema() != null) {
                schemas.add(((SchemaDocument)input[i]).getSchema());
            } else if (input[i] instanceof ConfigDocument.Config) {
                configs.add(input[i]);
            } else if (input[i] instanceof ConfigDocument && ((ConfigDocument)input[i]).getConfig() != null) {
                configs.add(((ConfigDocument)input[i]).getConfig());
            } else {
                throw new XmlException("Thread " + Thread.currentThread().getName() + ": The " + i + "th supplied input is not a schema or a config document: its type is " + input[i].schemaType());
            }
            ++i;
        }
        Collection userErrors = (Collection)options.get("ERROR_LISTENER");
        XmlErrorWatcher errorWatcher = new XmlErrorWatcher(userErrors);
        SchemaTypeSystemImpl stsi = SchemaTypeSystemCompiler.compileImpl(null, schemas.toArray(EMPTY_SCHEMA_ARRAY), configs.toArray(EMPTY_CONFIG_ARRAY), linkTo, options, errorWatcher, false, null, null);
        if (errorWatcher.hasError()) {
            throw new XmlException(errorWatcher.firstError());
        }
        return stsi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fileContainsTypeSystem(File file, String name) {
        boolean bl;
        String indexname = SchemaTypeSystemImpl.nameToPathString(name) + "index.xsb";
        if (file.isDirectory()) {
            return new File(file, indexname).isFile();
        }
        ZipFile zipfile = null;
        try {
            try {
                zipfile = new ZipFile(file);
                ZipEntry entry = zipfile.getEntry(indexname);
                bl = entry != null && !entry.isDirectory();
                Object var7_7 = null;
                if (zipfile == null) return bl;
            }
            catch (IOException e) {
                XBeanDebug.log("Problem loading SchemaTypeSystem, zipfilename " + file);
                XBeanDebug.logException(e);
                throw new SchemaTypeLoaderException(e.getMessage(), name, "index", 9);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (zipfile == null) throw throwable;
            try {
                zipfile.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return bl;
        }
        zipfile.close();
        return bl;
    }

    public static SchemaTypeSystemImpl forName(String name, ClassLoader loader) {
        try {
            Class<?> c = Class.forName(name + "." + "TypeSystemHolder", true, loader);
            return (SchemaTypeSystemImpl)c.getField("typeSystem").get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SchemaTypeSystemImpl(ResourceLoader resourceLoader, String name, SchemaTypeLoader linker) {
        this._name = name;
        this._basePackage = SchemaTypeSystemImpl.nameToPathString(this._name);
        this._linker = linker;
        this._resourceLoader = resourceLoader;
        try {
            this.initFromHeader();
        }
        catch (RuntimeException e) {
            XBeanDebug.logException(e);
            throw e;
        }
        catch (Error e) {
            XBeanDebug.logException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromHeader() {
        XBeanDebug.trace(1, "Reading unresolved handles for type system " + this._name, 0);
        XsbReader reader = null;
        try {
            reader = new XsbReader("index", 1);
            this._localHandles = new HandlePool();
            reader.readHandlePool(this._localHandles);
            this._globalElements = reader.readQNameRefMap();
            this._globalAttributes = reader.readQNameRefMap();
            this._modelGroups = reader.readQNameRefMap();
            this._attributeGroups = reader.readQNameRefMap();
            this._identityConstraints = reader.readQNameRefMap();
            this._globalTypes = reader.readQNameRefMap();
            this._documentTypes = reader.readQNameRefMap();
            this._attributeTypes = reader.readQNameRefMap();
            this._typeRefsByClassname = reader.readClassnameRefMap();
            this._namespaces = reader.readNamespaces();
            Object var3_2 = null;
            if (reader != null) {
                reader.readEnd();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (reader != null) {
                reader.readEnd();
            }
            throw throwable;
        }
    }

    void saveIndex() {
        String handle = "index";
        XsbReader saver = new XsbReader(handle);
        saver.writeIndexData();
        saver.writeRealHeader(handle, 1);
        saver.writeIndexData();
        saver.writeEnd();
    }

    void savePointers() {
        this.savePointersForComponents(this.globalElements(), "schema/element/");
        this.savePointersForComponents(this.globalAttributes(), "schema/attribute/");
        this.savePointersForComponents(this.modelGroups(), "schema/modelgroup/");
        this.savePointersForComponents(this.attributeGroups(), "schema/attributegroup/");
        this.savePointersForComponents(this.globalTypes(), "schema/type/");
        this.savePointersForComponents(this.identityConstraints(), "schema/identityconstraint/");
        this.savePointersForNamespaces(this._namespaces, "schema/namespace/");
        this.savePointersForClassnames(this._typeRefsByClassname.keySet(), "schema/javaname/");
    }

    void savePointersForComponents(SchemaComponent[] components, String dir) {
        int i = 0;
        while (i < components.length) {
            this.savePointerFile(dir + QNameHelper.hexsafedir(components[i].getName()), this._name);
            ++i;
        }
    }

    void savePointersForClassnames(Set classnames, String dir) {
        Iterator i = classnames.iterator();
        while (i.hasNext()) {
            String classname = (String)i.next();
            this.savePointerFile(dir + classname.replace('.', '/'), this._name);
        }
    }

    void savePointersForNamespaces(Set namespaces, String dir) {
        Iterator i = namespaces.iterator();
        while (i.hasNext()) {
            String ns = (String)i.next();
            this.savePointerFile(dir + QNameHelper.hexsafedir(new QName(ns, "xmlns")), this._name);
        }
    }

    void savePointerFile(String filename, String name) {
        XsbReader saver = new XsbReader(filename);
        saver.writeString(name);
        saver.writeRealHeader(filename, 5);
        saver.writeString(name);
        saver.writeEnd();
    }

    private Map buildTypeRefsByClassname() {
        ArrayList<SchemaType> allSeenTypes = new ArrayList<SchemaType>();
        LinkedHashMap<String, SchemaType.Ref> result = new LinkedHashMap<String, SchemaType.Ref>();
        allSeenTypes.addAll(Arrays.asList(this.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(this.attributeTypes()));
        allSeenTypes.addAll(Arrays.asList(this.globalTypes()));
        int i = 0;
        while (i < allSeenTypes.size()) {
            SchemaType gType = (SchemaType)allSeenTypes.get(i);
            String className = gType.getFullJavaName();
            if (className != null) {
                result.put(className.replace('$', '.'), gType.getRef());
            }
            allSeenTypes.addAll(Arrays.asList(gType.getAnonymousTypes()));
            ++i;
        }
        return result;
    }

    private Map buildTypeRefsByClassname(Map typesByClassname) {
        LinkedHashMap<String, SchemaType.Ref> result = new LinkedHashMap<String, SchemaType.Ref>();
        Iterator i = typesByClassname.keySet().iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            result.put(className, ((SchemaType)typesByClassname.get(className)).getRef());
        }
        return result;
    }

    private static Map buildComponentRefMap(SchemaComponent[] components) {
        LinkedHashMap<QName, SchemaComponent.Ref> result = new LinkedHashMap<QName, SchemaComponent.Ref>();
        int i = 0;
        while (i < components.length) {
            result.put(components[i].getName(), components[i].getComponentRef());
            ++i;
        }
        return result;
    }

    private static Map buildDocumentMap(SchemaType[] types) {
        LinkedHashMap<QName, SchemaType.Ref> result = new LinkedHashMap<QName, SchemaType.Ref>();
        int i = 0;
        while (i < types.length) {
            result.put(types[i].getDocumentElementName(), types[i].getRef());
            ++i;
        }
        return result;
    }

    private static Map buildAttributeTypeMap(SchemaType[] types) {
        LinkedHashMap<QName, SchemaType.Ref> result = new LinkedHashMap<QName, SchemaType.Ref>();
        int i = 0;
        while (i < types.length) {
            result.put(types[i].getAttributeTypeAttributeName(), types[i].getRef());
            ++i;
        }
        return result;
    }

    private static synchronized void nextBytes(byte[] result) {
        if (_random == null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream daos = new DataOutputStream(baos);
                daos.writeInt(System.identityHashCode(class$com$bea$xbean$schema$SchemaTypeSystemImpl == null ? (class$com$bea$xbean$schema$SchemaTypeSystemImpl = SchemaTypeSystemImpl.class$("com.bea.xbean.schema.SchemaTypeSystemImpl")) : class$com$bea$xbean$schema$SchemaTypeSystemImpl));
                String[] props = new String[]{"user.name", "user.dir", "user.timezone", "user.country", "java.class.path", "java.home", "java.vendor", "java.version", "os.version"};
                int i = 0;
                while (i < props.length) {
                    String prop = System.getProperty(props[i]);
                    if (prop != null) {
                        daos.writeUTF(prop);
                        daos.writeInt(System.identityHashCode(prop));
                    }
                    ++i;
                }
                daos.writeLong(Runtime.getRuntime().freeMemory());
                daos.close();
                byte[] bytes = baos.toByteArray();
                int i2 = 0;
                while (i2 < bytes.length) {
                    int j;
                    int n = j = i2 % _mask.length;
                    _mask[n] = (byte)(_mask[n] * 21);
                    int n2 = j;
                    _mask[n2] = (byte)(_mask[n2] + i2);
                    ++i2;
                }
            }
            catch (IOException e) {
                XBeanDebug.logException(e);
            }
            _random = new Random(System.currentTimeMillis());
        }
        _random.nextBytes(result);
        int i = 0;
        while (i < result.length) {
            int j = i & _mask.length;
            int n = i++;
            result[n] = (byte)(result[n] ^ _mask[j]);
        }
    }

    public SchemaTypeSystemImpl(String nameForSystem) {
        if (nameForSystem == null) {
            byte[] bytes = new byte[16];
            SchemaTypeSystemImpl.nextBytes(bytes);
            nameForSystem = "s" + new String(HexBin.encode(bytes));
        }
        this._name = "schema.system." + nameForSystem;
        this._basePackage = SchemaTypeSystemImpl.nameToPathString(this._name);
        this._classloader = null;
    }

    public void loadFromBuilder(SchemaGlobalElement[] globalElements, SchemaGlobalAttribute[] globalAttributes, SchemaType[] globalTypes, SchemaType[] documentTypes, SchemaType[] attributeTypes) {
        if (!$assertionsDisabled && this._classloader != null) {
            throw new AssertionError();
        }
        this._localHandles = new HandlePool();
        this._globalElements = SchemaTypeSystemImpl.buildComponentRefMap(globalElements);
        this._globalAttributes = SchemaTypeSystemImpl.buildComponentRefMap(globalAttributes);
        this._globalTypes = SchemaTypeSystemImpl.buildComponentRefMap(globalTypes);
        this._documentTypes = SchemaTypeSystemImpl.buildDocumentMap(documentTypes);
        this._attributeTypes = SchemaTypeSystemImpl.buildDocumentMap(attributeTypes);
        this._typeRefsByClassname = this.buildTypeRefsByClassname();
        this._namespaces = new HashSet();
    }

    public void loadFromStscState(StscState state) {
        if (!$assertionsDisabled && this._classloader != null) {
            throw new AssertionError();
        }
        this._localHandles = new HandlePool();
        this._globalElements = SchemaTypeSystemImpl.buildComponentRefMap(state.globalElements());
        this._globalAttributes = SchemaTypeSystemImpl.buildComponentRefMap(state.globalAttributes());
        this._modelGroups = SchemaTypeSystemImpl.buildComponentRefMap(state.modelGroups());
        this._attributeGroups = SchemaTypeSystemImpl.buildComponentRefMap(state.attributeGroups());
        this._globalTypes = SchemaTypeSystemImpl.buildComponentRefMap(state.globalTypes());
        this._documentTypes = SchemaTypeSystemImpl.buildDocumentMap(state.documentTypes());
        this._attributeTypes = SchemaTypeSystemImpl.buildAttributeTypeMap(state.attributeTypes());
        this._typeRefsByClassname = this.buildTypeRefsByClassname(state.typesByClassname());
        this._identityConstraints = SchemaTypeSystemImpl.buildComponentRefMap(state.idConstraints());
        this._namespaces = new HashSet<String>(Arrays.asList(state.getNamespaces()));
    }

    final SchemaTypeSystemImpl getTypeSystem() {
        return this;
    }

    public void saveToDirectory(File classDir) {
        this._baseSaveDir = classDir;
        this._localHandles.startWriteMode();
        this.saveTypesRecursively(this.globalTypes());
        this.saveTypesRecursively(this.documentTypes());
        this.saveTypesRecursively(this.attributeTypes());
        this.saveGlobalElements(this.globalElements());
        this.saveGlobalAttributes(this.globalAttributes());
        this.saveModelGroups(this.modelGroups());
        this.saveAttributeGroups(this.attributeGroups());
        this.saveIdentityConstraints(this.identityConstraints());
        this.saveIndex();
        this.savePointers();
    }

    void saveTypesRecursively(SchemaType[] types) {
        int i = 0;
        while (i < types.length) {
            if (types[i].getTypeSystem() == this.getTypeSystem()) {
                this.saveType(types[i]);
                this.saveTypesRecursively(types[i].getAnonymousTypes());
            }
            ++i;
        }
    }

    public void saveGlobalElements(SchemaGlobalElement[] elts) {
        int i = 0;
        while (i < elts.length) {
            this.saveGlobalElement(elts[i]);
            ++i;
        }
    }

    public void saveGlobalAttributes(SchemaGlobalAttribute[] attrs) {
        int i = 0;
        while (i < attrs.length) {
            this.saveGlobalAttribute(attrs[i]);
            ++i;
        }
    }

    public void saveModelGroups(SchemaModelGroup[] groups) {
        int i = 0;
        while (i < groups.length) {
            this.saveModelGroup(groups[i]);
            ++i;
        }
    }

    public void saveAttributeGroups(SchemaAttributeGroup[] groups) {
        int i = 0;
        while (i < groups.length) {
            this.saveAttributeGroup(groups[i]);
            ++i;
        }
    }

    public void saveIdentityConstraints(SchemaIdentityConstraint[] idcs) {
        int i = 0;
        while (i < idcs.length) {
            this.saveIdentityConstraint(idcs[i]);
            ++i;
        }
    }

    public void saveGlobalElement(SchemaGlobalElement elt) {
        String handle = this._localHandles.handleForElement(elt);
        XsbReader saver = new XsbReader(handle);
        saver.writeParticleData((SchemaParticle)((Object)elt));
        saver.writeString(elt.getSourceName());
        saver.writeRealHeader(handle, 3);
        saver.writeParticleData((SchemaParticle)((Object)elt));
        saver.writeString(elt.getSourceName());
        saver.writeEnd();
    }

    public void saveGlobalAttribute(SchemaGlobalAttribute attr) {
        String handle = this._localHandles.handleForAttribute(attr);
        XsbReader saver = new XsbReader(handle);
        saver.writeAttributeData(attr);
        saver.writeString(attr.getSourceName());
        saver.writeRealHeader(handle, 4);
        saver.writeAttributeData(attr);
        saver.writeString(attr.getSourceName());
        saver.writeEnd();
    }

    public void saveModelGroup(SchemaModelGroup grp) {
        String handle = this._localHandles.handleForModelGroup(grp);
        XsbReader saver = new XsbReader(handle);
        saver.writeModelGroupData(grp);
        saver.writeRealHeader(handle, 6);
        saver.writeModelGroupData(grp);
        saver.writeEnd();
    }

    public void saveAttributeGroup(SchemaAttributeGroup grp) {
        String handle = this._localHandles.handleForAttributeGroup(grp);
        XsbReader saver = new XsbReader(handle);
        saver.writeAttributeGroupData(grp);
        saver.writeRealHeader(handle, 7);
        saver.writeAttributeGroupData(grp);
        saver.writeEnd();
    }

    public void saveIdentityConstraint(SchemaIdentityConstraint idc) {
        String handle = this._localHandles.handleForIdentityConstraint(idc);
        XsbReader saver = new XsbReader(handle);
        saver.writeIdConstraintData(idc);
        saver.writeRealHeader(handle, 8);
        saver.writeIdConstraintData(idc);
        saver.writeEnd();
    }

    void saveType(SchemaType type) {
        String handle = this._localHandles.handleForType(type);
        XsbReader saver = new XsbReader(handle);
        saver.writeTypeData(type);
        saver.writeRealHeader(handle, 2);
        saver.writeTypeData(type);
        saver.writeEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String crackPointer(InputStream stream) {
        String string;
        DataInputStream input;
        block24: {
            block22: {
                String string2;
                block23: {
                    block20: {
                        String string3;
                        block21: {
                            short minorver;
                            block18: {
                                String string4;
                                block19: {
                                    block16: {
                                        String string5;
                                        block17: {
                                            input = null;
                                            input = new DataInputStream(stream);
                                            int magic = input.readInt();
                                            if (magic == -629491010) break block16;
                                            string5 = null;
                                            Object var13_6 = null;
                                            if (input == null) break block17;
                                            try {
                                                input.close();
                                            }
                                            catch (IOException e2) {
                                                // empty catch block
                                            }
                                        }
                                        return string5;
                                    }
                                    short majorver = input.readShort();
                                    minorver = input.readShort();
                                    if (majorver == 2) break block18;
                                    string4 = null;
                                    Object var13_7 = null;
                                    if (input == null) break block19;
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e2) {
                                        // empty catch block
                                    }
                                }
                                return string4;
                            }
                            if (minorver <= 14) break block20;
                            string3 = null;
                            Object var13_8 = null;
                            if (input == null) break block21;
                            try {
                                input.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        return string3;
                    }
                    short actualfiletype = input.readShort();
                    if (actualfiletype == 5) break block22;
                    string2 = null;
                    Object var13_9 = null;
                    if (input == null) break block23;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return string2;
            }
            StringPool stringPool = new StringPool("pointer", "unk");
            stringPool.readFrom(input);
            string = stringPool.stringForCode(input.readShort());
            Object var13_10 = null;
            if (input == null) break block24;
            try {
                input.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return string;
        catch (IOException e) {
            String string6;
            block25: {
                try {
                    string6 = null;
                    Object var13_11 = null;
                    if (input == null) break block25;
                }
                catch (Throwable throwable) {
                    block26: {
                        Object var13_12 = null;
                        if (input == null) break block26;
                        try {
                            input.close();
                        }
                        catch (IOException e2) {}
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return string6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaType typeForHandle(String handle) {
        Map map = this._resolvedHandles;
        synchronized (map) {
            return (SchemaType)this._resolvedHandles.get(handle);
        }
    }

    public SchemaType typeForClassname(String classname) {
        SchemaType.Ref ref = (SchemaType.Ref)this._typeRefsByClassname.get(classname);
        return ref != null ? ref.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaComponent resolveHandle(String handle) {
        SchemaComponent result;
        Map map = this._resolvedHandles;
        synchronized (map) {
            result = (SchemaComponent)this._resolvedHandles.get(handle);
        }
        if (result == null) {
            XsbReader reader = new XsbReader(handle, -1);
            int filetype = reader.getActualFiletype();
            switch (filetype) {
                case 2: {
                    XBeanDebug.trace(1, "Resolving type for handle " + handle, 0);
                    result = reader.finishLoadingType();
                    break;
                }
                case 3: {
                    XBeanDebug.trace(1, "Resolving element for handle " + handle, 0);
                    result = reader.finishLoadingElement();
                    break;
                }
                case 4: {
                    XBeanDebug.trace(1, "Resolving attribute for handle " + handle, 0);
                    result = reader.finishLoadingAttribute();
                    break;
                }
                case 6: {
                    XBeanDebug.trace(1, "Resolving model group for handle " + handle, 0);
                    result = reader.finishLoadingModelGroup();
                    break;
                }
                case 7: {
                    XBeanDebug.trace(1, "Resolving attribute group for handle " + handle, 0);
                    result = reader.finishLoadingAttributeGroup();
                    break;
                }
                case 8: {
                    XBeanDebug.trace(1, "Resolving id constraint for handle " + handle, 0);
                    result = reader.finishLoadingIdentityConstraint();
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal handle type");
                }
            }
            Map map2 = this._resolvedHandles;
            synchronized (map2) {
                if (!this._resolvedHandles.containsKey(handle)) {
                    this._resolvedHandles.put(handle, result);
                } else {
                    result = (SchemaComponent)this._resolvedHandles.get(handle);
                }
            }
        }
        return result;
    }

    public void resolve() {
        XBeanDebug.trace(1, "Resolve called type system " + this._name, 0);
        if (this._allNonGroupHandlesResolved) {
            return;
        }
        XBeanDebug.trace(1, "Resolving all handles for type system " + this._name, 1);
        ArrayList refs = new ArrayList();
        refs.addAll(this._globalElements.values());
        refs.addAll(this._globalAttributes.values());
        refs.addAll(this._globalTypes.values());
        refs.addAll(this._documentTypes.values());
        refs.addAll(this._attributeTypes.values());
        refs.addAll(this._identityConstraints.values());
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            SchemaComponent.Ref ref = (SchemaComponent.Ref)i.next();
            ref.getComponent();
        }
        XBeanDebug.trace(1, "Finished resolving type system " + this._name, -1);
        this._allNonGroupHandlesResolved = true;
    }

    public boolean isNamespaceDefined(String namespace) {
        return this._namespaces.contains(namespace);
    }

    public SchemaType.Ref findTypeRef(QName name) {
        return (SchemaType.Ref)this._globalTypes.get(name);
    }

    public SchemaType.Ref findDocumentTypeRef(QName name) {
        return (SchemaType.Ref)this._documentTypes.get(name);
    }

    public SchemaType.Ref findAttributeTypeRef(QName name) {
        return (SchemaType.Ref)this._attributeTypes.get(name);
    }

    public SchemaGlobalElement.Ref findElementRef(QName name) {
        return (SchemaGlobalElement.Ref)this._globalElements.get(name);
    }

    public SchemaGlobalAttribute.Ref findAttributeRef(QName name) {
        return (SchemaGlobalAttribute.Ref)this._globalAttributes.get(name);
    }

    public SchemaModelGroup.Ref findModelGroupRef(QName name) {
        return (SchemaModelGroup.Ref)this._modelGroups.get(name);
    }

    public SchemaAttributeGroup.Ref findAttributeGroupRef(QName name) {
        return (SchemaAttributeGroup.Ref)this._attributeGroups.get(name);
    }

    public SchemaIdentityConstraint.Ref findIdentityConstraintRef(QName name) {
        return (SchemaIdentityConstraint.Ref)this._identityConstraints.get(name);
    }

    public SchemaType[] globalTypes() {
        if (this._globalTypes.isEmpty()) {
            return EMPTY_ST_ARRAY;
        }
        SchemaType[] result = new SchemaType[this._globalTypes.size()];
        int j = 0;
        Iterator i = this._globalTypes.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaType.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public InputStream getSourceAsStream(String sourceName) {
        if (!sourceName.startsWith("/")) {
            sourceName = "/" + sourceName;
        }
        return this._resourceLoader.getResourceAsStream("schema/src" + sourceName);
    }

    public SchemaType[] documentTypes() {
        if (this._documentTypes.isEmpty()) {
            return EMPTY_ST_ARRAY;
        }
        SchemaType[] result = new SchemaType[this._documentTypes.size()];
        int j = 0;
        Iterator i = this._documentTypes.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaType.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaType[] attributeTypes() {
        if (this._attributeTypes.isEmpty()) {
            return EMPTY_ST_ARRAY;
        }
        SchemaType[] result = new SchemaType[this._attributeTypes.size()];
        int j = 0;
        Iterator i = this._attributeTypes.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaType.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaGlobalElement[] globalElements() {
        if (this._globalElements.isEmpty()) {
            return EMPTY_GE_ARRAY;
        }
        SchemaGlobalElement[] result = new SchemaGlobalElement[this._globalElements.size()];
        int j = 0;
        Iterator i = this._globalElements.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaGlobalElement.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaGlobalAttribute[] globalAttributes() {
        if (this._globalAttributes.isEmpty()) {
            return EMPTY_GA_ARRAY;
        }
        SchemaGlobalAttribute[] result = new SchemaGlobalAttribute[this._globalAttributes.size()];
        int j = 0;
        Iterator i = this._globalAttributes.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaGlobalAttribute.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaModelGroup[] modelGroups() {
        if (this._modelGroups.isEmpty()) {
            return EMPTY_MG_ARRAY;
        }
        SchemaModelGroup[] result = new SchemaModelGroup[this._modelGroups.size()];
        int j = 0;
        Iterator i = this._modelGroups.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaModelGroup.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaAttributeGroup[] attributeGroups() {
        if (this._attributeGroups.isEmpty()) {
            return EMPTY_AG_ARRAY;
        }
        SchemaAttributeGroup[] result = new SchemaAttributeGroup[this._attributeGroups.size()];
        int j = 0;
        Iterator i = this._attributeGroups.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaAttributeGroup.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public SchemaIdentityConstraint[] identityConstraints() {
        if (this._identityConstraints.isEmpty()) {
            return EMPTY_IC_ARRAY;
        }
        SchemaIdentityConstraint[] result = new SchemaIdentityConstraint[this._identityConstraints.size()];
        int j = 0;
        Iterator i = this._identityConstraints.values().iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaIdentityConstraint.Ref)i.next()).get();
            ++j;
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this._classloader;
    }

    public String handleForType(SchemaType type) {
        return this._localHandles.handleForType(type);
    }

    public String getName() {
        return this._name;
    }

    public SchemaTypeSystem typeSystemForName(String name) {
        if (this._name != null && name.equals(this._name)) {
            return this;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$schema$SchemaTypeSystemImpl == null ? (class$com$bea$xbean$schema$SchemaTypeSystemImpl = SchemaTypeSystemImpl.class$("com.bea.xbean.schema.SchemaTypeSystemImpl")) : class$com$bea$xbean$schema$SchemaTypeSystemImpl).desiredAssertionStatus();
        EMPTY_SCHEMA_ARRAY = new SchemaDocument.Schema[0];
        EMPTY_CONFIG_ARRAY = new ConfigDocument.Config[0];
        _mask = new byte[16];
        EMPTY_ST_ARRAY = new SchemaType[0];
        EMPTY_GE_ARRAY = new SchemaGlobalElement[0];
        EMPTY_GA_ARRAY = new SchemaGlobalAttribute[0];
        EMPTY_MG_ARRAY = new SchemaModelGroup[0];
        EMPTY_AG_ARRAY = new SchemaAttributeGroup[0];
        EMPTY_IC_ARRAY = new SchemaIdentityConstraint[0];
        SINGLE_ZERO_BYTE = new byte[]{0};
    }

    private class XsbReader {
        DataInputStream _input;
        DataOutputStream _output;
        StringPool _stringPool;
        String _handle;
        private int _majorver;
        private int _minorver;
        int _actualfiletype;
        static final /* synthetic */ boolean $assertionsDisabled;

        public XsbReader(String handle, int filetype) {
            String resourcename = SchemaTypeSystemImpl.this._basePackage + handle + ".xsb";
            InputStream rawinput = this.getLoaderStream(resourcename);
            if (rawinput == null) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: Could not locate compiled schema resource " + resourcename, SchemaTypeSystemImpl.this._name, handle, 0);
            }
            this._input = new DataInputStream(rawinput);
            this._handle = handle;
            int magic = this.readInt();
            if (magic != -629491010) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: Wrong magic cookie", SchemaTypeSystemImpl.this._name, handle, 1);
            }
            this._majorver = this.readShort();
            this._minorver = this.readShort();
            if (this._majorver != 2) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: Wrong major version - expecting 2, got " + this._majorver, SchemaTypeSystemImpl.this._name, handle, 2);
            }
            if (this._minorver > 14) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: Incompatible minor version - expecting up to 14, got " + this._minorver, SchemaTypeSystemImpl.this._name, handle, 3);
            }
            if (this._minorver < 14) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: Incompatible minor version - expecting at least 14, got " + this._minorver, SchemaTypeSystemImpl.this._name, handle, 3);
            }
            short actualfiletype = this.readShort();
            if (actualfiletype != filetype && filetype != -1) {
                throw new SchemaTypeLoaderException("XML-BEANS compiled schema: File has the wrong type - expecting type " + filetype + ", got type " + actualfiletype, SchemaTypeSystemImpl.this._name, handle, 4);
            }
            this._stringPool = new StringPool(this._handle, SchemaTypeSystemImpl.this._name);
            this._stringPool.readFrom(this._input);
            this._actualfiletype = actualfiletype;
        }

        protected boolean atLeast(int majorver, int minorver) {
            if (this._majorver > majorver) {
                return true;
            }
            if (this._majorver < majorver) {
                return false;
            }
            return this._minorver >= minorver;
        }

        protected boolean atMost(int majorver, int minorver) {
            if (this._majorver > majorver) {
                return false;
            }
            if (this._majorver < majorver) {
                return true;
            }
            return this._minorver <= minorver;
        }

        int getActualFiletype() {
            return this._actualfiletype;
        }

        XsbReader(String handle) {
            this._handle = handle;
            this._stringPool = new StringPool(this._handle, SchemaTypeSystemImpl.this._name);
        }

        void writeRealHeader(String handle, int filetype) {
            String resourcename = handle.indexOf(47) >= 0 ? handle + ".xsb" : SchemaTypeSystemImpl.this._basePackage + handle + ".xsb";
            OutputStream rawoutput = this.getSaverStream(resourcename);
            if (rawoutput == null) {
                throw new SchemaTypeLoaderException("Could not write compiled schema resource " + resourcename, SchemaTypeSystemImpl.this._name, handle, 12);
            }
            this._output = new DataOutputStream(rawoutput);
            this._handle = handle;
            this.writeInt(-629491010);
            this.writeShort(2);
            this.writeShort(14);
            this.writeShort(filetype);
            this._stringPool.writeTo(this._output);
        }

        void readEnd() {
            try {
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this._input = null;
            this._stringPool = null;
            this._handle = null;
        }

        void writeEnd() {
            try {
                if (this._output != null) {
                    this._output.flush();
                    this._output.close();
                }
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
            this._output = null;
            this._stringPool = null;
            this._handle = null;
        }

        int fileTypeFromComponentType(int componentType) {
            switch (componentType) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 6: {
                    return 6;
                }
                case 4: {
                    return 7;
                }
                case 5: {
                    return 8;
                }
            }
            throw new IllegalStateException("Unexpected component type");
        }

        void writeIndexData() {
            this.writeHandlePool(SchemaTypeSystemImpl.this._localHandles);
            this.writeQNameMap(SchemaTypeSystemImpl.this.globalElements());
            this.writeQNameMap(SchemaTypeSystemImpl.this.globalAttributes());
            this.writeQNameMap(SchemaTypeSystemImpl.this.modelGroups());
            this.writeQNameMap(SchemaTypeSystemImpl.this.attributeGroups());
            this.writeQNameMap(SchemaTypeSystemImpl.this.identityConstraints());
            this.writeQNameMap(SchemaTypeSystemImpl.this.globalTypes());
            this.writeDocumentTypeMap(SchemaTypeSystemImpl.this.documentTypes());
            this.writeAttributeTypeMap(SchemaTypeSystemImpl.this.attributeTypes());
            this.writeClassnameMap(SchemaTypeSystemImpl.this._typeRefsByClassname);
            this.writeNamespaces(SchemaTypeSystemImpl.this._namespaces);
        }

        void writeHandlePool(HandlePool pool) {
            this.writeShort(pool._componentsToHandles.size());
            Iterator i = pool._componentsToHandles.keySet().iterator();
            while (i.hasNext()) {
                SchemaComponent comp = (SchemaComponent)i.next();
                String handle = (String)pool._componentsToHandles.get(comp);
                int code = this.fileTypeFromComponentType(comp.getComponentType());
                this.writeString(handle);
                this.writeShort(code);
            }
        }

        void readHandlePool(HandlePool pool) {
            if (pool._handlesToRefs.size() != 0 || pool._started) {
                throw new IllegalStateException("Nonempty handle set before read");
            }
            int size = this.readShort();
            int i = 0;
            while (i < size) {
                SchemaComponent.Ref result;
                String handle = this.readString();
                short code = this.readShort();
                switch (code) {
                    case 2: {
                        result = new SchemaType.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    case 3: {
                        result = new SchemaGlobalElement.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    case 4: {
                        result = new SchemaGlobalAttribute.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    case 6: {
                        result = new SchemaModelGroup.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    case 7: {
                        result = new SchemaAttributeGroup.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    case 8: {
                        result = new SchemaIdentityConstraint.Ref(SchemaTypeSystemImpl.this.getTypeSystem(), handle);
                        break;
                    }
                    default: {
                        throw new SchemaTypeLoaderException("Schema index has an unrecognized entry of type " + code, SchemaTypeSystemImpl.this._name, handle, 5);
                    }
                }
                pool._handlesToRefs.put(handle, result);
                ++i;
            }
        }

        short readShort() {
            try {
                return this._input.readShort();
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        void writeShort(int s) {
            if (s > Short.MAX_VALUE || s < Short.MIN_VALUE) {
                throw new SchemaTypeLoaderException("Value " + s + " out of range: must fit in a 16-bit short.", SchemaTypeSystemImpl.this._name, this._handle, 10);
            }
            if (this._output != null) {
                try {
                    this._output.writeShort(s);
                }
                catch (IOException e) {
                    throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
                }
            }
        }

        int readInt() {
            try {
                return this._input.readInt();
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        void writeInt(int i) {
            if (this._output != null) {
                try {
                    this._output.writeInt(i);
                }
                catch (IOException e) {
                    throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
                }
            }
        }

        String readString() {
            return this._stringPool.stringForCode(this.readShort());
        }

        void writeString(String str) {
            int code = this._stringPool.codeForString(str);
            this.writeShort(code);
        }

        QName readQName() {
            String namespace = this.readString();
            String localname = this.readString();
            if (localname == null) {
                return null;
            }
            return new QName(namespace, localname);
        }

        void writeQName(QName qname) {
            if (qname == null) {
                this.writeString(null);
                this.writeString(null);
                return;
            }
            this.writeString(qname.getNamespaceURI());
            this.writeString(qname.getLocalPart());
        }

        SOAPArrayType readSOAPArrayType() {
            QName qName = this.readQName();
            String dimensions = this.readString();
            if (qName == null) {
                return null;
            }
            return new SOAPArrayType(qName, dimensions);
        }

        void writeSOAPArrayType(SOAPArrayType arrayType) {
            if (arrayType == null) {
                this.writeQName(null);
                this.writeString(null);
            } else {
                this.writeQName(arrayType.getQName());
                this.writeString(arrayType.soap11DimensionString());
            }
        }

        SchemaComponent.Ref readHandle() {
            String handle = this.readString();
            if (handle == null) {
                return null;
            }
            if (handle.charAt(0) != '_') {
                return SchemaTypeSystemImpl.this._localHandles.refForHandle(handle);
            }
            switch (handle.charAt(2)) {
                case 'I': {
                    return ((SchemaType)BuiltinSchemaTypeSystem.get().resolveHandle(handle)).getRef();
                }
                case 'T': {
                    return SchemaTypeSystemImpl.this._linker.findTypeRef(QNameHelper.forPretty(handle, 4));
                }
                case 'E': {
                    return SchemaTypeSystemImpl.this._linker.findElementRef(QNameHelper.forPretty(handle, 4));
                }
                case 'A': {
                    return SchemaTypeSystemImpl.this._linker.findAttributeRef(QNameHelper.forPretty(handle, 4));
                }
                case 'M': {
                    return SchemaTypeSystemImpl.this._linker.findModelGroupRef(QNameHelper.forPretty(handle, 4));
                }
                case 'N': {
                    return SchemaTypeSystemImpl.this._linker.findAttributeGroupRef(QNameHelper.forPretty(handle, 4));
                }
                case 'D': {
                    return SchemaTypeSystemImpl.this._linker.findIdentityConstraintRef(QNameHelper.forPretty(handle, 4));
                }
            }
            throw new SchemaTypeLoaderException("Cannot resolve handle " + handle, SchemaTypeSystemImpl.this._name, this._handle, 13);
        }

        void writeHandle(SchemaComponent comp) {
            if (comp == null || comp.getTypeSystem() == SchemaTypeSystemImpl.this.getTypeSystem()) {
                this.writeString(SchemaTypeSystemImpl.this._localHandles.handleForComponent(comp));
                return;
            }
            switch (comp.getComponentType()) {
                case 3: {
                    this.writeString("_XA_" + QNameHelper.pretty(comp.getName()));
                    return;
                }
                case 6: {
                    this.writeString("_XM_" + QNameHelper.pretty(comp.getName()));
                    return;
                }
                case 4: {
                    this.writeString("_XN_" + QNameHelper.pretty(comp.getName()));
                    return;
                }
                case 1: {
                    this.writeString("_XE_" + QNameHelper.pretty(comp.getName()));
                    return;
                }
                case 5: {
                    this.writeString("_XD_" + QNameHelper.pretty(comp.getName()));
                    return;
                }
                case 0: {
                    SchemaType type = (SchemaType)comp;
                    if (type.isBuiltinType()) {
                        this.writeString("_BI_" + type.getName().getLocalPart());
                        return;
                    }
                    this.writeString("_XT_" + QNameHelper.pretty(type.getName()));
                    return;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new SchemaTypeLoaderException("Cannot write handle for component " + comp, SchemaTypeSystemImpl.this._name, this._handle, 13);
        }

        SchemaType.Ref readTypeRef() {
            return (SchemaType.Ref)this.readHandle();
        }

        void writeType(SchemaType type) {
            this.writeHandle(type);
        }

        Map readQNameRefMap() {
            HashMap<QName, SchemaComponent.Ref> result = new HashMap<QName, SchemaComponent.Ref>();
            int size = this.readShort();
            int i = 0;
            while (i < size) {
                QName name = this.readQName();
                SchemaComponent.Ref obj = this.readHandle();
                result.put(name, obj);
                ++i;
            }
            return result;
        }

        void writeQNameMap(SchemaComponent[] components) {
            this.writeShort(components.length);
            int i = 0;
            while (i < components.length) {
                this.writeQName(components[i].getName());
                this.writeHandle(components[i]);
                ++i;
            }
        }

        void writeDocumentTypeMap(SchemaType[] doctypes) {
            this.writeShort(doctypes.length);
            int i = 0;
            while (i < doctypes.length) {
                this.writeQName(doctypes[i].getDocumentElementName());
                this.writeHandle(doctypes[i]);
                ++i;
            }
        }

        void writeAttributeTypeMap(SchemaType[] attrtypes) {
            this.writeShort(attrtypes.length);
            int i = 0;
            while (i < attrtypes.length) {
                this.writeQName(attrtypes[i].getAttributeTypeAttributeName());
                this.writeHandle(attrtypes[i]);
                ++i;
            }
        }

        SchemaType.Ref[] readTypeRefArray() {
            int size = this.readShort();
            SchemaType.Ref[] result = new SchemaType.Ref[size];
            int i = 0;
            while (i < size) {
                result[i] = this.readTypeRef();
                ++i;
            }
            return result;
        }

        void writeTypeArray(SchemaType[] array) {
            this.writeShort(array.length);
            int i = 0;
            while (i < array.length) {
                this.writeHandle(array[i]);
                ++i;
            }
        }

        Map readClassnameRefMap() {
            HashMap<String, SchemaComponent.Ref> result = new HashMap<String, SchemaComponent.Ref>();
            int size = this.readShort();
            int i = 0;
            while (i < size) {
                String name = this.readString();
                SchemaComponent.Ref obj = this.readHandle();
                result.put(name, obj);
                ++i;
            }
            return result;
        }

        void writeClassnameMap(Map typesByClass) {
            this.writeShort(typesByClass.size());
            Iterator i = typesByClass.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                this.writeString(className);
                this.writeHandle(((SchemaType.Ref)typesByClass.get(className)).get());
            }
        }

        Set readNamespaces() {
            HashSet<String> result = new HashSet<String>();
            int size = this.readShort();
            int i = 0;
            while (i < size) {
                String ns = this.readString();
                result.add(ns);
                ++i;
            }
            return result;
        }

        void writeNamespaces(Set namespaces) {
            this.writeShort(namespaces.size());
            Iterator i = namespaces.iterator();
            while (i.hasNext()) {
                String ns = (String)i.next();
                this.writeString(ns);
            }
        }

        OutputStream getSaverStream(String name) {
            File targetFile = new File(SchemaTypeSystemImpl.this._baseSaveDir, name);
            try {
                targetFile.getParentFile().mkdirs();
                return new FileOutputStream(targetFile);
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        InputStream getLoaderStream(String resourcename) {
            return SchemaTypeSystemImpl.this._resourceLoader.getResourceAsStream(resourcename);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SchemaGlobalElement finishLoadingElement() {
            String handle = null;
            try {
                SchemaGlobalElementImpl schemaGlobalElementImpl;
                try {
                    SchemaGlobalElementImpl impl = new SchemaGlobalElementImpl(SchemaTypeSystemImpl.this.getTypeSystem());
                    short particleType = this.readShort();
                    if (particleType != 4) {
                        throw new SchemaTypeLoaderException("Wrong particle type ", SchemaTypeSystemImpl.this._name, this._handle, 11);
                    }
                    this.loadParticle(impl, 4, true);
                    impl.setFilename(this.readString());
                    schemaGlobalElementImpl = impl;
                    Object var6_7 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, handle, 14, e);
                }
                this.readEnd();
                return schemaGlobalElementImpl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.readEnd();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SchemaGlobalAttribute finishLoadingAttribute() {
            SchemaGlobalAttributeImpl impl = new SchemaGlobalAttributeImpl(SchemaTypeSystemImpl.this.getTypeSystem());
            try {
                SchemaGlobalAttributeImpl schemaGlobalAttributeImpl;
                try {
                    this.loadAttribute(impl);
                    impl.setFilename(this.readString());
                    schemaGlobalAttributeImpl = impl;
                    Object var5_4 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, this._handle, 14, e);
                }
                this.readEnd();
                return schemaGlobalAttributeImpl;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.readEnd();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        SchemaModelGroup finishLoadingModelGroup() {
            SchemaModelGroupImpl impl = new SchemaModelGroupImpl(SchemaTypeSystemImpl.this.getTypeSystem());
            try {
                SchemaModelGroupImpl schemaModelGroupImpl;
                try {
                    this.loadModelGroup(impl);
                    schemaModelGroupImpl = impl;
                    Object var5_4 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, this._handle, 14, e);
                }
                this.readEnd();
                return schemaModelGroupImpl;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.readEnd();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        SchemaIdentityConstraint finishLoadingIdentityConstraint() {
            try {
                SchemaIdentityConstraintImpl schemaIdentityConstraintImpl;
                try {
                    SchemaIdentityConstraintImpl impl = new SchemaIdentityConstraintImpl(SchemaTypeSystemImpl.this.getTypeSystem());
                    impl.setName(this.readQName());
                    impl.setConstraintCategory(this.readShort());
                    impl.setSelector(this.readString());
                    String[] fields = new String[this.readShort()];
                    int i = 0;
                    while (i < fields.length) {
                        fields[i] = this.readString();
                        ++i;
                    }
                    impl.setFields(fields);
                    if (impl.getConstraintCategory() == 2) {
                        impl.setReferencedKey((SchemaIdentityConstraint.Ref)this.readHandle());
                    }
                    int mapCount = this.readShort();
                    HashMap<String, String> nsMappings = new HashMap<String, String>();
                    int i2 = 0;
                    while (i2 < mapCount) {
                        String prefix = this.readString();
                        String uri = this.readString();
                        nsMappings.put(prefix, uri);
                        ++i2;
                    }
                    impl.setNSMap(nsMappings);
                    schemaIdentityConstraintImpl = impl;
                    Object var10_11 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, this._handle, 14, e);
                }
                this.readEnd();
                return schemaIdentityConstraintImpl;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.readEnd();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        SchemaAttributeGroup finishLoadingAttributeGroup() {
            SchemaAttributeGroupImpl impl = new SchemaAttributeGroupImpl(SchemaTypeSystemImpl.this.getTypeSystem());
            try {
                SchemaAttributeGroupImpl schemaAttributeGroupImpl;
                try {
                    this.loadAttributeGroup(impl);
                    schemaAttributeGroupImpl = impl;
                    Object var5_4 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, this._handle, 14, e);
                }
                this.readEnd();
                return schemaAttributeGroupImpl;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.readEnd();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SchemaType finishLoadingType() {
            try {
                SchemaTypeImpl schemaTypeImpl;
                try {
                    int i;
                    int i2;
                    SchemaTypeImpl impl = new SchemaTypeImpl(SchemaTypeSystemImpl.this.getTypeSystem(), true);
                    impl.setName(this.readQName());
                    impl.setOuterSchemaTypeRef(this.readTypeRef());
                    impl.setBaseDepth(this.readShort());
                    impl.setBaseTypeRef(this.readTypeRef());
                    impl.setDerivationType(this.readShort());
                    switch (this.readShort()) {
                        case 1: {
                            impl.setContainerFieldRef(this.readHandle());
                            break;
                        }
                        case 2: {
                            impl.setContainerFieldIndex((short)1, this.readShort());
                            break;
                        }
                        case 3: {
                            impl.setContainerFieldIndex((short)2, this.readShort());
                            break;
                        }
                    }
                    impl.setFullJavaName(this.readString());
                    impl.setFullJavaImplName(this.readString());
                    impl.setAnonymousTypeRefs(this.readTypeRefArray());
                    impl.setAnonymousUnionMemberOrdinal(this.readShort());
                    int flags = this.readInt();
                    boolean isComplexType = (flags & 1) == 0;
                    impl.setCompiled((flags & 0x800) != 0);
                    impl.setDocumentType((flags & 2) != 0);
                    impl.setAttributeType((flags & 0x80000) != 0);
                    impl.setSimpleType(!isComplexType);
                    int complexVariety = 0;
                    if (isComplexType) {
                        impl.setAbstractFinal((flags & 0x40000) != 0, (flags & 0x4000) != 0, (flags & 0x8000) != 0);
                        impl.setBlock((flags & 0x1000) != 0, (flags & 0x2000) != 0);
                        impl.setOrderSensitive((flags & 0x200) != 0);
                        complexVariety = this.readShort();
                        impl.setComplexTypeVariety(complexVariety);
                        SchemaAttributeModelImpl attrModel = new SchemaAttributeModelImpl();
                        int attrCount = this.readShort();
                        int i3 = 0;
                        while (i3 < attrCount) {
                            attrModel.addAttribute(this.readAttributeData());
                            ++i3;
                        }
                        attrModel.setWildcardSet(this.readQNameSet());
                        attrModel.setWildcardProcess(this.readShort());
                        LinkedHashMap<QName, SchemaProperty> attrProperties = new LinkedHashMap<QName, SchemaProperty>();
                        int attrPropCount = this.readShort();
                        i2 = 0;
                        while (i2 < attrPropCount) {
                            SchemaProperty prop = this.readPropertyData();
                            if (!prop.isAttribute()) {
                                throw new SchemaTypeLoaderException("Attribute property " + i2 + " is not an attribute", SchemaTypeSystemImpl.this._name, this._handle, 6);
                            }
                            attrProperties.put(prop.getName(), prop);
                            ++i2;
                        }
                        SchemaParticle contentModel = null;
                        LinkedHashMap<QName, SchemaProperty> elemProperties = null;
                        short isAll = 0;
                        if (complexVariety == 3 || complexVariety == 4) {
                            isAll = this.readShort();
                            SchemaParticle[] parts = this.readParticleArray();
                            if (parts.length == 1) {
                                contentModel = parts[0];
                            } else {
                                if (parts.length != 0) throw new SchemaTypeLoaderException("Content model not well-formed", SchemaTypeSystemImpl.this._name, this._handle, 7);
                                contentModel = null;
                            }
                            elemProperties = new LinkedHashMap<QName, SchemaProperty>();
                            int elemPropCount = this.readShort();
                            i = 0;
                            while (i < elemPropCount) {
                                SchemaProperty prop = this.readPropertyData();
                                if (prop.isAttribute()) {
                                    throw new SchemaTypeLoaderException("Element property " + i + " is not an element", SchemaTypeSystemImpl.this._name, this._handle, 6);
                                }
                                elemProperties.put(prop.getName(), prop);
                                ++i;
                            }
                        }
                        impl.setContentModel(contentModel, attrModel, elemProperties, attrProperties, isAll == 1);
                        StscComplexTypeResolver.WildcardResult wcElt = StscComplexTypeResolver.summarizeEltWildcards(contentModel);
                        StscComplexTypeResolver.WildcardResult wcAttr = StscComplexTypeResolver.summarizeAttrWildcards(attrModel);
                        impl.setWildcardSummary(wcElt.typedWildcards, wcElt.hasWildcards, wcAttr.typedWildcards, wcAttr.hasWildcards);
                    }
                    if (!isComplexType || complexVariety == 2) {
                        boolean isStringEnum;
                        short simpleVariety = this.readShort();
                        impl.setSimpleTypeVariety(simpleVariety);
                        boolean bl = isStringEnum = (flags & 0x40) != 0;
                        impl.setOrdered((flags & 4) != 0 ? 0 : ((flags & 0x400) != 0 ? 2 : 1));
                        impl.setBounded((flags & 8) != 0);
                        impl.setFinite((flags & 0x10) != 0);
                        impl.setNumeric((flags & 0x20) != 0);
                        impl.setUnionOfLists((flags & 0x80) != 0);
                        impl.setSimpleFinal((flags & 0x8000) != 0, (flags & 0x20000) != 0, (flags & 0x10000) != 0);
                        XmlValueRef[] facets = new XmlValueRef[12];
                        boolean[] fixedFacets = new boolean[12];
                        short facetCount = this.readShort();
                        i2 = 0;
                        while (i2 < facetCount) {
                            short facetCode = this.readShort();
                            facets[facetCode] = this.readXmlValueObject();
                            fixedFacets[facetCode] = this.readShort() == 1;
                            ++i2;
                        }
                        impl.setBasicFacets(facets, fixedFacets);
                        impl.setWhiteSpaceRule(this.readShort());
                        impl.setPatternFacet((flags & 0x100) != 0);
                        int patternCount = this.readShort();
                        RegularExpression[] patterns = new RegularExpression[patternCount];
                        int i4 = 0;
                        while (i4 < patternCount) {
                            patterns[i4] = new RegularExpression(this.readString(), "X");
                            ++i4;
                        }
                        impl.setPatterns(patterns);
                        short enumCount = this.readShort();
                        XmlValueRef[] enumValues = new XmlValueRef[enumCount];
                        i = 0;
                        while (i < enumCount) {
                            enumValues[i] = this.readXmlValueObject();
                            ++i;
                        }
                        impl.setEnumerationValues(enumCount == 0 ? null : enumValues);
                        impl.setBaseEnumTypeRef(this.readTypeRef());
                        if (isStringEnum) {
                            int seCount = this.readShort();
                            SchemaStringEnumEntry[] entries = new SchemaStringEnumEntry[seCount];
                            int i5 = 0;
                            while (i5 < seCount) {
                                entries[i5] = new SchemaStringEnumEntryImpl(this.readString(), this.readShort(), this.readString());
                                ++i5;
                            }
                            impl.setStringEnumEntries(entries);
                        }
                        switch (simpleVariety) {
                            case 1: {
                                impl.setPrimitiveTypeRef(this.readTypeRef());
                                impl.setDecimalSize(this.readInt());
                                break;
                            }
                            case 3: {
                                impl.setPrimitiveTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
                                impl.setListItemTypeRef(this.readTypeRef());
                                break;
                            }
                            case 2: {
                                impl.setPrimitiveTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
                                impl.setUnionMemberTypeRefs(this.readTypeRefArray());
                                break;
                            }
                            default: {
                                throw new SchemaTypeLoaderException("Simple type does not have a recognized variety", SchemaTypeSystemImpl.this._name, this._handle, 8);
                            }
                        }
                    }
                    impl.setFilename(this.readString());
                    schemaTypeImpl = impl;
                    Object var21_29 = null;
                }
                catch (SchemaTypeLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SchemaTypeLoaderException("Cannot load type from typesystem", SchemaTypeSystemImpl.this._name, this._handle, 14, e);
                }
                this.readEnd();
                return schemaTypeImpl;
            }
            catch (Throwable throwable) {
                Object var21_30 = null;
                this.readEnd();
                throw throwable;
            }
        }

        void writeTypeData(SchemaType type) {
            int i;
            int i2;
            int i3;
            this.writeQName(type.getName());
            this.writeType(type.getOuterType());
            this.writeShort(((SchemaTypeImpl)type).getBaseDepth());
            this.writeType(type.getBaseType());
            this.writeShort(type.getDerivationType());
            if (type.getContainerField() == null) {
                this.writeShort(0);
            } else if (type.getOuterType().isAttributeType() || type.getOuterType().isDocumentType()) {
                this.writeShort(1);
                this.writeHandle((SchemaComponent)((Object)type.getContainerField()));
            } else if (type.getContainerField().isAttribute()) {
                this.writeShort(2);
                this.writeShort(((SchemaTypeImpl)type.getOuterType()).getIndexForLocalAttribute((SchemaLocalAttribute)type.getContainerField()));
            } else {
                this.writeShort(3);
                this.writeShort(((SchemaTypeImpl)type.getOuterType()).getIndexForLocalElement((SchemaLocalElement)type.getContainerField()));
            }
            this.writeString(type.getFullJavaName());
            this.writeString(type.getFullJavaImplName());
            this.writeTypeArray(type.getAnonymousTypes());
            this.writeShort(type.getAnonymousUnionMemberOrdinal());
            int flags = 0;
            if (type.isSimpleType()) {
                flags |= 1;
            }
            if (type.isDocumentType()) {
                flags |= 2;
            }
            if (type.isAttributeType()) {
                flags |= 0x80000;
            }
            if (type.ordered() != 0) {
                flags |= 4;
            }
            if (type.ordered() == 2) {
                flags |= 0x400;
            }
            if (type.isBounded()) {
                flags |= 8;
            }
            if (type.isFinite()) {
                flags |= 0x10;
            }
            if (type.isNumeric()) {
                flags |= 0x20;
            }
            if (type.hasStringEnumValues()) {
                flags |= 0x40;
            }
            if (((SchemaTypeImpl)type).isUnionOfLists()) {
                flags |= 0x80;
            }
            if (type.hasPatternFacet()) {
                flags |= 0x100;
            }
            if (type.isOrderSensitive()) {
                flags |= 0x200;
            }
            if (type.blockExtension()) {
                flags |= 0x1000;
            }
            if (type.blockRestriction()) {
                flags |= 0x2000;
            }
            if (type.finalExtension()) {
                flags |= 0x4000;
            }
            if (type.finalRestriction()) {
                flags |= 0x4000;
            }
            if (type.finalList()) {
                flags |= 0x20000;
            }
            if (type.finalUnion()) {
                flags |= 0x10000;
            }
            if (type.isAbstract()) {
                flags |= 0x40000;
            }
            this.writeInt(flags);
            if (!type.isSimpleType()) {
                this.writeShort(type.getContentType());
                SchemaAttributeModel attrModel = type.getAttributeModel();
                SchemaLocalAttribute[] attrs = attrModel.getAttributes();
                this.writeShort(attrs.length);
                i3 = 0;
                while (i3 < attrs.length) {
                    this.writeAttributeData(attrs[i3]);
                    ++i3;
                }
                this.writeQNameSet(attrModel.getWildcardSet());
                this.writeShort(attrModel.getWildcardProcess());
                SchemaProperty[] attrProperties = type.getAttributeProperties();
                this.writeShort(attrProperties.length);
                i2 = 0;
                while (i2 < attrProperties.length) {
                    this.writePropertyData(attrProperties[i2]);
                    ++i2;
                }
                if (type.getContentType() == 3 || type.getContentType() == 4) {
                    this.writeShort(type.hasAllContent() ? 1 : 0);
                    SchemaParticle[] parts = type.getContentModel() != null ? new SchemaParticle[]{type.getContentModel()} : new SchemaParticle[]{};
                    this.writeParticleArray(parts);
                    SchemaProperty[] eltProperties = type.getElementProperties();
                    this.writeShort(eltProperties.length);
                    i = 0;
                    while (i < eltProperties.length) {
                        this.writePropertyData(eltProperties[i]);
                        ++i;
                    }
                }
            }
            if (type.isSimpleType() || type.getContentType() == 2) {
                this.writeShort(type.getSimpleVariety());
                int facetCount = 0;
                int i4 = 0;
                while (i4 <= 11) {
                    if (type.getFacet(i4) != null) {
                        ++facetCount;
                    }
                    ++i4;
                }
                this.writeShort(facetCount);
                i3 = 0;
                while (i3 <= 11) {
                    XmlAnySimpleType facet = type.getFacet(i3);
                    if (facet != null) {
                        this.writeShort(i3);
                        this.writeXmlValueObject(facet);
                        this.writeShort(type.isFacetFixed(i3) ? 1 : 0);
                    }
                    ++i3;
                }
                this.writeShort(type.getWhiteSpaceRule());
                RegularExpression[] patterns = ((SchemaTypeImpl)type).getPatterns();
                this.writeShort(patterns.length);
                i2 = 0;
                while (i2 < patterns.length) {
                    this.writeString(patterns[i2].getPattern());
                    ++i2;
                }
                XmlAnySimpleType[] enumValues = type.getEnumerationValues();
                if (enumValues == null) {
                    this.writeShort(0);
                } else {
                    this.writeShort(enumValues.length);
                    int i5 = 0;
                    while (i5 < enumValues.length) {
                        this.writeXmlValueObject(enumValues[i5]);
                        ++i5;
                    }
                }
                this.writeType(type.getBaseEnumType());
                if (type.hasStringEnumValues()) {
                    SchemaStringEnumEntry[] entries = type.getStringEnumEntries();
                    this.writeShort(entries.length);
                    i = 0;
                    while (i < entries.length) {
                        this.writeString(entries[i].getString());
                        this.writeShort(entries[i].getIntValue());
                        this.writeString(entries[i].getEnumName());
                        ++i;
                    }
                }
                switch (type.getSimpleVariety()) {
                    case 1: {
                        this.writeType(type.getPrimitiveType());
                        this.writeInt(type.getDecimalSize());
                        break;
                    }
                    case 3: {
                        this.writeType(type.getListItemType());
                        break;
                    }
                    case 2: {
                        this.writeTypeArray(type.getUnionMemberTypes());
                    }
                }
            }
            this.writeString(type.getSourceName());
        }

        void readExtensionsList() {
            int count = this.readShort();
            if (!$assertionsDisabled && count != 0) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < count) {
                this.readString();
                this.readString();
                this.readString();
                ++i;
            }
        }

        SchemaLocalAttribute readAttributeData() {
            SchemaLocalAttributeImpl result = new SchemaLocalAttributeImpl();
            this.loadAttribute(result);
            return result;
        }

        void loadModelGroup(SchemaModelGroupImpl result) {
            try {
                result.init(this.readQName(), this.readString(), this.readShort() == 1, GroupDocument.Factory.parse(this.readString()).getGroup());
            }
            catch (XmlException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        void loadAttributeGroup(SchemaAttributeGroupImpl result) {
            try {
                result.init(this.readQName(), this.readString(), this.readShort() == 1, AttributeGroupDocument.Factory.parse(this.readString()).getAttributeGroup());
            }
            catch (XmlException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        void loadAttribute(SchemaLocalAttributeImpl result) {
            result.init(this.readQName(), this.readTypeRef(), this.readShort(), this.readString(), this.readShort() == 1, this.readSOAPArrayType());
        }

        void writeAttributeData(SchemaLocalAttribute attr) {
            this.writeQName(attr.getName());
            this.writeType(attr.getType());
            this.writeShort(attr.getUse());
            this.writeString(attr.getDefaultText());
            this.writeShort(attr.isFixed() ? 1 : 0);
            this.writeSOAPArrayType(((SchemaWSDLArrayType)((Object)attr)).getWSDLArrayType());
        }

        void writeIdConstraintData(SchemaIdentityConstraint idc) {
            this.writeQName(idc.getName());
            this.writeShort(idc.getConstraintCategory());
            this.writeString(idc.getSelector());
            String[] fields = idc.getFields();
            this.writeShort(fields.length);
            int i = 0;
            while (i < fields.length) {
                this.writeString(fields[i]);
                ++i;
            }
            if (idc.getConstraintCategory() == 2) {
                this.writeHandle(idc.getReferencedKey());
            }
            Set mappings = idc.getNSMap().entrySet();
            this.writeShort(mappings.size());
            Iterator it = mappings.iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String prefix = (String)e.getKey();
                String uri = (String)e.getValue();
                this.writeString(prefix);
                this.writeString(uri);
            }
        }

        SchemaParticle[] readParticleArray() {
            SchemaParticle[] result = new SchemaParticle[this.readShort()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.readParticleData();
                ++i;
            }
            return result;
        }

        void writeParticleArray(SchemaParticle[] spa) {
            this.writeShort(spa.length);
            int i = 0;
            while (i < spa.length) {
                this.writeParticleData(spa[i]);
                ++i;
            }
        }

        SchemaParticle readParticleData() {
            short particleType = this.readShort();
            SchemaParticleImpl result = particleType != 4 ? new SchemaParticleImpl() : new SchemaLocalElementImpl();
            this.loadParticle(result, particleType, false);
            return result;
        }

        void loadParticle(SchemaParticleImpl result, int particleType, boolean global) {
            short particleFlags = this.readShort();
            result.setParticleType(particleType);
            result.setMinOccurs(this.readBigInteger());
            result.setMaxOccurs(this.readBigInteger());
            result.setTransitionRules(this.readQNameSet(), (particleFlags & 1) != 0);
            switch (particleType) {
                case 5: {
                    result.setWildcardSet(this.readQNameSet());
                    result.setWildcardProcess(this.readShort());
                    break;
                }
                case 4: {
                    SchemaLocalElementImpl lresult = (SchemaLocalElementImpl)result;
                    lresult.setNameAndTypeRef(this.readQName(), this.readTypeRef());
                    lresult.setDefault(this.readString(), (particleFlags & 4) != 0);
                    lresult.setNillable((particleFlags & 8) != 0);
                    lresult.setBlock((particleFlags & 0x10) != 0, (particleFlags & 0x20) != 0, (particleFlags & 0x40) != 0);
                    lresult.setWsdlArrayType(this.readSOAPArrayType());
                    if (global) {
                        SchemaGlobalElementImpl gresult = (SchemaGlobalElementImpl)lresult;
                        gresult.setAbstractFinal((particleFlags & 0x80) != 0, (particleFlags & 0x100) != 0, (particleFlags & 0x200) != 0);
                        int substGroupCount = this.readShort();
                        int i = 0;
                        while (i < substGroupCount) {
                            gresult.addSubstitutionGroupMember(this.readQName());
                            ++i;
                        }
                    }
                    SchemaIdentityConstraint.Ref[] idcs = new SchemaIdentityConstraint.Ref[this.readShort()];
                    int i = 0;
                    while (i < idcs.length) {
                        idcs[i] = (SchemaIdentityConstraint.Ref)this.readHandle();
                        ++i;
                    }
                    lresult.setIdentityConstraints(idcs);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    result.setParticleChildren(this.readParticleArray());
                    break;
                }
                default: {
                    throw new SchemaTypeLoaderException("Unrecognized particle type ", SchemaTypeSystemImpl.this._name, this._handle, 11);
                }
            }
        }

        void writeParticleData(SchemaParticle part) {
            SchemaGlobalElement gpart;
            SchemaLocalElement lpart;
            this.writeShort(part.getParticleType());
            short flags = 0;
            if (part.isSkippable()) {
                flags = (short)(flags | 1);
            }
            if (part.getParticleType() == 4) {
                lpart = (SchemaLocalElement)((Object)part);
                if (lpart.isFixed()) {
                    flags = (short)(flags | 4);
                }
                if (lpart.isNillable()) {
                    flags = (short)(flags | 8);
                }
                if (lpart.blockExtension()) {
                    flags = (short)(flags | 0x10);
                }
                if (lpart.blockRestriction()) {
                    flags = (short)(flags | 0x20);
                }
                if (lpart.blockSubstitution()) {
                    flags = (short)(flags | 0x40);
                }
                if (lpart instanceof SchemaGlobalElement) {
                    gpart = (SchemaGlobalElement)lpart;
                    if (gpart.isAbstract()) {
                        flags = (short)(flags | 0x80);
                    }
                    if (gpart.finalExtension()) {
                        flags = (short)(flags | 0x100);
                    }
                    if (gpart.finalRestriction()) {
                        flags = (short)(flags | 0x200);
                    }
                }
            }
            this.writeShort(flags);
            this.writeBigInteger(part.getMinOccurs());
            this.writeBigInteger(part.getMaxOccurs());
            this.writeQNameSet(part.acceptedStartNames());
            switch (part.getParticleType()) {
                case 5: {
                    this.writeQNameSet(part.getWildcardSet());
                    this.writeShort(part.getWildcardProcess());
                    break;
                }
                case 4: {
                    lpart = (SchemaLocalElement)((Object)part);
                    this.writeQName(lpart.getName());
                    this.writeType(lpart.getType());
                    this.writeString(lpart.getDefaultText());
                    this.writeSOAPArrayType(((SchemaWSDLArrayType)((Object)lpart)).getWSDLArrayType());
                    if (lpart instanceof SchemaGlobalElement) {
                        gpart = (SchemaGlobalElement)lpart;
                        QName[] substGroupMembers = gpart.substitutionGroupMembers();
                        this.writeShort(substGroupMembers.length);
                        int i = 0;
                        while (i < substGroupMembers.length) {
                            this.writeQName(substGroupMembers[i]);
                            ++i;
                        }
                    }
                    SchemaIdentityConstraint[] idcs = lpart.getIdentityConstraints();
                    this.writeShort(idcs.length);
                    int i = 0;
                    while (i < idcs.length) {
                        this.writeHandle(idcs[i]);
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.writeParticleArray(part.getParticleChildren());
                    break;
                }
                default: {
                    throw new SchemaTypeLoaderException("Unrecognized particle type ", SchemaTypeSystemImpl.this._name, this._handle, 11);
                }
            }
        }

        SchemaProperty readPropertyData() {
            SchemaPropertyImpl prop = new SchemaPropertyImpl();
            prop.setName(this.readQName());
            prop.setTypeRef(this.readTypeRef());
            short propflags = this.readShort();
            prop.setAttribute((propflags & 1) != 0);
            prop.setContainerTypeRef(this.readTypeRef());
            prop.setMinOccurs(this.readBigInteger());
            prop.setMaxOccurs(this.readBigInteger());
            prop.setNillable(this.readShort());
            prop.setDefault(this.readShort());
            prop.setFixed(this.readShort());
            prop.setDefaultText(this.readString());
            prop.setJavaPropertyName(this.readString());
            prop.setJavaTypeCode(this.readShort());
            prop.setExtendsJava(this.readTypeRef(), (propflags & 2) != 0, (propflags & 4) != 0, (propflags & 8) != 0);
            prop.setJavaSetterDelimiter(this.readQNameSet());
            prop.setImmutable();
            return prop;
        }

        void writePropertyData(SchemaProperty prop) {
            this.writeQName(prop.getName());
            this.writeType(prop.getType());
            this.writeShort((prop.isAttribute() ? 1 : 0) | (prop.extendsJavaSingleton() ? 2 : 0) | (prop.extendsJavaOption() ? 4 : 0) | (prop.extendsJavaArray() ? 8 : 0));
            this.writeType(prop.getContainerType());
            this.writeBigInteger(prop.getMinOccurs());
            this.writeBigInteger(prop.getMaxOccurs());
            this.writeShort(prop.hasNillable());
            this.writeShort(prop.hasDefault());
            this.writeShort(prop.hasFixed());
            this.writeString(prop.getDefaultText());
            this.writeString(prop.getJavaPropertyName());
            this.writeShort(prop.getJavaTypeCode());
            this.writeType(prop.javaBasedOnType());
            this.writeQNameSet(prop.getJavaSetterDelimiter());
        }

        void writeModelGroupData(SchemaModelGroup grp) {
            SchemaModelGroupImpl impl = (SchemaModelGroupImpl)grp;
            this.writeQName(impl.getName());
            this.writeString(impl.getTargetNamespace());
            this.writeShort(impl.getChameleonNamespace() != null ? 1 : 0);
            this.writeString(impl.getParseObject().xmlText(new XmlOptions().setSaveOuter()));
        }

        void writeAttributeGroupData(SchemaAttributeGroup grp) {
            SchemaAttributeGroupImpl impl = (SchemaAttributeGroupImpl)grp;
            this.writeQName(impl.getName());
            this.writeString(impl.getTargetNamespace());
            this.writeShort(impl.getChameleonNamespace() != null ? 1 : 0);
            this.writeString(impl.getParseObject().xmlText(new XmlOptions().setSaveOuter()));
        }

        XmlValueRef readXmlValueObject() {
            SchemaType.Ref typeref = this.readTypeRef();
            short btc = this.readShort();
            switch (btc) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    return new XmlValueRef(typeref, null);
                }
                case -1: {
                    int size = this.readShort();
                    ArrayList<XmlValueRef> values = new ArrayList<XmlValueRef>();
                    this.writeShort(values.size());
                    int i = 0;
                    while (i < size) {
                        values.add(this.readXmlValueObject());
                        ++i;
                    }
                    return new XmlValueRef(typeref, values);
                }
                case 2: 
                case 3: 
                case 6: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    return new XmlValueRef(typeref, this.readString());
                }
                case 4: 
                case 5: {
                    return new XmlValueRef(typeref, this.readByteArray());
                }
                case 7: 
                case 8: {
                    return new XmlValueRef(typeref, this.readQName());
                }
                case 9: 
                case 10: 
            }
            return new XmlValueRef(typeref, new Double(this.readDouble()));
        }

        void writeXmlValueObject(XmlAnySimpleType value) {
            SchemaType type = value.schemaType();
            this.writeType(type);
            SchemaType iType = ((SimpleValue)((Object)value)).instanceType();
            if (iType == null) {
                this.writeShort(0);
            } else if (iType.getSimpleVariety() == 3) {
                this.writeShort(-1);
                List values = ((XmlObjectBase)((Object)value)).xlistValue();
                this.writeShort(values.size());
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    this.writeXmlValueObject((XmlAnySimpleType)i.next());
                }
            } else {
                int btc = iType.getPrimitiveType().getBuiltinTypeCode();
                this.writeShort(btc);
                switch (btc) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        this.writeString(value.stringValue());
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.writeByteArray(((SimpleValue)((Object)value)).byteArrayValue());
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.writeQName(((SimpleValue)((Object)value)).qNameValue());
                        break;
                    }
                    case 9: {
                        this.writeDouble(((SimpleValue)((Object)value)).floatValue());
                        break;
                    }
                    case 10: {
                        this.writeDouble(((SimpleValue)((Object)value)).doubleValue());
                    }
                }
            }
        }

        double readDouble() {
            try {
                return this._input.readDouble();
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        void writeDouble(double d) {
            if (this._output != null) {
                try {
                    this._output.writeDouble(d);
                }
                catch (IOException e) {
                    throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
                }
            }
        }

        QNameSet readQNameSet() {
            short flag = this.readShort();
            HashSet<String> uriSet = new HashSet<String>();
            int uriCount = this.readShort();
            int i = 0;
            while (i < uriCount) {
                uriSet.add(this.readString());
                ++i;
            }
            HashSet<QName> qnameSet1 = new HashSet<QName>();
            int qncount1 = this.readShort();
            int i2 = 0;
            while (i2 < qncount1) {
                qnameSet1.add(this.readQName());
                ++i2;
            }
            HashSet<QName> qnameSet2 = new HashSet<QName>();
            int qncount2 = this.readShort();
            int i3 = 0;
            while (i3 < qncount2) {
                qnameSet2.add(this.readQName());
                ++i3;
            }
            if (flag == 1) {
                return QNameSet.forSets(uriSet, null, qnameSet1, qnameSet2);
            }
            return QNameSet.forSets(null, uriSet, qnameSet2, qnameSet1);
        }

        void writeQNameSet(QNameSet set) {
            boolean invert = set.excludedURIs() != null;
            this.writeShort(invert ? 1 : 0);
            Set uriSet = invert ? set.excludedURIs() : set.includedURIs();
            this.writeShort(uriSet.size());
            Iterator i = uriSet.iterator();
            while (i.hasNext()) {
                this.writeString((String)i.next());
            }
            Set qnameSet1 = invert ? set.excludedQNamesInIncludedURIs() : set.includedQNamesInExcludedURIs();
            this.writeShort(qnameSet1.size());
            Iterator i2 = qnameSet1.iterator();
            while (i2.hasNext()) {
                this.writeQName((QName)i2.next());
            }
            Set qnameSet2 = invert ? set.includedQNamesInExcludedURIs() : set.excludedQNamesInIncludedURIs();
            this.writeShort(qnameSet2.size());
            Iterator i3 = qnameSet2.iterator();
            while (i3.hasNext()) {
                this.writeQName((QName)i3.next());
            }
        }

        byte[] readByteArray() {
            try {
                short len = this._input.readShort();
                byte[] result = new byte[len];
                this._input.readFully(result);
                return result;
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        void writeByteArray(byte[] ba) {
            try {
                this.writeShort(ba.length);
                if (this._output != null) {
                    this._output.write(ba);
                }
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), SchemaTypeSystemImpl.this._name, this._handle, 9);
            }
        }

        BigInteger readBigInteger() {
            byte[] result = this.readByteArray();
            if (result.length == 0) {
                return null;
            }
            if (result.length == 1 && result[0] == 0) {
                return BigInteger.ZERO;
            }
            if (result.length == 1 && result[0] == 1) {
                return BigInteger.ONE;
            }
            return new BigInteger(result);
        }

        void writeBigInteger(BigInteger bi) {
            if (bi == null) {
                this.writeShort(0);
            } else if (bi.signum() == 0) {
                this.writeByteArray(SINGLE_ZERO_BYTE);
            } else {
                this.writeByteArray(bi.toByteArray());
            }
        }

        static {
            $assertionsDisabled = !(class$com$bea$xbean$schema$SchemaTypeSystemImpl == null ? (class$com$bea$xbean$schema$SchemaTypeSystemImpl = SchemaTypeSystemImpl.class$("com.bea.xbean.schema.SchemaTypeSystemImpl")) : class$com$bea$xbean$schema$SchemaTypeSystemImpl).desiredAssertionStatus();
        }
    }

    class HandlePool {
        private Map _handlesToRefs = new LinkedHashMap();
        private Map _componentsToHandles = new LinkedHashMap();
        private boolean _started;

        HandlePool() {
        }

        private String addUniqueHandle(SchemaComponent obj, String base) {
            String handle = base = base.toLowerCase();
            int index = 2;
            while (this._handlesToRefs.containsKey(handle)) {
                handle = base + index;
                ++index;
            }
            this._handlesToRefs.put(handle, obj.getComponentRef());
            this._componentsToHandles.put(obj, handle);
            return handle;
        }

        String handleForComponent(SchemaComponent comp) {
            if (comp == null) {
                return null;
            }
            if (comp.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            if (comp instanceof SchemaType) {
                return this.handleForType((SchemaType)comp);
            }
            if (comp instanceof SchemaGlobalElement) {
                return this.handleForElement((SchemaGlobalElement)comp);
            }
            if (comp instanceof SchemaGlobalAttribute) {
                return this.handleForAttribute((SchemaGlobalAttribute)comp);
            }
            if (comp instanceof SchemaModelGroup) {
                return this.handleForModelGroup((SchemaModelGroup)comp);
            }
            if (comp instanceof SchemaAttributeGroup) {
                return this.handleForAttributeGroup((SchemaAttributeGroup)comp);
            }
            if (comp instanceof SchemaIdentityConstraint) {
                return this.handleForIdentityConstraint((SchemaIdentityConstraint)comp);
            }
            throw new IllegalStateException("Component type cannot have a handle");
        }

        String handleForElement(SchemaGlobalElement element) {
            if (element == null) {
                return null;
            }
            if (element.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(element);
            if (handle == null) {
                handle = this.addUniqueHandle(element, NameUtil.upperCamelCase(element.getName().getLocalPart()) + "Element");
            }
            return handle;
        }

        String handleForAttribute(SchemaGlobalAttribute attribute) {
            if (attribute == null) {
                return null;
            }
            if (attribute.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(attribute);
            if (handle == null) {
                handle = this.addUniqueHandle(attribute, NameUtil.upperCamelCase(attribute.getName().getLocalPart()) + "Attribute");
            }
            return handle;
        }

        String handleForModelGroup(SchemaModelGroup group) {
            if (group == null) {
                return null;
            }
            if (group.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(group);
            if (handle == null) {
                handle = this.addUniqueHandle(group, NameUtil.upperCamelCase(group.getName().getLocalPart()) + "ModelGroup");
            }
            return handle;
        }

        String handleForAttributeGroup(SchemaAttributeGroup group) {
            if (group == null) {
                return null;
            }
            if (group.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(group);
            if (handle == null) {
                handle = this.addUniqueHandle(group, NameUtil.upperCamelCase(group.getName().getLocalPart()) + "AttributeGroup");
            }
            return handle;
        }

        String handleForIdentityConstraint(SchemaIdentityConstraint idc) {
            if (idc == null) {
                return null;
            }
            if (idc.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(idc);
            if (handle == null) {
                handle = this.addUniqueHandle(idc, NameUtil.upperCamelCase(idc.getName().getLocalPart()) + "IdentityConstraint");
            }
            return handle;
        }

        String handleForType(SchemaType type) {
            if (type == null) {
                return null;
            }
            if (type.getTypeSystem() != SchemaTypeSystemImpl.this.getTypeSystem()) {
                throw new IllegalArgumentException("Cannot supply handles for types from another type system");
            }
            String handle = (String)this._componentsToHandles.get(type);
            if (handle == null) {
                QName name = type.getName();
                String suffix = "";
                if (name == null) {
                    if (type.isDocumentType()) {
                        name = type.getDocumentElementName();
                        suffix = "Doc";
                    } else if (type.isAttributeType()) {
                        name = type.getAttributeTypeAttributeName();
                        suffix = "AttrType";
                    } else if (type.getContainerField() != null) {
                        name = type.getContainerField().getName();
                        suffix = type.getContainerField().isAttribute() ? "Attr" : "Elem";
                    }
                }
                String uniq = Integer.toHexString(type.toString().hashCode() | Integer.MIN_VALUE).substring(4).toUpperCase();
                String baseName = name == null ? "Anon" + uniq + "Type" : NameUtil.upperCamelCase(name.getLocalPart()) + uniq + suffix + "Type";
                handle = this.addUniqueHandle(type, baseName);
            }
            return handle;
        }

        SchemaComponent.Ref refForHandle(String handle) {
            if (handle == null) {
                return null;
            }
            return (SchemaComponent.Ref)this._handlesToRefs.get(handle);
        }

        Set getAllHandles() {
            return this._handlesToRefs.keySet();
        }

        void startWriteMode() {
            this._started = true;
            this._componentsToHandles = new LinkedHashMap();
            Iterator i = this._handlesToRefs.keySet().iterator();
            while (i.hasNext()) {
                String handle = (String)i.next();
                SchemaComponent comp = ((SchemaComponent.Ref)this._handlesToRefs.get(handle)).getComponent();
                this._componentsToHandles.put(comp, handle);
            }
        }
    }

    static class StringPool {
        private List intsToStrings = new ArrayList();
        private Map stringsToInts = new HashMap();
        private String _handle;
        private String _name;

        StringPool(String handle, String name) {
            this._handle = handle;
            this._name = name;
            this.intsToStrings.add(null);
        }

        int codeForString(String str) {
            if (str == null) {
                return 0;
            }
            Integer result = (Integer)this.stringsToInts.get(str);
            if (result == null) {
                result = new Integer(this.intsToStrings.size());
                this.intsToStrings.add(str);
                this.stringsToInts.put(str, result);
            }
            return result;
        }

        String stringForCode(int code) {
            if (code == 0) {
                return null;
            }
            return (String)this.intsToStrings.get(code);
        }

        void writeTo(DataOutputStream output) {
            if (this.intsToStrings.size() > Short.MAX_VALUE) {
                throw new SchemaTypeLoaderException("Too many strings (" + this.intsToStrings.size() + ")", this._name, this._handle, 10);
            }
            try {
                output.writeShort(this.intsToStrings.size());
                Iterator i = this.intsToStrings.iterator();
                i.next();
                while (i.hasNext()) {
                    String str = (String)i.next();
                    output.writeUTF(str);
                }
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage(), this._name, this._handle, 9);
            }
        }

        void readFrom(DataInputStream input) {
            if (this.intsToStrings.size() != 1 || this.stringsToInts.size() != 0) {
                throw new IllegalStateException();
            }
            try {
                int size = input.readShort();
                int i = 1;
                while (i < size) {
                    String str = input.readUTF().intern();
                    int code = this.codeForString(str);
                    if (code != i) {
                        throw new IllegalStateException();
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new SchemaTypeLoaderException(e.getMessage() == null ? e.getMessage() : "IO Exception", this._name, this._handle, 9, e);
            }
        }
    }
}

