/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.schema;

import com.bea.xbean.common.NameUtil;
import com.bea.xbean.schema.SchemaTypeSystemImpl;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaStringEnumEntry;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeSystem;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public final class SchemaTypeCodePrinter {
    Writer _writer;
    int _indent;
    static final String LINE_SEPARATOR;
    static final int MAX_INDENT = 40;
    static final String MAX_SPACES = "                                        ";
    static final int INDENT_INCREMENT = 4;
    public static final String INDEX_CLASSNAME = "TypeSystemHolder";
    private static final int NOTHING = 1;
    private static final int ADD_NEW_VALUE = 3;
    private static final int THROW_EXCEPTION = 4;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$schema$SchemaTypeCodePrinter;

    public SchemaTypeCodePrinter(Writer writer) {
        this._writer = writer;
        this._indent = 0;
    }

    void indent() {
        this._indent += 4;
    }

    void outdent() {
        this._indent -= 4;
    }

    String encodeString(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch == '\\') {
                sb.append('\\');
                sb.append('\\');
            } else if (ch == '\r') {
                sb.append('\\');
                sb.append('r');
            } else if (ch == '\n') {
                sb.append('\\');
                sb.append('n');
            } else if (ch == '\t') {
                sb.append('\\');
                sb.append('t');
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    void emit(String s) throws IOException {
        int indent = this._indent;
        if (indent > 20) {
            indent = 10 + indent / 2;
        }
        if (indent > 40) {
            indent = 40;
        }
        this._writer.write(MAX_SPACES.substring(0, indent));
        this._writer.write(s);
        this._writer.write(LINE_SEPARATOR);
    }

    public static void printTypeImpl(Writer writer, SchemaType sType) throws IOException {
        SchemaTypeCodePrinter printer = new SchemaTypeCodePrinter(writer);
        SchemaTypeSystem system = sType.getTypeSystem();
        printer.printTypeImpl(sType, system);
    }

    public static void printType(Writer writer, SchemaType sType) throws IOException {
        SchemaTypeCodePrinter printer = new SchemaTypeCodePrinter(writer);
        SchemaTypeSystem system = sType.getTypeSystem();
        printer.printType(sType, system);
    }

    public static void printLoader(Writer writer, SchemaTypeSystem system) throws IOException {
        SchemaTypeCodePrinter printer = new SchemaTypeCodePrinter(writer);
        printer.printIndexType(system);
    }

    void printType(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.printTopComment(sType);
        this.printPackage(sType, true);
        this.emit("");
        this.printInnerType(sType, system);
        this._writer.flush();
    }

    void printTypeImpl(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.printTopComment(sType);
        this.printPackage(sType, false);
        this.printInnerTypeImpl(sType, system, false);
    }

    static String findJavaType(SchemaType sType) {
        while (sType.getFullJavaName() == null) {
            sType = sType.getBaseType();
        }
        return SchemaTypeCodePrinter.convertPackage(sType.getFullJavaName());
    }

    static String convertPackage(String result) {
        if (result.startsWith("xml.util")) {
            return "com.bea.xml" + result.substring("xml.util".length());
        }
        return result;
    }

    static String prettyQName(QName qname) {
        String result = qname.getLocalPart();
        if (qname.getNamespaceURI() != null) {
            result = result + "(@" + qname.getNamespaceURI() + ")";
        }
        return result;
    }

    void printInnerTypeJavaDoc(SchemaType sType) throws IOException {
        QName name = sType.getName();
        if (name == null) {
            if (sType.isDocumentType()) {
                name = sType.getDocumentElementName();
            } else if (sType.isAttributeType()) {
                name = sType.getAttributeTypeAttributeName();
            } else if (sType.getContainerField() != null) {
                name = sType.getContainerField().getName();
            }
        }
        this.emit("/**");
        if (sType.isDocumentType()) {
            this.emit(" * A document containing one " + SchemaTypeCodePrinter.prettyQName(name) + " element");
        } else if (sType.isAttributeType()) {
            this.emit(" * A document containing one " + SchemaTypeCodePrinter.prettyQName(name) + " attribute");
        } else if (name != null) {
            this.emit(" * An XML " + SchemaTypeCodePrinter.prettyQName(name));
        } else {
            this.emit(" * An anonymous inner XML type");
        }
        this.emit(" *");
        switch (sType.getSimpleVariety()) {
            case 0: {
                this.emit(" * This is a complex type.");
                break;
            }
            case 1: {
                this.emit(" * This is an atomic type that is a restriction of " + SchemaTypeCodePrinter.convertPackage(sType.getBaseType().getFullJavaName()) + ".");
                break;
            }
            case 3: {
                this.emit(" * This is a list type whose items are " + SchemaTypeCodePrinter.convertPackage(sType.getListItemType().getFullJavaName()) + ".");
                break;
            }
            case 2: {
                this.emit(" * This is a union type. Instances are of one of the following types:");
                SchemaType[] members = sType.getUnionConstituentTypes();
                int i = 0;
                while (i < members.length) {
                    this.emit(" *     " + SchemaTypeCodePrinter.convertPackage(members[i].getFullJavaName()));
                    ++i;
                }
                break;
            }
        }
        this.emit(" */");
    }

    public static String indexClassForSystem(SchemaTypeSystem system) {
        String name = system.getName();
        return name + "." + INDEX_CLASSNAME;
    }

    static String shortIndexClassForSystem(SchemaTypeSystem system) {
        return INDEX_CLASSNAME;
    }

    void printStaticTypeDeclaration(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.emit("public static final com.bea.xml.SchemaType type = (com.bea.xml.SchemaType)" + SchemaTypeCodePrinter.indexClassForSystem(system) + ".typeSystem.resolveHandle(\"" + ((SchemaTypeSystemImpl)system).handleForType(sType) + "\");");
    }

    void printIndexType(SchemaTypeSystem system) throws IOException {
        String shortName = SchemaTypeCodePrinter.shortIndexClassForSystem(system);
        this.emit("package " + system.getName() + ";");
        this.emit("");
        this.emit("public final class " + shortName);
        this.emit("{");
        this.indent();
        this.emit("private " + shortName + "() { }");
        this.emit("public static final com.bea.xml.SchemaTypeSystem typeSystem = loadTypeSystem();");
        this.emit("static { typeSystem.resolve(); }");
        this.emit("private static final com.bea.xml.SchemaTypeSystem loadTypeSystem()");
        this.emit("{");
        this.indent();
        this.emit("try { return (com.bea.xml.SchemaTypeSystem)Class.forName(\"com.bea.xbean.schema.SchemaTypeSystemImpl\", true, " + shortName + ".class.getClassLoader()).getConstructor(new Class[] { Class.class }).newInstance(new Object[] { " + shortName + ".class }); }");
        this.emit("catch (ClassNotFoundException e) { throw new RuntimeException(\"Cannot load com.bea.xbean.SchemaTypeSystemImpl: make sure xbean.jar is on the classpath.\", e); }");
        this.emit("catch (Exception e) { throw new RuntimeException(\"Could not instantiate SchemaTypeSystemImpl (\" + e.toString() + \"): is the version of xbean.jar correct?\", e); }");
        this.outdent();
        this.emit("}");
        this.outdent();
        this.emit("}");
    }

    void printInnerType(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.emit("");
        this.printInnerTypeJavaDoc(sType);
        this.startInterface(sType);
        this.printStaticTypeDeclaration(sType, system);
        if (sType.isSimpleType()) {
            if (sType.hasStringEnumValues()) {
                this.printStringEnumeration(sType);
            }
        } else {
            SchemaProperty[] props = sType.getDerivedProperties();
            int i = 0;
            while (i < props.length) {
                SchemaProperty prop = props[i];
                this.printPropertyGetters(prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), SchemaTypeCodePrinter.javaTypeForProperty(prop), SchemaTypeCodePrinter.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton());
                if (!prop.isReadOnly()) {
                    this.printPropertySetters(prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), SchemaTypeCodePrinter.javaTypeForProperty(prop), SchemaTypeCodePrinter.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton());
                }
                ++i;
            }
        }
        this.printNestedInnerTypes(sType, system);
        this.printFactory(sType);
        this.endBlock();
    }

    void printFactory(SchemaType sType) throws IOException {
        boolean fullFactory = true;
        if (sType.isAnonymousType() && !sType.isDocumentType() && !sType.isAttributeType()) {
            fullFactory = false;
        }
        String fullName = sType.getFullJavaName().replace('$', '.');
        this.emit("");
        this.emit("/**");
        this.emit(" * A factory class with static methods for creating instances");
        this.emit(" * of this type.");
        this.emit(" */");
        this.emit("");
        this.emit("public static final class Factory");
        this.emit("{");
        this.indent();
        if (sType.isSimpleType()) {
            this.emit("public static " + fullName + " newValue(java.lang.Object obj) {");
            this.emit("  return (" + fullName + ") type.newValue( obj ); }");
            this.emit("");
        }
        this.emit("public static " + fullName + " newInstance() {");
        this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().newInstance( type, null ); }");
        this.emit("");
        this.emit("public static " + fullName + " newInstance(com.bea.xml.XmlOptions options) {");
        this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().newInstance( type, options ); }");
        this.emit("");
        if (fullFactory) {
            this.emit("public static " + fullName + " parse(java.lang.String s) throws com.bea.xml.XmlException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( s, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.lang.String s, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( s, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.File f) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( f, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.File f, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( f, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.net.URL u) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( u, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.net.URL u, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( u, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.InputStream is) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( is, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.InputStream is, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( is, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.Reader r) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( r, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.Reader r, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( r, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.w3c.dom.Node node) throws com.bea.xml.XmlException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( node, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.w3c.dom.Node node, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( node, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(weblogic.xml.stream.XMLInputStream xis) throws com.bea.xml.XmlException, weblogic.xml.stream.XMLStreamException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( xis, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(weblogic.xml.stream.XMLInputStream xis, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, weblogic.xml.stream.XMLStreamException {");
            this.emit("  return (" + fullName + ") com.bea.xml.XmlBeans.getContextTypeLoader().parse( xis, type, options ); }");
            this.emit("");
            this.emit("public static weblogic.xml.stream.XMLInputStream newValidatingXMLInputStream(weblogic.xml.stream.XMLInputStream xis) throws com.bea.xml.XmlException, weblogic.xml.stream.XMLStreamException {");
            this.emit("  return com.bea.xml.XmlBeans.getContextTypeLoader().newValidatingXMLInputStream( xis, type, null ); }");
            this.emit("");
            this.emit("public static weblogic.xml.stream.XMLInputStream newValidatingXMLInputStream(weblogic.xml.stream.XMLInputStream xis, com.bea.xml.XmlOptions options) throws com.bea.xml.XmlException, weblogic.xml.stream.XMLStreamException {");
            this.emit("  return com.bea.xml.XmlBeans.getContextTypeLoader().newValidatingXMLInputStream( xis, type, options ); }");
            this.emit("");
        }
        this.emit("private Factory() { } // No instance of this class allowed");
        this.outdent();
        this.emit("}");
    }

    void printNestedInnerTypes(SchemaType sType, SchemaTypeSystem system) throws IOException {
        SchemaType[] anonTypes = sType.getAnonymousTypes();
        int i = 0;
        while (i < anonTypes.length) {
            if (anonTypes[i].isSkippedAnonymousType()) {
                this.printNestedInnerTypes(anonTypes[i], system);
            } else {
                this.printInnerType(anonTypes[i], system);
            }
            ++i;
        }
    }

    void printTopComment(SchemaType sType) throws IOException {
        this.emit("/*");
        if (sType.getName() != null) {
            this.emit(" * XML Type:  " + sType.getName().getLocalPart());
            this.emit(" * Namespace: " + sType.getName().getNamespaceURI());
        } else {
            QName thename = null;
            if (sType.isDocumentType()) {
                thename = sType.getDocumentElementName();
                this.emit(" * An XML document type.");
            } else if (sType.isAttributeType()) {
                thename = sType.getAttributeTypeAttributeName();
                this.emit(" * An XML attribute type.");
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && thename == null) {
                throw new AssertionError();
            }
            this.emit(" * Localname: " + thename.getLocalPart());
            this.emit(" * Namespace: " + thename.getNamespaceURI());
        }
        this.emit(" * Java type: " + SchemaTypeCodePrinter.convertPackage(sType.getFullJavaName()));
        this.emit(" *");
        this.emit(" * Automatically generated - do not modify.");
        this.emit(" */");
    }

    void printPackage(SchemaType sType, boolean intf) throws IOException {
        String fqjn = intf ? SchemaTypeCodePrinter.convertPackage(sType.getFullJavaName()) : SchemaTypeCodePrinter.convertPackage(sType.getFullJavaImplName());
        int lastdot = fqjn.lastIndexOf(46);
        if (lastdot < 0) {
            return;
        }
        String pkg = fqjn.substring(0, lastdot);
        this.emit("package " + pkg + ";");
    }

    void startInterface(SchemaType sType) throws IOException {
        String shortName = sType.getShortJavaName();
        String baseInterface = SchemaTypeCodePrinter.findJavaType(sType.getBaseType());
        this.emit("public interface " + shortName + " extends " + baseInterface);
        this.emit("{");
        this.indent();
        this.emitSpecializedAccessors(sType);
    }

    private void emitSpecializedAccessors(SchemaType sType) throws IOException {
        int parentBits;
        int bits;
        if (sType.getSimpleVariety() == 1 && sType.getPrimitiveType().getBuiltinTypeCode() == 11 && ((bits = sType.getDecimalSize()) != (parentBits = sType.getBaseType().getDecimalSize()) || sType.getBaseType().getFullJavaName() == null)) {
            if (bits == 1000000) {
                this.emit("java.math.BigInteger bigIntegerValue();");
                this.emit("void set(java.math.BigInteger bi);");
            } else if (bits == 64) {
                this.emit("long longValue();");
                this.emit("void set(long l);");
            } else if (bits == 32) {
                this.emit("int intValue();");
                this.emit("void set(int i);");
            } else if (bits == 16) {
                this.emit("short shortValue();");
                this.emit("void set(short s);");
            } else if (bits == 8) {
                this.emit("byte byteValue();");
                this.emit("void set(byte b);");
            }
        }
        if (sType.getSimpleVariety() == 2) {
            this.emit("java.lang.Object objectValue();");
            this.emit("void objectSet(java.lang.Object val);");
            this.emit("com.bea.xml.SchemaType instanceType();");
            SchemaType ctype = sType.getUnionCommonBaseType();
            if (ctype == null || ctype.getSimpleVariety() != 2) {
                // empty if block
            }
            this.emitSpecializedAccessors(ctype);
        }
        if (sType.getSimpleVariety() == 3) {
            this.emit("java.util.List listValue();");
            this.emit("java.util.List xlistValue();");
            this.emit("void set(java.util.List list);");
        }
    }

    void startBlock() throws IOException {
        this.emit("{");
        this.indent();
    }

    void endBlock() throws IOException {
        this.outdent();
        this.emit("}");
    }

    void printJavaDoc(String sentence) throws IOException {
        this.emit("");
        this.emit("/**");
        this.emit(" * " + sentence);
        this.emit(" */");
    }

    void printShortJavaDoc(String sentence) throws IOException {
        this.emit("/** " + sentence + " */");
    }

    static SchemaType findBaseEnumType(SchemaType sType) {
        while (sType.getBaseType().hasStringEnumValues()) {
            sType = sType.getBaseType();
        }
        return sType;
    }

    public static String javaStringEscape(String str) {
        block11: {
            int i = 0;
            while (i < str.length()) {
                switch (str.charAt(i)) {
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\\': {
                        break block11;
                    }
                    default: {
                        ++i;
                    }
                }
            }
            return str;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                default: {
                    sb.append(ch);
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    void printStringEnumeration(SchemaType sType) throws IOException {
        String constName;
        SchemaType baseEnumType = SchemaTypeCodePrinter.findBaseEnumType(sType);
        String baseEnumClass = baseEnumType.getFullJavaName();
        if (baseEnumType == sType) {
            this.emit("");
            this.emit("com.bea.xml.StringEnumAbstractBase enumValue();");
            this.emit("void set(com.bea.xml.StringEnumAbstractBase e);");
        }
        this.emit("");
        SchemaStringEnumEntry[] entries = sType.getStringEnumEntries();
        int i = 0;
        while (i < entries.length) {
            String enumValue = entries[i].getString();
            constName = entries[i].getEnumName();
            if (baseEnumType != sType) {
                this.emit("static final " + baseEnumClass + ".Enum " + constName + " = " + baseEnumClass + "." + constName + ";");
            } else {
                this.emit("static final Enum " + constName + " = Enum.forString(\"" + SchemaTypeCodePrinter.javaStringEscape(enumValue) + "\");");
            }
            ++i;
        }
        this.emit("");
        int i2 = 0;
        while (i2 < entries.length) {
            constName = "INT_" + entries[i2].getEnumName();
            if (baseEnumType != sType) {
                this.emit("static final int " + constName + " = " + baseEnumClass + "." + constName + ";");
            } else {
                this.emit("static final int " + constName + " = Enum." + constName + ";");
            }
            ++i2;
        }
        if (baseEnumType == sType) {
            this.emit("");
            this.emit("/**");
            this.emit(" * Enumeration value class for " + baseEnumClass + ".");
            this.emit(" * These enum values can be used as follows:");
            this.emit(" * <pre>");
            this.emit(" * enum.toString(); // returns the string value of the enum");
            this.emit(" * enum.intValue(); // returns an int value, useful for switches");
            if (entries.length > 0) {
                this.emit(" * // e.g., case Enum.INT_" + entries[0].getEnumName());
            }
            this.emit(" * Enum.forString(s); // returns the enum value for a string");
            this.emit(" * Enum.forInt(i); // returns the enum value for an int");
            this.emit(" * </pre>");
            this.emit(" * Enumeration objects are immutable singleton objects that");
            this.emit(" * can be compared using == object equality. They have no");
            this.emit(" * public constructor. See the constants defined within this");
            this.emit(" * class for all the valid values.");
            this.emit(" */");
            this.emit("static final class Enum extends com.bea.xml.StringEnumAbstractBase");
            this.emit("{");
            this.indent();
            this.emit("/**");
            this.emit(" * Returns the enum value for a string, or null if none.");
            this.emit(" */");
            this.emit("public static Enum forString(java.lang.String s)");
            this.emit("    { return (Enum)table.forString(s); }");
            this.emit("/**");
            this.emit(" * Returns the enum value corresponding to an int, or null if none.");
            this.emit(" */");
            this.emit("public static Enum forInt(int i)");
            this.emit("    { return (Enum)table.forInt(i); }");
            this.emit("");
            this.emit("private Enum(java.lang.String s, int i)");
            this.emit("    { super(s, i); }");
            this.emit("");
            int i3 = 0;
            while (i3 < entries.length) {
                String constName2 = "INT_" + entries[i3].getEnumName();
                int intValue = entries[i3].getIntValue();
                this.emit("static final int " + constName2 + " = " + intValue + ";");
                ++i3;
            }
            this.emit("");
            this.emit("public static final com.bea.xml.StringEnumAbstractBase.Table table =");
            this.emit("    new com.bea.xml.StringEnumAbstractBase.Table");
            this.emit("(");
            this.indent();
            this.emit("new Enum[]");
            this.emit("{");
            this.indent();
            int i4 = 0;
            while (i4 < entries.length) {
                String enumValue = entries[i4].getString();
                String constName3 = "INT_" + entries[i4].getEnumName();
                this.emit("new Enum(\"" + SchemaTypeCodePrinter.javaStringEscape(enumValue) + "\", " + constName3 + "),");
                ++i4;
            }
            this.outdent();
            this.emit("}");
            this.outdent();
            this.emit(");");
            this.emit("private static final long serialVersionUID = 1L;");
            this.emit("private Object readResolve() { return forInt(intValue()); } ");
            this.outdent();
            this.emit("}");
        }
    }

    static String xmlTypeForProperty(SchemaProperty sProp) {
        SchemaType sType = sProp.javaBasedOnType();
        return SchemaTypeCodePrinter.findJavaType(sType).replace('$', '.');
    }

    static boolean xmlTypeForPropertyIsUnion(SchemaProperty sProp) {
        SchemaType sType = sProp.javaBasedOnType();
        return sType.isSimpleType() && sType.getSimpleVariety() == 2;
    }

    static String javaTypeForProperty(SchemaProperty sProp) {
        if (sProp.getJavaTypeCode() == 0) {
            SchemaType sType = sProp.javaBasedOnType();
            return SchemaTypeCodePrinter.findJavaType(sType).replace('$', '.');
        }
        switch (sProp.getJavaTypeCode()) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "byte";
            }
            case 5: {
                return "short";
            }
            case 6: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "java.math.BigDecimal";
            }
            case 9: {
                return "java.math.BigInteger";
            }
            case 10: {
                return "java.lang.String";
            }
            case 11: {
                return "byte[]";
            }
            case 12: {
                return "com.bea.xml.GDate";
            }
            case 13: {
                return "com.bea.xml.GDuration";
            }
            case 14: {
                return "java.util.Date";
            }
            case 15: {
                return "javax.xml.namespace.QName";
            }
            case 16: {
                return "java.util.List";
            }
            case 17: {
                return "java.util.Calendar";
            }
            case 18: {
                SchemaType sType = sProp.javaBasedOnType().getBaseEnumType();
                return SchemaTypeCodePrinter.findJavaType(sType).replace('$', '.') + ".Enum";
            }
            case 19: {
                return "java.lang.Object";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new IllegalStateException();
    }

    void printPropertyGetters(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton) throws IOException {
        boolean xmltype;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        boolean bl = xmltype = javaType == 0;
        if (singleton) {
            this.printJavaDoc((several ? "Gets first " : "Gets the ") + propdesc);
            this.emit(type + " get" + propertyName + "();");
            if (!xmltype) {
                this.printJavaDoc((several ? "Gets (as xml) first " : "Gets (as xml) the ") + propdesc);
                this.emit(xtype + " xget" + propertyName + "();");
            }
            if (nillable) {
                this.printJavaDoc((several ? "Tests for nil first " : "Tests for nil ") + propdesc);
                this.emit("boolean isNil" + propertyName + "();");
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "True if has at least one " : "True if has ") + propdesc);
            this.emit("boolean isSet" + propertyName + "();");
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Gets array of all " + propdesc + "s");
            this.emit(type + "[] get" + arrayName + "();");
            this.printJavaDoc("Gets ith " + propdesc);
            this.emit(type + " get" + arrayName + "(int i);");
            if (!xmltype) {
                this.printJavaDoc("Gets (as xml) array of all " + propdesc + "s");
                this.emit(xtype + "[] xget" + arrayName + "();");
                this.printJavaDoc("Gets (as xml) ith " + propdesc);
                this.emit(xtype + " xget" + arrayName + "(int i);");
            }
            if (nillable) {
                this.printJavaDoc("Tests for nil ith " + propdesc);
                this.emit("boolean isNil" + arrayName + "(int i);");
            }
            this.printJavaDoc("Returns number of " + propdesc);
            this.emit("int sizeOf" + arrayName + "();");
        }
    }

    void printPropertySetters(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton) throws IOException {
        String safeVarName = NameUtil.nonJavaKeyword(NameUtil.lowerCamelCase(propertyName));
        if (safeVarName.equals("i")) {
            safeVarName = "iValue";
        }
        boolean xmltype = javaType == 0;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        if (singleton) {
            this.printJavaDoc((several ? "Sets first " : "Sets the ") + propdesc);
            this.emit("void set" + propertyName + "(" + type + " " + safeVarName + ");");
            if (!xmltype) {
                this.printJavaDoc((several ? "Sets (as xml) first " : "Sets (as xml) the ") + propdesc);
                this.emit("void xset" + propertyName + "(" + xtype + " " + safeVarName + ");");
            }
            if (xmltype && !several) {
                this.printJavaDoc("Appends and returns a new empty " + propdesc);
                this.emit(xtype + " addNew" + propertyName + "();");
            }
            if (nillable) {
                this.printJavaDoc((several ? "Nils the first " : "Nils the ") + propdesc);
                this.emit("void setNil" + propertyName + "();");
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "Removes first " : "Unsets the ") + propdesc);
            this.emit("void unset" + propertyName + "();");
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Sets array of all " + propdesc);
            this.emit("void set" + arrayName + "(" + type + "[] " + safeVarName + "Array);");
            this.printJavaDoc("Sets ith " + propdesc);
            this.emit("void set" + arrayName + "(int i, " + type + " " + safeVarName + ");");
            if (!xmltype) {
                this.printJavaDoc("Sets (as xml) array of all " + propdesc);
                this.emit("void xset" + arrayName + "(" + xtype + "[]" + safeVarName + "Array);");
                this.printJavaDoc("Sets (as xml) ith " + propdesc);
                this.emit("void xset" + arrayName + "(int i, " + xtype + " " + safeVarName + ");");
            }
            if (nillable) {
                this.printJavaDoc("Nils the ith " + propdesc);
                this.emit("void setNil" + arrayName + "(int i);");
            }
            if (!xmltype) {
                this.printJavaDoc("Inserts the value as the ith " + propdesc);
                this.emit("void insert" + propertyName + "(int i, " + type + " " + safeVarName + ");");
                this.printJavaDoc("Appends the value as the last " + propdesc);
                this.emit("void add" + propertyName + "(" + type + " " + safeVarName + ");");
            }
            if (xmltype) {
                this.printJavaDoc("Inserts and returns a new empty value (as xml) as the ith " + propdesc);
                this.emit(xtype + " insertNew" + propertyName + "(int i);");
                this.printJavaDoc("Appends and returns a new empty value (as xml) as the last " + propdesc);
                this.emit(xtype + " addNew" + propertyName + "();");
            }
            this.printJavaDoc("Removes the ith " + propdesc);
            this.emit("void remove" + propertyName + "(int i);");
        }
    }

    String getAtomicRestrictionType(SchemaType sType) {
        SchemaType pType = sType.getPrimitiveType();
        switch (pType.getBuiltinTypeCode()) {
            case 2: {
                return "com.bea.xbean.values.XmlAnySimpleTypeImpl";
            }
            case 3: {
                return "com.bea.xbean.values.JavaBooleanHolderEx";
            }
            case 4: {
                return "com.bea.xbean.values.JavaBase64HolderEx";
            }
            case 5: {
                return "com.bea.xbean.values.JavaHexBinaryHolderEx";
            }
            case 6: {
                return "com.bea.xbean.values.JavaUriHolderEx";
            }
            case 7: {
                return "com.bea.xbean.values.JavaQNameHolderEx";
            }
            case 8: {
                return "com.bea.xbean.values.JavaNotationHolderEx";
            }
            case 9: {
                return "com.bea.xbean.values.JavaFloatHolderEx";
            }
            case 10: {
                return "com.bea.xbean.values.JavaDoubleHolderEx";
            }
            case 11: {
                switch (sType.getDecimalSize()) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 1000001: {
                        return "com.bea.xbean.values.JavaDecimalHolderEx";
                    }
                    case 1000000: {
                        return "com.bea.xbean.values.JavaIntegerHolderEx";
                    }
                    case 64: {
                        return "com.bea.xbean.values.JavaLongHolderEx";
                    }
                    case 8: 
                    case 16: 
                    case 32: 
                }
                return "com.bea.xbean.values.JavaIntHolderEx";
            }
            case 12: {
                if (sType.hasStringEnumValues()) {
                    return "com.bea.xbean.values.JavaStringEnumerationHolderEx";
                }
                return "com.bea.xbean.values.JavaStringHolderEx";
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return "com.bea.xbean.values.JavaGDateHolderEx";
            }
            case 13: {
                return "com.bea.xbean.values.JavaGDurationHolderEx";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"unrecognized primitive type");
        }
        return null;
    }

    static SchemaType findBaseType(SchemaType sType) {
        while (sType.getFullJavaName() == null) {
            sType = sType.getBaseType();
        }
        return sType;
    }

    String getBaseClass(SchemaType sType) {
        SchemaType baseType = SchemaTypeCodePrinter.findBaseType(sType.getBaseType());
        if (baseType.isBuiltinType()) {
            switch (sType.getSimpleVariety()) {
                case 0: {
                    return "com.bea.xbean.values.XmlComplexContentImpl";
                }
                case 1: {
                    if (!$assertionsDisabled && sType.isBuiltinType()) {
                        throw new AssertionError();
                    }
                    return this.getAtomicRestrictionType(sType);
                }
                case 3: {
                    return "com.bea.xbean.values.XmlListImpl";
                }
                case 2: {
                    return "com.bea.xbean.values.XmlUnionImpl";
                }
            }
            throw new IllegalStateException();
        }
        return baseType.getFullJavaImplName();
    }

    void printConstructor(SchemaType sType, String shortName) throws IOException {
        this.emit("");
        this.emit("public " + shortName + "(com.bea.xml.SchemaType sType)");
        this.startBlock();
        this.emit("super(sType" + (sType.getSimpleVariety() == 0 ? "" : ", " + !sType.isSimpleType()) + ");");
        this.endBlock();
        if (sType.getSimpleVariety() != 0) {
            this.emit("");
            this.emit("protected " + shortName + "(com.bea.xml.SchemaType sType, boolean b)");
            this.startBlock();
            this.emit("super(sType, b);");
            this.endBlock();
        }
    }

    void startClass(SchemaType sType, boolean isInner) throws IOException {
        String shortName = sType.getShortJavaImplName();
        String baseClass = this.getBaseClass(sType);
        StringBuffer interfaces = new StringBuffer();
        interfaces.append(sType.getFullJavaName().replace('$', '.'));
        if (sType.getSimpleVariety() == 2) {
            SchemaType[] memberTypes = sType.getUnionMemberTypes();
            int i = 0;
            while (i < memberTypes.length) {
                interfaces.append(", " + memberTypes[i].getFullJavaName().replace('$', '.'));
                ++i;
            }
        }
        this.emit("public " + (isInner ? "static " : "") + "class " + shortName + " extends " + baseClass + " implements " + interfaces.toString());
        this.startBlock();
    }

    void makeDefaultValue(String jtargetType, SchemaProperty prop) throws IOException {
        String fullName = jtargetType;
        if (fullName == null) {
            fullName = prop.javaBasedOnType().getFullJavaName().replace('$', '.');
        }
        this.emit("target = (" + fullName + ") ");
        this.indent();
        this.emit(fullName + ".type.newValue( " + this.encodeString(prop.getDefaultText()) + " );");
        this.outdent();
    }

    void makeMissingValue(int javaType) throws IOException {
        switch (javaType) {
            case 1: {
                this.emit("return false;");
                break;
            }
            case 2: {
                this.emit("return 0.0f;");
                break;
            }
            case 3: {
                this.emit("return 0.0;");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.emit("return 0;");
                break;
            }
            case 7: {
                this.emit("return 0L;");
                break;
            }
            default: {
                this.emit("return null;");
            }
        }
    }

    void printJGetArrayValue(int javaType, String type) throws IOException {
        switch (javaType) {
            case 0: 
            case 18: {
                this.emit(type + "[] result = new " + type + "[targetList.size()];");
                this.emit("targetList.toArray(result);");
                break;
            }
            case 1: {
                this.emit("boolean[] result = new boolean[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).booleanValue();");
                break;
            }
            case 2: {
                this.emit("float[] result = new float[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).floatValue();");
                break;
            }
            case 3: {
                this.emit("double[] result = new double[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).doubleValue();");
                break;
            }
            case 4: {
                this.emit("byte[] result = new byte[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).byteValue();");
                break;
            }
            case 5: {
                this.emit("short[] result = new short[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).shortValue();");
                break;
            }
            case 6: {
                this.emit("int[] result = new int[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).intValue();");
                break;
            }
            case 7: {
                this.emit("long[] result = new long[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).longValue();");
                break;
            }
            case 8: {
                this.emit("java.math.BigDecimal[] result = new java.math.BigDecimal[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).bigDecimalValue();");
                break;
            }
            case 9: {
                this.emit("java.math.BigInteger[] result = new java.math.BigInteger[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).bigIntegerValue();");
                break;
            }
            case 10: {
                this.emit("java.lang.String[] result = new java.lang.String[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).stringValue();");
                break;
            }
            case 11: {
                this.emit("byte[][] result = new byte[targetList.size()][];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).byteArrayValue();");
                break;
            }
            case 17: {
                this.emit("java.util.Calendar[] result = new java.util.Calendar[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).calendarValue();");
                break;
            }
            case 14: {
                this.emit("java.util.Date[] result = new java.util.Date[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).dateValue();");
                break;
            }
            case 12: {
                this.emit("com.bea.xml.GDate[] result = new com.bea.xml.GDate[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).gDateValue();");
                break;
            }
            case 13: {
                this.emit("com.bea.xml.GDuration[] result = new com.bea.xml.GDuration[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).gDurationValue();");
                break;
            }
            case 15: {
                this.emit("javax.xml.namespace.QName[] result = new javax.xml.namespace.QName[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).qNameValue();");
                break;
            }
            case 16: {
                this.emit("java.util.List[] result = new java.util.List[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).listValue();");
                break;
            }
            case 19: {
                this.emit("Object[] result = new Object[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((com.bea.xml.SimpleValue)targetList.get(i)).booleanValue();");
            }
        }
        this.emit("return result;");
    }

    void printJGetValue(int javaType, String type) throws IOException {
        switch (javaType) {
            case 0: {
                this.emit("return target;");
                break;
            }
            case 1: {
                this.emit("return target.booleanValue();");
                break;
            }
            case 2: {
                this.emit("return target.floatValue();");
                break;
            }
            case 3: {
                this.emit("return target.doubleValue();");
                break;
            }
            case 4: {
                this.emit("return target.byteValue();");
                break;
            }
            case 5: {
                this.emit("return target.shortValue();");
                break;
            }
            case 6: {
                this.emit("return target.intValue();");
                break;
            }
            case 7: {
                this.emit("return target.longValue();");
                break;
            }
            case 8: {
                this.emit("return target.bigDecimalValue();");
                break;
            }
            case 9: {
                this.emit("return target.bigIntegerValue();");
                break;
            }
            case 10: {
                this.emit("return target.stringValue();");
                break;
            }
            case 11: {
                this.emit("return target.byteArrayValue();");
                break;
            }
            case 12: {
                this.emit("return target.gDateValue();");
                break;
            }
            case 13: {
                this.emit("return target.gDurationValue();");
                break;
            }
            case 17: {
                this.emit("return target.calendarValue();");
                break;
            }
            case 14: {
                this.emit("return target.dateValue();");
                break;
            }
            case 15: {
                this.emit("return target.qNameValue();");
                break;
            }
            case 16: {
                this.emit("return target.listValue();");
                break;
            }
            case 18: {
                this.emit("return (" + type + ")target.enumValue();");
                break;
            }
            case 19: {
                this.emit("return target.objectValue();");
            }
        }
    }

    String getIdentifier(Map qNameMap, QName qName) {
        return (String)qNameMap.get(qName);
    }

    Map printStaticFields(SchemaType sType) throws IOException {
        HashMap<QName, String> results = new HashMap<QName, String>();
        SchemaProperty[] properties = sType.getDerivedProperties();
        this.emit("");
        int i = 0;
        while (i < properties.length) {
            SchemaProperty prop = properties[i];
            QName name = prop.getName();
            String javaName = prop.getJavaPropertyName();
            String identifierName = (javaName + "$" + i).toUpperCase();
            String uriString = name.getNamespaceURI() == null ? "null" : "\"" + name.getNamespaceURI() + "\"";
            results.put(name, identifierName);
            this.emit("private static final javax.xml.namespace.QName " + identifierName + " = ");
            this.indent();
            this.emit("new javax.xml.namespace.QName(" + uriString + ", \"" + name.getLocalPart() + "\");");
            this.outdent();
            ++i;
        }
        this.emit("");
        return results;
    }

    void emitImplementationPreamble() throws IOException {
        this.emit("synchronized (monitor())");
        this.emit("{");
        this.indent();
        this.emit("check_orphaned();");
    }

    void emitImplementationPostamble() throws IOException {
        this.outdent();
        this.emit("}");
    }

    void emitAddTarget(String identifier, boolean isAttr, boolean declareTarget, String xtype) throws IOException {
        if (declareTarget) {
            this.emit(xtype + " target;");
        }
        if (isAttr) {
            this.emit("target = (" + xtype + ")get_store().add_attribute_user(" + identifier + ");");
        } else {
            this.emit("target = (" + xtype + ")get_store().add_element_user(" + identifier + ");");
        }
    }

    void emitGetTarget(String identifier, boolean isAttr, String index, int nullBehaviour, String xtype) throws IOException {
        this.emit(xtype + " target = null;");
        if (isAttr) {
            this.emit("target = (" + xtype + ")get_store().find_attribute_user(" + identifier + ");");
        } else {
            this.emit("target = (" + xtype + ")get_store().find_element_user(" + identifier + ", " + index + ");");
        }
        if (nullBehaviour == 1) {
            return;
        }
        this.emit("if (target == null)");
        this.startBlock();
        switch (nullBehaviour) {
            case 3: {
                this.emitAddTarget(identifier, isAttr, false, xtype);
                break;
            }
            case 4: {
                this.emit("throw new IndexOutOfBoundsException();");
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Bad behaviour type: " + nullBehaviour));
                }
                break;
            }
        }
        this.endBlock();
    }

    void printGetterImpls(SchemaProperty prop, QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton, boolean isunion, String identifier) throws IOException {
        String jtargetType;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        boolean xmltype = javaType == 0;
        String string = jtargetType = isunion ? "com.bea.xml.SimpleValue" : xtype;
        if (singleton) {
            this.printJavaDoc((several ? "Gets first " : "Gets the ") + propdesc);
            this.emit("public " + type + " get" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(identifier, isAttr, "0", 1, jtargetType);
            this.emit("if (target == null)");
            this.startBlock();
            if (isAttr && (prop.hasDefault() == 2 || prop.hasFixed() == 2)) {
                this.makeDefaultValue(jtargetType, prop);
            } else {
                this.makeMissingValue(javaType);
            }
            this.endBlock();
            this.printJGetValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc((several ? "Gets (as xml) first " : "Gets (as xml) the ") + propdesc);
                this.emit("public " + xtype + " xget" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "0", 1, xtype);
                if (isAttr && (prop.hasDefault() == 2 || prop.hasFixed() == 2)) {
                    this.emit("if (target == null)");
                    this.startBlock();
                    this.makeDefaultValue(xtype, prop);
                    this.endBlock();
                }
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc((several ? "Tests for nil first " : "Tests for nil ") + propdesc);
                this.emit("public boolean isNil" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "0", 1, xtype);
                this.emit("if (target == null) return false;");
                this.emit("return target.isNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "True if has at least one " : "True if has ") + propdesc);
            this.emit("public boolean isSet" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            if (isAttr) {
                this.emit("return get_store().find_attribute_user(" + identifier + ") != null;");
            } else {
                this.emit("return get_store().count_elements(" + identifier + ") != 0;");
            }
            this.emitImplementationPostamble();
            this.endBlock();
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Gets array of all " + propdesc + "s");
            this.emit("public " + type + "[] get" + arrayName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emit("java.util.List targetList = new java.util.ArrayList();");
            this.emit("get_store().find_all_element_users(" + identifier + ", targetList);");
            this.printJGetArrayValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            this.printJavaDoc("Gets ith " + propdesc);
            this.emit("public " + type + " get" + arrayName + "(int i)");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(identifier, isAttr, "i", 4, jtargetType);
            this.printJGetValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc("Gets (as xml) array of all " + propdesc + "s");
                this.emit("public " + xtype + "[] xget" + arrayName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emit("java.util.List targetList = new java.util.ArrayList();");
                this.emit("get_store().find_all_element_users(" + identifier + ", targetList);");
                this.emit(xtype + "[] result = new " + xtype + "[targetList.size()];");
                this.emit("targetList.toArray(result);");
                this.emit("return result;");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Gets (as xml) ith " + propdesc);
                this.emit("public " + xtype + " xget" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "i", 4, xtype);
                this.emit("return (" + xtype + ")target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc("Tests for nil ith " + propdesc);
                this.emit("public boolean isNil" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "i", 4, xtype);
                this.emit("return target.isNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            this.printJavaDoc("Returns number of " + propdesc);
            this.emit("public int sizeOf" + arrayName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emit("return get_store().count_elements(" + identifier + ");");
            this.emitImplementationPostamble();
            this.endBlock();
        }
    }

    void printSetterImpls(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton, boolean isunion, String identifier) throws IOException {
        String safeVarName = NameUtil.nonJavaKeyword(NameUtil.lowerCamelCase(propertyName));
        if (safeVarName.equals("i")) {
            safeVarName = "iValue";
        } else if (safeVarName.equals("target")) {
            safeVarName = "targetValue";
        }
        boolean xmltype = javaType == 0;
        boolean isobj = javaType == 19;
        String jSet = isobj ? "objectSet" : "set";
        String jtargetType = isunion ? "com.bea.xml.SimpleValue" : xtype;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        if (singleton) {
            this.printJavaDoc((several ? "Sets first " : "Sets the ") + propdesc);
            this.emit("public void set" + propertyName + "(" + type + " " + safeVarName + ")");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(identifier, isAttr, "0", 3, jtargetType);
            this.emit("target." + jSet + "(" + safeVarName + ");");
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc((several ? "Sets (as xml) first " : "Sets (as xml) the ") + propdesc);
                this.emit("public void xset" + propertyName + "(" + xtype + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "0", 3, xtype);
                this.emit("target.set(" + safeVarName + ");");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (xmltype && !several) {
                this.printJavaDoc("Appends and returns a new empty " + propdesc);
                this.emit("public " + xtype + " addNew" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitAddTarget(identifier, isAttr, true, xtype);
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc((several ? "Nils the first " : "Nils the ") + propdesc);
                this.emit("public void setNil" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "0", 3, xtype);
                this.emit("target.setNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "Removes first " : "Unsets the ") + propdesc);
            this.emit("public void unset" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            if (isAttr) {
                this.emit("get_store().remove_attribute(" + identifier + ");");
            } else {
                this.emit("get_store().remove_element(" + identifier + ", 0);");
            }
            this.emitImplementationPostamble();
            this.endBlock();
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Sets array of all " + propdesc);
            this.emit("public void set" + arrayName + "(" + type + "[] " + safeVarName + "Array)");
            this.startBlock();
            this.emitImplementationPreamble();
            if (isobj) {
                this.emit("unionArraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
            } else {
                this.emit("arraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
            }
            this.emitImplementationPostamble();
            this.endBlock();
            this.printJavaDoc("Sets ith " + propdesc);
            this.emit("public void set" + arrayName + "(int i, " + type + " " + safeVarName + ")");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(identifier, isAttr, "i", 4, jtargetType);
            this.emit("target." + jSet + "(" + safeVarName + ");");
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc("Sets (as xml) array of all " + propdesc);
                this.emit("public void xset" + arrayName + "(" + xtype + "[]" + safeVarName + "Array)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emit("arraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Sets (as xml) ith " + propdesc);
                this.emit("public void xset" + arrayName + "(int i, " + xtype + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "i", 4, xtype);
                this.emit("target.set(" + safeVarName + ");");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc("Nils the ith " + propdesc);
                this.emit("public void setNil" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(identifier, isAttr, "i", 4, xtype);
                this.emit("target.setNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (!xmltype) {
                this.printJavaDoc("Inserts the value as the ith " + propdesc);
                this.emit("public void insert" + propertyName + "(int i, " + type + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emit(jtargetType + " target = ");
                this.indent();
                this.emit("(" + jtargetType + ")get_store().insert_element_user(" + identifier + ", i);");
                this.outdent();
                this.emit("target." + jSet + "(" + safeVarName + ");");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Appends the value as the last " + propdesc);
                this.emit("public void add" + propertyName + "(" + type + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitAddTarget(identifier, isAttr, true, jtargetType);
                this.emit("target." + jSet + "(" + safeVarName + ");");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (xmltype) {
                this.printJavaDoc("Inserts and returns a new empty value (as xml) as the ith " + propdesc);
                this.emit("public " + xtype + " insertNew" + propertyName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emit(xtype + " target;");
                this.emit("target = (" + xtype + ")get_store().insert_element_user(" + identifier + ", i);");
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Appends and returns a new empty value (as xml) as the last " + propdesc);
                this.emit("public " + xtype + " addNew" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitAddTarget(identifier, isAttr, true, xtype);
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            this.printJavaDoc("Removes the ith " + propdesc);
            this.emit("public void remove" + propertyName + "(int i)");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emit("get_store().remove_element(" + identifier + ", i);");
            this.emitImplementationPostamble();
            this.endBlock();
        }
    }

    static void getTypeName(Class c, StringBuffer sb) {
        int arrayCount = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++arrayCount;
        }
        sb.append(c.getName());
        int i = 0;
        while (i < arrayCount) {
            sb.append("[]");
            ++i;
        }
    }

    void printInnerTypeImpl(SchemaType sType, SchemaTypeSystem system, boolean isInner) throws IOException {
        String shortName = sType.getShortJavaImplName();
        this.printInnerTypeJavaDoc(sType);
        this.startClass(sType, isInner);
        Map qNameMap = this.printStaticFields(sType);
        this.printConstructor(sType, shortName);
        if (!sType.isSimpleType()) {
            SchemaProperty[] properties = sType.getDerivedProperties();
            int i = 0;
            while (i < properties.length) {
                SchemaProperty prop = properties[i];
                this.printGetterImpls(prop, prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), SchemaTypeCodePrinter.javaTypeForProperty(prop), SchemaTypeCodePrinter.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton(), SchemaTypeCodePrinter.xmlTypeForPropertyIsUnion(prop), this.getIdentifier(qNameMap, prop.getName()));
                if (!prop.isReadOnly()) {
                    this.printSetterImpls(prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), SchemaTypeCodePrinter.javaTypeForProperty(prop), SchemaTypeCodePrinter.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton(), SchemaTypeCodePrinter.xmlTypeForPropertyIsUnion(prop), this.getIdentifier(qNameMap, prop.getName()));
                }
                ++i;
            }
        }
        this.printNestedTypeImpls(sType, system);
        this.endBlock();
    }

    void printNestedTypeImpls(SchemaType sType, SchemaTypeSystem system) throws IOException {
        SchemaType[] anonTypes = sType.getAnonymousTypes();
        int i = 0;
        while (i < anonTypes.length) {
            if (anonTypes[i].isSkippedAnonymousType()) {
                this.printNestedTypeImpls(anonTypes[i], system);
            } else {
                this.printInnerTypeImpl(anonTypes[i], system, true);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$schema$SchemaTypeCodePrinter == null ? (class$com$bea$xbean$schema$SchemaTypeCodePrinter = SchemaTypeCodePrinter.class$("com.bea.xbean.schema.SchemaTypeCodePrinter")) : class$com$bea$xbean$schema$SchemaTypeCodePrinter).desiredAssertionStatus();
        LINE_SEPARATOR = System.getProperty("line.separator") == null ? "\n" : System.getProperty("line.separator");
    }
}

