/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.common;

import com.bea.xbean.common.XMLChar;
import com.bea.xml.SimpleValue;
import com.bea.xml.XmlObject;

public class XmlObjectList {
    private final XmlObject[] _objects;

    public XmlObjectList(int objectCount) {
        this._objects = new XmlObject[objectCount];
    }

    public boolean set(XmlObject o, int index) {
        if (this._objects[index] != null) {
            return false;
        }
        this._objects[index] = o;
        return true;
    }

    public boolean filled() {
        int i = 0;
        while (i < this._objects.length) {
            if (this._objects[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int unfilled() {
        int i = 0;
        while (i < this._objects.length) {
            if (this._objects[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XmlObjectList)) {
            return false;
        }
        XmlObjectList other = (XmlObjectList)o;
        if (other._objects.length != this._objects.length) {
            return false;
        }
        int i = 0;
        while (i < this._objects.length) {
            if (this._objects[i] == null || other._objects[i] == null) {
                return false;
            }
            if (!this._objects[i].valueEquals(other._objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this._objects.length) {
            if (this._objects[i] != null) {
                h = 31 * h + this._objects[i].valueHashCode();
            }
            ++i;
        }
        return h;
    }

    private static String prettytrim(String s) {
        int end = s.length();
        while (end > 0) {
            if (!XMLChar.isSpace(s.charAt(end - 1))) break;
            --end;
        }
        int start = 0;
        while (start < end) {
            if (!XMLChar.isSpace(s.charAt(start))) break;
            ++start;
        }
        return s.substring(start, end);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this._objects.length) {
            if (i != 0) {
                b.append(" ");
            }
            b.append(XmlObjectList.prettytrim(((SimpleValue)this._objects[i]).stringValue()));
            ++i;
        }
        return b.toString();
    }
}

