/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class NameUtil {
    public static final char HYPHEN = '-';
    public static final char PERIOD = '.';
    public static final char COLON = ':';
    public static final char USCORE = '_';
    public static final char DOT = '\u00b7';
    public static final char TELEIA = '\u0387';
    public static final char AYAH = '\u06dd';
    public static final char ELHIZB = '\u06de';
    private static final boolean DEBUG = false;
    private static final Set javaWords = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static final Set javaNames = new HashSet<String>(Arrays.asList("CharSequence", "Cloneable", "Comparable", "Runnable", "Boolean", "Byte", "Character", "Class", "ClassLoader", "Compiler", "Double", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "ClassCastException", "ClassNotFoundException", "CloneNotSupportedException", "Exception", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IndexOutOfBoundsException", "InstantiationException", "InterruptedException", "NegativeArraySizeException", "NoSuchFieldException", "NoSuchMethodException", "NullPointerException", "NumberFormatException", "RuntimeException", "SecurityException", "StringIndexOutOfBoundsException", "UnsupportedOperationException", "AbstractMethodError", "AssertionError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "BigInteger", "BigDecimal", "Enum", "Date", "GDate", "GDuration", "QName", "List", "XmlObject", "XmlCursor", "XmlBeans", "SchemaType"));
    private static final Set tldSet = new HashSet<String>(Arrays.asList("COM", "NET", "ORG", "EDU", "INT", "MIL", "GOV", "ARPA", "AERO", "BIZ", "COOP", "INFO", "MUSEUM", "NAME", "PRO", "AF", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "TL", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "SH", "KN", "LC", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "SC", "SL", "SG", "SK", "SI", "SB", "SO", "ZA", "GS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "YU", "ZM", "ZW"));
    private static final String JAVA_NS_PREFIX = "java:";
    private static final String LANG_PREFIX = "java.";
    private static final int START = 0;
    private static final int PUNCT = 1;
    private static final int DIGIT = 2;
    private static final int MARK = 3;
    private static final int UPPER = 4;
    private static final int LOWER = 5;
    private static final int NOCASE = 6;

    public static boolean isTopLevelDomain(String str) {
        return tldSet.contains(str.toUpperCase());
    }

    public static boolean isValidJavaIdentifier(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        int len = id.length();
        if (len == 0) {
            return false;
        }
        if (javaWords.contains(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getClassNameFromQName(QName qname) {
        String java_type = NameUtil.upperCamelCase(qname.getLocalPart());
        String uri = qname.getNamespaceURI();
        String java_pkg = null;
        java_pkg = NameUtil.getPackageFromNamespace(uri);
        if (java_pkg != null) {
            return java_pkg + "." + java_type;
        }
        return java_type;
    }

    public static String getNamespaceFromPackage(Class clazz) {
        Class<?> curr_clazz = clazz;
        while (curr_clazz.isArray()) {
            curr_clazz = curr_clazz.getComponentType();
        }
        String fullname = clazz.getName();
        int lastdot = fullname.lastIndexOf(46);
        String pkg_name = lastdot < 0 ? "" : fullname.substring(0, lastdot);
        return JAVA_NS_PREFIX + pkg_name;
    }

    private static boolean isUriSchemeChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.' || ch == '+';
    }

    private static boolean isUriAlphaChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static int findSchemeColon(String uri) {
        int len = uri.length();
        if (len == 0) {
            return -1;
        }
        if (!NameUtil.isUriAlphaChar(uri.charAt(0))) {
            return -1;
        }
        int i = 1;
        while (i < len) {
            if (!NameUtil.isUriSchemeChar(uri.charAt(i))) break;
            ++i;
        }
        if (i == len) {
            return -1;
        }
        if (uri.charAt(i) != ':') {
            return -1;
        }
        return i;
    }

    private static String jls77String(String name) {
        StringBuffer buf = new StringBuffer(name);
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(buf.charAt(i))) {
                buf.setCharAt(i, '_');
            }
            ++i;
        }
        if (buf.length() == 0 || !Character.isJavaIdentifierStart(buf.charAt(0))) {
            buf.insert(0, '_');
        }
        if (NameUtil.isJavaReservedWord(name)) {
            buf.append('_');
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static List splitDNS(String dns) {
        i = dns.lastIndexOf(46);
        if (i < 0) {
            return Collections.singletonList(dns);
        }
        tld = dns.substring(i + 1);
        if (!NameUtil.tldSet.contains(tld.toUpperCase())) {
            return Collections.singletonList(dns);
        }
        result = new ArrayList<String>();
        result.add(tld.toLowerCase());
        ** GOTO lbl20
        while (--i >= 0) {
            while (dns.charAt(i) != '.') {
                end = i + 1;
                while (dns.charAt(i) != '.') {
                    if (--i < 0) break;
                }
                start = i + 1;
                result.add(NameUtil.jls77String(dns.substring(start, end)));
lbl20:
                // 2 sources

                if (i >= 0) continue;
            }
        }
        if (result.size() >= 3 && ((String)result.get(result.size() - 1)).toLowerCase().equals("www")) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private static String processFilename(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && (i + 1 + 2 == filename.length() || i + 1 + 3 == filename.length() || filename.substring(i + 1).toLowerCase() == "html")) {
            return filename.substring(0, i);
        }
        return filename;
    }

    /*
     * Unable to fully structure code
     */
    public static String getPackageFromNamespace(String uri) {
        if (uri == null || uri.length() == 0) {
            return "noNamespace";
        }
        len = uri.length();
        result = new ArrayList<String>();
        i = NameUtil.findSchemeColon(uri) + 1;
        ** GOTO lbl16
        while (++i < len) {
            while (uri.charAt(i) != '/') {
                start = i;
                while (uri.charAt(i) != '/') {
                    if (++i >= len) break;
                }
                end = i;
                result.add(uri.substring(start, end));
lbl16:
                // 2 sources

                if (i < len) continue;
            }
        }
        if (result.size() > 1) {
            result.set(result.size() - 1, NameUtil.processFilename((String)result.get(result.size() - 1)));
        }
        if (result.size() > 0) {
            splitdns = NameUtil.splitDNS((String)result.get(0));
            result.remove(0);
            result.addAll(0, splitdns);
        }
        buf = new StringBuffer();
        i = result.iterator();
        while (i.hasNext()) {
            buf.append(NameUtil.nonJavaKeyword(NameUtil.lowerCamelCase((String)i.next())));
            buf.append('.');
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            System.out.println(NameUtil.upperCaseUnderbar(args[i]));
            ++i;
        }
    }

    public static String upperCaseUnderbar(String xml_name) {
        StringBuffer buf = new StringBuffer();
        List words = NameUtil.splitWords(xml_name);
        int sz = words.size() - 1;
        if (sz >= 0 && !Character.isJavaIdentifierStart(((String)words.get(0)).charAt(0))) {
            buf.append("X_");
        }
        int i = 0;
        while (i < sz) {
            buf.append((String)words.get(i));
            buf.append('_');
            ++i;
        }
        if (sz >= 0) {
            buf.append((String)words.get(sz));
        }
        int len = buf.length();
        int j = 0;
        while (j < len) {
            char c = buf.charAt(j);
            buf.setCharAt(j, Character.toUpperCase(c));
            ++j;
        }
        return buf.toString();
    }

    public static String upperCamelCase(String xml_name) {
        StringBuffer buf = new StringBuffer();
        List words = NameUtil.splitWords(xml_name);
        if (words.size() > 0) {
            if (!Character.isJavaIdentifierStart(((String)words.get(0)).charAt(0))) {
                buf.append("X");
            }
            Iterator itr = words.iterator();
            while (itr.hasNext()) {
                buf.append((String)itr.next());
            }
        }
        return buf.toString();
    }

    public static String lowerCamelCase(String xml_name) {
        StringBuffer buf = new StringBuffer();
        List words = NameUtil.splitWords(xml_name);
        if (words.size() > 0) {
            String first = ((String)words.get(0)).toLowerCase();
            char f = first.charAt(0);
            if (!Character.isJavaIdentifierStart(f)) {
                buf.append("x");
            }
            buf.append(first);
            Iterator itr = words.iterator();
            itr.next();
            while (itr.hasNext()) {
                buf.append((String)itr.next());
            }
        }
        return buf.toString();
    }

    public static String upperCaseFirstLetter(String s) {
        if (s.length() == 0 || Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s);
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private static void addCapped(List list, String str) {
        if (str.length() > 0) {
            list.add(NameUtil.upperCaseFirstLetter(str));
        }
    }

    public static List splitWords(String name) {
        ArrayList list = new ArrayList();
        int len = name.length();
        int start = 0;
        int prefix = 0;
        int i = 0;
        while (i < len) {
            int current = NameUtil.getCharClass(name.charAt(i));
            if (prefix != 1 && current == 1) {
                NameUtil.addCapped(list, name.substring(start, i));
                while ((current = NameUtil.getCharClass(name.charAt(i))) == 1) {
                    if (++i < len) continue;
                    return list;
                }
                start = i;
            } else if (prefix == 2 != (current == 2) || prefix == 5 && current != 5 || NameUtil.isLetter(prefix) != NameUtil.isLetter(current)) {
                NameUtil.addCapped(list, name.substring(start, i));
                start = i;
            } else if (prefix == 4 && current == 5 && i > start + 1) {
                NameUtil.addCapped(list, name.substring(start, i - 1));
                start = i - 1;
            }
            prefix = current;
            ++i;
        }
        NameUtil.addCapped(list, name.substring(start));
        return list;
    }

    public static int getCharClass(char c) {
        if (NameUtil.isPunctuation(c)) {
            return 1;
        }
        if (Character.isDigit(c)) {
            return 2;
        }
        if (Character.isUpperCase(c)) {
            return 4;
        }
        if (Character.isLowerCase(c)) {
            return 5;
        }
        if (Character.isLetter(c)) {
            return 6;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return 3;
        }
        return 1;
    }

    private static boolean isLetter(int state) {
        return state == 4 || state == 5 || state == 6;
    }

    public static boolean isPunctuation(char c) {
        return c == '-' || c == '.' || c == ':' || c == '_' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    public static String nonJavaKeyword(String word) {
        if (NameUtil.isJavaReservedWord(word)) {
            return 'x' + word;
        }
        return word;
    }

    public static String nonJavaCommonClassName(String name) {
        if (NameUtil.isJavaCommonClassName(name)) {
            return "X" + name;
        }
        return name;
    }

    private static boolean isJavaReservedWord(String word) {
        return NameUtil.isJavaReservedWord(word, true);
    }

    private static boolean isJavaReservedWord(String word, boolean ignore_case) {
        if (ignore_case) {
            word = word.toLowerCase();
        }
        return javaWords.contains(word);
    }

    public static boolean isJavaCommonClassName(String word) {
        return javaNames.contains(word);
    }
}

