/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xbean.common;

import com.bea.xbean.common.QNameHelper;
import com.bea.xbean.common.ValidatorListener;
import com.bea.xbean.common.XPath;
import com.bea.xbean.common.XmlObjectList;
import com.bea.xml.SchemaIdentityConstraint;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlError;
import com.bea.xml.XmlID;
import com.bea.xml.XmlIDREF;
import com.bea.xml.XmlIDREFS;
import com.bea.xml.XmlObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IdentityConstraint {
    private ConstraintState _constraintStack;
    private ElementState _elementStack;
    private Collection _errorListener;
    private boolean _invalid;
    private boolean _trackIdrefs;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$xbean$common$IdentityConstraint;

    public IdentityConstraint(Collection errorListener, boolean trackIdrefs) {
        this._errorListener = errorListener;
        this._trackIdrefs = trackIdrefs;
    }

    public void element(ValidatorListener.Event e, SchemaIdentityConstraint[] ics) {
        this.newState();
        ConstraintState cs = this._constraintStack;
        while (cs != null) {
            cs.element(e);
            cs = cs._next;
        }
        int i = 0;
        while (ics != null && i < ics.length) {
            this.newConstraintState(ics[i]);
            ++i;
        }
    }

    public void endElement(ValidatorListener.Event e) {
        ConstraintState cs;
        if (this._elementStack._hasConstraints) {
            cs = this._constraintStack;
            while (cs != null && cs != this._elementStack._savePoint) {
                cs.remove(e);
                cs = cs._next;
            }
            this._constraintStack = this._elementStack._savePoint;
        }
        this._elementStack = this._elementStack._next;
        cs = this._constraintStack;
        while (cs != null) {
            cs.endElement(e);
            cs = cs._next;
        }
    }

    public void attr(ValidatorListener.Event e, SchemaType st, String value) {
        ConstraintState cs = this._constraintStack;
        while (cs != null) {
            cs.attr(e, st, value);
            cs = cs._next;
        }
    }

    public void text(ValidatorListener.Event e, SchemaType st, String value, boolean emptyContent) {
        ConstraintState cs = this._constraintStack;
        while (cs != null) {
            cs.text(e, st, value, emptyContent);
            cs = cs._next;
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    private void newConstraintState(SchemaIdentityConstraint ic) {
        if (ic.getConstraintCategory() == 2) {
            new KeyrefState(ic);
        } else {
            new SelectorState(ic);
        }
    }

    private void buildIdStates() {
        IdState ids = new IdState();
        if (this._trackIdrefs) {
            new IdRefState(ids);
        }
    }

    private void newState() {
        boolean firstTime = this._elementStack == null;
        ElementState st = new ElementState();
        st._next = this._elementStack;
        this._elementStack = st;
        if (firstTime) {
            this.buildIdStates();
        }
    }

    private void emitError(ValidatorListener.Event event, String msg) {
        this._invalid = true;
        if (this._errorListener != null) {
            if (!$assertionsDisabled && event == null) {
                throw new AssertionError();
            }
            this._errorListener.add(XmlError.forCursor(msg, event.getLocationAsCursor()));
        }
    }

    private void setSavePoint(ConstraintState cs) {
        if (!this._elementStack._hasConstraints) {
            this._elementStack._savePoint = cs;
        }
        this._elementStack._hasConstraints = true;
    }

    private static XmlObject newValue(SchemaType st, String value) {
        try {
            return st.newValue(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    static SchemaType getSimpleType(SchemaType st) {
        if (IdentityConstraint.$assertionsDisabled || st.isSimpleType() || st.getContentType() == 2) ** GOTO lbl4
        throw new AssertionError((Object)(st + " does not have simple content."));
lbl-1000:
        // 1 sources

        {
            st = st.getBaseType();
lbl4:
            // 2 sources

            ** while (!st.isSimpleType())
        }
lbl5:
        // 1 sources

        return st;
    }

    static boolean hasSimpleContent(SchemaType st) {
        return st.isSimpleType() || st.getContentType() == 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$xbean$common$IdentityConstraint == null ? (class$com$bea$xbean$common$IdentityConstraint = IdentityConstraint.class$("com.bea.xbean.common.IdentityConstraint")) : class$com$bea$xbean$common$IdentityConstraint).desiredAssertionStatus();
    }

    private static class ElementState {
        ElementState _next;
        boolean _hasConstraints;
        ConstraintState _savePoint;

        private ElementState() {
        }
    }

    public class IdRefState
    extends ConstraintState {
        IdState _ids;
        List _values;

        IdRefState(IdState ids) {
            this._ids = ids;
            this._values = new ArrayList();
        }

        private void handleValue(ValidatorListener.Event e, SchemaType st, String value) {
            if (value == null) {
                return;
            }
            if (st == null || st.isNoType()) {
                return;
            }
            if (XmlIDREFS.type.isAssignableFrom(st)) {
                XmlIDREFS lv = (XmlIDREFS)IdentityConstraint.newValue(XmlIDREFS.type, value);
                if (lv == null) {
                    return;
                }
                List l = lv.xlistValue();
                int i = 0;
                while (i < l.size()) {
                    XmlObjectList xmlValue = new XmlObjectList(1);
                    XmlIDREF idref = (XmlIDREF)l.get(i);
                    xmlValue.set(idref, 0);
                    this._values.add(xmlValue);
                    ++i;
                }
            } else if (XmlIDREF.type.isAssignableFrom(st)) {
                XmlObjectList xmlValue = new XmlObjectList(1);
                XmlIDREF idref = (XmlIDREF)st.newValue(value);
                if (idref == null) {
                    return;
                }
                xmlValue.set(idref, 0);
                this._values.add(xmlValue);
            }
        }

        void attr(ValidatorListener.Event e, SchemaType st, String value) {
            this.handleValue(e, st, value);
        }

        void text(ValidatorListener.Event e, SchemaType st, String value, boolean emptyContent) {
            if (emptyContent) {
                return;
            }
            this.handleValue(e, st, value);
        }

        void remove(ValidatorListener.Event e) {
            Iterator it = this._values.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this._ids._values.contains(o)) continue;
                IdentityConstraint.this.emitError(e, "ID not found for IDRef value '" + o + "'");
            }
        }

        void element(ValidatorListener.Event e) {
        }

        void endElement(ValidatorListener.Event e) {
        }
    }

    public class IdState
    extends ConstraintState {
        Set _values;

        IdState() {
            this._values = new LinkedHashSet();
        }

        void attr(ValidatorListener.Event e, SchemaType st, String value) {
            this.handleValue(e, st, value);
        }

        void text(ValidatorListener.Event e, SchemaType st, String value, boolean emptyContent) {
            if (emptyContent) {
                return;
            }
            this.handleValue(e, st, value);
        }

        private void handleValue(ValidatorListener.Event e, SchemaType st, String value) {
            if (value == null) {
                return;
            }
            if (st == null || st.isNoType()) {
                return;
            }
            if (XmlID.type.isAssignableFrom(st)) {
                XmlObjectList xmlValue = new XmlObjectList(1);
                XmlObject o = IdentityConstraint.newValue(XmlID.type, value);
                if (o == null) {
                    return;
                }
                xmlValue.set(o, 0);
                if (this._values.contains(xmlValue)) {
                    IdentityConstraint.this.emitError(e, "Duplicate ID value '" + value + "'");
                } else {
                    this._values.add(xmlValue);
                }
            }
        }

        void element(ValidatorListener.Event e) {
        }

        void endElement(ValidatorListener.Event e) {
        }

        void remove(ValidatorListener.Event e) {
        }
    }

    public class FieldState
    extends ConstraintState {
        SelectorState _selector;
        XPath.ExecutionContext[] _contexts;
        boolean[] _needsValue;
        XmlObjectList _value;

        FieldState(SelectorState selector) {
            this._selector = selector;
            SchemaIdentityConstraint ic = selector._constraint;
            int fieldCount = ic.getFields().length;
            this._contexts = new XPath.ExecutionContext[fieldCount];
            this._needsValue = new boolean[fieldCount];
            this._value = new XmlObjectList(fieldCount);
            int i = 0;
            while (i < fieldCount) {
                this._contexts[i] = new XPath.ExecutionContext();
                this._contexts[i].init((XPath)ic.getFieldPath(i));
                if ((this._contexts[i].start() & 1) != 0) {
                    this._needsValue[i] = true;
                }
                ++i;
            }
        }

        void element(ValidatorListener.Event e) {
            int i = 0;
            while (i < this._contexts.length) {
                if (this._needsValue[i]) {
                    IdentityConstraint.this.emitError(e, "Identity constraint field must have simple content");
                    this._needsValue[i] = false;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this._contexts.length) {
                if ((this._contexts[i2].element(e.getName()) & 1) != 0) {
                    this._needsValue[i2] = true;
                }
                ++i2;
            }
        }

        void attr(ValidatorListener.Event e, SchemaType st, String value) {
            if (value == null) {
                return;
            }
            int i = 0;
            while (i < this._contexts.length) {
                if (this._contexts[i].attr(e.getName())) {
                    XmlObject o = IdentityConstraint.newValue(st, value);
                    if (o == null) {
                        return;
                    }
                    boolean set = this._value.set(o, i);
                    if (!set) {
                        IdentityConstraint.this.emitError(e, "Multiple instances of field with xpath: '" + this._selector._constraint.getFields()[i] + "' for a selector");
                    }
                }
                ++i;
            }
        }

        void text(ValidatorListener.Event e, SchemaType st, String value, boolean emptyContent) {
            if (value == null && !emptyContent) {
                return;
            }
            int i = 0;
            while (i < this._contexts.length) {
                if (this._needsValue[i]) {
                    if (emptyContent || !IdentityConstraint.hasSimpleContent(st)) {
                        IdentityConstraint.this.emitError(e, "Identity constraint field must have simple content");
                        return;
                    }
                    SchemaType simpleType = IdentityConstraint.getSimpleType(st);
                    XmlObject o = IdentityConstraint.newValue(simpleType, value);
                    if (o == null) {
                        return;
                    }
                    boolean set = this._value.set(o, i);
                    if (!set) {
                        IdentityConstraint.this.emitError(e, "Multiple instances of field with xpath: '" + this._selector._constraint.getFields()[i] + "' for a selector");
                    }
                }
                ++i;
            }
        }

        void endElement(ValidatorListener.Event e) {
            int i = 0;
            while (i < this._needsValue.length) {
                this._contexts[i].end();
                this._needsValue[i] = false;
                ++i;
            }
        }

        void remove(ValidatorListener.Event e) {
            if (this._selector._constraint.getConstraintCategory() == 1 && this._value.unfilled() >= 0) {
                IdentityConstraint.this.emitError(e, "Key " + QNameHelper.pretty(this._selector._constraint.getName()) + " is missing field with xpath: '" + this._selector._constraint.getFields()[this._value.unfilled()] + "'");
            } else {
                this._selector.addFields(this._value, e);
            }
        }
    }

    public class KeyrefState
    extends SelectorState {
        Set _keyValues;

        KeyrefState(SchemaIdentityConstraint constraint) {
            super(constraint);
            this._keyValues = new HashSet();
        }

        void addKeyValues(Set values) {
            this._keyValues.addAll(values);
        }

        void remove(ValidatorListener.Event e) {
            ConstraintState cs = this._next;
            while (cs != null && cs != ((IdentityConstraint)IdentityConstraint.this)._elementStack._savePoint) {
                if (cs instanceof SelectorState) {
                    SelectorState sel = (SelectorState)cs;
                    if (sel._constraint == this._constraint.getReferencedKey()) {
                        this.addKeyValues(sel._values);
                    }
                }
                cs = cs._next;
            }
            Iterator it = this._values.iterator();
            while (it.hasNext()) {
                XmlObjectList fields = (XmlObjectList)it.next();
                if (fields.unfilled() >= 0 || this._keyValues.contains(fields)) continue;
                IdentityConstraint.this.emitError(e, "Key '" + fields + "' not found (keyRef " + QNameHelper.pretty(this._constraint.getName()) + ")");
                return;
            }
        }
    }

    public class SelectorState
    extends ConstraintState {
        SchemaIdentityConstraint _constraint;
        Set _values;
        XPath.ExecutionContext _context;

        SelectorState(SchemaIdentityConstraint constraint) {
            this._values = new LinkedHashSet();
            this._constraint = constraint;
            this._context = new XPath.ExecutionContext();
            this._context.init((XPath)this._constraint.getSelectorPath());
            if ((this._context.start() & 1) != 0) {
                this.createFieldState();
            }
        }

        void addFields(XmlObjectList fields, ValidatorListener.Event e) {
            if (this._constraint.getConstraintCategory() == 2) {
                this._values.add(fields);
            } else if (this._values.contains(fields)) {
                IdentityConstraint.this.emitError(e, "Duplicate key '" + fields + "' for key or unique constraint " + QNameHelper.pretty(this._constraint.getName()));
            } else {
                this._values.add(fields);
            }
        }

        void element(ValidatorListener.Event e) {
            if ((this._context.element(e.getName()) & 1) != 0) {
                this.createFieldState();
            }
        }

        void endElement(ValidatorListener.Event e) {
            this._context.end();
        }

        void createFieldState() {
            new FieldState(this);
        }

        void remove(ValidatorListener.Event e) {
            ConstraintState cs = this._next;
            while (cs != null) {
                if (cs instanceof KeyrefState) {
                    KeyrefState kr = (KeyrefState)cs;
                    if (kr._constraint.getReferencedKey() == this) {
                        kr.addKeyValues(this._values);
                    }
                }
                cs = cs._next;
            }
        }

        void attr(ValidatorListener.Event e, SchemaType st, String value) {
        }

        void text(ValidatorListener.Event e, SchemaType st, String value, boolean emptyContent) {
        }
    }

    public abstract class ConstraintState {
        ConstraintState _next;

        ConstraintState() {
            IdentityConstraint.this.setSavePoint(IdentityConstraint.this._constraintStack);
            this._next = IdentityConstraint.this._constraintStack;
            IdentityConstraint.this._constraintStack = this;
        }

        abstract void element(ValidatorListener.Event var1);

        abstract void endElement(ValidatorListener.Event var1);

        abstract void attr(ValidatorListener.Event var1, SchemaType var2, String var3);

        abstract void text(ValidatorListener.Event var1, SchemaType var2, String var3, boolean var4);

        abstract void remove(ValidatorListener.Event var1);
    }
}

