package com.ejie.ac09j;


import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.Interceptors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.ac09j.jms.message.pif.jaxB.NotificationBody;
import com.ejie.ac09j.jms.message.pif.jaxB.NotificationBody.Property;
import com.ejie.ac09j.service.mensaje.Ac09jMensajeService;
import com.ejie.ac09j.utils.jaxB.JaxBConverterManager;
import com.ejie.ac09j.utils.pif.PifHandleUtils;


@Interceptors(value = SpringBeanAutowiringInterceptor.class)
@MessageDriven(activationConfig = {
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "ac09j.ac09jJMSPIFQueue"),
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "ac09j.ac09jJMSPIFQueue")
@TransactionManagement(TransactionManagementType.BEAN)
public class Ac09jEventosJMSEJB implements MessageListener{

	private static final String FILE_NAME = "fileName";


	private static final String FOLDER = "folder";


	@Autowired()
	private Ac09jMensajeService ac09jMensajeService;
		

	/** The Constant LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Ac09jEventosJMSEJB.class);
			
	/**
	 * @param arg0 Message
	 */
	@Override
	public void onMessage(Message message) {
	
		//Directorio del PIF donde se ha producido el evento

		String folder = null;
		//Nombre del archivo en el PIF
		String fileName = null;
		//Para la conversión de datos
		Charset utf8 =Charset.forName("UTF-8");
		
		//Variables de gestión de ficheros
		BufferedReader bufferedReader = null;
		InputStream inputStream = null;

		//Declaracion de Objetos destinados a la gestion de los servicios del PIF
		PifHandleUtils pifHandleUtils;
		String pifPath = null;
		StringBuilder mensaje = null;
		
		try {
			//Clase de gestion de los servicios del PIF
			pifHandleUtils = new PifHandleUtils();
			
			if (message instanceof TextMessage) {
				
				//Se prepara y registra el mensaje recepcionado
				TextMessage textMessage = (TextMessage) message;
				registroMensajeRecibido(textMessage);
				
				//Una vez registrada la entrada en el sistema de logs, se tratan los datos recibidos
				JaxBConverterManager<NotificationBody> serializacionManager = new JaxBConverterManager<NotificationBody>();
				NotificationBody notificationBody;
				notificationBody = serializacionManager.deserializeXMLStringToObject(NotificationBody.class, textMessage.getText());
				
				for (Iterator<Property> iterator = notificationBody.getProperty().iterator(); iterator.hasNext();) {
					Property property = iterator.next();
					
					if(FOLDER.equals(property.getName())){
						folder = property.getValue();
					} else if(FILE_NAME.equals(property.getName())){
						fileName = property.getValue();
					}
				}
				
				//Se recupera el nuevo fichero del PIF para ser tratado
				pifPath = folder + "/" + fileName;
				inputStream = pifHandleUtils.getFile(pifPath);

				//Se ha descargado correctamente el fichero del PIF
				LOGGER.info("Se ha descargado correctamente el fichero, con Path: "+ pifPath + " del PIF!!!!!!!!!");
				
				bufferedReader = new BufferedReader(new InputStreamReader(inputStream, utf8));
				
				String str;
				mensaje = new StringBuilder();
				
				while ((str = bufferedReader.readLine()) != null) {
					mensaje.append(str);
				}
				
				ac09jMensajeService.leerMensaje(mensaje.toString(),fileName);
			}
		
		} catch (Exception e) {
			LOGGER.error("Error en el procesado de un mensaje por parte del mdb \"Ac09jEventosJMSEJB\" que escucha la cola \"ac09j.ac09jJMSPIFQueue\"" + e, e.getCause());
			
		}
	}

	/**
	 * Registro mensaje recibido.
	 *
	 * @param textMessage the text message
	 */
	private void registroMensajeRecibido(TextMessage textMessage) {
		try {
			//Campos obligatorios enviados en el Mensaje
			String entidad = textMessage.getStringProperty("EventEntity");
			String sistema = textMessage.getStringProperty("EventWho");
			String tipologia = textMessage.getStringProperty("EventTipology");
			String what = textMessage.getStringProperty("EventWhat");

			LOGGER.trace("EventEntity: " + entidad );
			LOGGER.trace("EventWho: " + sistema );
			LOGGER.trace("EventTipology: " + tipologia );
			LOGGER.trace("EventWhat: " + what );

			//Campos opcionales enviados en el Mensaje
			String correlation = textMessage.getStringProperty("EventCorrelationId");
			String timeStamp = textMessage.getStringProperty("EventTimeStamp");
		
			LOGGER.trace("EventCorrelationId: " + correlation );
			LOGGER.trace("EventTimeStamp: " + timeStamp );
			
		} catch (JMSException jmsException) {
			LOGGER.error(jmsException.getMessage(), jmsException);
			
		}
	}
	
}

