
package com.ejie.ac09j.model.mensaje;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enlacesEs",
    "enlacesEu",
    "fechaActualizacionProgramada",
    "fechaCreacion",
    "numAviso",
    "seguimiento",
    "sucesos",
    "tituloEs",
    "tituloEu"
})
public class Informe {

    @JsonProperty("enlacesEs")
    private List<EnlacesEs> enlacesEs = null;
    @JsonProperty("enlacesEu")
    private List<EnlacesEu> enlacesEu = null;
    @JsonProperty("fechaActualizacionProgramada")
    private String fechaActualizacionProgramada;
    @JsonProperty("fechaCreacion")
    private String fechaCreacion;
    @JsonProperty("numAviso")
    private String numAviso;
    @JsonProperty("seguimiento")
    private List<Seguimiento> seguimiento = null;
    @JsonProperty("sucesos")
    private List<Suceso> sucesos = null;
    @JsonProperty("tituloEs")
    private String tituloEs;
    @JsonProperty("tituloEu")
    private String tituloEu;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("enlacesEs")
    public List<EnlacesEs> getEnlacesEs() {
        return enlacesEs;
    }

    @JsonProperty("enlacesEs")
    public void setEnlacesEs(List<EnlacesEs> enlacesEs) {
        this.enlacesEs = enlacesEs;
    }

    @JsonProperty("enlacesEu")
    public List<EnlacesEu> getEnlacesEu() {
        return enlacesEu;
    }

    @JsonProperty("enlacesEu")
    public void setEnlacesEu(List<EnlacesEu> enlacesEu) {
        this.enlacesEu = enlacesEu;
    }

    @JsonProperty("fechaActualizacionProgramada")
    public String getFechaActualizacionProgramada() {
        return fechaActualizacionProgramada;
    }

    @JsonProperty("fechaActualizacionProgramada")
    public void setFechaActualizacionProgramada(String fechaActualizacionProgramada) {
        this.fechaActualizacionProgramada = fechaActualizacionProgramada;
    }

    @JsonProperty("fechaCreacion")
    public String getFechaCreacion() {
        return fechaCreacion;
    }

    @JsonProperty("fechaCreacion")
    public void setFechaCreacion(String fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    @JsonProperty("numAviso")
    public String getNumAviso() {
        return numAviso;
    }

    @JsonProperty("numAviso")
    public void setNumAviso(String numAviso) {
        this.numAviso = numAviso;
    }

    @JsonProperty("seguimiento")
    public List<Seguimiento> getSeguimiento() {
        return seguimiento;
    }

    @JsonProperty("seguimiento")
    public void setSeguimiento(List<Seguimiento> seguimiento) {
        this.seguimiento = seguimiento;
    }

    @JsonProperty("sucesos")
    public List<Suceso> getSucesos() {
        return sucesos;
    }

    @JsonProperty("sucesos")
    public void setSucesos(List<Suceso> sucesos) {
        this.sucesos = sucesos;
    }

    @JsonProperty("tituloEs")
    public String getTituloEs() {
        return tituloEs;
    }

    @JsonProperty("tituloEs")
    public void setTituloEs(String tituloEs) {
        this.tituloEs = tituloEs;
    }

    @JsonProperty("tituloEu")
    public String getTituloEu() {
        return tituloEu;
    }

    @JsonProperty("tituloEu")
    public void setTituloEu(String tituloEu) {
        this.tituloEu = tituloEu;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
