package com.ejie.ac09j.service.mensaje;

import javax.mail.Address;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class Ac09aMimeMessagePreparator implements MimeMessagePreparator {

	private String msg;
	private Address[] recipients;
	private String remitente;
	private String asunto;
	private Multipart parts;

	public Ac09aMimeMessagePreparator(String msg, Address[] arrayOfAddress, String remitente, String asunto,
			Multipart parts) {
		this.msg = msg;
		setRecipients(arrayOfAddress);
		this.remitente = remitente;
		this.asunto = asunto;
		this.parts = parts;
	}

	@Override
	public void prepare(MimeMessage mimeMessage) throws Exception {
		MimeMessageHelper helper = new MimeMessageHelper(mimeMessage);
		InternetAddress[] internetAdresses = new InternetAddress[recipients.length];
		int i = 0;
		for (Address recipient : recipients) {
			internetAdresses[i] = new InternetAddress(recipient.toString());
			i++;
		}

		helper.setTo(internetAdresses[0]);
		helper.setBcc(internetAdresses);
		helper.setFrom(remitente);
		helper.setSubject(asunto);
		helper.setText(msg);
		mimeMessage.setHeader("Content-Type", "text/html");
		mimeMessage.saveChanges();
		mimeMessage.setContent(parts);
	}

	public final void setRecipients(Address[] recipients) {
		if (recipients == null) {
			this.recipients = new Address[0];
		} else {
			this.recipients = recipients;
		}
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getRemitente() {
		return remitente;
	}

	public void setRemitente(String remitente) {
		this.remitente = remitente;
	}

	public String getAsunto() {
		return asunto;
	}

	public void setAsunto(String asunto) {
		this.asunto = asunto;
	}

	public Multipart getParts() {
		return parts;
	}

	public void setParts(Multipart parts) {
		this.parts = parts;
	}

	public Address[] getRecipients() {
		return recipients;
	}

}
