package com.ejie.ac09j.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ac09j.common.Ac09jConstants;
import com.ejie.ac09j.model.Suscriptor;
import com.ejie.ac09j.model.SuscriptorFilter;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SuscriptorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SuscriptorDaoImpl implements SuscriptorDao {

	private static final String COD_SUSCRIPTOR_01 = "COD_SUSCRIPTOR_01";

	private static final String PARAMS = "params";

	private static final String QUERY = "query";

	private static final String WHERE_1_1 = " WHERE 1=1 ";

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "CODSUSCRIPTOR01", "EMAIL01", "PASSWORDHASH01",
			"IDIOMA01", "CAMBIOEMAIL01", "FECHAALTA01", "FECHAACTIVACION01", "FECHAMODIFICACION01", "NUMENVIOS01",
			"BAJA01", "FECHABAJA01" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Suscriptor> rwMap = new RowMapper<Suscriptor>() {
		public Suscriptor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Suscriptor(resultSet.getInt("CODSUSCRIPTOR01"), resultSet.getString("EMAIL01"),
					resultSet.getString("PASSWORDHASH01"), resultSet.getString("IDIOMA01"),
					resultSet.getString("CAMBIOEMAIL01"), resultSet.getDate("FECHAALTA01"),
					resultSet.getDate("FECHAACTIVACION01"), resultSet.getDate("FECHAMODIFICACION01"),
					resultSet.getLong("NUMENVIOS01"), resultSet.getString("BAJA01"), resultSet.getDate("FECHABAJA01"));
		}
	};

	private RowMapper<Suscriptor> rwMapPK = new RowMapper<Suscriptor>() {
		public Suscriptor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Suscriptor(resultSet.getInt("CODSUSCRIPTOR01"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	public Suscriptor add(Suscriptor suscriptor) {
		String query = "INSERT INTO SUSCRIPTOR (COD_SUSCRIPTOR_01, EMAIL_01, PASSWORD_HASH_01, IDIOMA_01, CAMBIO_EMAIL_01, FECHA_ALTA_01, FECHA_ACTIVACION_01, FECHA_MODIFICACION_01, NUM_ENVIOS_01, BAJA_01, FECHA_BAJA_01) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, suscriptor.getCodSuscriptor01(), suscriptor.getEmail01(),
				suscriptor.getPasswordHash01(), suscriptor.getIdioma01(), suscriptor.getCambioEmail01(),
				suscriptor.getFechaAlta01(), suscriptor.getFechaActivacion01(), suscriptor.getFechaModificacion01(),
				suscriptor.getNumEnvios01(), suscriptor.getBaja01(), suscriptor.getFechaBaja01());
		return suscriptor;
	}

	/**
	 * Updates a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	public Suscriptor update(Suscriptor suscriptor) {
		String query = "UPDATE SUSCRIPTOR SET EMAIL_01=?, PASSWORD_HASH_01=?, IDIOMA_01=?, CAMBIO_EMAIL_01=?, FECHA_ALTA_01=?, FECHA_ACTIVACION_01=?, FECHA_MODIFICACION_01=?, NUM_ENVIOS_01=?, BAJA_01=?, FECHA_BAJA_01=? WHERE COD_SUSCRIPTOR_01=?";
		this.jdbcTemplate.update(query, suscriptor.getEmail01(), suscriptor.getPasswordHash01(),
				suscriptor.getIdioma01(), suscriptor.getCambioEmail01(), suscriptor.getFechaAlta01(),
				suscriptor.getFechaActivacion01(), suscriptor.getFechaModificacion01(), suscriptor.getNumEnvios01(),
				suscriptor.getBaja01(), suscriptor.getFechaBaja01(), suscriptor.getCodSuscriptor01());
		return suscriptor;
	}

	/**
	 * Finds a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	@Transactional(readOnly = true)
	public Suscriptor find(Suscriptor suscriptor) {
		String query = "SELECT t1.COD_SUSCRIPTOR_01 CODSUSCRIPTOR01, t1.EMAIL_01 EMAIL01, t1.PASSWORD_HASH_01 PASSWORDHASH01, t1.IDIOMA_01 IDIOMA01, t1.CAMBIO_EMAIL_01 CAMBIOEMAIL01, t1.FECHA_ALTA_01 FECHAALTA01, t1.FECHA_ACTIVACION_01 FECHAACTIVACION01, t1.FECHA_MODIFICACION_01 FECHAMODIFICACION01, t1.NUM_ENVIOS_01 NUMENVIOS01, t1.BAJA_01 BAJA01, t1.FECHA_BAJA_01 FECHABAJA01 FROM SUSCRIPTOR t1  WHERE t1.COD_SUSCRIPTOR_01 = ?  ";

		List<Suscriptor> suscriptorList = this.jdbcTemplate.query(query, this.rwMap, suscriptor.getCodSuscriptor01());
		return (Suscriptor) DataAccessUtils.uniqueResult(suscriptorList);
	}

	/**
	 * Removes a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return
	 */
	public void remove(Suscriptor suscriptor) {
		String query = "DELETE FROM SUSCRIPTOR WHERE COD_SUSCRIPTOR_01=?";
		this.jdbcTemplate.update(query, suscriptor.getCodSuscriptor01());
	}

	/**
	 * Finds a list of rows in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Suscriptor>
	 */
	@Transactional(readOnly = true)
	public List<Suscriptor> findAll(Suscriptor suscriptor, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD_SUSCRIPTOR_01 CODSUSCRIPTOR01,t1.EMAIL_01 EMAIL01,t1.PASSWORD_HASH_01 PASSWORDHASH01,t1.IDIOMA_01 IDIOMA01,t1.CAMBIO_EMAIL_01 CAMBIOEMAIL01,t1.FECHA_ALTA_01 FECHAALTA01,t1.FECHA_ACTIVACION_01 FECHAACTIVACION01,t1.FECHA_MODIFICACION_01 FECHAMODIFICACION01,t1.NUM_ENVIOS_01 NUMENVIOS01,t1.BAJA_01 BAJA01,t1.FECHA_BAJA_01 FECHABAJA01 ");
		query.append(getFrom());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(suscriptor);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get(PARAMS);

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, SuscriptorDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Suscriptor>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Suscriptor table using like.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Suscriptor>
	 */
	@Transactional(readOnly = true)
	public List<Suscriptor> findAllLike(Suscriptor suscriptor, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.COD_SUSCRIPTOR_01 CODSUSCRIPTOR01,t1.EMAIL_01 EMAIL01,t1.PASSWORD_HASH_01 PASSWORDHASH01,t1.IDIOMA_01 IDIOMA01,t1.CAMBIO_EMAIL_01 CAMBIOEMAIL01,t1.FECHA_ALTA_01 FECHAALTA01,t1.FECHA_ACTIVACION_01 FECHAACTIVACION01,t1.FECHA_MODIFICACION_01 FECHAMODIFICACION01,t1.NUM_ENVIOS_01 NUMENVIOS01,t1.BAJA_01 BAJA01,t1.FECHA_BAJA_01 FECHABAJA01 ");
		query.append(getFrom());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(suscriptor, startsWith);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get(PARAMS);

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, SuscriptorDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Suscriptor>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Suscriptor suscriptor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SUSCRIPTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(suscriptor);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get(PARAMS);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the Suscriptor table using like.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Suscriptor suscriptor, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SUSCRIPTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(suscriptor, startsWith);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get(PARAMS);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of Suscriptor selected for rup_table
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Suscriptor>>
	 */
	@Override
	public List<TableRowDto<Suscriptor>> reorderSelection(Suscriptor suscriptor, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(getSelect());
		// FROM
		query.append(getFrom());
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(suscriptor, startsWith);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get(PARAMS);

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, Suscriptor.class,
				filterParamList, COD_SUSCRIPTOR_01);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Suscriptor>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Suscriptor
	 * @param searchParams
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Suscriptor>>
	 */
	@Override
	public List<TableRowDto<Suscriptor>> search(Suscriptor filterParams, Suscriptor searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(getSelect());
		// FROM
		query.append(getFrom());
		// TABLAS_ALIAS
		List<String> fromAlias = new ArrayList<String>();
		fromAlias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhereFilter.get(QUERY));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get(PARAMS);

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get(QUERY)).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get(PARAMS);

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, Suscriptor.class,
				filterParamList, searchSQL, searchParamList, fromAlias, COD_SUSCRIPTOR_01);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Suscriptor>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filtersuscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Suscriptor filtersuscriptor, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(getSelect());
		// FROM
		query.append(getFrom());

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtersuscriptor, startsWith);
		StringBuilder where = new StringBuilder(WHERE_1_1);
		where.append(mapaWhere.get(QUERY));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get(PARAMS);

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, Suscriptor.class,
				query, params, COD_SUSCRIPTOR_01);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Suscriptor entity
	 *
	 * @param suscriptor
	 *            Suscriptor Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Suscriptor suscriptor) {

		StringBuilder where = new StringBuilder(SuscriptorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (suscriptor != null && suscriptor.getCodSuscriptor01() != null) {
			where.append(" AND t1.COD_SUSCRIPTOR_01 = ?");
			params.add(suscriptor.getCodSuscriptor01());
		}
		if (suscriptor != null && suscriptor.getEmail01() != null) {
			where.append(" AND t1.EMAIL_01 = ?");
			params.add(suscriptor.getEmail01());
		}
		if (suscriptor != null && suscriptor.getPasswordHash01() != null) {
			where.append(" AND t1.PASSWORD_HASH_01 = ?");
			params.add(suscriptor.getPasswordHash01());
		}
		if (suscriptor != null && suscriptor.getIdioma01() != null) {
			where.append(" AND t1.IDIOMA_01 = ?");
			params.add(suscriptor.getIdioma01());
		}
		if (suscriptor != null && suscriptor.getCambioEmail01() != null) {
			where.append(" AND t1.CAMBIO_EMAIL_01 = ?");
			params.add(suscriptor.getCambioEmail01());
		}
		if (suscriptor != null && suscriptor.getFechaAlta01() != null) {
			where.append(" AND t1.FECHA_ALTA_01 = ?");
			params.add(suscriptor.getFechaAlta01());
		}
		if (suscriptor != null && suscriptor.getFechaActivacion01() != null) {
			where.append(" AND t1.FECHA_ACTIVACION_01 = ?");
			params.add(suscriptor.getFechaActivacion01());
		}
		if (suscriptor != null && suscriptor.getFechaModificacion01() != null) {
			where.append(" AND t1.FECHA_MODIFICACION_01 = ?");
			params.add(suscriptor.getFechaModificacion01());
		}
		if (suscriptor != null && suscriptor.getNumEnvios01() != null) {
			where.append(" AND t1.NUM_ENVIOS_01 = ?");
			params.add(suscriptor.getNumEnvios01());
		}
		if (suscriptor != null && suscriptor.getBaja01() != null) {
			where.append(" AND t1.BAJA_01 = ?");
			params.add(suscriptor.getBaja01());
		}
		if (suscriptor != null && suscriptor.getFechaBaja01() != null) {
			where.append(" AND t1.FECHA_BAJA_01 = ?");
			params.add(suscriptor.getFechaBaja01());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put(QUERY, where);
		mapWhere.put(PARAMS, params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Suscriptor entity
	 *
	 * @param suscriptor
	 *            Suscriptor Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Suscriptor suscriptor, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SuscriptorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (suscriptor != null && suscriptor.getCodSuscriptor01() != null) {
			where.append(" AND t1.COD_SUSCRIPTOR_01 = ?");
			params.add(suscriptor.getCodSuscriptor01());
		}
		if (suscriptor != null && suscriptor.getEmail01() != null) {
			where.append(" AND UPPER(t1.EMAIL_01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(suscriptor.getEmail01().toUpperCase() + "%");
			} else {
				params.add("%" + suscriptor.getEmail01().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL_01 IS NOT NULL");
		}
		if (suscriptor != null && suscriptor.getPasswordHash01() != null) {
			where.append(" AND UPPER(t1.PASSWORD_HASH_01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(suscriptor.getPasswordHash01().toUpperCase() + "%");
			} else {
				params.add("%" + suscriptor.getPasswordHash01().toUpperCase() + "%");
			}
			where.append(" AND t1.PASSWORD_HASH_01 IS NOT NULL");
		}
		if (suscriptor != null && suscriptor.getIdioma01() != null) {
			where.append(" AND UPPER(t1.IDIOMA_01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(suscriptor.getIdioma01().toUpperCase() + "%");
			} else {
				params.add("%" + suscriptor.getIdioma01().toUpperCase() + "%");
			}
			where.append(" AND t1.IDIOMA_01 IS NOT NULL");
		}
		if (suscriptor != null && suscriptor.getCambioEmail01() != null) {
			where.append(" AND UPPER(t1.CAMBIO_EMAIL_01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(suscriptor.getCambioEmail01().toUpperCase() + "%");
			} else {
				params.add("%" + suscriptor.getCambioEmail01().toUpperCase() + "%");
			}
			where.append(" AND t1.CAMBIO_EMAIL_01 IS NOT NULL");
		}
		if (suscriptor != null && suscriptor.getFechaAlta01() != null) {
			where.append(" AND t1.FECHA_ALTA_01 = ?");
			params.add(suscriptor.getFechaAlta01());
		}
		if (suscriptor != null && suscriptor.getFechaActivacion01() != null) {
			where.append(" AND t1.FECHA_ACTIVACION_01 = ?");
			params.add(suscriptor.getFechaActivacion01());
		}
		if (suscriptor != null && suscriptor.getFechaModificacion01() != null) {
			where.append(" AND t1.FECHA_MODIFICACION_01 = ?");
			params.add(suscriptor.getFechaModificacion01());
		}
		if (suscriptor != null && suscriptor.getNumEnvios01() != null) {
			where.append(" AND t1.NUM_ENVIOS_01 = ?");
			params.add(suscriptor.getNumEnvios01());
		}
		if (suscriptor != null && suscriptor.getBaja01() != null) {
			where.append(" AND UPPER(t1.BAJA_01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(suscriptor.getBaja01().toUpperCase() + "%");
			} else {
				params.add("%" + suscriptor.getBaja01().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA_01 IS NOT NULL");
		}
		if (suscriptor != null && suscriptor.getFechaBaja01() != null) {
			where.append(" AND t1.FECHA_BAJA_01 = ?");
			params.add(suscriptor.getFechaBaja01());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put(QUERY, where);
		mapWhere.put(PARAMS, params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private String getWhereComarcas(int i, List<String> comarcas) {
		StringBuilder whereComarcas = new StringBuilder();

		if (i == 0) {
			whereComarcas.append(" AND (((COD_TH_05 = ?  AND COD_COMARCA_05 IN ");
		} else {
			whereComarcas.append(" OR ((COD_TH_05 = ? AND COD_COMARCA_05 IN  ");
		}

		whereComarcas.append("('");
		for (int j = 0; j < comarcas.size() - 1; j++) {
			whereComarcas.append(comarcas.get(j) + "','");
		}
		whereComarcas.append(comarcas.get(comarcas.size() - 1) + "'))");
		whereComarcas.append(" OR ( COD_TH_03 = ? AND COD_SUSCRIPCION_03 NOT "
				+ " IN(SELECT COD_SUSCRIPCION_05 FROM AC09J05T00 T5 WHERE COD_TH_05 = ? ) ) ");

		whereComarcas.append(" ) ");
		return whereComarcas.toString();
	}

	private String getFrom() {
		return "FROM SUSCRIPTOR t1 ";
	}

	private String getSelect() {
		return "SELECT t1.COD_SUSCRIPTOR_01 CODSUSCRIPTOR01,t1.EMAIL_01 EMAIL01,t1.PASSWORD_HASH_01 PASSWORDHASH01,t1.IDIOMA_01 IDIOMA01,t1.CAMBIO_EMAIL_01 CAMBIOEMAIL01,t1.FECHA_ALTA_01 FECHAALTA01,t1.FECHA_ACTIVACION_01 FECHAACTIVACION01,t1.FECHA_MODIFICACION_01 FECHAMODIFICACION01,t1.NUM_ENVIOS_01 NUMENVIOS01,t1.BAJA_01 BAJA01,t1.FECHA_BAJA_01 FECHABAJA01 ";
	}

	@Override
	public List<Suscriptor> findSuscriptores(List<SuscriptorFilter> filterSuscriptores) {
		StringBuilder query = new StringBuilder();
		query.append(
				" SELECT DISTINCT(t1.COD_SUSCRIPTOR_01) CODSUSCRIPTOR01, t1.EMAIL_01 EMAIL01, t1.PASSWORD_HASH_01 PASSWORDHASH01, ");
		query.append("t1.IDIOMA_01 IDIOMA01, t1.CAMBIO_EMAIL_01 CAMBIOEMAIL01, t1.FECHA_ALTA_01 FECHAALTA01, ");
		query.append(
				"t1.FECHA_ACTIVACION_01 FECHAACTIVACION01,t1.FECHA_MODIFICACION_01 FECHAMODIFICACION01, t1.NUM_ENVIOS_01 NUMENVIOS01, ");
		query.append("t1.BAJA_01 BAJA01, t1.FECHA_BAJA_01 FECHABAJA01 ");

		StringBuilder from = new StringBuilder();
		from.append(" FROM AC09J01T00 T1 INNER JOIN AC09J03T00 T3 ");
		from.append(" ON T1.COD_SUSCRIPTOR_01 = T3.COD_SUSCRIPTOR_03 ");
		from.append(" INNER JOIN AC09J04T00 T4 ");
		from.append(" ON T3.COD_SUSCRIPCION_03 = T4.COD_SUSCRIPCION_04 ");
		from.append(" LEFT JOIN AC09J05T00 T5 ");
		from.append(" ON T3.COD_SUSCRIPCION_03 = T5.COD_SUSCRIPCION_05 ");

		query.append(from);

		int j = 0;
		List<Object> params = new ArrayList<Object>();

		for (SuscriptorFilter suscriptorFilter : filterSuscriptores) {

			StringBuilder where = new StringBuilder();
			if (j == 0 && suscriptorFilter.getIdTipoAviso() != Ac09jConstants.INT_ESPECIAL) {
				where.append(" WHERE (COD_TIPO_AVISO_04 = ? ");
				params.add(suscriptorFilter.getIdTipoAviso());
			} else if (j != 0 && suscriptorFilter.getIdTipoAviso() != Ac09jConstants.INT_ESPECIAL) {
				where.append(" OR (COD_TIPO_AVISO_04 = ? ");
				params.add(suscriptorFilter.getIdTipoAviso());
			}

			int i = 0;

			if (!suscriptorFilter.getProvinciasSinComarc().isEmpty()) {
				where.append(" AND ( COD_TH_03 IN  ");
				where.append("('");
				for (int k = 0; k < suscriptorFilter.getProvinciasSinComarc().size() - 1; k++) {
					where.append(suscriptorFilter.getProvinciasSinComarc().get(k) + "','");
				}
				where.append(suscriptorFilter.getProvinciasSinComarc()
						.get(suscriptorFilter.getProvinciasSinComarc().size() - 1) + "')");

				if (suscriptorFilter.getComarcasGipuzkoa().isEmpty() && !suscriptorFilter.getComarcasAraba().isEmpty()
						&& !suscriptorFilter.getComarcasBizkaia().isEmpty()) {
					where.append(" )");
				}
				i++;

			}

			if (!suscriptorFilter.getComarcasGipuzkoa().isEmpty()) {
				where.append(getWhereComarcas(i, suscriptorFilter.getComarcasGipuzkoa()));
				i++;
				params.add(Ac09jConstants.GIPUZKOA);
				params.add(Ac09jConstants.GIPUZKOA);
				params.add(Ac09jConstants.GIPUZKOA);
			}
			if (!suscriptorFilter.getComarcasAraba().isEmpty()) {
				where.append(getWhereComarcas(i, suscriptorFilter.getComarcasAraba()));
				i++;
				params.add(Ac09jConstants.ARABA);
				params.add(Ac09jConstants.ARABA);
				params.add(Ac09jConstants.ARABA);
			}
			if (!suscriptorFilter.getComarcasBizkaia().isEmpty()) {
				where.append(getWhereComarcas(i, suscriptorFilter.getComarcasBizkaia()));
				i++;
				params.add(Ac09jConstants.BIZKAIA);
				params.add(Ac09jConstants.BIZKAIA);
				params.add(Ac09jConstants.BIZKAIA);
			}

			where.append(" OR COD_TH_03 = ' ') ");
			if (suscriptorFilter.getIdTipoAviso() != Ac09jConstants.INT_ESPECIAL) {
				where.append(" ) ");
			}
			query.append(where);

			j++;
		}

		query.append("AND BAJA_01 = ? ");
		params.add(Ac09jConstants.ALTA);

		return this.jdbcTemplate.query(query.toString(), params.toArray(), this.rwMap);
	}

	@Override
	public void addNumEnvios(Suscriptor suscriptorEnvio) {

		String query = "UPDATE SUSCRIPTOR SET  NUM_ENVIOS_01=NUM_ENVIOS_01 +1 WHERE COD_SUSCRIPTOR_01=?";
		this.jdbcTemplate.update(query, suscriptorEnvio.getCodSuscriptor01());

	}
}
