package com.ejie.ac09j.dao;

import java.util.List;

import com.ejie.ac09j.model.Suscriptor;
import com.ejie.ac09j.model.SuscriptorFilter;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SuscriptorDao  
 * 
 *  
 */

public interface SuscriptorDao {

	/**
	 * Inserts a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	Suscriptor add(Suscriptor suscriptor);

	/**
	 * Updates a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	Suscriptor update(Suscriptor suscriptor);

	/**
	 * Finds a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Suscriptor
	 */
	Suscriptor find(Suscriptor suscriptor);

	/**
	 * Removes a single row in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 */
	void remove(Suscriptor suscriptor);

	/**
	 * Finds a List of rows in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Suscriptor> findAll(Suscriptor suscriptor, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Suscriptor table using like.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Suscriptor> findAllLike(Suscriptor suscriptor, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Suscriptor table.
	 *
	 * @param filterSuscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Suscriptor filterSuscriptor, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Suscriptor table using like.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Suscriptor suscriptor, Boolean startsWith);

	/**
	 * Counts rows in the Suscriptor table.
	 *
	 * @param suscriptor
	 *            Suscriptor
	 * @return Long
	 */
	Long findAllCount(Suscriptor suscriptor);

	/**
	 * Reorder selection.
	 *
	 * @param filterSuscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Suscriptor>>
	 */
	List<TableRowDto<Suscriptor>> reorderSelection(Suscriptor filterSuscriptor, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterSuscriptor
	 *            Suscriptor
	 * @param searchSuscriptor
	 *            Suscriptor
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Suscriptor>>
	 */
	List<TableRowDto<Suscriptor>> search(Suscriptor filterSuscriptor, Suscriptor searchSuscriptor,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * 
	 * @param filterSuscriptores
	 * @return
	 */
	List<Suscriptor> findSuscriptores(List<SuscriptorFilter> filterSuscriptores);

	/**
	 * 
	 * @param suscriptorEnvio
	 */
	void addNumEnvios(Suscriptor suscriptorEnvio);
}
