package com.ejie.ac09j.common;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 * <p>
 * Clase abstracta con funciones para tratar secuencias
 * </p>
 * 
 *  
 * 
 */
public abstract class SequenceUtils {

	private SequenceUtils() {
		// creates a new SequenceUtils
	}

	/**
	 * <p>
	 * Incrementa la secuencia pasada en el par&aacute;metro
	 * <code>sequenceName</code> y devuelve el valor tomado
	 * </p>
	 * 
	 * @param jdbcTemplate
	 *            Conexi&oacute;n con la base de datos
	 * @param sequenceName
	 *            Nombre de la secuencia
	 * @return Siguiente valor de la secuencia
	 */
	public static Long getNextSequenceValue(final JdbcTemplate jdbcTemplate, final String sequenceName) {

		String sequenceQuery = "SELECT " + sequenceName + ".nextval FROM dual";

		return jdbcTemplate.queryForObject(sequenceQuery, Long.class);

	}

	/**
	 * <p>
	 * Devuelve el valor actual de la secuencia pasada en el par&aacute;metro
	 * <code>sequenceName</code>
	 * </p>
	 * 
	 * @param jdbcTemplate
	 *            Conexi&oacute;n con la base de datos
	 * @param sequenceName
	 *            Nombre de la secuencia
	 * @return Valor actual de la secuencia
	 */
	public static Long getCurrSequenceValue(final JdbcTemplate jdbcTemplate, final String sequenceName) {

		String sequenceQuery = "SELECT " + sequenceName + ".currval FROM dual";

		return jdbcTemplate.queryForObject(sequenceQuery, Long.class);

	}
}
