clear

##------------------------------------------------------------------
## Obtencion de fecha y hora actuales
##------------------------------------------------------------------
DATE="`date +%Y%m%d`"
TIME="`date +%H%M%S`"

# -------------------------------------------
# INICIALIZAR VARIABLES
# -------------------------------------------

# Directorio para los logs
DIR_LOGS=/datos/ac09j/log
# Nombre del fichero de log
NOMBRE_FICHERO_LOGS=AC09J_INIT_${DATE}_${TIME}
# Path del fichero de log
FICHERO_LOGS=$DIR_LOGS/$NOMBRE_FICHERO_LOGS.log

# -------------------------------------------
# INICIALIZAR VARIABLES
# -------------------------------------------
# Directorio para los scripts
export DIR_SCRIPTS=/aplic/ac09j/scripts


# ------------------------------------------------------------------
# Trazas de cabecera de ejecucion del script
# ------------------------------------------------------------------

echo "\nComienzo del script para la version v1.0.1 `date +"%d/%m/%Y %T"`\n\n" | tee -a $FICHERO_LOGS


# ------------------------------------------------------------------
# Comprobar el objeto de seguridad
# ------------------------------------------------------------------

. /aplic/n38/cade/n38bd 35237 01 STRING  

STAT=$?
if [ $STAT != 0 ]; then
   echo "El objeto de seguridad no es válido." | tee -a $FICHERO_LOGS
   read resp
   exit 1
else
   HOST=`echo $STRING |cut -d '#' -f1`
   USUARIO=`echo $STRING |cut -d '#' -f2`
   PASSWORD=`echo $STRING |cut -d '#' -f3`
fi


# ------------------------------------------------------------------
# Inicio de la funcionalidad del script
# ------------------------------------------------------------------

# ---------------------
# TABLAS
# ---------------------

echo "\Script de la v1.0.1..." | tee -a $FICHERO_LOGS

sqlplus -s $USUARIO/$PASSWORD @$DIR_SCRIPTS/AC09J_20190311.sql | tee -a $FICHERO_LOGS

if [ $? !=  0 ];
then 
	echo "\nERROR, proceso detenido mientras se ejecutaba el script de la v1.0.1" | tee -a $FICHERO_LOGS

	echo "\n\n****************************************************************" | tee -a $FICHERO_LOGS
	echo "* EL SCRIPT DE INICIALIZACIÓN DE LA V1.0.1 HA FINALIZADO CON ERROR" | tee -a $FICHERO_LOGS
	echo "****************************************************************\n\n" | tee -a $FICHERO_LOGS

	exit 1;
fi            
if [ $? =  0 ];
then 
	echo "\nOK, script de inicialización de la v1.0.1" | tee -a $FICHERO_LOGS

	echo "\n\n****************************************************************" | tee -a $FICHERO_LOGS
	echo "* EL SCRIPT DE INICIALIZACIÓN DE LA V1.0.1 HA FINALIZADO CON ERROR" | tee -a $FICHERO_LOGS
	echo "****************************************************************\n\n" | tee -a $FICHERO_LOGS
fi

exit 0;