-------------------------------------------------------------------------------------------------------------------------------------
-- @description	SCRIPT DE CREACION DE TABLAS 
--  
-- @date		07/11/2018
-------------------------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------------------------
-- SUSCRIPTOR
-------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE AC09J01T00
(
	 COD_SUSCRIPTOR_01		NUMBER(5) NOT NULL
	,EMAIL_01				VARCHAR2(250) NOT NULL
	,PASSWORD_HASH_01		VARCHAR2(500)
	,IDIOMA_01				VARCHAR2(1) NOT NULL
	,CAMBIO_EMAIL_01		VARCHAR2(250)
	,FECHA_ALTA_01			DATE NOT NULL
	,FECHA_ACTIVACION_01	DATE
	,FECHA_MODIFICACION_01	DATE
	,NUM_ENVIOS_01			NUMBER(2) NOT NULL
	,BAJA_01				VARCHAR2(1) DEFAULT 'A' NOT NULL
	,FECHA_BAJA_01			DATE
)
TABLESPACE AC0901E00;

COMMENT ON TABLE AC09J01T00 IS 
	'Tabla de suscriptores dados de alta';
COMMENT ON COLUMN AC09J01T00.COD_SUSCRIPTOR_01 IS 
	'Codigo interno del suscriptor';
COMMENT ON COLUMN AC09J01T00.EMAIL_01 IS 
	'Dirección de correo electrónico';
COMMENT ON COLUMN AC09J01T00.PASSWORD_HASH_01 IS 
	'Hash de la contraseña del usuario';
COMMENT ON COLUMN AC09J01T00.IDIOMA_01 IS 
	'Idioma elegido por el usuario para las comunicaciones por email';
COMMENT ON COLUMN AC09J01T00.CAMBIO_EMAIL_01 IS 
	'Email provisional para cambio pendiente de verificación';
COMMENT ON COLUMN AC09J01T00.FECHA_ALTA_01 IS 
	'Fecha de alta del suscriptor';
COMMENT ON COLUMN AC09J01T00.FECHA_ACTIVACION_01 IS 
	'Fecha de activación de la cuenta del suscriptor';
COMMENT ON COLUMN AC09J01T00.FECHA_MODIFICACION_01 IS 
	'Última fecha de modificación de la cuenta del suscriptor';
COMMENT ON COLUMN AC09J01T00.NUM_ENVIOS_01 IS 
	'Numero de comunicaciones enviadas al suscriptor hasta la fecha';
	

-------------------------------------------------------------------------------------------------------------------------------------
-- TIPO_AVISO
-------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE AC09J02T00
(
	 COD_TIPO_AVISO_02	NUMBER(2) NOT NULL
	,DESC_ES_02			VARCHAR2(50) NOT NULL
	,DESC_EU_02			VARCHAR2(50) NOT NULL
	,AYUDA_ES_02		VARCHAR2(500) NOT NULL
	,AYUDA_EU_02		VARCHAR2(500) NOT NULL
)
TABLESPACE AC0901E00;

COMMENT ON TABLE AC09J02T00 IS 
	'Tabla de suscriptores dados de alta';
COMMENT ON COLUMN AC09J02T00.COD_TIPO_AVISO_02 IS 
	'Codigo interno del tipo de aviso';
COMMENT ON COLUMN AC09J02T00.DESC_ES_02 IS 
	'Nombre del tipo de aviso en castellano';
COMMENT ON COLUMN AC09J02T00.DESC_EU_02 IS 
	'Nombre del tipo de aviso en euskera';
COMMENT ON COLUMN AC09J02T00.AYUDA_ES_02 IS 
	'Texto de ayuda acerca del tipo de aviso en castellano';
COMMENT ON COLUMN AC09J02T00.AYUDA_EU_02 IS 
	'Texto de ayuda acerca del tipo de aviso en euskera';


-------------------------------------------------------------------------------------------------------------------------------------
-- SUSCRIPCION
-------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE AC09J03T00
(
	 COD_SUSCRIPCION_03		NUMBER(6) NOT NULL
	,COD_SUSCRIPTOR_03		NUMBER(5) NOT NULL
	,COD_TH_03				VARCHAR2(3)
	,FECHA_ALTA_03			VARCHAR2(500) NOT NULL
	,FECHA_MODIFICACION_03	VARCHAR2(500)
)
TABLESPACE AC0901E00;

COMMENT ON TABLE AC09J03T00 IS 
	'Tabla con las suscripciones realizadas por los suscriptores';
COMMENT ON COLUMN AC09J03T00.COD_SUSCRIPCION_03 IS 
	'Codigo interno de la suscripción';
COMMENT ON COLUMN AC09J03T00.COD_SUSCRIPTOR_03 IS 
	'Código interno del suscriptor al que pertenece la suscripción';
COMMENT ON COLUMN AC09J03T00.COD_TH_03 IS 
	'Código de la entidad de NORA de PROVINCIA';
COMMENT ON COLUMN AC09J03T00.FECHA_ALTA_03 IS 
	'Fecha en la que se creó la suscripción';
COMMENT ON COLUMN AC09J03T00.FECHA_MODIFICACION_03 IS 
	'Fecha de última modificación de la suscripción';


-------------------------------------------------------------------------------------------------------------------------------------
-- REL_SUSCRIPCION_TIPO_AVISO
-------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE AC09J04T00
(
	 COD_REL_SUS_TIPO_04	NUMBER(7) NOT NULL
	,COD_SUSCRIPCION_04		NUMBER(5) NOT NULL
	,COD_TIPO_AVISO_04		NUMBER(2) NOT NULL
)
TABLESPACE AC0901E00;

COMMENT ON TABLE AC09J04T00 IS 
	'Tabla con las relaciones entre las suscripciones y los tipos de aviso';
COMMENT ON COLUMN AC09J04T00.COD_REL_SUS_TIPO_04 IS 
	'Codigo interno de la relación';
COMMENT ON COLUMN AC09J04T00.COD_SUSCRIPCION_04 IS 
	'Código interno de la suscripción';
COMMENT ON COLUMN AC09J04T00.COD_TIPO_AVISO_04 IS 
	'Código interno del tipo de aviso';


-------------------------------------------------------------------------------------------------------------------------------------
-- REL_SUSCRIPCION_COMARCA
-------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE AC09J05T00
(
	 COD_REL_SUS_COMA_05	NUMBER(7) NOT NULL
	,COD_SUSCRIPCION_05		NUMBER(5) NOT NULL
	,COD_TH_05				VARCHAR2(2) NOT NULL
	,COD_COMARCA_05			VARCHAR2(2) NOT NULL
)
TABLESPACE AC0901E00;

COMMENT ON TABLE AC09J05T00 IS 
	'Tabla con las relaciones entre las suscripciones y comarcas';
COMMENT ON COLUMN AC09J05T00.COD_REL_SUS_COMA_05 IS 
	'Codigo interno de la relación';
COMMENT ON COLUMN AC09J05T00.COD_SUSCRIPCION_05 IS 
	'Código interno de la suscripción';
COMMENT ON COLUMN AC09J05T00.COD_COMARCA_05 IS 
	'Código interno de la comarca';


-------------------------------------------------------------------------------------------------------------------------------------
--  CREATE PRIMARY KEY CONSTRAINTS 
-------------------------------------------------------------------------------------------------------------------------------------

ALTER TABLE AC09J01T00 ADD CONSTRAINT PK_AC09J01T00 PRIMARY KEY (COD_SUSCRIPTOR_01);
ALTER INDEX PK_AC09J01T00 REBUILD TABLESPACE AC0902E00;

ALTER TABLE AC09J02T00 ADD CONSTRAINT PK_AC09J02T00 PRIMARY KEY (COD_TIPO_AVISO_02);
ALTER INDEX PK_AC09J02T00 REBUILD TABLESPACE AC0902E00;

ALTER TABLE AC09J03T00 ADD CONSTRAINT PK_AC09J03T00 PRIMARY KEY (COD_SUSCRIPCION_03);
ALTER INDEX PK_AC09J03T00 REBUILD TABLESPACE AC0902E00;

ALTER TABLE AC09J04T00 ADD CONSTRAINT PK_AC09J04T00 PRIMARY KEY (COD_REL_SUS_TIPO_04);
ALTER INDEX PK_AC09J04T00 REBUILD TABLESPACE AC0902E00;

ALTER TABLE AC09J05T00 ADD CONSTRAINT PK_AC09J05T00 PRIMARY KEY (COD_REL_SUS_COMA_05);
ALTER INDEX PK_AC09J05T00 REBUILD TABLESPACE AC0902E00;


-------------------------------------------------------------------------------------------------------------------------------------
--  CREATE FOREIGN KEY CONSTRAINTS 
-------------------------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------------------------
-- A TABLA 		AC09J01T00	/	SUSCRIPTOR
-------------------------------------------------------------------------------------------------------------------------------------
ALTER TABLE AC09J03T00 ADD CONSTRAINT FK_AC09J03T00_01 FOREIGN KEY (COD_SUSCRIPTOR_03)
REFERENCES AC09J01T00 (COD_SUSCRIPTOR_01);

-------------------------------------------------------------------------------------------------------------------------------------
-- A TABLA 		AC09J02T00	/	TIPO_AVISO
-------------------------------------------------------------------------------------------------------------------------------------
ALTER TABLE AC09J04T00 ADD CONSTRAINT FK_AC09J04T00_02 FOREIGN KEY (COD_TIPO_AVISO_04)
REFERENCES AC09J02T00 (COD_TIPO_AVISO_02);

-------------------------------------------------------------------------------------------------------------------------------------
-- A TABLA 		AC09J03T00	/	SUSCRIPCION
-------------------------------------------------------------------------------------------------------------------------------------
ALTER TABLE AC09J04T00 ADD CONSTRAINT FK_AC09J04T00_04 FOREIGN KEY (COD_SUSCRIPCION_04)
REFERENCES AC09J03T00 (COD_SUSCRIPCION_03);

ALTER TABLE AC09J05T00 ADD CONSTRAINT FK_AC09J05T00_04 FOREIGN KEY (COD_SUSCRIPCION_05)
REFERENCES AC09J03T00 (COD_SUSCRIPCION_03);


-------------------------------------------------------------------------------------------------------------------------------------
--  CREATE UNIQUE CONSTRAINTS 
-------------------------------------------------------------------------------------------------------------------------------------

ALTER TABLE AC09J01T00 ADD CONSTRAINT UK_AC09J01T00_EMAIL UNIQUE (EMAIL_01);
ALTER TABLE AC09J04T00 ADD CONSTRAINT UK_AC09J04T00_TIPO UNIQUE (COD_SUSCRIPCION_04,  COD_TIPO_AVISO_04);
ALTER TABLE AC09J05T00 ADD CONSTRAINT UK_AC09J05T00_TIPO UNIQUE (COD_SUSCRIPCION_05,  COD_TH_05,  COD_COMARCA_05);


-------------------------------------------------------------------------------------------------------------------------------------
--  CREATE SEQUENCES 
-------------------------------------------------------------------------------------------------------------------------------------

CREATE SEQUENCE SEC_SUSCRIPTOR 					MINVALUE 1 MAXVALUE 99999		INCREMENT BY 1 START WITH 1 NOCACHE ORDER  ;
CREATE SEQUENCE SEC_TIPO_AVISO 					MINVALUE 1 MAXVALUE 99				INCREMENT BY 1 START WITH 1 NOCACHE ORDER  ;
CREATE SEQUENCE SEC_SUSCRIPCION 				MINVALUE 1 MAXVALUE 999999		INCREMENT BY 1 START WITH 1 NOCACHE ORDER  ;
CREATE SEQUENCE SEC_REL_SUSCRIPCION_TIPO_AVISO 	MINVALUE 1 MAXVALUE 9999999	INCREMENT BY 1 START WITH 1 NOCACHE ORDER  ;
CREATE SEQUENCE SEC_REL_SUSCRIPCION_COMARCA		MINVALUE 1 MAXVALUE 9999999	INCREMENT BY 1 START WITH 1 NOCACHE ORDER  ;


-------------------------------------------------------------------------------------------------------------------------------------
--  SYNONYMS 
-------------------------------------------------------------------------------------------------------------------------------------

-- Sinonimos internos
CREATE OR REPLACE SYNONYM SUSCRIPTOR					FOR AC09J01T00;
CREATE OR REPLACE SYNONYM TIPO_AVISO					FOR AC09J02T00;
CREATE OR REPLACE SYNONYM SUSCRIPCION					FOR AC09J03T00;
CREATE OR REPLACE SYNONYM REL_SUSCRIPCION_TIPO_AVISO	FOR AC09J04T00;
CREATE OR REPLACE SYNONYM REL_SUSCRIPCION_COMARCA		FOR AC09J05T00;

-- Sinonimos externos
CREATE OR REPLACE SYNONYM PROVINCIA 	FOR T17I.T17_PROVINCIA;
CREATE OR REPLACE SYNONYM COMARCA 		FOR T17I.T17_COMARCA;


-------------------------------------------------------------------------------------------------------------------------------------
--  POPULATE TABLES 
-------------------------------------------------------------------------------------------------------------------------------------
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Mar', 'Itsasoa', '???_es', '???_eu');
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Temperaturas altas', 'Tenperatura altuak', '???_es', '???_eu');
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Temperaturas mínimas', 'Itsasoa', '???_es', '???_eu' );
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Nieve', 'Elurra', '???_es', '???_eu');
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Lluvia', 'Euria', '???_es', '???_eu');
INSERT INTO AC09J02T00 VALUES (SEC_TIPO_AVISO.NEXTVAL, 'Viento', 'Haizea', '???_es', '???_eu');


-------------------------------------------------------------------------------------------------------------------------------------
--  GRANTS 
-------------------------------------------------------------------------------------------------------------------------------------
GRANT ALL ON "AC09J".AC09J01T00 TO AC09A ;
GRANT ALL ON "AC09J".AC09J02T00 TO AC09A ;
GRANT ALL ON "AC09J".AC09J03T00 TO AC09A ;
GRANT ALL ON "AC09J".AC09J04T00 TO AC09A ;
GRANT ALL ON "AC09J".AC09J05T00 TO AC09A ;

GRANT SELECT ON  "AC09J".SEC_SUSCRIPTOR TO AC09A ;
GRANT SELECT ON  "AC09J".SEC_TIPO_AVISO TO AC09A ;
GRANT SELECT ON  "AC09J".SEC_SUSCRIPCION TO AC09A ;
GRANT SELECT ON  "AC09J".SEC_REL_SUSCRIPCION_TIPO_AVISO TO AC09A ;
GRANT SELECT ON  "AC09J".SEC_REL_SUSCRIPCION_COMARCA TO AC09A ;


-------------------------------------------------------------------------------------------------------------------------------------	
COMMIT;

EXIT;