clear

##------------------------------------------------------------------
## Obtencion de fecha y hora actuales
##------------------------------------------------------------------
DATE="`date +%Y%m%d`"
TIME="`date +%H%M%S`"

# -------------------------------------------
# INICIALIZAR VARIABLES
# -------------------------------------------

# Directorio para los logs
DIR_LOGS=/datos/ac09j/log
# Nombre del fichero de log
NOMBRE_FICHERO_LOGS=AC09J_INIT_BACK_${DATE}_${TIME}
# Path del fichero de log
FICHERO_LOGS=$DIR_LOGS/$NOMBRE_FICHERO_LOGS.log

# -------------------------------------------
# INICIALIZAR VARIABLES
# -------------------------------------------
# Directorio para los scripts
export DIR_SCRIPTS=/aplic/ac09j/scripts


# ------------------------------------------------------------------
# Trazas de cabecera de ejecucion del script
# ------------------------------------------------------------------

echo "\nComienzo del script para la version v3.3.1 `date +"%d/%m/%Y %T"`\n\n" | tee -a $FICHERO_LOGS


# ------------------------------------------------------------------
# Comprobar el objeto de seguridad
# ------------------------------------------------------------------

. /aplic/n38/cade/n38bd 35237 01 STRING  

STAT=$?
if [ $STAT != 0 ]; then
   echo "El objeto de seguridad no es válido." | tee -a $FICHERO_LOGS
   read resp
   exit 1
else
   HOST=`echo $STRING |cut -d '#' -f1`
   USUARIO=`echo $STRING |cut -d '#' -f2`
   PASSWORD=`echo $STRING |cut -d '#' -f3`
fi


# ------------------------------------------------------------------
# Inicio de la funcionalidad del script
# ------------------------------------------------------------------

# ---------------------
# TABLAS
# ---------------------

echo "\Script de inicialización de la BDD..." | tee -a $FICHERO_LOGS

sqlplus -s $USUARIO/$PASSWORD @$DIR_SCRIPTS/AC09J_INIT_BACK.sql | tee -a $FICHERO_LOGS

if [ $? !=  0 ];
then 
	echo "\nTABLES ERROR, proceso detenido mientras se ejecutaba el script de inicialización de la BDD" | tee -a $FICHERO_LOGS

	echo "\n\n****************************************************************" | tee -a $FICHERO_LOGS
	echo "* EL SCRIPT DE INICIALIZACIÓN DE LA BDD HA FINALIZADO CON ERROR" | tee -a $FICHERO_LOGS
	echo "****************************************************************\n\n" | tee -a $FICHERO_LOGS

	exit 1;
fi            
if [ $? =  0 ];
then 
	echo "\nTABLES OK, script de inicialización de la BDD" | tee -a $FICHERO_LOGS

	echo "\n\n****************************************************************" | tee -a $FICHERO_LOGS
	echo "* EL SCRIPT DE INICIALIZACIÓN DE LA BDD HA FINALIZADO CON ERROR" | tee -a $FICHERO_LOGS
	echo "****************************************************************\n\n" | tee -a $FICHERO_LOGS
fi

exit 0;