jQuery(function($){
	$("#zonas_filter_div").toggle();
	$("#GRID_zonas").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../zonas",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idzona",
		ondblClickRow : fncDetalleZona,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
			$.rup.i18n.app.GRID_cabeceras.dRed,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "idzona",
				label: "idzona",
				index: "idzona",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "czona",
				label: "czona",
				index: "czona",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "ezona",
				label: "ezona",
				index: "ezona",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "rzona",
				label: "rzona",
				index: "rzona",
				width: "50",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#zonas").rup_maint({
		jQueryGrid: "GRID_zonas",
		primaryKey: "idzona",
		modelObject: "zonas",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [/*{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoZona
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleZona
						}*/
	
					]
			}
				
	});
	
	$("#rup-maint_toolbar-zonas").hide();
/*DIÁLOGO NUEVO ZONA INI*/
	
	var ventanaDialogoNuevoZona= $("#dialogoEditarZona").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoZona",
		modal: true,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.nuevo.zona,
		close: function(event, ui) { $("#GRID_zonas").rup_grid("reloadGrid"); }	
	});
	
	function nuevoZona() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../zonas/nuevo';
		document.getElementById("iframeEditarZona").src = ventanaIFrame;
		$("#dialogoEditarZona").rup_dialog("open");
	}
	
	function cerrarIFrameNuevoZona() {
		if ($("#dialogoEditarZona").rup_dialog('isOpen')) {
			$("#dialogoEditarZona").rup_dialog('close');
			document.getElementById("iframeEditarZona").src = '';
		}
	}
	
	$("#iframeNuevoZona").load(function (){ ;});	
	/*DIÁLOGO NUEVO Zona FIN*/
	
	/* DIALOGO DETALLE */
	function fncDetalleZona() {
	
		var ventanaDialogoDetalleZona = $("#dialogoEditarZona").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detalleZona",
			modal: true,
			resizable: false,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Zona,
			close: function(event, ui) { $("#GRID_zonas").rup_grid("reloadGrid"); }		
		});
		
		 var id= $("#GRID_zonas").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_zonas").rup_grid('getRowData',id); 
		 var idZona =ret.idzona;	 
		 var ventanaIFrame ="../zonas/modificar?idZona="+idZona;
	
		  document.getElementById("iframeEditarZona").src = ventanaIFrame;
			$("#dialogoEditarZona").rup_dialog("open");
		
		  $("#iframeEditarZona").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_zonas").unbind("click");
	$("#clean_search_zonas").bind("click",limpiarFormBusqueda);
	
	$("#zonas").rup_maint("search");

});

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	
	$("#zonas").rup_maint("cleanSearchForm");
	$("#zonas").rup_maint("search");

}

function ocultarBusqueda(){
	
	$("#zonas_filter_div").toggle("slow",function(){
		
	});
}