jQuery(function($){
	$("#usuarios_filter_div").toggle();
	$("#GRID_usuarios").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../usuarios",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "uidPer",
		ondblClickRow : fncDetalleUsuario,
		colNames: [
		    $.rup.i18n.app.mensajesUsuarios.uidPer,
			$.rup.i18n.app.nuevo.nombre,
			$.rup.i18n.app.mensajesUsuarios.responsable,
			$.rup.i18n.app.mensajesServicio.servicio,
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "uidPer",
				label: "uidPer",
				index: "uidPer",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "nombre",
				label: "nombre",
				index: "nombre",
				width: "200",
				editable: true,
				edittype: "text"
			},
			{ name: "responsable",
				label: "responsable",
				index: "responsable",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "servicio." + obtenerIdioma() + "servicio",
				label: "servicio." + obtenerIdioma() + "servicio",
				index: obtenerIdioma() + "servicio",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "50",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#usuarios").rup_maint({
		jQueryGrid: "GRID_usuarios",
		primaryKey: "uidPer",
		modelObject: "Usuario",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoUsuario
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleUsuario
						}
					]
			}
	});

	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_usuarios").unbind("click");
	$("#clean_search_usuarios").bind("click",limpiarFormBusqueda);
	
	$("#usuarios").rup_maint("search");
	
});

function limpiarFormBusqueda() {
	$("#responsable_search").prop('checked', false);
	$("#baja_search").prop('checked', false);
	
	$("#usuarios").rup_maint("cleanSearchForm");
	$("#usuarios").rup_maint("search");
}
function nuevoUsuario() {
	window.location = "/aa20bMaqPartesWar/usuarios/nuevo";	
}
	
function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}
function activarCheckResp(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? 1 : 0);
	});
}
function fncDetalleUsuario() {
	var id= $("#GRID_usuarios").rup_grid('getGridParam','selrow');
	 //alert(id);
	 var ret = $("#GRID_usuarios").rup_grid('getRowData',id); 
	 var idUsuario =ret.uidPer;
	 
	    // enviamos el form alternativo con el idUsuario para la busqueda
		buscaUsuarioForm.idUsuarioBusc.value = idUsuario;
		buscaUsuarioForm.submit();
	return false; 		
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}
function ocultarBusqueda(){
	
	$("#usuarios_filter_div").toggle("slow",function(){
		
	});
}
