jQuery(function($){
	$("#tecnicosEdificios_filter_div").toggle();
	$("#GRID_tecnicosEdificios").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../tecnicoedif",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idtecnico",
		ondblClickRow : fncDetalleTecnico,
		colNames: [
		    "idtecnico",		           
		    "idedificio",		           
		    $.rup.i18n.app.mensajesTecnicos.nombre,
		    $.rup.i18n.app.mensajesTecnicos.edificio,
		    $.rup.i18n.app.mensajesTecnicos.edificio,
		    $.rup.i18n.app.nuevo.zona,
		    $.rup.i18n.app.nuevo.zona,
		    $.rup.i18n.app.mensajesTecnicos.baja
		],
		colModel: [
			{ name: "idtecnico",
				label: "idtecnico",
				index: "idtecnico",
				width: "40",
				editable: true,
				hidden: true
			},
			{ name: "idedificio",
				label: "idedificio",
				index: "idedificio",
				width: "40",
				editable: true,
				hidden: true
			},
			{ name: "nombre",
				label: "nombre",
				index: "nombre",
				width: "40",
				editable: true,
				hidden: false
			},
			{ name: "cedificio",
				label: "cedificio",
				index: "cedificio",
				width: "40",
				editable: true,
				hidden: false,
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "eedificio",
				label: "eedificio",
				index: "eedificio",
				width: "40",
				editable: true,
				hidden: false,
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "zona.czona",
				label: "zona.czona",
				index: "czona",
				width: "40",
				editable: true,
				hidden: false,
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "zona.ezona",
				label: "zona.ezona",
				index: "czona",
				width: "40",
				editable: true,
				hidden: false,
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: true,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#tecnicosEdificios").rup_maint({
		jQueryGrid: "GRID_tecnicosEdificios",
		primaryKey: "idtecnico,idedificio",
		modelObject: "TecnicoEdif",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [
					{obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleTecnico
						}
	
					]
			}
	});
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_tecnicosEdificios").unbind("click");
	$("#clean_search_tecnicosEdificios").bind("click",limpiarFormBusqueda);
	
	$("#tecnicosEdificios").rup_maint("search");
});

function fncDetalleTecnico(){
	var id= $("#GRID_tecnicosEdificios").rup_grid('getGridParam','selrow');
	 var ret = $("#GRID_tecnicosEdificios").rup_grid('getRowData',id); 
	 if($("#nombre_search").val()!=""){
		 var idTecnico =ret.idtecnico;
		 
		    // enviamos el form alternativo con el idTecnico para la busqueda
			buscaTecnicoForm.idTecnicoBusc.value = idTecnico;
			buscaTecnicoForm.submit();
	}else {
		 var idEdificio =ret.idedificio;
		 
		    // enviamos el form alternativo con el idEdificio para la busqueda
		 buscaEdificioForm.idEdificioBusc.value = idEdificio;
		 buscaEdificioForm.submit();
	}
	return false; 		
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	
	$("#tecnicosEdificios").rup_maint("cleanSearchForm");
	$("#tecnicosEdificios").rup_maint("search");
}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function ocultarBusqueda(){
	
	$("#tecnicosEdificios_filter_div").toggle("slow",function(){
		
	});
}