jQuery(function($){
	$("#tecnicos_filter_div").toggle();
	$("#GRID_tecnicos").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../tecnicos",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idtecnico",
		ondblClickRow : fncDetalleTecnico,
		colNames: [
		    "idtecnico",		           
		    $.rup.i18n.app.nuevo.nombre,
		    $.rup.i18n.app.mensajesServicio.servicio,
			$.rup.i18n.app.mensajesTecnicos.telefo,
		    $.rup.i18n.app.mensajesTecnicos.mail,
		    $.rup.i18n.app.mensajesTecnicos.baja,
		    $.rup.i18n.app.mensajesTecnicos.tecnicoContrata,
		    $.rup.i18n.app.mensajesTecnicos.movilgmao
		],
		colModel: [
			{ name: "idtecnico",
				label: "idtecnico",
				index: "idtecnico",
				width: "400",
				editable: true,
				hidden: true
			},
			{ name: "nombre",
				label: "nombre",
				index: "nombre",
				width: "200",
				editable: true,
				edittype: "text"
			},
			{ name: "servicio." + obtenerIdioma() + "servicio",
				label: "servicio." + obtenerIdioma() + "servicio",
				index: obtenerIdioma() + "servicio",
				width: "200",
				editable: true,
				edittype: "text"
			},
			{ name: "telefo",
				label: "telefo",
				index: "telefo",
				width: "75",
				editable: true,
				edittype: "text"
			},
			{ name: "mail",
				label: "mail",
				index: "mail",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: true,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "tecnicoContrata",
				label: "tecnicoContrata",
				index: "tecnicoContrata",
				width: "60",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{
				name:"movilgmao",
				label: "movilgmao",
				index: "movilgmao",
				width: "30",
				editable: true,
				edittype: "checkbox",
				formatter: "checkbox",
				align: "center"
			}
        ]
		
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	

	$("#tecnicos").rup_maint({
		jQueryGrid: "GRID_tecnicos",
		primaryKey: "idtecnico",
		modelObject: "Tecnicos",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						id:"MiNuevo",
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoTecnico
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleTecnico
					},
					{
					obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirTecnicosGmao
					}
	
					]
			}
	});
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_tecnicos").unbind("click");
	$("#clean_search_tecnicos").bind("click",limpiarFormBusqueda);
	
	$("#tecnicos").rup_maint("search");
});

function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}

function fncNuevoTecnico(){
	//alert("Nuevo Tecnico");
	window.location = "/aa20bMaqPartesWar/tecnicos/nuevoTecnico";
}
function fncDetalleTecnico(){
	var id= $("#GRID_tecnicos").rup_grid('getGridParam','selrow');
	 //alert(id);
	 var ret = $("#GRID_tecnicos").rup_grid('getRowData',id); 
	 var idTecnico =ret.idtecnico;
	 
	    // enviamos el form alternativo con el idTecnico para la busqueda
		buscaTecnicoForm.idTecnicoBusc.value = idTecnico;
		buscaTecnicoForm.submit();
	return false; 		
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#tecnicoContrata_search").prop('checked', false);
	
	$("#tecnicos").rup_maint("cleanSearchForm");
	$("#tecnicos").rup_maint("search");
}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function fncSubirTecnicosGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesTecnicos.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosTecnicosGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_tecnicos").rup_feedback (propertiesOK);
						$("#feedback_tecnicos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_tecnicos").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_tecnicos").rup_feedback (propertiesError);
						$("#feedback_tecnicos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_tecnicos").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_tecnicos").rup_feedback (propertiesError);
			 		$("#feedback_tecnicos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_tecnicos").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}
function ocultarBusqueda(){
	
	$("#tecnicos_filter_div").toggle("slow",function(){
		
	});
}