jQuery(function($){
	$("#servicios_filter_div").toggle();
	
	$("#GRID_servicios").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../servicios",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idservicio",
		ondblClickRow : fncDetalleServicio,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "idservicio",
				label: "idservicio",
				index: "idservicio",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "cservicio",
				label: "cservicio",
				index: "cservicio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "eservicio",
				label: "eservicio",
				index: "eservicio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#servicios").rup_maint({
		jQueryGrid: "GRID_servicios",
		primaryKey: "idservicio",
		modelObject: "Servicio",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoServicio
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleServicio
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirServiciosGmao
					}
	
					]
			}
				
	});
	
	$("#dialogoSincronizar").rup_dialog(
			{
				type : $.rup.dialog.DIV,
				height : 200,
				width : 500,
				modal : true,
				showLoading : true,
				autoOpen : false,
				title : $.rup.i18n.app.mensajesEdificios.sincronizando
			});
	
/*DIÁLOGO NUEVO ESPACIO INI*/
	
	var ventanaDialogoNuevoServicio= $("#dialogoEditarServicio").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoServicio",
		modal: true,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.nuevo.servicio,
		close: function(event, ui) { $("#GRID_servicios").rup_grid("reloadGrid"); }
	});
	
	function nuevoServicio() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../servicios/nuevo';
		document.getElementById("iframeEditarServicio").src = ventanaIFrame;
		$("#dialogoEditarServicio").rup_dialog("open");
	}
	
	function cerrarIFrameNuevoServicio() {
		if ($("#dialogoEditarServicio").rup_dialog('isOpen')) {
			$("#dialogoEditarServicio").rup_dialog('close');
			document.getElementById("iframeEditarServicio").src = '';
		}
	}
	
	$("#iframeNuevoServicio").load(function (){ ;});	
	/*DIÁLOGO NUEVO Servicio FIN*/
	
	/* DIALOGO DETALLE */
	function fncDetalleServicio() {
	
		var ventanaDialogoDetalleServicio = $("#dialogoEditarServicio").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detalleServicio",
			modal: true,
			resizable: false,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Servicio,
			close: function(event, ui) { $("#GRID_servicios").rup_grid("reloadGrid"); }
		});
		
		 var id= $("#GRID_servicios").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_servicios").rup_grid('getRowData',id); 
		 var idServicio =ret.idservicio;	 
		 var ventanaIFrame ="../servicios/modificar?idServicio="+idServicio;
	
		  document.getElementById("iframeEditarServicio").src = ventanaIFrame;
			$("#dialogoEditarServicio").rup_dialog("open");
		
		  $("#iframeEditarServicio").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_servicios").unbind("click");
	$("#clean_search_servicios").bind("click",limpiarFormBusqueda);
	
	$("#servicios").rup_maint("search");

});

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	
	$("#servicios").rup_maint("cleanSearchForm");
	$("#servicios").rup_maint("search");

}

function fncSubirServiciosGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesServicio.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosServiciosGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_servicios").rup_feedback (propertiesOK);
						$("#feedback_servicios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_servicios").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_servicios").rup_feedback (propertiesError);
						$("#feedback_servicios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_servicios").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_servicios").rup_feedback (propertiesError);
			 		$("#feedback_servicios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_servicios").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#servicios_filter_div").toggle("slow",function(){
		
	});
}