jQuery(function($){
	$("#presencias_filter_div").toggle();
	
	$("#GRID_presencias").rup_grid({
		
		hasMaint: true,
		width: 865,
		url: "../presencia/gridPresencias",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "nombre",
		ondblClickRow : fncDetallePresencia,
		colNames: [
		    "idpresencia",
			"idtecnico",
			$.rup.i18n.app.nuevo.nombre,		
		    $.rup.i18n.app.GRID_cabeceras.desde,
		    $.rup.i18n.app.GRID_cabeceras.hasta
		],
		colModel: [
			{ name: "idpresencia",
				label: "idpresencia",
				index: "idpresencia",
				width: "50",
				editable: true,
				edittype: "text",
				hidden: true
			},
			{ name: "idtecnico",
				label: "idtecnico",
				index: "idtecnico",
				width: "50",
				editable: true,
				edittype: "text",
				hidden: true
			},
			{ name: "nombre",
				label: "nombre",
				index: "nombre",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "fhdesde",
				label: "fhdesde",
				index: "fhdesde",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "fhhasta",
				label: "fhhasta",
				index: "fhhasta",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			}
        ]
		
	});
	

	$("#presencias").rup_maint({
		jQueryGrid: "GRID_presencias",
		primaryKey: "idpresencia",
		modelObject: "Presencia",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoPresencia
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetallePresencia
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.mensajesPresencia.historia,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncHistoriaPresencia
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSincronizarPresencias
					}
	
					]
			}
				
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	
	
/*DIÁLOGO NUEVO TIPO INI*/
	
	var ventanaDialogoNuevoPresencia= $("#dialogoEditarPresencia").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoPresencia",
		modal: true,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.mensajesPresencia.presencia,
		close: function(event, ui) { $("#GRID_presencias").rup_grid("reloadGrid"); }
	});
	
	function nuevoPresencia() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../presencia/nuevo';
		document.getElementById("iframeEditarPresencia").src = ventanaIFrame;
		$("#dialogoEditarPresencia").rup_dialog("open");
	}
	
	
	$("#iframeNuevoPresencia").load(function (){ ;});	
	/*DIÁLOGO NUEVO Presencia FIN*/
	
	
	
	/* DIALOGO DETALLE */
	function fncDetallePresencia() {
	
		var ventanaDialogoDetallePresencia = $("#dialogoEditarPresencia").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detallePresencia",
			modal: true,
			resizable: false,
			height: 700,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Presencia,
			close: function(event, ui) { $("#GRID_presencias").rup_grid("reloadGrid"); }
		});
		
		 var id= $("#GRID_presencias").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_presencias").rup_grid('getRowData',id); 
		 var idPresencia =ret.idpresencia;	 
		 var ventanaIFrame ="../presencia/modificar?idPresencia="+idPresencia;
	
		  document.getElementById("iframeEditarPresencia").src = ventanaIFrame;
			$("#dialogoEditarPresencia").rup_dialog("open");
		
		  $("#iframeEditarPresencia").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	
	//$("#feDesde_search").rup_date();
	//$("#feHasta_search").rup_date();
	
	var propertiesFePre= {
			from: "fechaPreD_search",
			to : "fechaPreH_search",
			datetimepicker:true,
			showSecond: false,
			timeFormat: 'hh:mm',
			independientes: true
			};
	$.rup_date (propertiesFePre);
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_presencias").unbind("click");
	$("#clean_search_presencias").bind("click",limpiarFormBusqueda);
	
});

function cerrarIFrameNuevoPresencia() {
	if ($("#dialogoEditarPresencia").rup_dialog('isOpen')) {
		$("#dialogoEditarPresencia").rup_dialog('close');
		document.getElementById("iframeEditarPresencia").src = '';
	}
}


function fncHistoriaPresencia(){
	var id= $("#GRID_presencias").rup_grid('getGridParam','selrow');
	 var ret = $("#GRID_presencias").rup_grid('getRowData',id); 
	 var idPresencia =ret.idpresencia;
	 
	    // enviamos el form alternativo con el idPresencia para la busqueda
	 buscaPresenciaForm.idPresenciaBusc.value = idPresencia;
	 buscaPresenciaForm.fechaPreDBusc.value = $("#fechaPreD_search").val();
	 buscaPresenciaForm.fechaPreHBusc.value = $("#fechaPreH_search").val();
	 buscaPresenciaForm.submit();
	return false; 		
}
function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#presenteAhora").prop('checked', false);
	
	$("#presencias").rup_maint("cleanSearchForm");
}

function fncSincronizarPresencias(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesPresencia.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/sincronizarTodasPresencias",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_presencias").rup_feedback (propertiesOK);
						$("#feedback_presencias").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_presencias").rup_feedback("show");
						
					}else{
						$("#feedback_presencias").rup_feedback (propertiesError);
						$("#feedback_presencias").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_presencias").rup_feedback("show");
					}
					$("#GRID_presencias").rup_grid("reloadGrid");
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_presencias").rup_feedback (propertiesError);
			 		$("#feedback_presencias").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_presencias").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#presencias_filter_div").toggle("slow",function(){
		
	});
}