jQuery(function($){
	$("#plantas_filter_div").toggle();
	$("#GRID_plantas").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../plantas",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "numPlanta",
		ondblClickRow : fncDetallePlanta,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.orden,
			$.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
			$.rup.i18n.app.GRID_cabeceras.dRed,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "numPlanta",
				label: "numPlanta",
				index: "numPlanta",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "idplanta",
				label: "idplanta",
				index: "idplanta",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "cplanta",
				label: "cplanta",
				index: "cplanta",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "eplanta",
				label: "eplanta",
				index: "eplanta",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "rplanta",
				label: "rplanta",
				index: "rplanta",
				width: "50",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#plantas").rup_maint({
		jQueryGrid: "GRID_plantas",
		primaryKey: "idplanta",
		modelObject: "plantas",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [/*{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoPlanta
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetallePlanta
						}*/
	
					]
			}
				
	});
	
	$("#rup-maint_toolbar-plantas").hide();
/*DIÁLOGO NUEVO PLANTA INI*/
	
	var ventanaDialogoNuevoPlanta= $("#dialogoEditarPlanta").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoPlanta",
		modal: true,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.nuevo.planta,
		close: function(event, ui) { $("#GRID_plantas").rup_grid("reloadGrid"); }
	});
	
	function nuevoPlanta() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../plantas/nuevo';
		document.getElementById("iframeEditarPlanta").src = ventanaIFrame;
		$("#dialogoEditarPlanta").rup_dialog("open");
	}
	
	function cerrarIFrameNuevoPlanta() {
		if ($("#dialogoEditarPlanta").rup_dialog('isOpen')) {
			$("#dialogoEditarPlanta").rup_dialog('close');
			document.getElementById("iframeEditarPlanta").src = '';
		}
	}
	
	$("#iframeNuevoPlanta").load(function (){ ;});	
	/*DIÁLOGO NUEVO Planta FIN*/
	
	/* DIALOGO DETALLE */
	function fncDetallePlanta() {
	
		var ventanaDialogoDetallePlanta = $("#dialogoEditarPlanta").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detallePlanta",
			modal: true,
			resizable: false,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Planta,
			close: function(event, ui) { $("#GRID_plantas").rup_grid("reloadGrid"); }	
		});
		
		 var id= $("#GRID_plantas").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_plantas").rup_grid('getRowData',id); 
		 var idPlanta =ret.idplanta;	 
		 var ventanaIFrame ="../plantas/modificar?idPlanta="+idPlanta;
	
		  document.getElementById("iframeEditarPlanta").src = ventanaIFrame;
			$("#dialogoEditarPlanta").rup_dialog("open");
		
		  $("#iframeEditarPlanta").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_plantas").unbind("click");
	$("#clean_search_plantas").bind("click",limpiarFormBusqueda);
	
	$("#plantas").rup_maint("search");

});

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	
	$("#plantas").rup_maint("cleanSearchForm");
	$("#plantas").rup_maint("search");

}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function valida(e){
    tecla = (document.all) ? e.keyCode : e.which;

    //Tecla de retroceso para borrar, siempre la permite
    if (tecla==8){
        return true;
    }
        
    // Patron de entrada, en este caso solo acepta numeros
    patron =/[0-9]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}

function ocultarBusqueda(){
	
	$("#plantas_filter_div").toggle("slow",function(){
		
	});
}