jQuery(function($){

	//Edificio
	$("#comboEdificiosGeneral").rup_combo({
		source: "../partes/edificios/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo()+"edificio", value:"idedificio"},
		width: 339,
		blank: "",
		selected: accion != "NUEVO"?$("#idEdificio").val():"",
		select: function(){
			$("#divCanvas").hide();
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#idEdificio").val($("#comboEdificiosGeneral").rup_combo("value"));
			$("#idZona").val(0);
			$("#idPlanta").val(0);
			comprobarCombosEdificioGeneral();
		},
		style : "dropdown"										
	});

	//Edificio
	$("#comboEdificios").rup_combo({
		source: "../partes/edificios/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo()+"edificio", value:"idedificio"},
		width: 339,
		blank: "",
		//seleccionar en el combo de edificios el edificio asociado al parte para que se pueda recargar Zona y Planta
		selected: accion != "NUEVO"?$("#idEdificio").val():"",
		select: function(){
			$("#divCanvas").hide();
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#idEdificio").val($("#comboEdificios").rup_combo("value"));
			comprobarCombos();
			
		},
		style : "dropdown"										
	});

	$("#comboZonas").rup_combo({
		parent: [ "comboEdificios"],
		source: "../partes/zonasEdif/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo() + "zona", value:"idzona"},
		//selected: "0",
		select : function() { 
			$("#divCanvas").hide();
			$("#idZona").val($("#comboZonas").val());
			comprobarCombos();
		},
		width: 200,
		blank: "",
		style : "dropdown"										
	});

	$("#comboPlantas").rup_combo({
		parent: [ "comboZonas", "comboEdificios"],
		source: "../partes/plantasZona/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo() + "planta", value:"idplanta"},
		//selected: "0",
		ordered: false,
		select : function() { 
			$("#divCanvas").hide();
			$("#idPlanta").val($("#comboPlantas").val());
			comprobarCombos();
		},
		width: 200,
		blank: "",
		style : "dropdown"										
	});
	
});

$("#fileupload_only").rup_upload({
	fileInput: $("#file_only"),
	maxFileSize: 5000000
	});

$('#fileupload_only').bind('fileuploaddone', function (e, data) {
	$("#fileupload_only").hide();
	$("#divCanvas").show();
	obtenerPlano();
  	$.rup_messages("msgOK", { 
  		title: $.rup.i18n.app.comun.control,
  		message: $.rup.i18n.app.mensajesPlano.planoGuardado,
 		beforeClose: function (){
 			$("#esPGE").attr('disabled','disabled');	
 			if ($("#esPGE").is(':checked')){
 				$("#comboEdificiosGeneral").rup_combo("disable");
 			}else{
 				$("#comboEdificios").rup_combo("disable");
 				$("#comboZonas").rup_combo("disable");
 				$("#comboPlantas").rup_combo("disable");
 			}
 		}

  	});
});

$('#fileupload_only').bind('fileuploadadd', function (e, data) {
	$('#tablaResultadoSubida').show();
});
$("#fileupload_only").hide();

function comprobarCombos(){
	//Si no ha seleccionado Edificio Zona y Planta no se continua
	if ($("#comboEdificios").val()=="" || $("#comboZonas").val() =="" || $("#comboPlantas").val()==""){
		$("#fileupload_only").hide();
	}else{
		var codEdificio = $("#comboEdificios").rup_combo("value");
		var codZona = $("#comboZonas").rup_combo("value");
		var codPlanta = $("#comboPlantas").rup_combo("value");

		//Comprobar si ya existe un plano para estos datos
		$.ajax({
			type: "GET",
			url: "../planos/obtenerListaPlanos",
			data:  { codEdif:codEdificio, codPlanta:codPlanta, codZona:codZona },
			success: function(data){
				//Si no hay ningun registro no pintar el icono para mostrar el plano
				if (data.length==0){
					//Mostramos los componentes para subir nuevo plano
					$("#fileupload_only").show();			
				}else{
					//Ya existe plano
					$.rup_messages("msgAlert", { 
			 			title: $.rup.i18n.app.comun.control,
				 		message: $.rup.i18n.app.mensajesPlano.yaExistePlano
				 	});
					$("#fileupload_only").hide();
					$("#divCanvas").show();
					obtenerPlano();
				}
			},
			  dataType: "json"
			});
	}
	
}

function comprobarCombosEdificioGeneral(){
	//Si no ha seleccionado Edificio
	if ($("#comboEdificiosGeneral").val()==""){
		$("#fileupload_only").hide();
	}else{
		var codEdificio = $("#comboEdificios").rup_combo("value");
		var codZona = 0;
		var codPlanta = 0;

		//Comprobar si ya existe un plano para estos datos
		$.ajax({
			type: "GET",
			url: "../planos/obtenerListaPlanos",
			data:  { codEdif:codEdificio, codPlanta:codPlanta, codZona:codZona },
			success: function(data){
				//Si no hay ningun registro no pintar el icono para mostrar el plano
				if (data.length==0){
					//Mostramos los componentes para subir nuevo plano
					$("#fileupload_only").show();			
				}else{
					//Ya existe plano
					$.rup_messages("msgAlert", { 
			 			title: $.rup.i18n.app.comun.control,
				 		message: $.rup.i18n.app.mensajesPlano.yaExistePlanoGeneral
				 	});
					$("#fileupload_only").hide();
					$("#divCanvas").show();
					obtenerPlano();
				}
			},
			  dataType: "json"
			});
	}
	
}
$("#bt_Volver").bind("click", volver);
$("#bt_nuevo").bind("click", nuevo);
function volver(){
	window.location = "/aa20bMaqPartesWar/planos/maintVolver";	
}
function nuevo(){
	window.location = "/aa20bMaqPartesWar/planos/nuevoPlano";
}
function obtenerIdiomaCombo(){
	var idioma="c";		
	if ($.rup_utils.capitalizedLang() =="Es") {	
		idioma = "c";
	} else idioma="e";
	return idioma;
	}



/********************************* FEEDBACK MENSAJES OK  ****************************************************************/

function mensajeInfo (texto) {
	 var properties = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
			};
		$("#feedbackEditarPlano").rup_feedback (properties);

		$("#feedbackEditarPlano").rup_feedback("set", texto);

		$("#feedbackEditarPlano").rup_feedback("show");
}


/* Error */
function mensajeError (texto) {
	 var properties = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
			};
	
		$("#feedbackEditarPlano").rup_feedback (properties);

		$("#feedbackEditarPlano").rup_feedback("set", texto);

		$("#feedbackEditarPlano").rup_feedback("show");
}


jQuery("#feedbackEditarPlano").rup_feedback({
	  type: "ok",                  
	  closeLink: true,                  
	  delay: 1000,                  
	  fadeSpeed: 500,                  
	  block:true          
	  }); 

/********************************* FIN FEEDBACK MENSAJES OK  ****************************************************************/


function activarPGE(e){
	if ($("#esPGE").is(':checked')){
		$("#EdificioGeneral").show();
		$("#EdificioZonaPlanta").hide();
	}else{
		$("#EdificioGeneral").hide();	
		$("#EdificioZonaPlanta").show();
	}
}

/**********************************************************************************/
/******************************** IMAGEN PLANO   **********************************/
/**********************************************************************************/
	function obtenerPlano(){
		var codEdif = $("#idEdificio").val();
		var codPlanta = $("#idPlanta").val();
		var codZona = $("#idZona").val();

		var planoDetalle=null;

		cPunto = document.getElementById("canvaPunto");
		ctxPunto = cPunto.getContext("2d");
		
		planoDetalle = new Image();
		planoDetalle.onload=function(){
			ctxPunto.clearRect( 0, 0, 390, 312);
			ctxPunto.drawImage(planoDetalle, 0, 0, 390, 312);
			//width="300" height="240"
		};
		//planoParte.src="../parteplano/mostrarPlanoParte?idParte=90"; //+ $("#idparte").val();
		planoDetalle.src="../planos/mostrarPlano?edificio=" + codEdif + "&planta=" + codPlanta + "&zona=" + codZona;
		
	}