jQuery(function($){
	$("#planos_filter_div").toggle();
	
	$("#GRID_planos").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../planos",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idplano",
		ondblClickRow : fncDetallePlano,
		colNames: [
		    "level", "hasChildren", "parentNodes", "filter", //Jerarquia
		    $.rup.i18n.app.GRID_cabeceras.codigo,
		    $.rup.i18n.app.GRID_cabeceras.codigo,
		    $.rup.i18n.app.GRID_cabeceras.edifZonaPlta,
			$.rup.i18n.app.nuevo.edificio,
			$.rup.i18n.app.nuevo.edificio,		
			$.rup.i18n.app.nuevo.zona,		
			$.rup.i18n.app.nuevo.zona,		
			$.rup.i18n.app.nuevo.planta,		
			$.rup.i18n.app.nuevo.planta,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			//Jerarquia
			{ name: "level", hidden: true },
			{ name: "hasChildren", hidden: true },
			{ name: "parentNodes", hidden: true },
			{ name: "filter", hidden: true },
			//Fin Jerarquia
			{ name: "idplano",
				label: "idplano",
				index: "idplano",
				width: "50",
				editable: true,
				edittype: "text",
				hidden: true
			},
			{ name: "idpadre",
				label: "idpadre",
				index: "idpadre",
				width: "50",
				editable: true,
				edittype: "text",
				hidden: true
			},
			{ name: "descPlano",
				label: "edificio.descPlano",
				index: "descPlano",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "edificio.cedificio",
				label: "edificio.cedificio",
				index: "cedificio",
				width: "200",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "edificio.eedificio",
				label: "edificio.eedificio",
				index: "eedificio",
				width: "200",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "zona.czona",
				label: "zona.czona",
				index: "czona",
				width: "100",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "zona.ezona",
				label: "zona.ezona",
				index: "ezona",
				width: "100",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "planta.cplanta",
				label: "planta.cplanta",
				index: "cplanta",
				width: "100",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "planta.eplanta",
				label: "planta.eplanta",
				index: "eplanta",
				width: "100",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#planos").rup_maint({
		jQueryGrid: "GRID_planos",
		primaryKey: "idplano",
		modelObject: "planos",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoPlano
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetallePlano
						}
	
					]
			}
				
	});
	
	
	function fncDetallePlano() {
		var id= $("#GRID_planos").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_planos").rup_grid('getRowData',id); 
		 var idPlano=ret.idplano;
		 
		    // enviamos el form alternativo con el idPlano para la busqueda
			buscaPlanoForm.idPlanoBusc.value = idPlano;
			buscaPlanoForm.submit();
		return false; 		
	}
	
	function nuevoPlano(){
		window.location = "/aa20bMaqPartesWar/planos/nuevoPlano";
	}
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_planos").unbind("click");
	$("#clean_search_planos").bind("click",limpiarFormBusqueda);
	
	$("#planos").rup_maint("search");

	
	$("#GRID_planos").rup_grid_jerarquia({
		expandColName : "descPlano",
		relatedColName : "idplano",
		multiboxonly:true,
		resetEvents: {
			click: ["bt_search_planos", "clean_search_planos"],
			keydown : [ function(event){ if (event.keyCode === 13) { return false; } }, "searchForm" ]
		}
	});
	
});

function limpiarFormBusqueda() {
	$("#planos").rup_maint("cleanSearchForm");
	$("#planos").rup_maint("search");
}

function ocultarBusqueda(){
	
	$("#planos_filter_div").toggle("slow",function(){
		
	});
}