jQuery(function($){
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	
	/**
	 * Función cuando cambia el valor en el combo de objetoSubida
	 */
	$("#objetoSubida").on("change",function(event) {
		if($("#objetoSubida").val() == ""){
			$("#tipoSubida").val("");
			$("#textareaJson").hide();
			$("#botoneraAutomatico").hide();
			$("#botoneraManual").hide();
		}
		
	});
	
	/**
	 * Función cuando cambia el valor en el combo de tipoSubida
	 */
	$("#tipoSubida").on("change",function(event) {
		if($("#tipoSubida").val() != ""){
			if($("#tipoSubida").val() == "1"){
				$("#botoneraAutomatico").show();
				$("#textareaJson").hide();
				$("#botoneraManual").hide();
			}else if($("#tipoSubida").val() == "2"){
				$("#botoneraAutomatico").hide();
				$("#textareaJson").show();
				$("#botoneraManual").show();
			}
		}else{
			$("#textareaJson").hide();
			$("#botoneraAutomatico").hide();
			$("#botoneraManual").hide();
		}

	});
	
	
	$("#bt_syncauto").on("click",function(event) {
		fncSincronizarEstructuraGmao();
	});
	
	$("#bt_syncmanual").on("click",function(event) {
		fncSincronizarEstructuraGmao();
	});
	
	
});


function fncSincronizarEstructuraGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: true
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	var valor = $("#objetoSubida").val();
	
	//Si es subida manual pasamos el json
	var datos = "";
	if($("#tipoSubida").val() == "2"){
		 datos = $("#txtJsonSinc").val();
	}
	

	
	var url = "";
	if(valor == "1"){
		url = "../procesosGmao/estrGmaoClaseActivoEdificio";
	}else if(valor == "2"){
		url = "../procesosGmao/subirTodosTerritoriosGmao";
	}else if(valor == "3"){
		url = "../procesosGmao/subirTodasPrioridadesGmao";
	}else if(valor == "4"){
		url = "../procesosGmao/estrGmaoTiposOTs";
	}else if(valor == "5"){
		url = "../procesosGmao/limpiezaActivosGmao";
	}else if(valor == "6"){
		url = "../procesosGmao/subirTodosDepartamentosGmao";
	}else if(valor == "7"){
		url = "../procesosGmao/subirTodasDireccionesGmao";
	}else if(valor == "8"){
		url = "../procesosGmao/finalizarPartesPendientes";
	}else if(valor == "9"){
		url = "../procesosGmao/finalizarFichasPendientes";
	}else if(valor == "10"){
		url = "../procesosGmao/subirTodosEstadosGmao";
	}else if(valor == "11"){
		url = "../procesosGmao/subirTodasHorasGmao";
	}else if(valor == "12"){
		url = "../procesosGmao/subirAgrupacionActivoGmao";
	}else if(valor == "13"){
		url = "../procesosGmao/subirAgrupacionOperarioGmao";
	}else if(valor == "14"){
		url = "../procesosGmao/subirAgrupacionOperarioActivoGmao";
	}
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"accionesRegistros.sincronizarMovilGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: url,
				dataType: "json",
				data: {valorJSON:datos},
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK" || (valor == "5" && respuesta == "")){
						$("#feedback_procesosIniciales").rup_feedback (propertiesOK);
						$("#feedback_procesosIniciales").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_procesosIniciales").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_procesosIniciales").rup_feedback (propertiesError);
						$("#feedback_procesosIniciales").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_procesosIniciales").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_procesosIniciales").rup_feedback (propertiesError);
			 		$("#feedback_procesosIniciales").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_procesosIniciales").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}