jQuery(function($){
	$("#maquinas_filter_div").toggle();
	
	$("#GRID_maquinas").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../maquinas/gridMaquinasUsuario",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idmaquina",
		ondblClickRow : fncDetalleMaquina,
		colNames: [
			$.rup.i18n.app.GRID_cabeceras.edifZonaPlta,
			"idzona",
			"idplanta",
		    $.rup.i18n.app.mensajesMaquina.codigo,
			$.rup.i18n.app.GRID_cabeceras.desc,
			$.rup.i18n.app.mensajesMaquina.codigo,		
			$.rup.i18n.app.mensajesGama.codigo,		
		    $.rup.i18n.app.mensajesMaquina.primerMto,
		    $.rup.i18n.app.mensajesMaquina.sigMto,
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "edifZonaPlta",
				label: "edifZonaPlta",
				index: "edifZonaPlta",
				width: "70",
				editable: true,
				edittype: "text"
			},
			{ name: "idzona",
				label: "idzona",
				index: "idzona",
				width: "30",
				edittype: "hidden",
				hidden:true
			},
			{ name: "idplanta",
				label: "idplanta",
				index: "idplanta",
				width: "30",
				edittype: "hidden",
				hidden:true
			},
			{ name: "idmaquina",
				label: "idmaquina",
				index: "idmaquina",
				width: "50",
				edittype: "hidden",
				hidden:true
			},
			{ name: obtenerIdioma() + "maquina",
				label: obtenerIdioma() + "maquina",
				index: "cmaquina",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "mcodigo",
				label: "mcodigo",
				index: "mcodigo",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "gama." + obtenerIdioma() + "gama",
				label: "gama." + obtenerIdioma() + "gama",
				index: "idgama",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "primerMto",
				label: "primerMto",
				index: "primerMto",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "sigMto",
				label: "sigMto",
				index: "sigMto",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#maquinas").rup_maint({
		jQueryGrid: "GRID_maquinas",
		primaryKey: "idmaquina",
		modelObject: "Maquina",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoMaquina
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleMaquina
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizarMaq1,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirMaquinasGmaoFase1
					}
					
	
					]
			}
				
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_maquinas").unbind("click");
	$("#clean_search_maquinas").bind("click",limpiarFormBusqueda);
	
	$("#maquinas").rup_maint("search");

});

function fncNuevoMaquina(){
	window.location = "/aa20bMaqPartesWar/maquinas/nuevoMaquina";
}

function fncDetalleMaquina(){
	var id= $("#GRID_maquinas").rup_grid('getGridParam','selrow');
	 //alert(id);
	 var ret = $("#GRID_maquinas").rup_grid('getRowData',id); 
	 var idMaquina =ret.idmaquina;
	 
	    // enviamos el form alternativo con el idMaquina para la busqueda
		buscaMaquinaForm.idMaquinaBusc.value = idMaquina;
		buscaMaquinaForm.submit();
	return false; 		
}

function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}
function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#gestCentra_search").prop('checked', false);
	
	$("#maquinas").rup_maint("cleanSearchForm");
	$("#maquinas").rup_maint("search");
}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}


function fncSubirMaquinasGmaoFase1(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesMaquina.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosMaquinasGmaoFase1",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_maquinas").rup_feedback (propertiesOK);
						$("#feedback_maquinas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_maquinas").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_maquinas").rup_feedback (propertiesError);
						$("#feedback_maquinas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_maquinas").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_maquinas").rup_feedback (propertiesError);
			 		$("#feedback_maquinas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_maquinas").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#maquinas_filter_div").toggle("slow",function(){
		
	});
}
