jQuery(function($){
	$("#gamas_filter_div").toggle();
	
	$("#GRID_gamas").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../gamas",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idgama",
		ondblClickRow : fncDetalleGama,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
			$.rup.i18n.app.mensajesServicio.servicio,
			$.rup.i18n.app.mensajesClase.clase,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja,
		    $.rup.i18n.app.GRID_cabeceras.contrata
		],
		colModel: [
			{ name: "idgama",
				label: "idgama",
				index: "idgama",
				width: "50",
				editable: true,
				edittype: "hidden",
				hidden:true
			},
			{ name: "cgama",
				label: "cgama",
				index: "cgama",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "egama",
				label: "egama",
				index: "egama",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "servicio." + obtenerIdioma() + "servicio",
				label: "servicio." + obtenerIdioma() + "servicio",
				index: obtenerIdioma() + "servicio",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "clase." + obtenerIdioma() + "clase",
				label: "clase." + obtenerIdioma() + "clase",
				index: "idclase",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "contrata",
				label: "contrata",
				index: "contrata",
				width: "60",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#gamas").rup_maint({
		jQueryGrid: "GRID_gamas",
		primaryKey: "idgama",
		modelObject: "Gama",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoGama
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleGama
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirGamasGmao
					}
	
					]
			}
				
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_gamas").unbind("click");
	$("#clean_search_gamas").bind("click",limpiarFormBusqueda);
	
	$("#gamas").rup_maint("search");

});

function fncNuevoGama(){
	window.location = "/aa20bMaqPartesWar/gamas/nuevoGama";
}

function fncDetalleGama(){
	var id= $("#GRID_gamas").rup_grid('getGridParam','selrow');
	 //alert(id);
	 var ret = $("#GRID_gamas").rup_grid('getRowData',id); 
	 var idGama =ret.idgama;
	 
	    // enviamos el form alternativo con el idGama para la busqueda
		buscaGamaForm.idGamaBusc.value = idGama;
		buscaGamaForm.submit();
	return false; 		
}

function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#contrata_search").prop('checked', false);
	
	$("#gamas").rup_maint("cleanSearchForm");
	$("#gamas").rup_maint("search");

}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function fncSubirGamasGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesGama.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosGamasGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_gamas").rup_feedback (propertiesOK);
						$("#feedback_gamas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_gamas").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_gamas").rup_feedback (propertiesError);
						$("#feedback_gamas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_gamas").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_gamas").rup_feedback (propertiesError);
			 		$("#feedback_gamas").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_gamas").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#gamas_filter_div").toggle("slow",function(){
		
	});
}