$( document ).ready(function() {
	var sClase="";
	var sCodigo="";
	var sCodClase="";
	var sCodCodigo="";
});	 

// Al pulsar el botón guardar enviamos los campos del formulario al Controller
$("#bt_guardar").bind("click", confirmarGuardar);

function confirmarGuardar (){
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesActuacion.nuevoParteCorr"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesActuacion.deseaGuardarPCorr"),
		OKFunction: function(){
			guardarNuevoParteCorr();		
		},
		CANCELFunction : function(){
		}
		});
}
	
function guardarNuevoParteCorr() {	
	var properties={
			url:"../actuacion/addNuevoParteCorrectivo",
			feedback:$("#feedbacknuevoParteCorr"),
			//useJsonIfPossible: true,
			 dataType: "json",
			 error: function(data) {
				 alert(data.responseText);
				 mensajeError("<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorguardar + "</strong></p>");
			 },
			 success: function(data2){					 					
				 mensajeInfo("<p><strong>" +  $.rup.i18n.app.accionesRegistros.guardadook + "</strong></p>"); 
				 if (data2!=null){
					 //Abrir el parte correctivo creado
					 parent.abrirParteCorrectivo(data2.idparte);
					 //buscaParteForm.idparte.value = data2.idparte;
					//buscaParteForm.submit();
					
				 }else{
					 Alert("Se ha producido un error al intentar mostrar el parte creado");
				 }

			 },
			 validate: {
				 rules: {
					 "claseActivo":{required:true},
					 "activo":{required:true}					 
				 }
			 }
			};
			$("#nuevoParteCorrForm").rup_form(properties);				
			$("#nuevoParteCorrForm").submit();
}
/********************************* FIN GUARDAR NUEVO ****************************************************************/



/*************************************************************************************************/
/********************************* CLASES Y CODIGOS **********************************************/
/*************************************************************************************************/


function btn_BuscarCodigos(){
	$("#idTablaClases").empty();
	
	//Obtener la lista de Clases
	$.ajax({
		type: "POST",
		url: "../clase/clasesAlta/obtenerClasesAlta",
		success: function(data){
			var miselect=$("#idTablaClases");
			$("#idTablaClases").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = data[i].cclase;
              	} else {
              		descripcion = data[i].eclase;
              	}
              	miselect.append('<option value="' + data[i].idclase + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigosAlta/obtenerCodigosAlta",
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = data[i].ccodigo;
              	} else {
              		descripcion = data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	
	//Mostrar la ventana de lupaClases
	$("#lupaClases").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:300,
        width:649,  
        resizable:false,
        title:$.rup.i18n.app.comun.clasesActivosVigentes,
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarlupaClases",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
	        		//Pintar el texto de la clase y activo seleccionado
	        		$("#claseActivo").val(sClase);
	        		$("#activo").val(sCodigo);

	        		//Pintar el tecto de la clase y codigo seleccioando en los inputs para mandar por correo
	        		$("#idCClase").val(sClase);
	        		$("#idCCodigo").val(sCodigo);

	        		//Recoger los codigos de clase y activo seleccionado
	        		$("#idClase").val(sCodClase);
	        		$("#idCodigo").val(sCodCodigo);
	        		
	        		$("#lupaClases").rup_dialog("close");
	        		}
        	},
	        {
	    		id: "cerrarlupaClases",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupaClases").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   
}
function obtenerCodigosClase(valor){

	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigosAlta/obtenerCodigosAltaClase",
		  data:  { claseSel:valor },
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = data[i].ccodigo;
              	} else {
              		descripcion = data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	sClase=$("#idTablaClases option:selected").html();
	
	var claseCodigo= valor; //Original Text
	var partes= claseCodigo.split('@');
	sCodClase = partes[0];
	
}
function obtenerClaseCodigo(valor){
	var claseCodigo= valor; //Original Text

	var partes= claseCodigo.split('@');
	var clase = partes[0];
	var codigo= partes[1];
	
	sCodigo=$("#idTablaCodigos option:selected").html();
	sCodCodigo=codigo;
	//Marcar clase asociada al activo	
	$("#idTablaClases option[value="+ clase +"]").attr("selected",true);
	sClase=$("#idTablaClases option:selected").html();
	sCodClase=clase;
}

/********************************* FEEDBACK MENSAJES OK  ****************************************************************/

function mensajeInfo (texto) {
	 var properties = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
			};
	
		$("#feedbacknuevoParteCorr").rup_feedback (properties);

		$("#feedbacknuevoParteCorr").rup_feedback("set", texto);

		$("#feedbacknuevoParteCorr").rup_feedback("show");
}

function mensajeError (texto) {
	 var properties = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
			};

		$("#feedbacknuevoParteCorr").rup_feedback (properties);

		$("#feedbacknuevoParteCorr").rup_feedback("set", texto);

		$("#feedbacknuevoParteCorr").rup_feedback("show");
}

/********************************* FIN FEEDBACK MENSAJES OK  ****************************************************************/


// Esto es necesario para que salgan los mensajes de validacion de uda
jQuery("#feedbacknuevoParteCorr").rup_feedback({
	  type: "ok",                  
	  closeLink: true,                  
	  delay: 1000,                  
	  fadeSpeed: 500,                  
	  block:false          
	  }); 

