var claseUsuario = "";

$.ajax({
	  type: "POST",
	  url: "../usuarios/obtenerClaseUsuario",
	  success: function(data){
		
			  if (data.idclase != null && data.idclase >=0){
				 
				  claseUsuario = data.idclase;			
				  	  
					  $("#idclase_search").val(data.idclase);				
					 
				  
				  
			  }else{
				  //Si desde el mantenimiento de usuarios no se le ha asignado alguna clase no puede buscar nada
				  $("#idclase_search").val("-1");
				  
				  
			  }
		  },
		 error: function(data){
			 alert( "Error al comprobar la clase a la que pertenece el usuario");
		 },
	  dataType: "json"
	});

jQuery(function($){

	$("#mantFichas_filter_div").toggle();
	
	//Si el usuario es tiene acceso a todos los servicios (idServicio=0) se podrá filtrar por cualquier Servicio.
	//En el resto de casos se filtrara por el Servicio al que pertenece para que solo salgan los partes asociados a ese servico
	$.ajax({
		  type: "POST",
		  url: "../usuarios/usuarioTodosServicios",
		  success: function(data){
				  if (data){
					  $("#filtroServicio").show();
				  }else{
					  $("#filtroServicio").hide();
				  }
			  },
			 error: function(data){
				 alert( "Error al comprobar el servicio al que pertenece el usuario");
			 },
		  dataType: "json"
		});

	//Busqueda por fecha de recepcion.
	$.rup_date({
		from: "fechaD_search",
		to: "fechaH_search",
		independientes: true
		});
	
	$.rup_date({
		from: "fechaplanifD_search",
		to: "fechaplanifH_search",
		independientes: true
		});

	
	//Si no hay busqueda por fecha metemos la fecha de dos semanas antes
	if($("#fechaD_search").val() == "" && $("#fechaH_search").val() == ""){
		var twoWeekAgo = new Date();
		twoWeekAgo.setDate(twoWeekAgo.getDate() - 14);
		$("#fechaD_search").rup_date("setDate",twoWeekAgo);
	}
	
	
	$("#GRID_mantFichas").rup_grid({
		
		//hasMaint: true,
		loadOnStartUp:false,
		width: 1012,
		url: "../ficha/gridFichas",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "desc",
		sortname: "idficha",
		expandColumn: "idficha",
		ondblClickRow : fncDetalleFicha,
		colNames: [
		    $.rup.i18n.app.nuevo.idficha,
			$.rup.i18n.app.nuevo.fechaPre,
			$.rup.i18n.app.nuevo.fechaplanif,
			$.rup.i18n.app.pendientes.tecnicos,			
			$.rup.i18n.app.mensajesFicha.tiempo,
			$.rup.i18n.app.nuevo.edificio,
			$.rup.i18n.app.nuevo.zona,
			$.rup.i18n.app.nuevo.planta,
			$.rup.i18n.app.nuevo.mcodigo,
			$.rup.i18n.app.mensajesFicha.equipo,
			$.rup.i18n.app.nuevo.gama,
			$.rup.i18n.app.listCorr.ejecutado
		],
		colModel: [
			{ name: "idficha",
				label: "idficha",
				index: "idficha",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "feejec",
				label: "feejec",
				index: "feejec",
				width: "120",
				editable: true,
				edittype: "text"
			},
			{ name: "fechaplanif",
				label: "fechaplanif",
				index: "fechaplanif",
				width: "95",
				editable: true,
				edittype: "text"
			},
			{ name: "tecnicos",
				label: "tecnicos",
				index: "tecnicos",
				width: "120",
				editable: true,
				edittype: "text"
			},
			{ name: "tiemporeal",
				label: "tiemporeal",
				index: "tiemporeal",
				width: "99",
				editable: true,
				edittype: "text",
				hidden:true,
				formatter :
                	masiveIconFormatter = function(cellval, el, opts) 
                	{
                		var html = '';
                    	if (cellval && cellval != ''){
                    		var fichaHoras=Math.floor(cellval/60);
                    		var fichaMinutos=cellval%60;
                    		html = '<spam width="20" height="20" id="idTR-'+el.rowId+'" title="'+$.rup.i18n.app.fichaTecnicos.tiemporeal+'">'+fichaHoras+':'+ fichaMinutos +' </spam>';
                    	}
                    	return html;
                	}
			},
			{ name: "maquina.edificio." + obtenerIdioma() + "edificio",
				label: "maquina.edificio." + obtenerIdioma() + "edificio",
				index: obtenerIdioma() + "edificio",
				width: "170",
				editable: true,
				edittype: "text"
			},
			{ name: "maquina.zona." + obtenerIdioma() + "zona",
				label: "maquina.zona." + obtenerIdioma() + "zona",
				index: obtenerIdioma() + "zona",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "maquina.planta." + obtenerIdioma() + "planta",
				label: "maquina.planta." + obtenerIdioma() + "planta",
				index: obtenerIdioma() + "planta",
				width: "110",
				editable: true,
				edittype: "text"
			},
			{ name: "maquina.mcodigo",
				label: "maquina.mcodigo",
				index: "mcodigo",
				width: "110",
				editable: true,
				edittype: "text"
			},
			{ name: "maquina." + obtenerIdioma() + "maquina",
				label: "maquina." + obtenerIdioma() + "maquina",
				index: obtenerIdioma() + "maquina",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "gama." + obtenerIdioma() + "gama",
				label: "gama." + obtenerIdioma() + "gama",
				index: obtenerIdioma() + "gama",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "ejecutado",
				label: "ejecutado",
				index: "ejecutado",
				width: "35",
				editable: true,
				edittype: "text",
			    formatter :
                	masiveIconFormatter = function(cellval, el, opts) 
                	{
			    		var html = '';
			    		var src = $.rup.RUP+"/basic-theme/images/rup.ok.png";
                		if (cellval && cellval != 0){
                        	html = '<img width="20" height="20" src='+src+' id="idDesc-'+cellval+'"  title="'+$.rup.i18n.app.listCorr.ejecutado+'">';
                        }
                        return html;
                	}
			}
        ]
		
	});
	
	$("#mantFichas").rup_maint({
		jQueryGrid: "GRID_mantFichas",
		primaryKey: "idficha",
		modelObject: "Ficha",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		onafterDetailShow: function(){
			$("mantFichas").rup_maint("search");
		},
		searchForm: "searchForm",
		showMessages: true,
		toolbar:{
			createDefaultToolButtons:false,
			newButtons: [
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleFicha
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.imprimir,
							css: "rup-maint_imprimir"
							},
							json_i18n: $.rup.i18n.app.simpelMaint,
							click: fncImprimir
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.imprimirDiario,
							css: "rup-maint_imprimir"
							},
							json_i18n: $.rup.i18n.app.simpelMaint,
							click: fncImprimirDiario
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.imprimirEjecutados,
							css: "rup-maint_imprimir"
							},
							json_i18n: $.rup.i18n.app.simpelMaint,
							click: fncImprimirEjecutados
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.imprimirDetallados,
							css: "rup-maint_imprimir"
							},
							json_i18n: $.rup.i18n.app.simpelMaint,
							click: fncImprimirDetallados
					}
	
	
					]
	
			}
	});

	
	function fncDetalleFicha() {
		var id= $("#GRID_mantFichas").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_mantFichas").rup_grid('getRowData',id); 
		 var idficha =ret.idficha;
		 
		 if($("#modoConsultaTipo").val() == "1"){
			 editarFichasFormSoloLectura.idEditarFicha.value =idficha;
			 editarFichasFormSoloLectura.submit();
		 }else{
			    // enviamos el form alternativo con el idficha
			 editarFichasForm.idEditarFicha.value = idficha;
			 editarFichasForm.submit();
		 }
		 
		 

		return false; 		
	}
	
	function fncImprimir() {

		cargarDatosImprimir();
		
		$("#filtroListadoFichasForm").attr("action","../ficha/imprimirListadoFichas");
		$("#filtroListadoFichasForm").attr("method","GET");
		$("#filtroListadoFichasForm").attr("target","_blank");

		$("#filtroListadoFichasForm").submit();
		
	}
	
	function fncImprimirDiario() {

		cargarDatosImprimir();
		
		$("#filtroListadoFichasForm").attr("action","../ficha/imprimirDiario");
		$("#filtroListadoFichasForm").attr("method","GET");
		$("#filtroListadoFichasForm").attr("target","_blank");

		$("#filtroListadoFichasForm").submit();
		
	}

	function fncImprimirEjecutados() {

		cargarDatosImprimir();
		
		$("#filtroListadoFichasForm").attr("action","../ficha/imprimirEjecutados");
		$("#filtroListadoFichasForm").attr("method","GET");
		$("#filtroListadoFichasForm").attr("target","_blank");

		$("#filtroListadoFichasForm").submit();
		
	}
	
	function fncImprimirDetallados() {

		cargarDatosImprimir();
		
		$("#filtroListadoFichasForm").attr("action","../ficha/imprimirDetallados");
		$("#filtroListadoFichasForm").attr("method","GET");
		$("#filtroListadoFichasForm").attr("target","_blank");

		$("#filtroListadoFichasForm").submit();
		
	}
	
	function cargarDatosImprimir(){
		//Pasar los filtros al formulario filtroListadoFichasForm
		$("#idficha_imp").val($("#idficha_search").val());
		$("#fechaD_imp").val($("#fechaD_search").val());
		$("#fechaH_imp").val($("#fechaH_search").val());
		$("#fechaplanifD_imp").val($("#fechaplanifD_search").val());
		$("#fechaplanifH_imp").val($("#fechaplanifH_search").val());
		$("#idedificio_imp").val($("#idedificio_search").val());
		$("#idzona_imp").val($("#idzona_search").val());
		$("#idplanta_imp").val($("#idplanta_search").val());
		$("#mcodigo_imp").val($("#mcodigo_search").val());
		$("#maquina_imp").val($("#maquina_search").val());
		$("#gama_imp").val($("#gama_search").val());
		$("#idclase_imp").val($("#idclase_search").val());
		$("#tecnicos_imp").val($("#idtecnico_search").val());
		$("#ejecutado_imp").val($("#ejecutado_search").val());
		$("#parado_imp").val($("#parado_search").val());
		$("#pendEjec_imp").val($("#pendEjec_search").val());
		$("#conTecnicos_imp").val($("#conTecnicos_search").val());
		
	}
	
	

	//Edificio
	$("#comboEdificios").rup_combo({
		source: "../partes/edificiosUsuario/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo()+"edificio", value:"idedificio"},
		width: 200,
		menuWidth:350,
		blank: "",
		select: function(){
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#idedificio_search").val($("#comboEdificios").rup_combo("value"));
			//asignar el valor para la opción de imprimir
			if ($("#comboEdificios").rup_combo("value")!=""){
				$("#cedificio_imp").val($("#comboEdificios-button").text());	
			}else{
				$("#cedificio_imp").val("");
			}
		},
		style : "dropdown"										
	});
	
	
	//Se Crea el combo de Con Tecnicos 
	$('#conTecnicosCombo').rup_combo({
		source : [
				{i18nCaption: $.rup.i18n.app.comboConTecnicos._blank, value:""},
				{i18nCaption: $.rup.i18n.app.comboConTecnicos.conTecnicos, value:"1"},
				{i18nCaption: $.rup.i18n.app.comboConTecnicos.sinTecnicos, value:"0"}
		         ],
		width: 150,
		select: function(){
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#conTecnicos_search").val($("#conTecnicosCombo").rup_combo("value"));
		},
		orderedByValue: true,
		style : "dropdown"	
	});
	
	//Combo multiselección Tecnicos para posterior búsqueda
	$("#idtecnico_search").rup_combo(
	{
		source: "../usutecnicos/comboTecnicosUsuario?idUsuario="+$("#idUsuario").val(),
		sourceParam : {
			label : "nombre",
			value : "idtecnico"
		},
		width : 300,
		showValue: false,
		submitAsString : true,
		method : 'GET',
		multiselect: true,
		multiOptgroupIconText: true,
		filterMultiple:true,
		onLoadSuccess: function(){

			var tecnicos = $("#tec").val();
			if(tecnicos.indexOf(",") != -1){
				var tecArray = [];
				tecArray = tecnicos.split(",");
				for(var i=0;i<tecArray.length;i++){
					$("#idtecnico_search").rup_combo("select",[tecArray[i]]);
				}
			}else{
				$("#idtecnico_search").rup_combo("select",[$("#tec").val()]);
			}
		}
	});


	$("#bt_search_mantFichas").unbind("click");
	$("#bt_search_mantFichas").bind("click",busquedaFiltro);

	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_mantFichas").unbind("click");
	$("#clean_search_mantFichas").bind("click",limpiarFormBusqueda);
	
	setTimeout(function() {
		$("#mantFichas").rup_maint("search");
	 }, 200);	
});

function busquedaFiltro(){
	//Si selecciona sin tecnicos ocultamos la columna de tecnicos
	if ($("#conTecnicos_search").val()=="0"){
		$("#GRID_mantFichas").jqGrid('hideCol','tecnicos');
	}else{
		$("#GRID_mantFichas").jqGrid('showCol','tecnicos');
	}
	
	if ($("#ejecutado_search").val()=="1"){
		$("#GRID_mantFichas").jqGrid('showCol','tiemporeal');
	}else{
		$("#GRID_mantFichas").jqGrid('hideCol','tiemporeal');
	}
		
	$("#GRID_mantFichas").setGridWidth(1000,true);
	$("#mantFichas").rup_maint("search");
}
/*************************************************************/
/***********************SERVICIOS*****************************/
/*************************************************************/

$("#imgBuscarServicios").rup_tooltip({
	content: {
	text: $.rup.i18n.app.nuevo.ventanaSeleccion
	}
});

function btn_BuscarServicios(){
	var urlServicios="../servicios/obtenerServicios";
	
	$("#idTablaServicios").empty();
	var textoBaja="";
	//Obtener la lista de Servicios
	$.ajax({
		type: "POST",
		url: urlServicios,
		success: function(data){
			var miselect=$("#idTablaServicios");
			$("#idTablaServicios").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion =  textoBaja + data[i].cservicio;
              	} else {
              		descripcion = textoBaja + data[i].eservicio;
              	}
              	miselect.append('<option value="' + data[i].idservicio + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	
	//Mostrar la ventana de lupa Servicios
	$("#lupaServicios").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:300,
        width:450,  
        resizable:false,
        title:$.rup.i18n.app.comun.serviciosVigentes,
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarlupaServicios",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
		        		//Pintar el texto de servicio 
		        		$("#idServicio").val($("#idTablaServicios option:selected").val());
		        		var texto = $("#idTablaServicios option:selected").html();
		        		texto = texto.replace(/&nbsp;/g, "");
		        		$("#textoServicio").val(texto);
		        		$("#lupaServicios").rup_dialog("close");
	        		}
        	},
	        {
	    		id: "cerrarlupaServicios",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupaServicios").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   

}

/**************************************************************/

function limpiarFormBusqueda() {
	$("#ejecutado_search").prop('checked', false);
	$("#parado_search").prop('checked', false);
	$("#pendEjec_search").prop('checked', false);

	$('#conTecnicosCombo').rup_combo("setRupValue","");
	
	$("#mantFichas").rup_maint("cleanSearchForm");
	
	$("#GRID_mantFichas").jqGrid('showCol','tecnicos');
	$("#GRID_mantFichas").jqGrid('hideCol','tiemporeal');
	$("#GRID_mantFichas").setGridWidth(1000,true);
	
	$("#idclase_search").val(claseUsuario);
	$("#mantFichas").rup_maint("search");
	
	limpiarFormImprimir();
}

function limpiarFormImprimir() {
	$('#filtroListadoFichasForm').each (function(){
		this.val("");
	});
}



function obtenerIdiomaCombo(){
	var idioma="c";		
	if ($.rup_utils.capitalizedLang() =="Es") {	
		idioma = "c";
	} else idioma="e";
	return idioma;
	}
/*function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}*/
function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}


$(window).load(function() {
	$('#comboEdificios').rup_combo("setRupValue",$("#idedificio_search").val());
	$('#conTecnicosCombo').rup_combo("setRupValue",$("#conTecnicos_search").val());

});

function ocultarBusqueda(){
	
	$("#mantFichas_filter_div").toggle("slow",function(){
		
	});
}

function comprobarCheckEjecutado(valor){

	if($('#ejecutado_search').is(":checked")) {
		$('#ejecutado_search').prop("checked", true);
		$('#ejecutado_search').val("1");
    }else{
    	$('#ejecutado_search').prop("checked", false);
    	$('#ejecutado_search').val("0");
    }
}


function comprobarCheckParado(valor){
    if($('#parado_search').is(":checked")) {
    	$('#parado_search').prop("checked", true);
    	$('#parado_search').val("1");
    }else{
    	$('#parado_search').prop("checked", false);
    	$('#parado_search').val("0");
    }
}



function comprobarCheckPendejec(valor){
    if($('#pendEjec_search').is(":checked")) {
    	$('#pendEjec_search').prop("checked", true);
    	$('#pendEjec_search').val("1");
    }else{
    	$('#pendEjec_search').prop("checked", false);
    	$('#pendEjec_search').val("0");
    }
}
