jQuery(function($){
	$("#espacios_filter_div").toggle();
	$("#GRID_espacios").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../espacio",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idespacio",
		ondblClickRow : fncDetalleEspacio,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
		    $.rup.i18n.app.GRID_cabecerasEspacios.intExt,
		    $.rup.i18n.app.GRID_cabeceras.baja
		],
		colModel: [
			{ name: "idespacio",
				label: "idespacio",
				index: "idespacio",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "cespacio",
				label: "cespacio",
				index: "cespacio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "eespacio",
				label: "eespacio",
				index: "eespacio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "intExt",
				label: "intExt",
				index: "intExt",
				width: "30",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	

	$("#espacios").rup_maint({
		jQueryGrid: "GRID_espacios",
		primaryKey: "idespacio",
		modelObject: "Espacio",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoEspacio
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleEspacio
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirEspaciosGmao
					}
	
					]
			}
				
	});
	
	//Se Crea el combo de seleccion de Interior Exterior
	$('#intExtComboBusqueda').rup_combo({
		source : [
				{i18nCaption: $.rup.i18n.app.comboIntExt._blank, value:""},
				{i18nCaption: $.rup.i18n.app.comboIntExt.interior, value:"I"},
				{i18nCaption: $.rup.i18n.app.comboIntExt.exterior, value:"E"}
		         ],
		width: 100,
		select: function(event, object){
		},
		style : "dropdown"	
	});
	
/*DIÁLOGO NUEVO ESPACIO INI*/
	
	var ventanaDialogoNuevoEspacio= $("#dialogoEditarEspacio").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoEspacio",
		modal: true,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.nuevo.espacio,
		close: function(event, ui) { $("#GRID_espacios").rup_grid("reloadGrid"); }
	});
	
	function nuevoEspacio() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../espacio/nuevo';
		document.getElementById("iframeEditarEspacio").src = ventanaIFrame;
		$("#dialogoEditarEspacio").rup_dialog("open");
	}
	
	function cerrarIFrameNuevoEspacio() {
		if ($("#dialogoEditarEspacio").rup_dialog('isOpen')) {
			$("#dialogoEditarEspacio").rup_dialog('close');
			document.getElementById("iframeEditarEspacio").src = '';
		}
	}
	
	$("#iframeNuevoEspacio").load(function (){ ;});	
	/*DIÁLOGO NUEVO Espacio FIN*/
	
	/* DIALOGO DETALLE */
	function fncDetalleEspacio() {
	
		var ventanaDialogoDetalleEspacio = $("#dialogoEditarEspacio").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detalleEspacio",
			modal: true,
			resizable: false,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Espacio,
			close: function(event, ui) { $("#GRID_espacios").rup_grid("reloadGrid"); }
		});
		
		 var id= $("#GRID_espacios").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_espacios").rup_grid('getRowData',id); 
		 var idEspacio =ret.idespacio;	 
		 var ventanaIFrame ="../espacio/modificar?idEspacio="+idEspacio;
	
		  document.getElementById("iframeEditarEspacio").src = ventanaIFrame;
			$("#dialogoEditarEspacio").rup_dialog("open");
		
		  $("#iframeEditarEspacio").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_espacios").unbind("click");
	$("#clean_search_espacios").bind("click",limpiarFormBusqueda);
	
	$("#espacios").rup_maint("search");

	
});

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	
	$("#espacios").rup_maint("cleanSearchForm");
	$("#espacios").rup_maint("search");

}


function fncSubirEspaciosGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesEspacio.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosEspaciosGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_espacios").rup_feedback (propertiesOK);
						$("#feedback_espacios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_espacios").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_espacios").rup_feedback (propertiesError);
						$("#feedback_espacios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_espacios").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_espacios").rup_feedback (propertiesError);
			 		$("#feedback_espacios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_espacios").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}
function ocultarBusqueda(){
	
	$("#espacios_filter_div").toggle("slow",function(){
		
	});
}