jQuery(function($){
	$("#GRID_mantEdificosXLNET").rup_grid({
		
		hasMaint: true,
		width: 865,
		url: "../edificiosxlnet",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "n38uidedificio",
		colNames: [
			$.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,
			$.rup.i18n.app.GRID_cabecerasEdificios.codPostal,
			$.rup.i18n.app.GRID_cabecerasEdificios.provincia,
			$.rup.i18n.app.GRID_cabecerasEdificios.localidad,
			$.rup.i18n.app.GRID_cabecerasEdificios.calle
		],
		colModel: [
			{ name: "n38uidedificio",
				label: "n38uidedificio",
				index: "n38uidedificio",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "n38caedificio",
				label: "n38caedificio",
				index: "n38caedificio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "n38euedificio",
				label: "n38euedificio",
				index: "n38euedificio",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "postalcode",
				label: "postalcode",
				index: "postalcode",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "n38provincia",
				label: "n38provincia",
				index: "n38provincia",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "localidad",
				label: "localidad",
				index: "localidad",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "street",
				label: "street",
				index: "street",
				width: "150",
				editable: true,
				edittype: "text"
			}
        ]
		

	});
	

	$("#mantEdificosXLNET").rup_maint({
		jQueryGrid: "GRID_mantEdificosXLNET",
		primaryKey: "n38uidedificio",
		modelObject: "EdificiosXlnet",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						id:"MiObtener",
						i18nCaption: $.rup.i18n.app.botones.obtener,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncConfirmar
					}]
			}
	});
	$("#dialogoEspera").hide();
	$("#GRID_mantEdificosXLNET").unbind("dblclick");
});

function fncConfirmar(){
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificiosXLNET.obtener"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificiosXLNET.mensajeObtener"),
		OKFunction: function(){
			$("#dialogoEspera").show();
			 fncObtenerEdificios();
		},
		CANCELFunction : function(){
		}
		});
}

function fncObtenerEdificios(){

	$.ajax({
		  type: "POST",
		  url: "../edificiosxlnet/listaEdificiosXLNET",
		  success: function(data){
			  $("#dialogoEspera").hide();
			  $("#GRID_mantEdificosXLNET").rup_grid("reloadGrid");
		  },
		  error: function(data){
			  $("#dialogoEspera").hide();
			  alert( data);
		  },
		  dataType: "json"
		});
	
}