var cargarInicio=true;
var esXLNET = false;
$( document ).ready(function() {
	
	$("#botoneraModificar").show();
	    
	//Se Crea el combo de seleccion de territorios
	$("#territorioCombo").rup_combo({
		source : [
				{i18nCaption: $.rup.i18n.app.territorios._blank, value:""},
				{i18nCaption: $.rup.i18n.app.territorios.p1, value:"1"},
				{i18nCaption: $.rup.i18n.app.territorios.p20, value:"20"},
				{i18nCaption: $.rup.i18n.app.territorios.p48, value:"48"}
		         ],
		width: 100,
		select: function(){
			$("#idTerri").val($("#territorioCombo").rup_combo("value"));
		},
		orderedByValue: true,
		style : "dropdown"	
	});
	
	$("#bt_Volver").bind("click", volver);
	$("#bt_guardar").bind("click", validar);
	$("#bt_buscarEdificios").bind("click", buscarEdificios);
	
	
	$("#imgBuscar").hide();
	$("#textoEmpezar88").show();
	$("#divXLNET").hide();
	$("#divNOXLNET").show();
	
	$("#feedbacknuevoEdificio").rup_feedback({
		type : "ok",
		block : false,
		closeLink : true
	});
});

function validar(){
	var codigoEdificio=$("#idedificio").val();
	
	if($("#rbOpcionXLNET").is(':checked')) {
		//Comprobar que el código empieza por 88 y tiene 6 caracteres de longitud
		if (codigoEdificio.length!=6 || codigoEdificio.substring(2, 0)!="88"){
	 		$.rup_messages("msgError", { 
	 			title: $.rup.i18n.app.comun.control,
		 		message: $.rup.i18n.app.mensajesEdificios.textoEmpezar88
		 	});
	 		return;
		}
 	}
	
	$.ajax({
		  type: "GET",
		  url: "../edificios/existeEdificio?idedificio="+codigoEdificio,
		  success: function(data){
			  if (data == true){
			 		$.rup_messages("msgError", { 
			 			title: $.rup.i18n.app.comun.control,
				 		message: $.rup.i18n.app.mensajesEdificios.yaExisteEdificio
				 	});
			  }else{
				  altaEdificio();
			  }
		  	},
		  error: function(data){
				 alert( data);
			 },
		  dataType: "json"
		});
}

function altaEdificio(){
	
	//Hay que habilitar los campos para que lleguen al controller
	$("#idedificio").attr('disabled',false);
	$("#cedificio").attr('disabled',false);
	$("#eedificio").attr('disabled',false);
	
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
	
	var properties={
			url:"../edificios/alta",
			feedback:$("#feedbacknuevoEdificio"),
			dataType: "json",
			 beforeSend : function(data) {
					//Mostrar div de sincronizando
				  $("#dialogoGuardar").rup_dialog(
							{
								type : $.rup.dialog.DIV,
								height : 200,
								width : 500,
								modal : true,
								showLoading : true,
								autoOpen : false,
								title : $.rup.i18n.app.mensajesEdificios.guardando
							});
					$("#dialogoGuardar").rup_dialog("open");
			  },
			 error: function() {
				 	$("#dialogoGuardar").rup_dialog("close");
				  	$("#dialogoGuardar").rup_dialog("destroy");
				 	$("#feedbacknuevoEdificio").rup_feedback("set", $.rup.i18n.app.accionesRegistros.errorguardar, "error");			
					//Si esta seleccionado 'Existe en XLNET' volvemos a deshabilitar los campos para que lleguen al controller
				 	if (esXLNET){
						$("#idedificio").attr('disabled','disabled');
						$("#cedificio").attr('disabled','disabled');
						$("#eedificio").attr('disabled','disabled');
				 	}
			 },
			 success: function(data2){
				 $("#dialogoGuardar").rup_dialog("close");
				  	$("#dialogoGuardar").rup_dialog("destroy");
				 	if (data2!=null){
						 $("#feedbacknuevoEdificio").rup_feedback("set", $.rup.i18n.app.accionesRegistros.guardadook, "ok");
						 //ahora abrimos el edificio en modo edicion
						 editarEdificio();
				 	};
			 },
			 validate: {
				 rules: {
						"idedificio":{required:true,digits:true},
						"cedificio":{required:true},
						"eedificio":{required:true},
						"idterri":{required:true},
						"redificio":{required:true}
				 }
			 }
			};
			$("#nuevoEdificioForm").rup_form(properties);
			$("#nuevoEdificioForm").submit();
		
}
function volver(){
	window.history.back();
}

function editarEdificio(){
	
    // enviamos el form con el idEdificio para la busqueda
	buscaEdificioForm.idEdificioBusc.value = $("#idedificio").val();
	buscaEdificioForm.submit();
}

function buscarEdificios(){
	$("#idTablaEdificios").empty();
	var idEdificio=$("#idEdificio").val();
	
	if ($("#idEdificio").val()!=""){
		//Obtener la lista de Edificios
		$.ajax({
			type: "POST",
			url: "../edificiosxlnet/obtenerEdificiosXLNET",
			data:  { idEdificio:idEdificio},
			success: function(data){
				var miselect=$("#idTablaEdificios");
				$("#idTablaEdificios").empty();
	            for (var i=0; i<data.length; i++) {
	            	var descripcion = "";
	              	descripcion = data[i].n38uidedificio + "#" + data[i].n38caedificio+ "#" + data[i].n38euedificio+ "#" + data[i].n38provincia;
	              	miselect.append('<option value="' + descripcion + '">' + descripcion + '</option>');
	             	}								  
				},
			  dataType: "json"
			});
	}
	
}
function btn_obtenerListaEdificios(){
	$("#idTablaEdificios").empty();
	
	//Mostrar la ventana de lupaEdificios
	$("#lupaEdificios").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:400,
        width:649,  
        resizable:false,
        title:"",
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarlupaEdificios",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
	        		if ($("#lupaidEdificio").val()==""){
	        			alert($.rup.i18n.app.mensajesEdificios.selecEdif);
	        		}else{
	        			$("#idedificio").val($("#lupaidEdificio").val());
	        			$("#cedificio").val($("#lupacEdificio").val());
	        			$("#eedificio").val($("#lupaeEdificio").val());
	        			$("#idterriXLNET").val($("#lupaidTerri").val());
	        			var codProvincia=$("#lupaidTerri").val().substring(0, 2);
	        			$("#idTerri").val(codProvincia);
	        			
	        			$("#lupaEdificios").rup_dialog("close");
	        		}
	        		
	        		}
        	},
	        {
	    		id: "cerrarlupaEdificios",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupaEdificios").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   
}
function existeEnXLNET(valorOpcion){
	if (valorOpcion==1){
		$("#imgBuscar").show();
		$("#textoEmpezar88").hide();
		$("#divXLNET").show();
		$("#divNOXLNET").hide();
		$("#idedificio").attr('disabled','disabled');
		$("#cedificio").attr('disabled','disabled');
		$("#eedificio").attr('disabled','disabled');
		$("#idterriXLNET").attr('disabled','disabled');
		$("#idTerri").val("");
		esXLNET =true;
	}else if (valorOpcion==0){
		$("#imgBuscar").hide();
		$("#textoEmpezar88").show();
		$("#divXLNET").hide();
		$("#divNOXLNET").show();
		$("#idedificio").attr('disabled',false);
		$("#cedificio").attr('disabled',false);
		$("#eedificio").attr('disabled',false);
		$("#idterriXLNET").attr('disabled',false);
		$("#idedificio").val("");
		$("#cedificio").val("");
		$("#eedificio").val("");
		$("#idterriXLNET").val("");
		$("#idTerri").val("");
		esXLNET =false;
	}
}
function seleccionarEdificio(valorOpcion){
	var seleccion = valorOpcion.split('#');
	var idEdificio = seleccion[0];
	var cEdificio = seleccion[1];
	var eEdificio = seleccion[2];
	var idTerri = seleccion[3];
	
	$("#lupaidEdificio").val(idEdificio);
	$("#lupacEdificio").val(cEdificio);
	$("#lupaeEdificio").val(eEdificio);
	$("#lupaidTerri").val(idTerri);
}

function valida(e){
	var charCode = !e.charCode ? e.which : e.charCode;
	//La tecla / no está permitida en este campo porque si no casca al hacer las jerarquias en el mantenimiento de Planos.
	if (charCode==47){
		return false;
	}
	return;
}